/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.service.AbstractSchemeService;
import kd.scmc.im.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class TransInvSchemeService
extends AbstractSchemeService {
    private Map<Long, Object> orgToOwnerMap = new HashMap<Long, Object>(16);

    public TransInvSchemeService() {
    }

    public TransInvSchemeService(DynamicObject bill) {
        super(bill);
    }

    public TransInvSchemeService(IFormView view) {
        super(view);
    }

    @Override
    public Object getDefalutOwner(String type, int i) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        DynamicObject inorg = null;
        inorg = MetaDataHelper.isExistField(this.bill.getDataEntityType(), "inorg") ? (DynamicObject)this.getValue("inorg") : (DynamicObject)this.getValue("org");
        inorg = this.dealTransInOwner(inorg);
        return this.getOwner(inorg, i);
    }

    private DynamicObject dealTransInOwner(DynamicObject inorg) {
        if ("im_transinbill".equals(this.bill.getDataEntityType().getName())) {
            Object value = this.getValue("transit");
            if ("B".equals(value)) {
                inorg = (DynamicObject)this.getValue("org");
            } else if ("A".equals(value)) {
                inorg = (DynamicObject)this.getValue("outorg");
            }
        }
        return inorg;
    }

    @Override
    public Object getDefalutOutOwner(String type, int i) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        DynamicObject outorg = null;
        outorg = MetaDataHelper.isExistField(this.bill.getDataEntityType(), "outorg") ? (DynamicObject)this.getValue("outorg") : (DynamicObject)this.getValue("org");
        return this.getOutOwner(outorg, i);
    }

    @Override
    public Object getDefalutKeeper(String type, int i) {
        return this.getKeeper("keepertype", i);
    }

    @Override
    public Object getDefalutOutKeeper(String type, int i) {
        return this.getKeeper("outkeepertype", i);
    }

    protected Object getKeeper(String field, int index) {
        Object keeperId = null;
        DynamicObject org = null;
        if (field == null) {
            return keeperId;
        }
        switch (field) {
            case "outkeepertype": {
                if (MetaDataHelper.isExistField(this.bill.getDataEntityType(), "outorg")) {
                    org = (DynamicObject)this.getValue("outorg");
                    break;
                }
                org = (DynamicObject)this.getValue("org");
                break;
            }
            default: {
                org = MetaDataHelper.isExistField(this.bill.getDataEntityType(), "inorg") ? (DynamicObject)this.getValue("inorg") : (DynamicObject)this.getValue("org");
            }
        }
        Object keeperTypeObj = this.getValue(field, index);
        if (keeperTypeObj != null) {
            switch (keeperTypeObj.toString()) {
                case "bos_org": {
                    keeperId = org == null ? null : org.getPkValue();
                    break;
                }
                case "bd_supplier": 
                case "bd_customer": {
                    keeperId = null;
                    break;
                }
            }
        } else {
            keeperId = null;
        }
        return keeperId;
    }

    protected Object getOwner(DynamicObject org, int rowIndex) {
        Object ownerId = null;
        Object inOwnerType = this.getValue("ownertype", rowIndex);
        if (!"bos_org".equals(inOwnerType)) {
            return ownerId;
        }
        if (CommonUtils.isNull((Object)org)) {
            return ownerId;
        }
        Long orgId = (Long)org.getPkValue();
        ownerId = this.orgToOwnerMap.get(orgId);
        if (ownerId == null) {
            ownerId = OwnerHelper.getOwnerDefValue(orgId);
            this.orgToOwnerMap.put(orgId, ownerId);
        }
        return ownerId;
    }

    protected Object getOutOwner(DynamicObject org, int rowIndex) {
        Object ownerId = null;
        Object inOwnerType = this.getValue("outownertype", rowIndex);
        if (!"bos_org".equals(inOwnerType)) {
            return ownerId;
        }
        if (CommonUtils.isNull((Object)org)) {
            return ownerId;
        }
        Long orgId = (Long)org.getPkValue();
        ownerId = this.orgToOwnerMap.get(orgId);
        if (ownerId == null) {
            ownerId = OwnerHelper.getOwnerDefValue(orgId);
            this.orgToOwnerMap.put(orgId, ownerId);
        }
        return ownerId;
    }

    protected Object getAccountOrgId(DynamicObject org) {
        Long orgId = (Long)org.getPkValue();
        Long accountingId = null;
        Boolean isaccounting = org.getBoolean("fisaccounting");
        if (isaccounting.booleanValue()) {
            accountingId = orgId;
        } else {
            Map companys = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            accountingId = companys.get("id");
        }
        return accountingId;
    }

    @Override
    public void setKeeperEnable(int rowIndex) {
        String keeperType = (String)this.getValue("keepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, keeperType, "keeper");
    }

    @Override
    public void setKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("keepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "keeper");
    }

    @Override
    public void setOwnerEnable(int rowIndex) {
        String entityName = this.view.getModel().getDataEntityType().getName();
        if ("im_transinbill".equals(entityName) || "im_transdirbill".equals(entityName)) {
            String ownerType = (String)this.getValue("ownertype", rowIndex);
            this.setOwnerFieldEnable(rowIndex, ownerType, "owner");
        }
    }

    @Override
    public void setOwnerEnable(RowDataEntity row) {
        String entityName = this.view.getModel().getDataEntityType().getName();
        if ("im_transinbill".equals(entityName) || "im_transdirbill".equals(entityName)) {
            DynamicObject entry = row.getDataEntity();
            int rowIndex = row.getRowIndex();
            String ownerType = entry.getString("ownertype");
            this.setOwnerFieldEnable(rowIndex, ownerType, "owner");
        }
    }

    @Override
    public void setOutKeeperEnable(int rowIndex) {
        String outKeeperType = (String)this.getValue("outkeepertype", rowIndex);
        this.setKeeperOwnerEnable(rowIndex, outKeeperType, "outkeeper");
    }

    @Override
    public void setOutKeeperEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        String ownerType = entry.getString("outkeepertype");
        this.setKeeperOwnerEnable(rowIndex, ownerType, "outkeeper");
    }

    @Override
    public void setOutOwnerEnable(int rowIndex) {
        String entityName = this.view.getModel().getDataEntityType().getName();
        if ("im_transoutbill".equals(entityName) || "im_transdirbill".equals(entityName)) {
            String outOwnerType = (String)this.getValue("outownertype", rowIndex);
            this.setOwnerFieldEnable(rowIndex, outOwnerType, "outowner");
        }
    }

    @Override
    public void setOutOwnerEnable(RowDataEntity row) {
        String entityName = this.view.getModel().getDataEntityType().getName();
        if ("im_transoutbill".equals(entityName) || "im_transdirbill".equals(entityName)) {
            DynamicObject entry = row.getDataEntity();
            int rowIndex = row.getRowIndex();
            String outOwnerType = entry.getString("outownertype");
            this.setOwnerFieldEnable(rowIndex, outOwnerType, "outowner");
        }
    }
}

