/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.workbench;

import java.math.BigDecimal;
import java.util.Map;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.workbench.WorkbenchServiceHelper;
import kd.scmc.im.utils.BigDecimalUtils;

public class WorkbenchAuxQtyAndUnitHelper {
    private static Log logger = LogFactory.getLog(BaseDataServiceHelper.class);

    public static void setAuxBizQtyAndUnit(IFormView view, int rowIndex, String fieldName) {
        DynamicObject materialInvInfo = (DynamicObject)WorkbenchServiceHelper.getValue("materiel", rowIndex, view);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        switch (fieldName) {
            case "qty": 
            case "unit": {
                WorkbenchAuxQtyAndUnitHelper.changeUntAndQty(view, rowIndex, material, auxptyUnit);
                break;
            }
            case "qty2nd": {
                WorkbenchAuxQtyAndUnitHelper.changeAuxPtyQty(view, rowIndex, material);
                break;
            }
        }
    }

    private static void changeUntAndQty(IFormView view, int rowIndex, DynamicObject material, DynamicObject auxPtyUnit) {
        boolean isConvert;
        IDataModel model = view.getModel();
        BigDecimal baseQty = (BigDecimal)WorkbenchServiceHelper.getValue("baseqty", rowIndex, view);
        DynamicObject baseUnit = (DynamicObject)WorkbenchServiceHelper.getValue("baseunit", rowIndex, view);
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (!isConvert) {
            return;
        }
        if (BigDecimal.ZERO.compareTo(baseQty) == 0) {
            WorkbenchServiceHelper.setValueNoChange("qty2nd", BigDecimal.ZERO, rowIndex, view);
            return;
        }
        BigDecimal qtyUnit2nd = BillUnitAndQtytHelper.getDesQtyConv(material, baseUnit, baseQty, auxPtyUnit);
        try {
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)model, (BigDecimal)qtyUnit2nd, (String)"qty2nd");
        }
        catch (Exception e) {
            view.showErrorNotification(e.getMessage());
            return;
        }
        WorkbenchServiceHelper.setValueNoChange("qty2nd", qtyUnit2nd, rowIndex, view);
    }

    private static void changeAuxPtyQty(IFormView view, int rowIndex, DynamicObject material) {
        boolean isConvert;
        IDataModel model = view.getModel();
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        if (!isConvert) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)WorkbenchServiceHelper.getValue("baseunit", rowIndex, view);
        DynamicObject unit2nd = (DynamicObject)WorkbenchServiceHelper.getValue("unit2nd", rowIndex, view);
        BigDecimal qtyUnit2nd = (BigDecimal)WorkbenchServiceHelper.getValue("qty2nd", rowIndex, view);
        Map allFields = view.getModel().getDataEntityType().getAllFields();
        if (!allFields.containsKey("baseqty")) {
            return;
        }
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv(material, unit2nd, qtyUnit2nd, baseUnit);
        try {
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)model, (BigDecimal)baseQty, (String)"baseqty");
        }
        catch (Exception e) {
            view.showErrorNotification(e.getMessage());
            return;
        }
        WorkbenchServiceHelper.setValueNoChange("baseqty", baseQty, rowIndex, view);
        WorkbenchAuxQtyAndUnitHelper.setQtyByBaseQtyChange(view, rowIndex, material, baseUnit, baseQty);
    }

    private static void setQtyByBaseQtyChange(IFormView view, int rowIndex, DynamicObject material, DynamicObject baseUnit, BigDecimal baseQty) {
        IDataModel bill = view.getModel();
        BigDecimal qty = BigDecimal.ZERO;
        if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObject unit = (DynamicObject)WorkbenchServiceHelper.getValue("unit", rowIndex, view);
            if (unit == null) {
                return;
            }
            qty = BillUnitAndQtytHelper.getDesQtyConv(material, baseUnit, baseQty, unit);
        }
        try {
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)qty, (String)"qty");
        }
        catch (Exception e) {
            view.showErrorNotification(e.getMessage());
            return;
        }
        WorkbenchServiceHelper.setValueNoChange("qty", qty, rowIndex, view);
    }
}

