/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.workbench;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.scmc.im.business.helper.SupplyChainParameterHelper;
import kd.scmc.im.business.workbench.InterfaceCfgField;
import kd.scmc.im.business.workbench.WorkbenchServiceHelper;

public class WorkbenchFieldsConditionShowAndLockHelper {
    private static final Set<String> alwaysLockFields = new HashSet<String>(16);
    private static final Set<String> formBOTPLockFields;
    private static final Map<String, Set<String>> propertyChangeLockFieldsMap;

    public static boolean isLock(DynamicObject rowData, boolean formBOTP, String key) {
        if (alwaysLockFields.contains(key)) {
            return true;
        }
        if (formBOTP && formBOTPLockFields.contains(key)) {
            return true;
        }
        DynamicObject materielInvInfo = null;
        DynamicObject materiel = null;
        try {
            materielInvInfo = rowData.getDynamicObject("materiel");
            materiel = materielInvInfo.getDynamicObject("masterid");
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean isLock = false;
        switch (key) {
            case "biztype": {
                Object billType = rowData.get("billtype");
                if (!Objects.isNull(billType)) break;
                isLock = true;
                break;
            }
            case "bookdate": {
                isLock = SupplyChainParameterHelper.getEnableScmParam("INV0004");
                break;
            }
            case "materielname": {
                boolean isDisposable = materiel == null ? true : materiel.getBoolean("isdisposable");
                isLock = !isDisposable;
                break;
            }
            case "auxpty": {
                boolean isUseAuxPty = materiel == null ? true : materiel.getBoolean("isuseauxpty");
                isLock = !isUseAuxPty;
                break;
            }
            case "lotnumber": {
                boolean enableLot = materielInvInfo == null ? true : materielInvInfo.getBoolean("enablelot");
                isLock = !enableLot;
                break;
            }
            case "producedate": 
            case "expiredate": {
                boolean enableShelfLifeMgr = materielInvInfo == null ? true : materielInvInfo.getBoolean("enableshelflifemgr");
                isLock = !enableShelfLifeMgr;
                break;
            }
            case "qty2nd": {
                isLock = materiel == null || materiel.getDynamicObject("auxptyunit") == null;
                break;
            }
            case "outwarehouse": 
            case "outinvtype": 
            case "outinvstatus": 
            case "outownertype": 
            case "outowner": 
            case "outkeepertype": {
                isLock = !WorkbenchFieldsConditionShowAndLockHelper.isInvSchemeOutUpdate(rowData);
                break;
            }
            case "outlocation": {
                DynamicObject outWareHouse;
                boolean containsOutWareHouse = rowData.containsProperty("outwarehouse");
                DynamicObject dynamicObject = outWareHouse = containsOutWareHouse ? rowData.getDynamicObject("outwarehouse") : null;
                boolean bl = outWareHouse == null ? false : (isLock = !outWareHouse.getBoolean("isopenlocation"));
                if (isLock) break;
                isLock = !WorkbenchFieldsConditionShowAndLockHelper.isInvSchemeOutUpdate(rowData);
                break;
            }
            case "outkeeper": {
                String outKeeperType;
                boolean containsOutKeeperType = rowData.containsProperty("outkeepertype");
                String string = outKeeperType = containsOutKeeperType ? rowData.getString("outkeepertype") : "";
                if ("bos_org".equals(outKeeperType)) {
                    isLock = true;
                }
                if (isLock) break;
                isLock = !WorkbenchFieldsConditionShowAndLockHelper.isInvSchemeOutUpdate(rowData);
                break;
            }
            case "inwarehouse": 
            case "ininvtype": 
            case "ininvstatus": 
            case "inownertype": 
            case "inowner": 
            case "inkeepertype": {
                isLock = !WorkbenchFieldsConditionShowAndLockHelper.isInvSchemeInUpdate(rowData);
                break;
            }
            case "inlocation": {
                DynamicObject inWareHouse;
                boolean containsInWareHouse = rowData.containsProperty("inwarehouse");
                DynamicObject dynamicObject = inWareHouse = containsInWareHouse ? rowData.getDynamicObject("inwarehouse") : null;
                boolean bl = inWareHouse == null ? false : (isLock = !inWareHouse.getBoolean("isopenlocation"));
                if (isLock) break;
                isLock = !WorkbenchFieldsConditionShowAndLockHelper.isInvSchemeInUpdate(rowData);
                break;
            }
            case "inkeeper": {
                String inKeeperType;
                boolean containsInKeeperType = rowData.containsProperty("inkeepertype");
                String string = inKeeperType = containsInKeeperType ? rowData.getString("inkeepertype") : "";
                if ("bos_org".equals(inKeeperType)) {
                    isLock = true;
                }
                if (isLock) break;
                isLock = !WorkbenchFieldsConditionShowAndLockHelper.isInvSchemeInUpdate(rowData);
                break;
            }
            case "configuredcode": {
                String configProperties;
                String string = configProperties = materiel == null ? "" : materiel.getString("configproperties");
                if ("2".equals(configProperties)) break;
                isLock = true;
                break;
            }
        }
        return isLock;
    }

    private static boolean isInvSchemeOutUpdate(DynamicObject rowData) {
        DynamicObject invScheme;
        DynamicObject dynamicObject = invScheme = rowData.containsProperty("invscheme") ? rowData.getDynamicObject("invscheme") : null;
        if (invScheme == null) {
            return true;
        }
        return invScheme.getBoolean("isoutupdate");
    }

    private static boolean isInvSchemeInUpdate(DynamicObject rowData) {
        DynamicObject invScheme;
        DynamicObject dynamicObject = invScheme = rowData.containsProperty("invscheme") ? rowData.getDynamicObject("invscheme") : null;
        if (invScheme == null) {
            return true;
        }
        return invScheme.getBoolean("isinupdate");
    }

    public static boolean isShow(DynamicObject rowData, String key) {
        DynamicObject invScheme;
        boolean isShow = true;
        DynamicObject dynamicObject = invScheme = rowData.containsProperty("invscheme") ? rowData.getDynamicObject("invscheme") : null;
        if (invScheme == null) {
            return true;
        }
        switch (key) {
            case "auxpty": {
                isShow = false;
                break;
            }
            case "outwarehouse": 
            case "outlocation": 
            case "outinvtype": 
            case "outinvstatus": 
            case "outownertype": 
            case "outowner": 
            case "outkeepertype": 
            case "outkeeper": {
                isShow = invScheme == null ? true : invScheme.getBoolean("isoutupdate");
                break;
            }
            case "inwarehouse": 
            case "inlocation": 
            case "ininvtype": 
            case "ininvstatus": 
            case "inownertype": 
            case "inowner": 
            case "inkeepertype": 
            case "inkeeper": {
                isShow = invScheme == null ? true : invScheme.getBoolean("isinupdate");
                break;
            }
        }
        return isShow;
    }

    public static void propertyChangeLock(IFormView view, DynamicObject rowData, boolean formBOTP, String key, int index, List<InterfaceCfgField> interfaceFieldList) {
        Set<String> needChangeLockFields = propertyChangeLockFieldsMap.get(key);
        if (needChangeLockFields == null || needChangeLockFields.isEmpty()) {
            return;
        }
        for (String needChangeLockField : needChangeLockFields) {
            WorkbenchFieldsConditionShowAndLockHelper.setEnable(rowData, formBOTP, needChangeLockField, index, interfaceFieldList, view);
        }
    }

    public static void propertyChangeShow(IFormView view, DynamicObject rowData, String key, List<InterfaceCfgField> interfaceFieldList) {
        switch (key) {
            case "invscheme": {
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "outwarehouse", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "outlocation", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "inwarehouse", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "inlocation", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "outinvtype", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "outinvstatus", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "outownertype", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "outowner", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "outkeepertype", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "outkeeper", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "ininvtype", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "ininvstatus", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "inownertype", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "inowner", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "inkeepertype", interfaceFieldList, view);
                WorkbenchFieldsConditionShowAndLockHelper.setShow(rowData, "inkeeper", interfaceFieldList, view);
                break;
            }
        }
    }

    public static void setEnable(DynamicObject rowData, boolean formBOTP, String key, int index, List<InterfaceCfgField> interfaceCfgFieldList, IFormView view) {
        MainEntityType dataEntityType = view.getModel().getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        boolean containsKey = allFields.containsKey(key);
        if (!containsKey) {
            return;
        }
        InterfaceCfgField interfaceField = WorkbenchServiceHelper.getInterfaceFieldByKey(interfaceCfgFieldList, key);
        boolean lock = interfaceField.getLock();
        boolean conditionLock = WorkbenchFieldsConditionShowAndLockHelper.isLock(rowData, formBOTP, key);
        if (lock || conditionLock) {
            view.setEnable(Boolean.FALSE, index, new String[]{key});
            if (index == -1) {
                view.setEnable(Boolean.FALSE, new String[]{key});
            }
        } else {
            view.setEnable(Boolean.TRUE, index, new String[]{key});
            if (index == -1) {
                view.setEnable(Boolean.TRUE, new String[]{key});
            }
        }
    }

    private static void setShow(DynamicObject rowData, String key, List<InterfaceCfgField> interfaceFieldList, IFormView view) {
        MainEntityType dataEntityType = view.getModel().getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        boolean containsKey = allFields.containsKey(key);
        if (!containsKey) {
            return;
        }
        InterfaceCfgField interfaceField = WorkbenchServiceHelper.getInterfaceFieldByKey(interfaceFieldList, key);
        boolean show = interfaceField.getShow();
        boolean conditionShow = WorkbenchFieldsConditionShowAndLockHelper.isShow(rowData, key);
        if (!show || !conditionShow) {
            view.setVisible(Boolean.FALSE, new String[]{key});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{key});
        }
    }

    static {
        alwaysLockFields.add("billstatus");
        alwaysLockFields.add("billno");
        alwaysLockFields.add("billobj");
        alwaysLockFields.add("baseunit");
        alwaysLockFields.add("baseqty");
        alwaysLockFields.add("unit2nd");
        alwaysLockFields.add("sourcebillobj");
        alwaysLockFields.add("sourcebillno");
        alwaysLockFields.add("sourcebillrowno");
        alwaysLockFields.add("sourcebillid");
        alwaysLockFields.add("sourcerowid");
        alwaysLockFields.add("outownertype");
        alwaysLockFields.add("outkeepertype");
        alwaysLockFields.add("inownertype");
        alwaysLockFields.add("inkeepertype");
        formBOTPLockFields = new HashSet<String>(16);
        formBOTPLockFields.add("billtype");
        formBOTPLockFields.add("biztype");
        formBOTPLockFields.add("supplier");
        formBOTPLockFields.add("customer");
        formBOTPLockFields.add("outorg");
        formBOTPLockFields.add("inorg");
        formBOTPLockFields.add("materiel");
        formBOTPLockFields.add("materielname");
        formBOTPLockFields.add("unit");
        formBOTPLockFields.add("configuredcode");
        formBOTPLockFields.add("tracknumber");
        propertyChangeLockFieldsMap = new HashMap<String, Set<String>>(16);
        HashSet<String> bizTypeSet = new HashSet<String>(2);
        bizTypeSet.add("biztype");
        propertyChangeLockFieldsMap.put("billtype", bizTypeSet);
        HashSet<String> materialChangeSet = new HashSet<String>(8);
        materialChangeSet.add("materielname");
        materialChangeSet.add("auxpty");
        materialChangeSet.add("lotnumber");
        materialChangeSet.add("producedate");
        materialChangeSet.add("expiredate");
        materialChangeSet.add("qty2nd");
        materialChangeSet.add("configuredcode");
        propertyChangeLockFieldsMap.put("materiel", materialChangeSet);
        HashSet<String> invshemeChangeSet = new HashSet<String>(16);
        invshemeChangeSet.add("outwarehouse");
        invshemeChangeSet.add("outlocation");
        invshemeChangeSet.add("inwarehouse");
        invshemeChangeSet.add("inlocation");
        invshemeChangeSet.add("outinvtype");
        invshemeChangeSet.add("outinvstatus");
        invshemeChangeSet.add("outownertype");
        invshemeChangeSet.add("outowner");
        invshemeChangeSet.add("outkeepertype");
        invshemeChangeSet.add("outkeeper");
        invshemeChangeSet.add("ininvtype");
        invshemeChangeSet.add("ininvstatus");
        invshemeChangeSet.add("inownertype");
        invshemeChangeSet.add("inowner");
        invshemeChangeSet.add("inkeepertype");
        invshemeChangeSet.add("inkeeper");
        propertyChangeLockFieldsMap.put("invscheme", invshemeChangeSet);
        HashSet<String> outWarehouseChangeSet = new HashSet<String>(2);
        outWarehouseChangeSet.add("outlocation");
        propertyChangeLockFieldsMap.put("outwarehouse", outWarehouseChangeSet);
        HashSet<String> inWarehouseChangeSet = new HashSet<String>(2);
        inWarehouseChangeSet.add("inlocation");
        propertyChangeLockFieldsMap.put("inwarehouse", inWarehouseChangeSet);
        HashSet<String> outKeeperTypeChangeSet = new HashSet<String>(2);
        outKeeperTypeChangeSet.add("outkeeper");
        propertyChangeLockFieldsMap.put("outkeepertype", outKeeperTypeChangeSet);
        HashSet<String> inKeeperTypeChangeSet = new HashSet<String>(2);
        inKeeperTypeChangeSet.add("inkeeper");
        propertyChangeLockFieldsMap.put("inkeepertype", inKeeperTypeChangeSet);
    }
}

