/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.workbench;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.im.business.workbench.InterfaceCfgField;
import kd.scmc.im.business.workbench.PushServiceHelper;
import kd.scmc.im.business.workbench.WorkbenchFieldsConditionShowAndLockHelper;

public class WorkbenchServiceHelper {
    private static final Log log = LogFactory.getLog(WorkbenchServiceHelper.class);
    public static final String CAKEY_TAR_ENTITY_TYPE_KEY = "tarEntityType";
    public static final String CAKEY_TAR_ENTITY_DYNAMIC_KEY = "tarEntityDynamic";
    public static final String CAKEY_SRC_ENTITY_TYPE_KEY = "srcEntityType";
    private static final String INTERFACE_FIELD = "interfacefield";
    private static final String TAR_BILL_FIELD = "tarbillfield";
    public static final String DETAIL_PAGE_ID = "detailPageId";
    public static final String DETAIL_ROW_INDEX = "detail_row_index";
    public static final String DATA_LOAD_TIME_CACHE_KEY = "data_load_time";
    public static final String BILL_NO_LOAD_TIME_CACHE_KEY = "bill_no_load_time";

    public static List<DynamicObject> getTarBillByBOTP(DynamicObjectCollection taskDataColl, String billNo, DynamicObject botp, IFormView view) {
        StringBuilder tipInfo;
        if (taskDataColl == null || taskDataColl.isEmpty()) {
            if (StringUtils.isNotEmpty((CharSequence)billNo)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u5931\u8d25\uff0c\u672a\u627e\u5230\u5355\u636e\u6216\u4efb\u52a1\u5355\u3002", (String)"WorkbenchServiceHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
            }
            return Collections.emptyList();
        }
        ConvertOperationResult convertOperationResult = PushServiceHelper.push(botp, taskDataColl);
        List<Object> botpPushBill = Collections.emptyList();
        if (convertOperationResult.isSuccess()) {
            botpPushBill = PushServiceHelper.getBOTPPushBill(botp, convertOperationResult);
        }
        if ((tipInfo = WorkbenchServiceHelper.getBOTPPushErrorInfo(convertOperationResult)).length() > 0) {
            view.showErrorNotification(tipInfo.toString());
        } else if ((botpPushBill == null || botpPushBill.isEmpty()) && StringUtils.isNotEmpty((CharSequence)billNo)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u5931\u8d25\uff0c\u672a\u627e\u5230\u5355\u636e\u6216\u4efb\u52a1\u5355\u3002", (String)"WorkbenchServiceHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        return botpPushBill;
    }

    public static List<DynamicObject> getTarBillByBOTP(List<Object> srcIdList, DynamicObject botp, IFormView view) {
        StringBuilder tipInfo;
        if (srcIdList == null || srcIdList.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u5931\u8d25\uff0c\u672a\u627e\u5230\u5355\u636e\u6216\u4efb\u52a1\u5355\u3002", (String)"WorkbenchServiceHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        ConvertOperationResult convertOperationResult = PushServiceHelper.push(botp, srcIdList);
        List<Object> botpPushBill = Collections.emptyList();
        if (convertOperationResult.isSuccess()) {
            botpPushBill = PushServiceHelper.getBOTPPushBill(botp, convertOperationResult);
        }
        if ((tipInfo = WorkbenchServiceHelper.getBOTPPushErrorInfo(convertOperationResult)).length() > 0) {
            view.showErrorNotification(tipInfo.toString());
        } else if (botpPushBill == null || botpPushBill.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f55\u5165\u5931\u8d25\uff0c\u672a\u627e\u5230\u5355\u636e\u6216\u4efb\u52a1\u5355\u3002", (String)"WorkbenchServiceHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        return botpPushBill;
    }

    private static StringBuilder getBOTPPushErrorInfo(ConvertOperationResult convertOperationResult) {
        StringBuilder tipInfo = new StringBuilder();
        List billReports = convertOperationResult.getBillReports();
        String errTip = ResManager.loadKDString((String)"\u5355\u636e", (String)"WorkbenchServiceHelper_0", (String)"scmc-im-business", (Object[])new Object[0]);
        for (SourceBillReport billReport : billReports) {
            int failRowCount = billReport.getFailRowCount();
            int rowCount = billReport.getRowCount();
            if (failRowCount <= 0 || rowCount != failRowCount) continue;
            tipInfo.append(errTip);
            tipInfo.append('(');
            tipInfo.append(billReport.getBillNo());
            tipInfo.append(')');
            tipInfo.append(billReport.getFailMessage());
            tipInfo.append('\n');
        }
        if (!convertOperationResult.isSuccess() && tipInfo.length() == 0) {
            tipInfo.append(convertOperationResult.getMessage());
        }
        return tipInfo;
    }

    public static DynamicObjectCollection getCurrentUserTaskDataByTaskTypeId(long taskTypeId, String srcEntityNumber, String billNo) {
        QFilter taskManageQf = new QFilter("taskstatus", "=", (Object)"A");
        taskManageQf.and("srcobj.number", "=", (Object)srcEntityNumber);
        taskManageQf.and("bizuser.operatorid", "=", (Object)UserServiceHelper.getCurrentUserId());
        taskManageQf.and("tasktype", "=", (Object)taskTypeId);
        if (StringUtils.isNotBlank((CharSequence)billNo)) {
            String[] splitBillNos = billNo.split(" ");
            taskManageQf.and("srcbillno", "in", (Object)splitBillNos);
        }
        return QueryServiceHelper.query((String)"msbd_wb_task_manage", (String)"id as manangeid,srcid,srcentryid,tasktype,srcentrykey,srcbillno", (QFilter[])taskManageQf.toArray(), null);
    }

    public static void setEntryRowDynamicData(IFormView view, String id, String rowId, String key, Object value) {
        DynamicObject entryRowDynamicData = WorkbenchServiceHelper.getEntryRowDynamicData(view, id);
        if (entryRowDynamicData == null) {
            return;
        }
        String[] split = key.split("\\.");
        String entryKey = "";
        if (split.length >= 2) {
            entryKey = split[0];
            DynamicObjectCollection entryCol = entryRowDynamicData.getDynamicObjectCollection(entryKey);
            for (DynamicObject entryData : entryCol) {
                String oriRowId = entryData.getString("id");
                if (!rowId.equals(oriRowId)) continue;
                entryData.set(split[1], value);
            }
        } else {
            entryRowDynamicData.set(key, value);
        }
        WorkbenchServiceHelper.updateDynamicObjCache(view, entryRowDynamicData);
    }

    public static void updateDynamicObjCache(IFormView view, DynamicObject billInfo) {
        IPageCache pageCache = view.getPageCache();
        String dy = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{billInfo}, (DynamicObjectType)billInfo.getDynamicObjectType());
        String cacheDataStr = pageCache.get(CAKEY_TAR_ENTITY_DYNAMIC_KEY);
        Map cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheDataStr, Map.class);
        String id = billInfo.getString("id");
        cacheDataMap.put(id, dy);
        pageCache.put(CAKEY_TAR_ENTITY_DYNAMIC_KEY, SerializationUtils.toJsonString((Object)cacheDataMap));
    }

    public static DynamicObject getEntryRowDynamicData(IFormView view, String id) {
        IPageCache pageCache = view.getPageCache();
        String tarEntityType = pageCache.get(CAKEY_TAR_ENTITY_TYPE_KEY);
        if (StringUtils.isEmpty((CharSequence)tarEntityType)) {
            return null;
        }
        String cacheDataStr = pageCache.get(CAKEY_TAR_ENTITY_DYNAMIC_KEY);
        if (StringUtils.isEmpty((CharSequence)cacheDataStr)) {
            return null;
        }
        Map cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheDataStr, Map.class);
        String cacheDataDyStr = (String)cacheDataMap.get(id);
        if (StringUtils.isEmpty((CharSequence)cacheDataDyStr)) {
            return null;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)tarEntityType);
        Object[] cacheData = DynamicObjectSerializeUtil.deserialize((String)cacheDataDyStr, (DynamicObjectType)dataEntityType);
        return (DynamicObject)cacheData[0];
    }

    public static String getEntryRowStrData(IFormView view, String id) {
        IPageCache pageCache = view.getPageCache();
        String tarEntityType = pageCache.get(CAKEY_TAR_ENTITY_TYPE_KEY);
        if (StringUtils.isEmpty((CharSequence)tarEntityType)) {
            return null;
        }
        String cacheDataStr = pageCache.get(CAKEY_TAR_ENTITY_DYNAMIC_KEY);
        if (StringUtils.isEmpty((CharSequence)cacheDataStr)) {
            return null;
        }
        Map cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheDataStr, Map.class);
        return (String)cacheDataMap.get(id);
    }

    public static String getTargetEntityType(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        return pageCache.get(CAKEY_TAR_ENTITY_TYPE_KEY);
    }

    public static String getSrcEntityType(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        return pageCache.get(CAKEY_SRC_ENTITY_TYPE_KEY);
    }

    public static Map<String, String> getCacheDataMap(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String cacheDataStr = pageCache.get(CAKEY_TAR_ENTITY_DYNAMIC_KEY);
        if (StringUtils.isEmpty((CharSequence)cacheDataStr)) {
            return new HashMap<String, String>();
        }
        Map cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheDataStr, Map.class);
        return cacheDataMap;
    }

    public static List<InterfaceCfgField> getInterfaceFieldList(DynamicObject interfaceCfgDy) {
        if (interfaceCfgDy == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection interfaceCfgColl = interfaceCfgDy.getDynamicObjectCollection("entryentity");
        ArrayList<InterfaceCfgField> interfaceCfgFieldList = new ArrayList<InterfaceCfgField>(interfaceCfgColl.size());
        for (DynamicObject interfaceColumn : interfaceCfgColl) {
            String interfaceFiled = interfaceColumn.getString(INTERFACE_FIELD);
            String tarBillFiled = interfaceColumn.getString(TAR_BILL_FIELD);
            String wbTab = interfaceColumn.getString("wbtab");
            boolean isShow = interfaceColumn.getBoolean("isshow");
            boolean isEdit = interfaceColumn.getBoolean("islock");
            boolean isMustInput = interfaceColumn.getBoolean("ismustinput");
            InterfaceCfgField interfaceCfgField = new InterfaceCfgField();
            interfaceCfgField.setInterfaceField(interfaceFiled);
            interfaceCfgField.setTarBillField(tarBillFiled);
            interfaceCfgField.setTab(wbTab);
            interfaceCfgField.setShow(isShow);
            interfaceCfgField.setLock(isEdit);
            interfaceCfgField.setMustInput(isMustInput);
            interfaceCfgFieldList.add(interfaceCfgField);
        }
        return interfaceCfgFieldList;
    }

    public static Object getValue(DynamicObject billInfo, DynamicObject entryInfo, String field) {
        String[] split = field.split("\\.");
        if (split.length == 2 && entryInfo != null) {
            return entryInfo.get(split[1]);
        }
        if (split.length == 1 && billInfo != null) {
            return billInfo.get(field);
        }
        return null;
    }

    public static void setValue(DynamicObject billInfo, DynamicObject entryInfo, String field, Object value) {
        String[] split = field.split("\\.");
        if (split.length == 2 && entryInfo != null) {
            entryInfo.set(split[1], value);
        } else if (split.length == 1 && billInfo != null) {
            billInfo.set(field, value);
        }
    }

    public static String getTarBillEntryKey(List<InterfaceCfgField> fieldsMappingList) {
        Optional<InterfaceCfgField> firstTarBillEntryField = fieldsMappingList.stream().filter(p -> p.getTarBillField().contains(".")).findFirst();
        String tarBillEntryKey = "";
        if (firstTarBillEntryField.isPresent()) {
            InterfaceCfgField firstTarBillEntryFieldOBj = firstTarBillEntryField.get();
            String tarBillField = firstTarBillEntryFieldOBj.getTarBillField();
            String[] keySplit = tarBillField.split("\\.");
            tarBillEntryKey = keySplit[0];
        }
        return tarBillEntryKey;
    }

    public static void appendEntryRow(List<InterfaceCfgField> fieldsMappingList, DynamicObject tarBillData, IFormView view) {
        IDataModel model = view.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        EntityType entityType = (EntityType)model.getDataEntityType().getAllEntities().get("entryentity");
        Map fields = entityType.getFields();
        String tarBillEntryKey = WorkbenchServiceHelper.getTarBillEntryKey(fieldsMappingList);
        if (StringUtils.isNotEmpty((CharSequence)tarBillEntryKey)) {
            DynamicObjectCollection tarBillEntryCollection = tarBillData.getDynamicObjectCollection(tarBillEntryKey);
            long[] ids = DB.genGlobalLongIds((int)tarBillEntryCollection.size());
            int j = 0;
            for (DynamicObject tarBillEntry : tarBillEntryCollection) {
                int ridx = model.createNewEntryRow("entryentity");
                long id = ids[j];
                WorkbenchServiceHelper.appendRowByTarBillEntry(fieldsMappingList, tarBillData, tarBillEntry, id, ridx, view);
                ++j;
            }
        } else {
            int ridx = model.createNewEntryRow("entryentity");
            DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", ridx);
            for (InterfaceCfgField interfaceCfg : fieldsMappingList) {
                String interfaceField = interfaceCfg.getInterfaceField();
                String tarBillField = interfaceCfg.getTarBillField();
                IDataEntityProperty interfaceFieldProperty = (IDataEntityProperty)fields.get(interfaceField);
                WorkbenchServiceHelper.setFieldValue(tarBillData, entryRowEntity, interfaceField, tarBillField, interfaceFieldProperty, view);
            }
            BusinessDataServiceHelper.loadRefence((Object[])new Object[]{entryRowEntity}, (IDataEntityType)entryRowEntity.getDataEntityType());
            BindingContext bindCtx = new BindingContext(entryRowEntity.getDataEntityType(), entryRowEntity, ridx);
            List rowValues = entryGrid.getRowBindValue(bindCtx);
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            proxy.appendRow("entryentity", rowValues);
        }
    }

    public static void appendRowByTarBillEntry(List<InterfaceCfgField> fieldsMappingList, DynamicObject tarBillData, DynamicObject tarBillEntry, long newEntryId, int ridx, IFormView view) {
        IDataModel model = view.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        EntityType entityType = (EntityType)model.getDataEntityType().getAllEntities().get("entryentity");
        Map fields = entityType.getFields();
        DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", ridx);
        entryRowEntity.set("billid", tarBillData.getPkValue());
        long entryId = (Long)tarBillEntry.getPkValue();
        if (entryId == 0L) {
            entryRowEntity.set("rowid", (Object)newEntryId);
            tarBillEntry.set("id", (Object)newEntryId);
        } else {
            entryRowEntity.set("rowid", (Object)entryId);
        }
        for (InterfaceCfgField interfaceCfg : fieldsMappingList) {
            String interfaceField = interfaceCfg.getInterfaceField();
            IDataEntityProperty interfaceFieldProperty = (IDataEntityProperty)fields.get(interfaceField);
            String tarBillField = interfaceCfg.getTarBillField();
            String[] keySplit = tarBillField.split("\\.");
            if (keySplit.length >= 2) {
                tarBillField = keySplit[1];
                WorkbenchServiceHelper.setFieldValue(tarBillEntry, entryRowEntity, interfaceField, tarBillField, interfaceFieldProperty, view);
                continue;
            }
            WorkbenchServiceHelper.setFieldValue(tarBillData, entryRowEntity, interfaceField, tarBillField, interfaceFieldProperty, view);
        }
        BusinessDataServiceHelper.loadRefence((Object[])new Object[]{entryRowEntity}, (IDataEntityType)entryRowEntity.getDataEntityType());
        BindingContext bindCtx = new BindingContext(entryRowEntity.getDataEntityType(), entryRowEntity, ridx);
        List rowValues = entryGrid.getRowBindValue(bindCtx);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.appendRow("entryentity", rowValues);
    }

    public static void setFieldValue(DynamicObject billData, DynamicObject entryRowEntity, String interfaceField, String tarBillField, IDataEntityProperty interfaceFieldProperty, IFormView view) {
        block11: {
            IDataEntityProperty tarBillFiledProperty = (IDataEntityProperty)billData.getDataEntityType().getProperties().get((Object)tarBillField);
            if (tarBillFiledProperty == null) {
                return;
            }
            try {
                Object tarFieldVal = billData.get(tarBillField);
                if (Objects.isNull(tarFieldVal)) {
                    InterfaceCfgField interfaceFieldCfg;
                    String bizDateTarBillField;
                    entryRowEntity.set(interfaceField, null);
                    if ("bookdate".equals(interfaceField) && !StringUtils.isEmpty((CharSequence)(bizDateTarBillField = (interfaceFieldCfg = WorkbenchServiceHelper.getInterfaceFieldByKey(WorkbenchServiceHelper.getFieldsMappingList(view), "bizdate")).getTarBillField()))) {
                        Object bizDate = null;
                        try {
                            bizDate = billData.get(bizDateTarBillField);
                        }
                        catch (Exception e) {
                            log.error("\u83b7\u53d6\u76ee\u6807\u5355\u4e1a\u52a1\u65e5\u671f\u51fa\u9519\uff1a", (Throwable)e);
                        }
                        entryRowEntity.set(interfaceField, bizDate);
                        billData.set(tarBillField, bizDate);
                    }
                    return;
                }
                if (interfaceFieldProperty instanceof BasedataProp) {
                    if (tarBillFiledProperty instanceof BasedataProp) {
                        entryRowEntity.set(interfaceField + "_id", billData.get(tarBillField + ".id"));
                        return;
                    }
                    IDataEntityProperty refIdProp = ((BasedataProp)interfaceFieldProperty).getRefIdProp();
                    if (refIdProp instanceof LongProp) {
                        entryRowEntity.set(interfaceField + "_id", (Object)billData.getLong(tarBillField));
                    } else {
                        entryRowEntity.set(interfaceField + "_id", (Object)billData.getString(tarBillField));
                    }
                    return;
                }
                entryRowEntity.set(interfaceField, tarFieldVal);
            }
            catch (Exception e) {
                log.error("\u5de5\u4f5c\u53f0\u5b57\u6bb5\u8d4b\u503c\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                if (interfaceFieldProperty == null) break block11;
                LocaleString displayNameLocale = interfaceFieldProperty.getDisplayName();
                String displayName = displayNameLocale.getLocaleValue();
                throw new KDBizException(ResManager.loadKDString((String)"\u754c\u9762\u5b57\u6bb5\u201c{0}\u201d\u4e0e\u76ee\u6807\u5355\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u5de5\u4f5c\u53f0\u754c\u9762\u914d\u7f6e\u4e2d\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"IM-D-671622", (String)"scmc-im-business", (Object[])new Object[]{displayName}));
            }
        }
    }

    public static void updateEntryRow(DynamicObject tarBillData, String rowId, int rowIndex, IFormView view) {
        List<InterfaceCfgField> fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList(view);
        IDataModel model = view.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        EntityType entityType = (EntityType)model.getDataEntityType().getAllEntities().get("entryentity");
        Map fields = entityType.getFields();
        String tarBillEntryKey = WorkbenchServiceHelper.getTarBillEntryKey(fieldsMappingList);
        if (StringUtils.isNotEmpty((CharSequence)tarBillEntryKey)) {
            DynamicObjectCollection tarBillEntryCollection = tarBillData.getDynamicObjectCollection(tarBillEntryKey);
            for (DynamicObject tarBillEntry : tarBillEntryCollection) {
                String entryPkValue = tarBillEntry.getString("id");
                if (!entryPkValue.equals(rowId)) continue;
                long entryId = Long.parseLong(entryPkValue);
                WorkbenchServiceHelper.appendRowByTarBillEntry(fieldsMappingList, tarBillData, tarBillEntry, entryId, rowIndex, view);
                break;
            }
        } else {
            DynamicObject entryRowEntity = model.getEntryRowEntity("entryentity", rowIndex);
            for (InterfaceCfgField interfaceCfg : fieldsMappingList) {
                String interfaceField = interfaceCfg.getInterfaceField();
                String tarBillField = interfaceCfg.getTarBillField();
                IDataEntityProperty interfaceFieldProperty = (IDataEntityProperty)fields.get(interfaceField);
                WorkbenchServiceHelper.setFieldValue(tarBillData, entryRowEntity, interfaceField, tarBillField, interfaceFieldProperty, view);
            }
            BusinessDataServiceHelper.loadRefence((Object[])new Object[]{entryRowEntity}, (IDataEntityType)entryRowEntity.getDataEntityType());
            BindingContext bindCtx = new BindingContext(entryRowEntity.getDataEntityType(), entryRowEntity, rowIndex);
            List rowValues = entryGrid.getRowBindValue(bindCtx);
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            proxy.appendRow("entryentity", rowValues);
        }
    }

    public static List<InterfaceCfgField> getFieldsMappingList(IFormView view) {
        String cacheStr = view.getPageCache().get("interfaceFieldCache");
        if (StringUtils.isEmpty((CharSequence)cacheStr)) {
            return Collections.emptyList();
        }
        return SerializationUtils.fromJsonStringToList((String)cacheStr, InterfaceCfgField.class);
    }

    public static Map<String, DynamicObject> getSingleRowDynamicData(IFormView view, String entryEntityKey) {
        HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>();
        Map<String, String> cacheDataMap = WorkbenchServiceHelper.getCacheDataMap(view);
        if (cacheDataMap == null || cacheDataMap.isEmpty()) {
            return new HashMap<String, DynamicObject>();
        }
        String targetEntityType = WorkbenchServiceHelper.getTargetEntityType(view);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)targetEntityType);
        for (Map.Entry<String, String> entry : cacheDataMap.entrySet()) {
            String cacheDataDyStr = entry.getValue();
            Object[] cacheData = DynamicObjectSerializeUtil.deserialize((String)cacheDataDyStr, (DynamicObjectType)dataEntityType);
            DynamicObject dynamicObject = (DynamicObject)cacheData[0];
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(entryEntityKey);
            for (DynamicObject row : entryEntity) {
                DynamicObjectCollection singleList = new DynamicObjectCollection();
                singleList.add((Object)row);
                dynamicObject.set(entryEntityKey, (Object)singleList);
                entryMap.put(row.getString("id"), dynamicObject);
            }
        }
        return entryMap;
    }

    public static InterfaceCfgField getInterfaceFieldByKey(List<InterfaceCfgField> fieldsMappingList, String key) {
        Optional<InterfaceCfgField> firstTarBillEntryField = fieldsMappingList.stream().filter(p -> p.getInterfaceField().contains(key)).findFirst();
        return firstTarBillEntryField.orElseGet(InterfaceCfgField::new);
    }

    public static void setTarDynamicObjectValue(int rowIndex, String key, Object value, IFormView view) {
        IDataModel model = view.getModel();
        String billId = (String)model.getValue("billid", rowIndex);
        String rowId = (String)model.getValue("rowid", rowIndex);
        List<InterfaceCfgField> fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList(view);
        Optional<InterfaceCfgField> firstTarBillEntryField = fieldsMappingList.stream().filter(p -> p.getInterfaceField().equals(key)).findFirst();
        if (firstTarBillEntryField.isPresent()) {
            InterfaceCfgField firstTarBillEntryFieldOBj = firstTarBillEntryField.get();
            WorkbenchServiceHelper.setEntryRowDynamicData(view, billId, rowId, firstTarBillEntryFieldOBj.getTarBillField(), value);
        }
    }

    public static void sendPropertyChangeEvent(IFormView view, String key, Object newValue) {
        HashMap<String, Object> eventMap = new HashMap<String, Object>(2);
        eventMap.put("key", key);
        if (newValue instanceof DynamicObject) {
            eventMap.put("val", newValue == null ? null : ((DynamicObject)newValue).getPkValue());
        } else {
            eventMap.put("val", newValue);
        }
        IPageCache pageCache = view.getPageCache();
        String detailPageId = pageCache.get(DETAIL_PAGE_ID);
        IFormView detailView = view.getView(detailPageId);
        if (detailView != null) {
            String cacheEventParams = pageCache.get("cache_event_params");
            Map<String, HashMap<String, Object>> eventParamMap = new HashMap<String, HashMap<String, Object>>();
            if (StringUtils.isNotEmpty((CharSequence)cacheEventParams)) {
                eventParamMap = (Map)SerializationUtils.fromJsonString((String)cacheEventParams, Map.class);
            }
            eventParamMap.put("propertyChangedEvent", eventMap);
            pageCache.put("cache_event_params", SerializationUtils.toJsonString(eventParamMap));
            try {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("eventid", "propertyChangedEvent");
                detailView.invokeOperation("handleevent", operateOption);
                view.sendFormAction(detailView);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    public static void detailSendPropertyChangeEvent(IFormView view, String key, Object newValue) {
        HashMap<String, Object> eventMap = new HashMap<String, Object>(2);
        eventMap.put("key", key);
        if (newValue instanceof DynamicObject) {
            eventMap.put("val", newValue == null ? null : ((DynamicObject)newValue).getPkValue());
        } else {
            eventMap.put("val", newValue);
        }
        String parentPageId = view.getFormShowParameter().getParentPageId();
        IFormView parentView = view.getView(parentPageId);
        if (parentView != null) {
            String cacheEventParams = parentView.getPageCache().get("cache_event_params");
            Map<String, HashMap<String, Object>> eventParamMap = new HashMap<String, HashMap<String, Object>>();
            if (StringUtils.isNotEmpty((CharSequence)cacheEventParams)) {
                eventParamMap = (Map)SerializationUtils.fromJsonString((String)cacheEventParams, Map.class);
            }
            eventParamMap.put("propertyChangedEvent", eventMap);
            parentView.getPageCache().put("cache_event_params", SerializationUtils.toJsonString(eventParamMap));
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("eventid", "propertyChangedEvent");
            parentView.invokeOperation("propertyChangedEvent", operateOption);
            view.sendFormAction(parentView);
        }
    }

    public static void sendRowChangeEvent(IFormView view, Map<String, Object> eventMap) {
        IPageCache pageCache = view.getPageCache();
        String detailPageId = pageCache.get(DETAIL_PAGE_ID);
        IFormView detailView = view.getView(detailPageId);
        if (detailView != null) {
            String cacheEventParams = pageCache.get("cache_event_params");
            Map<String, Map<String, Object>> eventParamMap = new HashMap<String, Map<String, Object>>();
            if (StringUtils.isNotEmpty((CharSequence)cacheEventParams)) {
                eventParamMap = (Map)SerializationUtils.fromJsonString((String)cacheEventParams, Map.class);
            }
            eventParamMap.put("rowChangedEvent", eventMap);
            pageCache.put("cache_event_params", SerializationUtils.toJsonString(eventParamMap));
            try {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("eventid", "rowChangedEvent");
                detailView.invokeOperation("handleevent", operateOption);
                view.sendFormAction(detailView);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    public static void clearEntryData(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        int rowCount = entryEntity.getRowCount();
        int[] rows = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = i;
        }
        model.deleteEntryRows("entryentity", rows);
        view.getPageCache().remove(CAKEY_TAR_ENTITY_DYNAMIC_KEY);
    }

    public static void addEntryRowData(List<DynamicObject> tarBillList, IFormView view) {
        List<InterfaceCfgField> fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList(view);
        IDataModel model = view.getModel();
        model.beginInit();
        Map<String, String> cacheMap = WorkbenchServiceHelper.getCacheDataMap(view);
        for (DynamicObject tarBillData : tarBillList) {
            WorkbenchServiceHelper.appendEntryRow(fieldsMappingList, tarBillData, view);
            String id = tarBillData.getString("id");
            String dy = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{tarBillData}, (DynamicObjectType)tarBillData.getDynamicObjectType());
            cacheMap.put(id, dy);
        }
        model.endInit();
        view.getPageCache().put(CAKEY_TAR_ENTITY_DYNAMIC_KEY, SerializationUtils.toJsonString(cacheMap));
        view.updateView("entryentity");
    }

    public static Map<String, Object> doTaskComplete(List<Map<String, String>> taskData, String srcEntityNumber, long taskTypeId) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"WorkBenchTaskCompleteService", (String)"completeWbTask", (Object[])new Object[]{taskData, srcEntityNumber, taskTypeId});
    }

    public static void setNullValue(String key, int rowIndex, IFormView view) {
        IDataModel model = view.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        boolean containsKey = allFields.containsKey(key);
        if (!containsKey) {
            return;
        }
        if (rowIndex == -1) {
            view.getModel().setValue(key, null);
        } else {
            view.getModel().setValue(key, null, rowIndex);
            WorkbenchServiceHelper.setTarDynamicObjectValue(rowIndex, key, null, view);
        }
    }

    public static void setValue(String key, Object value, int rowIndex, IFormView view) {
        IDataModel model = view.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        boolean containsKey = allFields.containsKey(key);
        if (!containsKey) {
            return;
        }
        if (rowIndex == -1) {
            view.getModel().setValue(key, value);
        } else {
            view.getModel().setValue(key, value, rowIndex);
            WorkbenchServiceHelper.setTarDynamicObjectValue(rowIndex, key, value, view);
        }
    }

    public static void updateView(String key, int rowIndex, IFormView view) {
        IDataModel model = view.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        boolean containsKey = allFields.containsKey(key);
        if (!containsKey) {
            return;
        }
        if (rowIndex == -1) {
            view.updateView(key);
        } else {
            view.updateView(key, rowIndex);
        }
    }

    public static Object getValue(String key, int rowIndex, IFormView view) {
        IDataModel model = view.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        boolean containsKey = allFields.containsKey(key);
        if (!containsKey) {
            return null;
        }
        Object value = rowIndex == -1 ? view.getModel().getValue(key) : view.getModel().getValue(key, rowIndex);
        return value;
    }

    public static void setValueNoChange(String key, Object value, int rowIndex, IFormView view) {
        IDataModel model = view.getModel();
        model.beginInit();
        WorkbenchServiceHelper.setValue(key, value, rowIndex, view);
        model.endInit();
        if (rowIndex == -1) {
            WorkbenchServiceHelper.detailSendPropertyChangeEvent(view, key, value);
        } else {
            WorkbenchServiceHelper.sendPropertyChangeEvent(view, key, value);
        }
        WorkbenchServiceHelper.updateView(key, rowIndex, view);
    }

    public static Date parseDate(String dateStr) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        Date date = null;
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sd.parse(dateStr);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef in WorkbenchServiceHelper.parseDate", (Throwable)e);
        }
        return date;
    }

    public static void setPageShowProperty(IFormView view, boolean dataFromBOTP) {
        int rowCount = view.getModel().getEntryRowCount("entryentity");
        List<InterfaceCfgField> fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList(view);
        for (InterfaceCfgField interfaceCfgField : fieldsMappingList) {
            String interfaceField = interfaceCfgField.getInterfaceField();
            boolean isShow = interfaceCfgField.getShow();
            boolean isLock = interfaceCfgField.getLock();
            boolean isMustInput = interfaceCfgField.getMustInput();
            FieldEdit control = (FieldEdit)view.getControl(interfaceField);
            if (control != null) {
                control.setMustInput(isMustInput);
            }
            view.setVisible(Boolean.valueOf(isShow), new String[]{interfaceField});
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject rowData = view.getModel().getEntryRowEntity("entryentity", i);
                String billNo = (String)rowData.get("billno");
                if (StringUtils.isNotEmpty((CharSequence)billNo)) {
                    view.setEnable(Boolean.FALSE, i, new String[]{interfaceField});
                    continue;
                }
                boolean conditionLock = WorkbenchFieldsConditionShowAndLockHelper.isLock(rowData, dataFromBOTP, interfaceField);
                if (isLock || conditionLock) {
                    view.setEnable(Boolean.FALSE, i, new String[]{interfaceField});
                    continue;
                }
                view.setEnable(Boolean.TRUE, i, new String[]{interfaceField});
            }
        }
    }

    public static boolean isDataFromBOTP(IFormView view) {
        String dataFromBOTPStr = view.getPageCache().get("dataFromBOTP");
        boolean dataFromBOTP = false;
        if ("true".equals(dataFromBOTPStr)) {
            dataFromBOTP = true;
        }
        return dataFromBOTP;
    }

    public static DynamicObject newTarBill(String tarEntityNumber, IFormView view) {
        DynamicObject bizObj = BusinessDataServiceHelper.newDynamicObject((String)tarEntityNumber);
        ISimpleProperty primaryKey = bizObj.getDataEntityType().getPrimaryKey();
        if (primaryKey instanceof TextProp) {
            bizObj.set("id", (Object)DB.genStringId((String)""));
        } else {
            bizObj.set("id", (Object)DB.genGlobalLongId());
        }
        List<InterfaceCfgField> fieldsMappingList = WorkbenchServiceHelper.getFieldsMappingList(view);
        String tarBillEntryKey = WorkbenchServiceHelper.getTarBillEntryKey(fieldsMappingList);
        if (StringUtils.isNotEmpty((CharSequence)tarBillEntryKey)) {
            DynamicObjectCollection entryDataCollection = bizObj.getDynamicObjectCollection(tarBillEntryKey);
            DynamicObject newEntry = entryDataCollection.addNew();
            newEntry.set("id", (Object)DB.genGlobalLongId());
        }
        return bizObj;
    }

    public static int getFocusLineIndex(IFormView view) {
        String cacheIndex = view.getPageCache().get(DETAIL_ROW_INDEX);
        int detailIndex = -1;
        if (StringUtils.isNotBlank((CharSequence)cacheIndex)) {
            try {
                detailIndex = Integer.parseInt(cacheIndex);
            }
            catch (NumberFormatException e) {
                log.error("\u83b7\u53d6\u7126\u70b9\u884c\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
        return detailIndex;
    }

    public static void selectedFocusRow(IFormView view) {
        int focusLineIndex = WorkbenchServiceHelper.getFocusLineIndex(view);
        if (focusLineIndex >= 0) {
            EntryGrid control = (EntryGrid)view.getControl("entryentity");
            control.selectRows(focusLineIndex);
            DynamicObjectCollection entryDataColl = (DynamicObjectCollection)view.getModel().getDataEntity(true).get("entryentity");
            DynamicObject rowData = (DynamicObject)entryDataColl.get(focusLineIndex);
            String billId = rowData.getString("billid");
            String rowId = rowData.getString("rowid");
            String entryRowDynamicDataStr = WorkbenchServiceHelper.getEntryRowStrData(view, billId);
            HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
            paramMap.put("rowId", rowId);
            paramMap.put("rowData", entryRowDynamicDataStr);
            WorkbenchServiceHelper.sendRowChangeEvent(view, paramMap);
        }
    }

    public static void setDataLoadTime(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        pageCache.put(DATA_LOAD_TIME_CACHE_KEY, String.valueOf(System.currentTimeMillis()));
    }

    public static long getDataLoadTime(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String loadTimeStr = pageCache.get(DATA_LOAD_TIME_CACHE_KEY);
        if (StringUtils.isNotBlank((CharSequence)loadTimeStr)) {
            return Long.parseLong(loadTimeStr);
        }
        return System.currentTimeMillis();
    }

    public static void setBillNoLoadTime(IFormView view, String ... billNos) {
        IPageCache pageCache = view.getPageCache();
        String billNoTimeStr = pageCache.get(BILL_NO_LOAD_TIME_CACHE_KEY);
        Map<String, Long> billNoTimeMap = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)billNoTimeStr)) {
            billNoTimeMap = (Map)SerializationUtils.fromJsonString((String)billNoTimeStr, Map.class);
        }
        long nowTime = System.currentTimeMillis();
        for (String billNo : billNos) {
            billNoTimeMap.put(billNo, nowTime);
        }
        String timeMapStr = SerializationUtils.toJsonString(billNoTimeMap);
        pageCache.put(BILL_NO_LOAD_TIME_CACHE_KEY, timeMapStr);
    }

    public static Map<String, Long> getBillNoLoadTimeMap(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String billNoTimeStr = pageCache.get(BILL_NO_LOAD_TIME_CACHE_KEY);
        Map<String, Long> billNoTimeMap = new HashMap<String, Long>(16);
        if (StringUtils.isNotBlank((CharSequence)billNoTimeStr)) {
            billNoTimeMap = (Map)SerializationUtils.fromJsonString((String)billNoTimeStr, Map.class);
        }
        return billNoTimeMap;
    }

    public static long getBillNoLoadTime(IFormView view, String billNo) {
        Long time;
        IPageCache pageCache = view.getPageCache();
        String billNoTimeStr = pageCache.get(BILL_NO_LOAD_TIME_CACHE_KEY);
        Map billNoTimeMap = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)billNoTimeStr)) {
            billNoTimeMap = (Map)SerializationUtils.fromJsonString((String)billNoTimeStr, Map.class);
        }
        if ((time = (Long)billNoTimeMap.get(billNo)) == null) {
            time = System.currentTimeMillis();
        }
        return time;
    }
}

