/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.service.impl.WorkflowServiceImpl;

public class TriggerEventHelper {
    private static Map<String, String> opTypeKeyEventNumMap = new HashMap<String, String>(5);

    public void triggerEventSubscribeJobs(String eventNum, DynamicObject[] bills) {
        WorkflowServiceImpl service = (WorkflowServiceImpl)ServiceFactory.getService((String)"IWorkflowService");
        service.triggerEventSubscribeJobs(eventNum, bills);
    }

    public Object triggerEvent(String eventNum, JSONObject json) {
        WorkflowServiceImpl service = (WorkflowServiceImpl)ServiceFactory.getService((String)"IWorkflowService");
        return service.triggerEventSubscribe(eventNum, json.toJSONString());
    }

    public void triggerEventByOp(DynamicObject[] invBillDycs, String operate, String formId) {
        this.triggerEventByOp(invBillDycs, operate, formId, null);
    }

    public void triggerEventByOp(DynamicObject[] invBillDycs, String operate, String formId, OperateOption option) {
        if (invBillDycs == null || invBillDycs.length == 0) {
            return;
        }
        StringBuilder idsSb = new StringBuilder();
        StringBuilder numbersSb = new StringBuilder();
        String billNoField = ((BillEntityType)EntityMetadataCache.getDataEntityType((String)formId)).getBillNo();
        for (DynamicObject invBillDyc : invBillDycs) {
            idsSb.append(invBillDyc.getPkValue());
            idsSb.append(",");
            numbersSb.append(invBillDyc.getString(billNoField));
            numbersSb.append(",");
        }
        JSONObject jParam = new JSONObject();
        jParam.put("operate", (Object)operate);
        jParam.put("entity", (Object)formId);
        jParam.put("ids", (Object)idsSb.substring(0, idsSb.length() - 1));
        jParam.put("numbers", (Object)numbersSb.substring(0, numbersSb.length() - 1));
        jParam.put("entityNumber", (Object)formId);
        if (option != null) {
            jParam.put("operateoption", (Object)option.getVariables());
        }
        String eventNum = opTypeKeyEventNumMap.get(operate);
        this.triggerEvent(eventNum, jParam);
    }

    static {
        opTypeKeyEventNumMap.put("submit", "InvBillSubmit");
        opTypeKeyEventNumMap.put("unsubmit", "InvBillUnSubmit");
        opTypeKeyEventNumMap.put("audit", "InvBillAudit");
        opTypeKeyEventNumMap.put("unaudit", "InvBillUnAudit");
        opTypeKeyEventNumMap.put("delete", "InvBillDelete");
    }
}

