/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.idemponent.properties.ConcurrentPolicyEnum;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.properties.StorageStrategyEnum;

public class DefaultEcServiceIdempotentProperties {
    public static IdempotentProperties generate(String className, Object param) {
        String keyStr = className + "#" + JSON.toJSONString((Object)param, (SerializeFilter)new ParamPropertyPreFilter(), (SerializerFeature[])new SerializerFeature[0]);
        IdempotentProperties idemProp = new IdempotentProperties();
        idemProp.setIdempotentKey(DefaultEcServiceIdempotentProperties.encode(keyStr));
        idemProp.setAlivedTime(Long.valueOf(2400000L));
        idemProp.setDbRoute(new DBRoute("scm"));
        idemProp.setStorageStrategy(StorageStrategyEnum.DB);
        idemProp.setConcurrentPolicy(ConcurrentPolicyEnum.QUICK_RETURN);
        return idemProp;
    }

    private static String encode(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e1) {
            throw new KDBizException((Throwable)e1, new ErrorCode("", String.format("IM-SHA256Base64Util:[%s] args:[%s]", e1.getMessage(), message)), new Object[0]);
        }
    }

    static class ParamPropertyPreFilter
    implements PropertyPreFilter {
        ParamPropertyPreFilter() {
        }

        public boolean apply(JSONSerializer serializer, Object source, String name) {
            if (name.equalsIgnoreCase("userName")) {
                return false;
            }
            if (name.equalsIgnoreCase("userId")) {
                return false;
            }
            if (name.equalsIgnoreCase("orgId")) {
                return false;
            }
            return !name.equalsIgnoreCase("requestId");
        }
    }
}

