/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class GetAdviceType {
    public static final String ORG_ID = "orgId";
    public static final String MATERIAL_ID = "baseDataId";
    public static final String BIZ_TYPE = "bizType";
    public static final String BASE_DATA_TYPE = "baseDataType";
    public static final String BILL_ID = "billId";
    public static final String UNIQUE_KEY = "uniqueKey";
    public static final String PUR_TYPE_FALSE = "false";
    public static final String PUR_TYPE_ONE = "1";
    public static final String PUR_TYPE_TWO = "2";
    public static final String SUCCESS = "success";
    public static final String FALSE = "false";
    public static final String CLASS_TYPE = "classType";
    public static final String REQ_KIND = "reqKind";
    public static final String REQ_KIND_A = "A";
    public static final String CENTER_PUR = "1";
    public static final String DEMANDKIND = "demandkind";
    private static Log logger = LogFactory.getLog((String)"kd.scmc.im.utils.GetAdviceType");

    private GetAdviceType() {
    }

    public static Set<Object> getCenterPurEntryIds(Set<String> entryIds, DynamicObject[] invAdviceBills) {
        HashSet<Long> reqBillEntryIds = new HashSet<Long>(16);
        HashSet<Object> centerPurEntryIds = new HashSet<Object>(16);
        for (DynamicObject invAdviceBill : invAdviceBills) {
            DynamicObjectCollection entries = invAdviceBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                if (entryIds != null && !entryIds.isEmpty() && !entryIds.contains(entry.getString("id"))) continue;
                reqBillEntryIds.add(entry.getLong("demandbillentryid"));
            }
        }
        if (!reqBillEntryIds.isEmpty()) {
            Map reqEntryInfoMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pssc", (String)"IPassReqBillService", (String)"queryReqStrategyInfo", (Object[])new Object[]{reqBillEntryIds});
            reqBillEntryIds.clear();
            for (Map.Entry reqEntryInfo : reqEntryInfoMap.entrySet()) {
                String purStrategy = (String)((Map)reqEntryInfo.getValue()).get(CLASS_TYPE);
                String reqKind = (String)((Map)reqEntryInfo.getValue()).get(REQ_KIND);
                if (!StringUtils.isNotEmpty((String)reqKind) || !REQ_KIND_A.equals(reqKind) || !StringUtils.isNotEmpty((String)purStrategy) || !"1".equals(purStrategy)) continue;
                reqBillEntryIds.add((Long)reqEntryInfo.getKey());
            }
        }
        if (reqBillEntryIds.isEmpty()) {
            return centerPurEntryIds;
        }
        ArrayList<Map<String, Object>> param = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject invAdviceBill : invAdviceBills) {
            String demandKind = invAdviceBill.getString(DEMANDKIND);
            int bizType = 1;
            if (REQ_KIND_A.equals(demandKind)) {
                bizType = 2;
            } else if ("B".equals(demandKind)) {
                bizType = 3;
            }
            Object invBillId = invAdviceBill.getPkValue();
            DynamicObject invOrg = invAdviceBill.getDynamicObject("org");
            DynamicObjectCollection adviceBillEntrys = invAdviceBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject adviceBillEntry : adviceBillEntrys) {
                long reqEntryId = adviceBillEntry.getLong("demandbillentryid");
                if (!reqBillEntryIds.contains(reqEntryId)) continue;
                param.add(GetAdviceType.buildCommonParam(adviceBillEntry, String.valueOf(bizType), invBillId, invOrg.getPkValue()));
            }
        }
        if (param.isEmpty()) {
            return centerPurEntryIds;
        }
        return GetAdviceType.getAdviceType(param);
    }

    private static Map<String, Object> buildCommonParam(DynamicObject adviceBillEntry, String bizType, Object billId, Object orgId) {
        Object materialId = adviceBillEntry.getDynamicObject("material").getPkValue();
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put(BIZ_TYPE, bizType);
        param.put(MATERIAL_ID, materialId);
        param.put(ORG_ID, orgId);
        param.put(BASE_DATA_TYPE, PUR_TYPE_TWO);
        param.put(BILL_ID, billId);
        param.put(UNIQUE_KEY, adviceBillEntry.getPkValue());
        return param;
    }

    public static Set<Object> getAdviceType(List<Map<String, Object>> params) {
        HashSet<Object> purFocusSet = new HashSet();
        Set<String> orgMaterialBillIdMappingList = GetAdviceType.callPurPolicyInterface(params);
        purFocusSet = GetAdviceType.callDemandServiceInterface(params, orgMaterialBillIdMappingList);
        return purFocusSet;
    }

    private static Set<String> callPurInterface(List<Map<String, Object>> inParams) {
        Map purTypeData;
        List<Map<String, Object>> purParams = GetAdviceType.builderPurInterfaceParam(inParams);
        HashSet<String> orgMaterialMappingSet = new HashSet<String>();
        if (purParams.isEmpty()) {
            return orgMaterialMappingSet;
        }
        Map purType = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"ICategoryService", (String)"batchGetPurChaseOrg", (Object[])new Object[]{purParams, "im_balanceinv_advice"});
        logger.info("\u83b7\u53d6\u91c7\u8d2d\u76ee\u5f55\u63a5\u53e3\u7ed3\u679c\u7684\u5165\u53c2\uff1a" + purParams + ",\u7ed3\u679c\uff1a" + purType);
        boolean isSuccess = (Boolean)purType.get(SUCCESS);
        if (isSuccess && !(purTypeData = (Map)purType.get("data")).isEmpty()) {
            for (Map.Entry entry : purTypeData.entrySet()) {
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                String classType = (String)value.get("classtype");
                if (!"1".equals(classType)) continue;
                orgMaterialMappingSet.add(key);
            }
        }
        return orgMaterialMappingSet;
    }

    private static List<Map<String, Object>> builderPurInterfaceParam(List<Map<String, Object>> inParams) {
        ArrayList<Map<String, Object>> returnParams = new ArrayList<Map<String, Object>>(inParams.size());
        for (Map<String, Object> param : inParams) {
            HashMap<String, Object> purParam = new HashMap<String, Object>(4);
            purParam.put(ORG_ID, param.get(ORG_ID));
            purParam.put(MATERIAL_ID, param.get(MATERIAL_ID));
            purParam.put(BIZ_TYPE, param.get(BIZ_TYPE));
            purParam.put(BASE_DATA_TYPE, param.get(BASE_DATA_TYPE));
            returnParams.add(purParam);
        }
        return returnParams;
    }

    private static Set<String> callPurPolicyInterface(List<Map<String, Object>> inParams) {
        Map data;
        HashSet<String> orgMaterialMappingSet = new HashSet<String>();
        List<Map<String, Object>> purPolicyParam = GetAdviceType.builderPurPolicyParam(inParams);
        if (purPolicyParam.isEmpty()) {
            return orgMaterialMappingSet;
        }
        GetAdviceType.initDemandParam(purPolicyParam, orgMaterialMappingSet);
        Map purPolicyData = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"ICategoryService", (String)"matchPurChaseStrategy", (Object[])new Object[]{purPolicyParam, "im_balanceinv_advice"});
        logger.info("\u91c7\u8d2d\u6267\u884c\u7b56\u7565\u63a5\u53e3\u5165\u53c2\uff1a" + purPolicyParam + ",\u7ed3\u679c\uff1a" + purPolicyData);
        boolean isSuccess = (Boolean)purPolicyData.get(SUCCESS);
        if (isSuccess && !(data = (Map)purPolicyData.get("data")).isEmpty()) {
            for (Map.Entry entry : data.entrySet()) {
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                boolean isMal = Boolean.parseBoolean(value.get("isMal").toString());
                if (!isMal) continue;
                orgMaterialMappingSet.remove(key);
            }
        }
        return orgMaterialMappingSet;
    }

    private static void initDemandParam(List<Map<String, Object>> purPolicyParam, Set<String> orgMaterialMappingSet) {
        for (Map<String, Object> map : purPolicyParam) {
            Object orgId = map.get(ORG_ID);
            Object materialId = map.get(MATERIAL_ID);
            String baseDataType = (String)map.get(BASE_DATA_TYPE);
            String value = orgId + "-" + materialId + "-" + baseDataType;
            orgMaterialMappingSet.add(value);
        }
    }

    private static List<Map<String, Object>> builderPurPolicyParam(List<Map<String, Object>> inParams) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(inParams.size());
        for (Map<String, Object> param : inParams) {
            Object orgId = param.get(ORG_ID);
            Object materialId = param.get(MATERIAL_ID);
            String baseDataType = (String)param.get(BASE_DATA_TYPE);
            HashMap<String, Object> purPolicyParam = new HashMap<String, Object>(4);
            purPolicyParam.put(ORG_ID, orgId);
            purPolicyParam.put(BASE_DATA_TYPE, baseDataType);
            purPolicyParam.put(MATERIAL_ID, materialId);
            purPolicyParam.put(BILL_ID, param.get(BILL_ID));
            result.add(purPolicyParam);
        }
        return result;
    }

    private static Set<Object> callDemandServiceInterface(List<Map<String, Object>> inParams, Set<String> set) {
        HashSet<Object> result = new HashSet<Object>();
        List<Map<String, Object>> demandServiceParam = GetAdviceType.buildDemandServiceParam(inParams, set);
        if (demandServiceParam.isEmpty()) {
            return result;
        }
        String resStr = (String)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pssc", (String)"IReqGatherPathService", (String)"queryReqGatherPath", (Object[])new Object[]{SerializationUtils.toJsonString(demandServiceParam)});
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)resStr, Map.class);
        logger.info("\u8c03\u7528\u9700\u6c42\u6c47\u603b\u8def\u5f84\u670d\u52a1\u63a5\u53e3\u5165\u53c2\uff1a" + demandServiceParam + ",\u7ed3\u679c\uff1a" + dataMap);
        boolean isSuccess = (Boolean)dataMap.get(SUCCESS);
        if (isSuccess) {
            List dataList = (List)dataMap.get("data");
            for (Map map : dataList) {
                boolean value = Boolean.parseBoolean(map.get("value").toString());
                if (value) continue;
                result.add(Long.parseLong(map.get(UNIQUE_KEY).toString()));
            }
        }
        return result;
    }

    private static List<Map<String, Object>> buildDemandServiceParam(List<Map<String, Object>> inParams, Set<String> set) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (set.isEmpty()) {
            return result;
        }
        for (Map<String, Object> param : inParams) {
            Object orgId = param.get(ORG_ID);
            Object materialId = param.get(MATERIAL_ID);
            String baseDataType = (String)param.get(BASE_DATA_TYPE);
            String setKey = orgId + "-" + materialId + "-" + baseDataType;
            if (!set.contains(setKey)) continue;
            HashMap<String, Object> demandServiceParam = new HashMap<String, Object>(4);
            demandServiceParam.put("org", orgId);
            String kind = REQ_KIND_A;
            String bizType = (String)param.get(BIZ_TYPE);
            if (!PUR_TYPE_TWO.equals(bizType)) {
                kind = "B";
            }
            demandServiceParam.put("kind", kind);
            demandServiceParam.put("material", materialId);
            demandServiceParam.put(UNIQUE_KEY, param.get(UNIQUE_KEY));
            result.add(demandServiceParam);
        }
        return result;
    }
}

