/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveRecordHandler;
import kd.mpscmm.msbd.reserve.business.record.ReserveRecordHelper;
import kd.mpscmm.msbd.reserve.mservice.ReserveService;

public class InvAdviceReserveRelease {
    public static void releaseReserve(DynamicObject[] invAdviceBill) {
        InvAdviceReserveRelease.releaseReserve(invAdviceBill, true);
    }

    public static void releaseReservation(List<DynamicObject> billList) {
        if (!billList.isEmpty()) {
            QFilter filter;
            DynamicObjectCollection reserveRecordList;
            ArrayList<Long> purAdviceIds = new ArrayList<Long>();
            final ArrayList<Long> matAdviceIds = new ArrayList<Long>();
            ArrayList<Long> matAdviceEntryIds = new ArrayList<Long>();
            for (DynamicObject bill : billList) {
                String adviceType = bill.getString("advicetype");
                long billId = bill.getLong("id");
                if ("A".equals(adviceType) || "F".equals(adviceType)) {
                    purAdviceIds.add(billId);
                    continue;
                }
                matAdviceIds.add(billId);
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    matAdviceEntryIds.add(entry.getLong("id"));
                }
            }
            if (!matAdviceIds.isEmpty()) {
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onRollbacked() {
                        ReserveService.releaseReserveRollBack((long)0L, (String)"im_balanceinv_advice", (String)JSON.toJSONString((Object)matAdviceIds));
                    }
                });
                OperationResult result = ReserveService.releaseReserve((String)"im_balanceinv_advice", (String)JSON.toJSONString(matAdviceIds), (String)JSON.toJSONString(matAdviceEntryIds));
                if (!result.isSuccess()) {
                    throw new KDBizException(result.getMessage());
                }
            }
            if (!purAdviceIds.isEmpty() && !(reserveRecordList = ReserveRecordHelper.queryReserveRecordList((QFilter)(filter = new QFilter("bal_id", "in", purAdviceIds).and("ispredict", "=", (Object)true)))).isEmpty()) {
                ReserveRecordHandler.reserveRemoveByRecordList((List)reserveRecordList);
            }
        }
    }

    public static void releaseReserve(DynamicObject[] invAdviceBill, boolean needCheck) {
        HashSet<Long> keeper = new HashSet<Long>(16);
        HashSet<Long> demandBillEntryId = new HashSet<Long>(16);
        HashSet<Long> wareHouse = new HashSet<Long>();
        HashSet<Long> purInvBillId = new HashSet<Long>(invAdviceBill.length);
        HashSet<Long> invBillId = new HashSet<Long>(invAdviceBill.length);
        ArrayList<Map<String, Object>> listInv = new ArrayList<Map<String, Object>>(16);
        HashSet<Long> billEntryId = new HashSet<Long>(16);
        for (int i = 0; i < invAdviceBill.length; ++i) {
            DynamicObject invBill = invAdviceBill[i];
            String adviceType = invBill.getString("advicetype");
            DynamicObjectCollection entryCol = invBill.getDynamicObjectCollection("entryentity");
            if ("F".equals(adviceType)) continue;
            if ("A".equals(adviceType)) {
                purInvBillId.add((Long)invBill.getPkValue());
                continue;
            }
            DynamicObject supplyOrg = invBill.getDynamicObject("supplyorg");
            DynamicObject supplier = invBill.getDynamicObject("supplier");
            String billNo = invBill.getString("billno");
            long ownerId = 0L;
            if (supplyOrg == null && supplier == null) {
                if (!needCheck) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u201c%s\u201d\u7684\u4f9b\u5e94\u7ec4\u7ec7\u548c\u4f9b\u5e94\u5546\u540c\u65f6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u91ca\u653e\u9884\u7559\u3002", (String)"InvAdviceReserveRelease_0", (String)"scmc-im-common", (Object[])new Object[0]), billNo));
            }
            ownerId = supplyOrg == null ? ((Long)supplier.getPkValue()).longValue() : ((Long)supplyOrg.getPkValue()).longValue();
            billEntryId.addAll(InvAdviceReserveRelease.getBillEntryId((List<DynamicObject>)entryCol));
            InvAdviceReserveRelease.resolveBillEntry((List<DynamicObject>)entryCol, keeper, wareHouse, demandBillEntryId, ownerId, listInv, billNo, needCheck);
            invBillId.add((Long)invBill.getPkValue());
        }
        if (!invBillId.isEmpty()) {
            Long[] ids = invBillId.toArray(new Long[invBillId.size()]);
            InvAdviceReserveRelease.doReleaseReserveByBillId(listInv, ids, demandBillEntryId, InvAdviceReserveRelease.getBOTPLinkBillIds("im_balanceinv_advice", ids), billEntryId, false);
        }
        if (!purInvBillId.isEmpty()) {
            InvAdviceReserveRelease.releasePreInReserve(purInvBillId);
        }
    }

    private static void releasePreInReserve(Set<Long> ids) {
        QFilter filter = new QFilter("bal_id", "in", ids);
        DynamicObjectCollection reserveRecords = QueryServiceHelper.query((String)"msmod_reserve_record", (String)"id", (QFilter[])filter.toArray());
        if (reserveRecords != null && !reserveRecords.isEmpty()) {
            ArrayList<Object> reserveIdList = new ArrayList<Object>();
            for (DynamicObject reserveRecord : reserveRecords) {
                reserveIdList.add(reserveRecord.get("id"));
            }
            ReserveService.removeReserveRecordByRecordId(reserveIdList);
        }
    }

    public static void resolveBillPurEntry(List<DynamicObject> billEntry, Set<Long> demandBillEntryId, List<Map<String, Object>> listInv, Set<Long> purBillEntryId) {
        for (DynamicObject entry : billEntry) {
            String isClosed = entry.getString("isclosed");
            String isCancel = entry.getString("iscancel");
            if ("B".equals(isClosed) || "B".equals(isCancel)) continue;
            long billEntryId = entry.getLong("demandbillentryid");
            demandBillEntryId.add(billEntryId);
            purBillEntryId.add((Long)entry.getPkValue());
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("demandbillentryid", billEntryId);
            map.put("qty", entry.getBigDecimal("baseqty"));
            map.put("entryid", entry.getPkValue());
            listInv.add(map);
        }
    }

    public static void resolveBillEntry(List<DynamicObject> billEntry, Set<Long> keeper, Set<Long> wareHouse, Set<Long> demandBillEntryId, long ownerId, List<Map<String, Object>> listInv, String billNo) {
        InvAdviceReserveRelease.resolveBillEntry(billEntry, keeper, wareHouse, demandBillEntryId, ownerId, listInv, billNo, true);
    }

    public static void resolveBillEntry(List<DynamicObject> billEntry, Set<Long> keeper, Set<Long> wareHouse, Set<Long> demandBillEntryId, long ownerId, List<Map<String, Object>> listInv, String billNo, boolean needCheck) {
        for (DynamicObject entry : billEntry) {
            String isClosed = entry.getString("isclosed");
            String isCancel = entry.getString("iscancel");
            if ("B".equals(isClosed) || "B".equals(isCancel)) continue;
            DynamicObject supplyInvOrg = entry.getDynamicObject("supplyinvorg");
            int seq = entry.getInt("seq");
            if (supplyInvOrg == null) {
                if (!needCheck) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e%1$s\u7684\u5206\u5f55\u884c\u7b2c%2$s\u884c\u4f9b\u5e94\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u91ca\u653e\u9884\u7559\u3002", (String)"InvAdviceReserveRelease_1", (String)"scmc-im-common", (Object[])new Object[0]), billNo, seq));
            }
            DynamicObject supplyWareHouse = entry.getDynamicObject("supplywarehouse");
            if (supplyWareHouse == null) {
                if (!needCheck) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e%1$s\u7684\u5206\u5f55\u884c\u7b2c%2$s\u884c\u4f9b\u5e94\u4ed3\u5e93\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u91ca\u653e\u9884\u7559\u3002", (String)"InvAdviceReserveRelease_2", (String)"scmc-im-common", (Object[])new Object[0]), billNo, seq));
            }
            long keeperId = (Long)supplyInvOrg.getPkValue();
            long curDemandBillEntryId = entry.getLong("demandbillentryid");
            long wareHouseId = (Long)supplyWareHouse.getPkValue();
            keeper.add(keeperId);
            demandBillEntryId.add(curDemandBillEntryId);
            wareHouse.add(wareHouseId);
            HashMap<String, Object> map = new HashMap<String, Object>(6);
            map.put("demandbillentryid", curDemandBillEntryId);
            map.put("supplyorg", ownerId);
            map.put("supplyinvorg", keeperId);
            map.put("supplywarehouse", wareHouseId);
            map.put("qty", entry.getBigDecimal("baseqty"));
            map.put("entryid", entry.getPkValue());
            listInv.add(map);
        }
    }

    private static List<Map<String, Object>> buildReserveParam(List<Map<String, Object>> listInv, DynamicObject[] reserveRecord, Map<Long, Object> entryIdMap) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(16);
        block0: for (Map<String, Object> map : listInv) {
            Object demandBillEntryId = map.get("demandbillentryid");
            Object ownerId = map.get("supplyorg");
            Object keeperId = map.get("supplyinvorg");
            Object wareHouseId = map.get("supplywarehouse");
            BigDecimal invQty = (BigDecimal)map.get("qty");
            for (DynamicObject reserve : reserveRecord) {
                boolean isTrue;
                if (invQty.compareTo(BigDecimal.ZERO) <= 0) continue block0;
                BigDecimal reserveBaseQty = reserve.getBigDecimal("base_qty");
                if (reserveBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                HashMap<String, Object> paramMap = new HashMap<String, Object>(6);
                Object reserveDemandBillEntryId = reserve.get("billentry_id");
                Object reserveOwnerId = ((DynamicObject)reserve.get("s_owner")).getPkValue();
                Object reserveKeeperId = ((DynamicObject)reserve.get("s_keeper")).getPkValue();
                Object reserveWareHouseId = ((DynamicObject)reserve.get("s_warehouse")).getPkValue();
                Long billEntryId = (Long)map.get("entryid");
                boolean bl = isTrue = demandBillEntryId.equals(reserveDemandBillEntryId) || reserveDemandBillEntryId.equals(entryIdMap.get(billEntryId));
                if (isTrue && ownerId.equals(reserveOwnerId) && keeperId.equals(reserveKeeperId) && wareHouseId.equals(reserveWareHouseId)) {
                    invQty = InvAdviceReserveRelease.dealWithQty(invQty, reserve, paramMap);
                }
                if (paramMap.isEmpty()) continue;
                paramList.add(paramMap);
            }
        }
        return paramList;
    }

    private static List<Map<String, Object>> buildPurReserveParam(List<Map<String, Object>> listInv, DynamicObject[] reserveRecord, Map<Long, Object> entryIdMap) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(16);
        block0: for (Map<String, Object> map : listInv) {
            Object demandBillEntryId = map.get("demandbillentryid");
            BigDecimal invQty = (BigDecimal)map.get("qty");
            for (DynamicObject reserve : reserveRecord) {
                if (invQty.compareTo(BigDecimal.ZERO) <= 0) continue block0;
                BigDecimal reserveBaseQty = reserve.getBigDecimal("base_qty");
                if (reserveBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                HashMap<String, Object> paramMap = new HashMap<String, Object>(6);
                Object reserveDemandBillEntryId = reserve.get("billentry_id");
                Long billEntryId = (Long)map.get("entryid");
                if (demandBillEntryId.equals(reserveDemandBillEntryId) || reserveDemandBillEntryId.equals(entryIdMap.get(billEntryId))) {
                    invQty = InvAdviceReserveRelease.dealWithQty(invQty, reserve, paramMap);
                }
                if (paramMap.isEmpty()) continue;
                paramList.add(paramMap);
            }
        }
        return paramList;
    }

    private static void doReleaseReserveByBillId(List<Map<String, Object>> listInv, Long[] billIds, Set<Long> demandBillEntryId, Set<Object> ids, Set<Long> billEntryId, boolean preRecord) {
        List<Map<String, Object>> reserveParam;
        String selectProperties = "id,qty,base_qty,qty2nd,billentry_id,s_owner,s_keeper,s_warehouse,s_materiel,s_unit,s_baseunit,s_unit2nd,ispredict";
        QFilter qFilter = null;
        QFilter billIdFilter = new QFilter("bill_id", "in", ids).or(new QFilter("bal_id", "in", ids));
        qFilter = billIdFilter.and(new QFilter("ispredict", "=", (Object)preRecord));
        DynamicObject[] reserveRecord = BusinessDataServiceHelper.load((String)"msmod_reserve_record", (String)selectProperties, (QFilter[])qFilter.toArray());
        Map<Long, Object> entryIdMap = InvAdviceReserveRelease.getBOTPLinkBillEntryIds("im_balanceinv_advice", "entryentity", billIds, billEntryId.toArray(new Long[demandBillEntryId.size()]));
        List<Map<String, Object>> list = reserveParam = preRecord ? InvAdviceReserveRelease.buildPurReserveParam(listInv, reserveRecord, entryIdMap) : InvAdviceReserveRelease.buildReserveParam(listInv, reserveRecord, entryIdMap);
        if (!reserveParam.isEmpty()) {
            ReserveService.reserveReleaseBatch(reserveParam);
        }
    }

    public static void writeBackSourceBillQty(DynamicObject[] invAdviceBill) {
        HashSet<Long> demandBillId = new HashSet<Long>(16);
        HashMap<Object, BigDecimal> entryId2QtyMap = new HashMap<Object, BigDecimal>(16);
        for (DynamicObject adviceBill : invAdviceBill) {
            DynamicObjectCollection entryBillCol = adviceBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryBill : entryBillCol) {
                String isClosed = entryBill.getString("isclosed");
                String isCancel = entryBill.getString("iscancel");
                if ("B".equals(isClosed) || "B".equals(isCancel)) continue;
                long curDemandBillId = entryBill.getLong("demandbillid");
                long curDemandEntryId = entryBill.getLong("demandbillentryid");
                BigDecimal baseQty = entryBill.getBigDecimal("baseqty");
                demandBillId.add(curDemandBillId);
                BigDecimal countQty = entryId2QtyMap.getOrDefault(curDemandEntryId, BigDecimal.ZERO);
                entryId2QtyMap.put(curDemandEntryId, countQty.add(baseQty));
            }
        }
        InvAdviceReserveRelease.updateBillQtyField(entryId2QtyMap, demandBillId);
    }

    public static void releaseReserve(List<DynamicObject> billEntryList, long ownerId, long billId, String billNo) {
        HashSet<Long> keeper = new HashSet<Long>(billEntryList.size());
        HashSet<Long> wareHouse = new HashSet<Long>(billEntryList.size());
        HashSet<Long> demandBillEntryId = new HashSet<Long>(billEntryList.size());
        ArrayList<Map<String, Object>> listInv = new ArrayList<Map<String, Object>>(billEntryList.size());
        InvAdviceReserveRelease.resolveBillEntry(billEntryList, keeper, wareHouse, demandBillEntryId, ownerId, listInv, billNo);
        InvAdviceReserveRelease.doReleaseReserveByBillId(listInv, new Long[]{billId}, demandBillEntryId, InvAdviceReserveRelease.getBOTPLinkBillIds("im_balanceinv_advice", new Long[]{billId}), InvAdviceReserveRelease.getBillEntryId(billEntryList), false);
    }

    public static void writeBackSourceBillQty(List<DynamicObject> billEntry) {
        HashSet<Long> demandBillId = new HashSet<Long>(billEntry.size());
        HashMap<Object, BigDecimal> entryId2QtyMap = new HashMap<Object, BigDecimal>(billEntry.size());
        for (DynamicObject entryBill : billEntry) {
            long curDemandBillId = entryBill.getLong("demandbillid");
            long curDemandEntryId = entryBill.getLong("demandbillentryid");
            BigDecimal baseQty = entryBill.getBigDecimal("baseqty");
            demandBillId.add(curDemandBillId);
            BigDecimal countQty = entryId2QtyMap.getOrDefault(curDemandEntryId, BigDecimal.ZERO);
            entryId2QtyMap.put(curDemandEntryId, countQty.add(baseQty));
        }
        InvAdviceReserveRelease.updateBillQtyField(entryId2QtyMap, demandBillId);
    }

    public static void setBillNo(List<DynamicObject> billList) {
        List billNoList = CodeRuleServiceHelper.getNumbers((String)"im_balanceinv_advice", billList);
        for (int i = 0; i < billNoList.size(); ++i) {
            billList.get(i).set("billno", billNoList.get(i));
        }
    }

    private static Set<Object> getBOTPLinkBillIds(String billName, Long[] billIdArray) {
        HashSet<Object> ids = new HashSet<Object>(16);
        Map srcBills = BFTrackerServiceHelper.findSourceBills((String)billName, (Long[])billIdArray);
        for (HashSet srcId : srcBills.values()) {
            ids.addAll(srcId);
        }
        ids.addAll(Arrays.asList(billIdArray));
        return ids;
    }

    private static Map<Long, Object> getBOTPLinkBillEntryIds(String billNumber, String entryNumber, Long[] billId, Long[] entryId) {
        List listUpNode = BFTrackerServiceHelper.loadLinkUpNodes((String)billNumber, (String)entryNumber, (Long[])billId, (Long[])entryId, null);
        HashMap<Long, Object> entryIdToSrcEntryId = new HashMap<Long, Object>(entryId.length);
        if (!listUpNode.isEmpty()) {
            for (Long id : entryId) {
                BFRowLinkUpNode linkUpNode = InvAdviceReserveRelease.getBFRowLinkUpNode(id, listUpNode);
                Object srcEntryId = InvAdviceReserveRelease.getSrcEntryIdByBOTP(linkUpNode);
                entryIdToSrcEntryId.put(id, srcEntryId);
            }
        }
        return entryIdToSrcEntryId;
    }

    private static BFRowLinkUpNode getBFRowLinkUpNode(Long id, List<BFRowLinkUpNode> listUpNode) {
        for (BFRowLinkUpNode curUpNode : listUpNode) {
            if (!id.equals(curUpNode.getRowId().getEntryId())) continue;
            return curUpNode;
        }
        return null;
    }

    private static Object getSrcEntryIdByBOTP(BFRowLinkUpNode linkUpNode) {
        if (linkUpNode != null) {
            Map sNodes = linkUpNode.getSNodes();
            if (sNodes.isEmpty() || sNodes.size() <= 0) {
                return linkUpNode.getRowId().getEntryId();
            }
            return InvAdviceReserveRelease.getSrcEntryIdByBOTP(sNodes.values().toArray(new BFRowLinkUpNode[sNodes.size()])[0]);
        }
        return null;
    }

    private static BigDecimal dealWithQty(BigDecimal invQty, DynamicObject reserve, Map<String, Object> paramMap) {
        BigDecimal reserveBaseQty = reserve.getBigDecimal("base_qty");
        long materialId = (Long)reserve.getDynamicObject("s_materiel").getPkValue();
        long srcUnitId = (Long)reserve.getDynamicObject("s_baseunit").getPkValue();
        DynamicObject reserveUnit = reserve.getDynamicObject("s_unit");
        long desUnitId = 0L;
        int unitPrecision = reserve.getDynamicObject("s_baseunit").getInt("precision");
        if (reserveUnit != null) {
            desUnitId = (Long)reserveUnit.getPkValue();
            unitPrecision = reserveUnit.getInt("precision");
        }
        BigDecimal unitRate = BigDecimal.ZERO;
        DynamicObject reserve2ndUnit = reserve.getDynamicObject("s_unit2nd");
        BigDecimal unitRate2nd = BigDecimal.ZERO;
        int unit2ndPrecision = 0;
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        if (muConv != null) {
            unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
        }
        if (reserve2ndUnit == null) {
            unit2ndPrecision = unitPrecision;
        } else {
            unit2ndPrecision = reserve2ndUnit.getInt("precision");
            long des2ndUnitId = (Long)reserve2ndUnit.getPkValue();
            DynamicObject muConv2nd = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)des2ndUnitId);
            if (muConv2nd != null) {
                unitRate2nd = new BigDecimal(muConv2nd.getInt("numerator")).divide(new BigDecimal(muConv2nd.getInt("denominator")), 10, 4);
            }
        }
        BigDecimal reserveQty = reserve.getBigDecimal("qty");
        BigDecimal qty2nd = reserve.getBigDecimal("qty2nd");
        paramMap.put("reserve_record", reserve.getPkValue());
        paramMap.put("release_type", "release");
        if (invQty.compareTo(reserveBaseQty) > 0) {
            paramMap.put("base_qty", reserveBaseQty);
            paramMap.put("qty", reserveQty);
            paramMap.put("qty2nd", qty2nd);
            invQty = invQty.subtract(reserveBaseQty);
            reserve.set("base_qty", (Object)BigDecimal.ZERO);
            reserve.set("qty", (Object)BigDecimal.ZERO);
            reserve.set("qty2nd", (Object)BigDecimal.ZERO);
        } else {
            BigDecimal covQty = invQty.compareTo(reserveBaseQty) == 0 ? reserveQty : invQty.multiply(unitRate).setScale(unitPrecision, RoundingMode.HALF_UP);
            BigDecimal covQty2nd = invQty.compareTo(reserveBaseQty) == 0 ? qty2nd : invQty.multiply(unitRate2nd).setScale(unit2ndPrecision, RoundingMode.HALF_UP);
            paramMap.put("base_qty", invQty);
            paramMap.put("qty", covQty);
            paramMap.put("qty2nd", covQty2nd);
            reserve.set("base_qty", (Object)reserveBaseQty.subtract(invQty));
            reserve.set("qty", (Object)reserveQty.subtract(covQty));
            reserve.set("qty2nd", (Object)qty2nd.subtract(covQty2nd));
            invQty = invQty.subtract(invQty);
        }
        return invQty;
    }

    private static Set<Long> getBillEntryId(List<DynamicObject> billEntry) {
        HashSet<Long> entryId = new HashSet<Long>(16);
        for (DynamicObject entry : billEntry) {
            entryId.add((Long)entry.getPkValue());
        }
        return entryId;
    }

    private static void updateBillQtyField(Map<Object, BigDecimal> entryId2QtyMap, Set<Long> demandBillId) {
        DynamicObject[] demandBillArray;
        for (DynamicObject demandBill : demandBillArray = BusinessDataServiceHelper.load((String)"pm_requirapplybill", (String)"id,billentry.unit,billentry.baseunit,billentry.protranqty,billentry.protranbaseqty,billentry.materialmasterid", (QFilter[])new QFilter("id", "in", demandBillId).toArray())) {
            DynamicObjectCollection demandEntryCol = demandBill.getDynamicObjectCollection("billentry");
            for (DynamicObject demandEntry : demandEntryCol) {
                Object demandEntryId = demandEntry.getPkValue();
                BigDecimal qty = entryId2QtyMap.get(demandEntryId);
                if (qty == null) continue;
                BigDecimal demandEntryTransferBaseQty = demandEntry.getBigDecimal("protranbaseqty");
                BigDecimal demandEntryTransferQty = demandEntry.getBigDecimal("protranqty");
                BigDecimal unitRate = BigDecimal.ZERO;
                DynamicObject baseUnit = demandEntry.getDynamicObject("baseunit");
                DynamicObject unit = demandEntry.getDynamicObject("unit");
                int unitPrecision = baseUnit.getInt("precision");
                if (unit != null) {
                    unitPrecision = unit.getInt("precision");
                    Long materialId = (Long)demandEntry.getDynamicObject("materialmasterid").getPkValue();
                    DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)baseUnit.getPkValue()), (Long)((Long)unit.getPkValue()));
                    unitRate = muConv != null ? new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4) : BigDecimal.ZERO;
                }
                BigDecimal reqQty = demandEntryTransferBaseQty.compareTo(qty) == 0 ? demandEntryTransferQty : qty.multiply(unitRate).setScale(unitPrecision, RoundingMode.HALF_UP);
                demandEntry.set("protranbaseqty", (Object)demandEntryTransferBaseQty.subtract(qty));
                demandEntry.set("protranqty", (Object)demandEntryTransferQty.subtract(reqQty));
            }
        }
        SaveServiceHelper.save((DynamicObject[])demandBillArray);
    }
}

