/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.age;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.report.algox.age.AgeRptParam;
import kd.scmc.im.report.algox.age.AgeRptUtil;
import kd.scmc.im.report.algox.util.RptForm;
import kd.scmc.im.report.algox.util.RptUtil;

public final class AgeRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private RptForm localRptForm;
    private volatile boolean changed;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getRptForm().register((Object)this);
    }

    private RptForm getRptForm() {
        if (this.localRptForm == null) {
            this.localRptForm = new RptForm(this.getView());
        }
        return this.localRptForm;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getRptForm().initPage(this.getRemoveFilterGridCols());
        this.initAgeEntry();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisibleByShowAgeGrp();
        this.getRptForm().changeContainLowerGrp();
    }

    private void setVisibleByShowAgeGrp() {
        Object showAgeGroup = this.getModel().getValue("showagegroup");
        boolean isShowAgeGroup = (Boolean)showAgeGroup;
        this.getView().setVisible(Boolean.valueOf(isShowAgeGroup), new String[]{"agesetting"});
        this.getView().setVisible(Boolean.valueOf(!isShowAgeGroup), new String[]{"retrospectdays"});
    }

    private void initAgeEntry() {
        if (this.changed) {
            return;
        }
        this.changed = true;
        this.initAgeEntry(this.buildAgeSegment());
    }

    private void initAgeEntry(int[] ages) {
        IDataModel model = this.getModel();
        model.deleteEntryData("ageentry");
        int[] idxs = this.getModel().batchCreateNewEntryRow("ageentry", ages.length);
        for (int i = 0; i < ages.length; ++i) {
            if (i == ages.length - 1) {
                model.setValue("agename", (Object)AgeRptUtil.buildAgeLastName(ages[i]), idxs[i]);
                model.setValue("ageval", null, idxs[i]);
            } else {
                model.setValue("agename", (Object)AgeRptUtil.buildAgeName(ages[i], ages[i + 1]), idxs[i]);
                model.setValue("ageval", (Object)(ages[i + 1] - ages[i]), idxs[i]);
            }
            this.getView().setEnable(Boolean.FALSE, idxs[i], new String[]{"agename"});
        }
    }

    private int[] buildAgeSegment() {
        boolean showAgeGroup = (Boolean)this.getModel().getValue("showagegroup");
        if (showAgeGroup) {
            return this.buildAgeSegment(this.getModel().getDataEntity(true));
        }
        return this.buildDetailAgeSegment();
    }

    private int[] buildDetailAgeSegment() {
        Object value = this.getModel().getValue("retrospectdays");
        if (value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u8d26\u9f84\u8ffd\u6eaf\u8303\u56f4\uff08\u5929\uff09\u201d\u3002", (String)"AgeRptForm_3", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        int retrospectDays = (Integer)value;
        if (retrospectDays <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u8d26\u9f84\u8ffd\u6eaf\u8303\u56f4\uff08\u5929\uff09\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"AgeRptForm_4", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        if (retrospectDays > 365) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u8d26\u9f84\u8ffd\u6eaf\u8303\u56f4\uff08\u5929\uff09\u201d\u4e0d\u80fd\u5927\u4e8e365\u3002", (String)"AgeRptForm_5", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        int[] ageSegment = new int[retrospectDays + 1];
        for (int i = 0; i < retrospectDays + 1; ++i) {
            ageSegment[i] = i;
        }
        return ageSegment;
    }

    private int[] buildAgeSegment(DynamicObject data) {
        DynamicObjectCollection ageSetting = data.getDynamicObjectCollection("ageentry");
        ArrayList<Integer> ages = new ArrayList<Integer>(ageSetting.size());
        ages.add(0);
        int age = 0;
        for (int i = 0; i < ageSetting.size(); ++i) {
            if (i == ageSetting.size() - 1) {
                Map cache = this.getView().getPageCache().getAll();
                String deleteAgeRow = (String)cache.get("delete_age_row");
                DynamicObject row = (DynamicObject)ageSetting.get(i);
                if (row.get("ageval") != null && "TRUE".equals(deleteAgeRow)) {
                    cache.remove("delete_age_row");
                    continue;
                }
            }
            if ((age = ((DynamicObject)ageSetting.get(i)).getInt("ageval")) <= 0) continue;
            ages.add(age);
        }
        if (ages.size() < 2) {
            return AgeRptUtil.DEF_AGE_SEGMENT;
        }
        int[] ageSegment = new int[ages.size()];
        for (int i = 0; i < ageSegment.length; ++i) {
            ageSegment[i] = i == 0 ? 0 : ageSegment[i - 1] + (Integer)ages.get(i);
        }
        return ageSegment;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs;
        super.beforeDeleteRow(e);
        if ("ageentry".equals(e.getEntryProp().getName()) && ((rowIndexs = e.getRowIndexs())[0] == 0 || rowIndexs[0] == 1)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u548c\u7b2c\u4e8c\u884c\u4e3a\u4fdd\u7559\u884c\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AgeRptForm_1", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        this.getRptForm().propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "ageval": {
                this.ageValChanged(e);
                break;
            }
            case "showagegroup": {
                this.setVisibleByShowAgeGrp();
                break;
            }
        }
    }

    private void ageValChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        int rowIndex = changeSet[0].getRowIndex();
        if (newValue == null || (Integer)newValue == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u95f4\u9694\u5929\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgeRptForm_2", (String)"scmc-im-report", (Object[])new Object[0]));
            this.getModel().beginInit();
            this.getModel().setValue("ageval", oldValue, rowIndex);
            this.getModel().endInit();
            return;
        }
        this.initAgeEntry();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        if (RptUtil.isNull(view, "invorg") || RptUtil.isNull(view, "groupstandard")) {
            return false;
        }
        if (!this.getRptForm().checkDataCtrl()) {
            return false;
        }
        ReportQueryParam param = this.getQueryParam();
        AgeRptParam reportParam = this.buildReportParms();
        param.getCustomParam().put(AgeRptParam.class.getName(), reportParam);
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        List<Long> warehouseIds = this.getRptForm().warehouseBeforeQuery(queryParam, this.getModel(), "im_age_rpt");
        AgeRptParam rptParam = (AgeRptParam)queryParam.getCustomParam().get(AgeRptParam.class.getName());
        rptParam.setWareHouseIds(warehouseIds);
    }

    private AgeRptParam buildReportParms() {
        AgeRptParam param = new AgeRptParam();
        this.getRptForm().buildRptParam(param);
        DynamicObject data = this.getModel().getDataEntity();
        param.setClosingDate(data.getDate("closingdate"), this.buildAgeSegment());
        param.setShowAgeGroup(data.getBoolean("showagegroup"));
        return param;
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        this.getRptForm().beforeF7Select(f7);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent f7) {
        this.getRptForm().beforeF7Select(f7, this.getModel());
    }

    private Set<String> getRemoveFilterGridCols() {
        HashSet<String> removedPros = new HashSet<String>();
        removedPros.add("datatype");
        removedPros.add("biztime");
        removedPros.add("materialmasterid");
        return removedPros;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name;
        switch (name = e.getEntryProp().getName()) {
            case "ageentry": {
                this.delterAgeEntryRow();
                break;
            }
        }
    }

    private void delterAgeEntryRow() {
        Map all = this.getView().getPageCache().getAll();
        all.put("delete_age_row", "TRUE");
        this.initAgeEntry();
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        this.changed = true;
        int[] ageSegment = this.buildAgeSegment(scheme);
        this.initAgeEntry(ageSegment);
        this.getRptForm().loadOtherEntryFilter(scheme);
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        this.getRptForm().saveEntryFilter("auxentry", "ageentry");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        this.getRptForm().closedCallBack(evt);
    }

    public void click(EventObject evt) {
        this.getRptForm().click(evt, (IFormPlugin)this);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        String key = e.getKey();
        if ("retrospectdays".equals(key)) {
            Object range = e.getValue();
            if (StringUtils.isBlank((Object)range)) {
                return;
            }
            if (Integer.parseInt(range.toString()) > 365) {
                e.setCancel(true);
                this.getView().updateView(key);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8d26\u9f84\u8ffd\u6eaf\u8303\u56f4\uff08\u5929\uff09\u201d\u4e0d\u80fd\u5927\u4e8e365\u3002", (String)"AgeRptForm_5", (String)"scmc-im-report", (Object[])new Object[0]));
            }
        }
    }
}

