/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.age;

import java.util.Date;
import kd.scmc.im.report.algox.util.RptParam;
import kd.scmc.im.report.algox.util.RptUtil;

public class AgeRptParam
extends RptParam {
    private static final long serialVersionUID = 7678827208498655439L;
    private boolean useClosingDate;
    private Date closingDate;
    private Date toDate;
    private Date billFromDate;
    private Date ageFromDate;
    private int[] ageSegment = new int[]{0, 7};
    private boolean showAgeGroup = true;

    public void setClosingDate(Date closingDate, int[] ageSegment) {
        this.useClosingDate = closingDate != null;
        this.closingDate = RptUtil.getShortDate(this.useClosingDate ? closingDate : new Date());
        if (this.checkSegment(ageSegment)) {
            this.ageSegment = ageSegment;
        }
        this.parseDateInfo();
    }

    private void parseDateInfo() {
        this.toDate = RptUtil.getShortDate(this.closingDate, 1);
        this.ageFromDate = RptUtil.getShortDate(this.toDate, -1 - this.ageSegment[this.ageSegment.length - 1]);
        this.billFromDate = this.useClosingDate ? RptUtil.getFirstDateOfMonth(this.ageFromDate) : this.ageFromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public Date getBillFromDate() {
        return this.billFromDate;
    }

    public Date getClosingDate() {
        return this.closingDate;
    }

    public Date getAgeFromDate() {
        return this.ageFromDate;
    }

    public boolean isUseClosingDate() {
        return this.useClosingDate;
    }

    public int[] getAgeSegment() {
        return this.ageSegment;
    }

    private boolean checkSegment(int[] ageSegment) {
        if (ageSegment == null || ageSegment.length == 0) {
            return false;
        }
        for (int i = 0; i < ageSegment.length - 1; ++i) {
            if (ageSegment[i + 1] - ageSegment[i] >= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isShowAgeGroup() {
        return this.showAgeGroup;
    }

    public void setShowAgeGroup(boolean showAgeGroup) {
        this.showAgeGroup = showAgeGroup;
    }
}

