/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.age;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;

public class AgeRptUtil {
    public static final int[] DEF_AGE_SEGMENT = new int[]{0, 7};
    public static final String SUFFIX_INIT = "init";

    public static List<String> buildQtyCols(Collection<String> qtyCols, int[] ageSegment) {
        List<String> cols = AgeRptUtil.buildAgeQtyCols(qtyCols, ageSegment);
        cols.addAll(qtyCols);
        return cols;
    }

    public static List<String> buildAgeQtyCols(Collection<String> qtyCols, int[] ageSegment) {
        ArrayList<String> cols = new ArrayList<String>(qtyCols.size() * (ageSegment.length + 1));
        for (String qtyCol : qtyCols) {
            for (int i : ageSegment) {
                cols.add(AgeRptUtil.getQtyInCol(qtyCol, i));
            }
            cols.add(AgeRptUtil.getQtyOutCol(qtyCol));
            cols.add(AgeRptUtil.getQtyInitCol(qtyCol));
        }
        return cols;
    }

    public static String getQtyInitCol(String qtyCol) {
        return qtyCol + SUFFIX_INIT;
    }

    public static String getQtyInCol(String qtyCol, int segment) {
        return qtyCol + AgeRptUtil.getQtyInColSuffix(segment);
    }

    public static String getQtyInColSuffix(int segment) {
        return "_in_" + segment;
    }

    public static String getQtyOutCol(String qtyCol) {
        return qtyCol + "_out";
    }

    public static String buildAgeName(int from, int to) {
        return ResManager.loadResFormat((String)ResManager.loadKDString((String)"%1\u5230%2\u5929", (String)"AgeRptUtil_0", (String)"scmc-im-report", (Object[])new Object[0]), (String)"AgeRptUtil_0", (String)"scmc-im-report", (Object[])new Object[]{from, to - 1});
    }

    public static String buildAgeLastName(int from) {
        return ResManager.loadResFormat((String)ResManager.loadKDString((String)"%1\u5929\u53ca\u4ee5\u4e0a", (String)"AgeRptUtil_1", (String)"scmc-im-report", (Object[])new Object[0]), (String)"AgeRptUtil_1", (String)"scmc-im-report", (Object[])new Object[]{from});
    }
}

