/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.age.func;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.scmc.im.report.algox.age.AgeRptParam;
import kd.scmc.im.report.algox.age.AgeRptUtil;

public class CalAgeQtyMapFunc
extends MapFunction {
    private RowMeta rowMeta;
    private Set<String> qtyCols;
    private int[] ageSegment;
    private Map<String, Integer> idxs;
    private static final long serialVersionUID = 9089786030588255355L;

    public CalAgeQtyMapFunc(RowMeta rowMeta, ReportDataCtx ctx) {
        this.rowMeta = rowMeta;
        this.qtyCols = ctx.getShowQtyCols();
        AgeRptParam param = (AgeRptParam)ctx.getParam(AgeRptParam.class.getName());
        this.ageSegment = param.getAgeSegment();
        this.buildIdxs();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void buildIdxs() {
        List<String> allCols = AgeRptUtil.buildQtyCols(this.qtyCols, this.ageSegment);
        this.idxs = TransformUtil.buildIndexs((RowMeta)this.rowMeta, allCols);
    }

    public RowX map(RowX rowX) {
        for (String qtyCol : this.qtyCols) {
            this.addInitQty2LastSegment(qtyCol, rowX);
            this.calQty(qtyCol, rowX);
        }
        return rowX;
    }

    private void addInitQty2LastSegment(String qtyCol, RowX rowX) {
        int lastSegmentIdx = this.idxs.get(AgeRptUtil.getQtyInCol(qtyCol, this.ageSegment[this.ageSegment.length - 1]));
        int initQtyIdx = this.idxs.get(AgeRptUtil.getQtyInitCol(qtyCol));
        BigDecimal qty = rowX.getBigDecimal(lastSegmentIdx).add(rowX.getBigDecimal(initQtyIdx));
        rowX.set(lastSegmentIdx, (Object)qty);
    }

    private void calQty(String qtyCol, RowX rowX) {
        BigDecimal outQty = rowX.getBigDecimal(this.idxs.get(AgeRptUtil.getQtyOutCol(qtyCol)).intValue());
        BigDecimal inQty = null;
        int idx = -1;
        for (int i = this.ageSegment.length - 1; i >= 0; --i) {
            idx = this.idxs.get(AgeRptUtil.getQtyInCol(qtyCol, this.ageSegment[i]));
            inQty = rowX.getBigDecimal(idx);
            if ((outQty = outQty.subtract(inQty)).compareTo(BigDecimal.ZERO) <= 0) {
                rowX.set(idx, (Object)outQty.negate());
                break;
            }
            rowX.set(idx, (Object)BigDecimal.ZERO);
        }
    }
}

