/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.age.func;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.scmc.im.report.algox.age.AgeRptParam;
import kd.scmc.im.report.algox.age.AgeRptUtil;
import kd.scmc.im.report.algox.util.RptUtil;

public class MoveAgeColMapFunc
extends MapFunction {
    private static final long serialVersionUID = 8383510151388516270L;
    private RowMeta rowMeta;
    private int[] ageSegment;
    private Set<String> qtyCols;
    private Map<String, Integer> idxs;
    private boolean useClosingDate;
    private Date closingDate;
    private Date ageFromDate;

    public MoveAgeColMapFunc(ReportDataCtx ctx, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.qtyCols = ctx.getShowQtyCols();
        AgeRptParam param = (AgeRptParam)ctx.getParam(AgeRptParam.class.getName());
        this.ageSegment = param.getAgeSegment();
        this.useClosingDate = param.isUseClosingDate();
        this.ageFromDate = param.getAgeFromDate();
        this.closingDate = param.getClosingDate();
        this.buildIdxs();
    }

    private void buildIdxs() {
        List<String> allCols = AgeRptUtil.buildQtyCols(this.qtyCols, this.ageSegment);
        allCols.add("biztime");
        allCols.add("datatype");
        this.idxs = TransformUtil.buildIndexs((RowMeta)this.rowMeta, allCols);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX rowX) {
        this.swapInAndOutQty(rowX);
        String type = rowX.getString(this.idxs.get("datatype").intValue());
        if ("0".equals(type) || "3".equals(type)) {
            this.handleInData(rowX);
        } else if ("1".equals(type)) {
            this.handleOutData(rowX);
        } else {
            this.handleInitBalData(rowX);
        }
        return rowX;
    }

    private void swapInAndOutQty(RowX rowX) {
        int idx = this.idxs.get("datatype");
        String type = rowX.getString(idx);
        if ("0".equals(type) || "3".equals(type)) {
            this.swapTo(rowX, "1", idx);
        } else if ("1".equals(type)) {
            this.swapTo(rowX, "0", idx);
        }
    }

    private void swapTo(RowX rowX, String type, int typeIdx) {
        if (this.isAllNetate(rowX)) {
            int idx = -1;
            for (String qtyCol : this.qtyCols) {
                idx = this.idxs.get(qtyCol);
                rowX.set(idx, (Object)rowX.getBigDecimal(idx).negate());
            }
            rowX.set(typeIdx, (Object)type);
        }
    }

    private boolean isAllNetate(RowX rowX) {
        int zeroCount = 0;
        for (String qtyCol : this.qtyCols) {
            int result = rowX.getBigDecimal(this.idxs.get(qtyCol).intValue()).compareTo(BigDecimal.ZERO);
            if (result > 0) {
                return false;
            }
            if (result != 0) continue;
            ++zeroCount;
        }
        return zeroCount != this.qtyCols.size();
    }

    private int calAgesegment(Date bizDate) {
        int days = RptUtil.calBetweenDays(bizDate, this.closingDate);
        if (days <= 0) {
            return 0;
        }
        for (int i = 1; i < this.ageSegment.length; ++i) {
            if (days >= this.ageSegment[i]) continue;
            return this.ageSegment[i - 1];
        }
        return this.ageSegment[this.ageSegment.length - 1];
    }

    private void handleInData(RowX rowX) {
        int idx = this.idxs.get("biztime");
        Date bizDate = rowX.getDate(idx);
        boolean beforeAge = bizDate.before(this.ageFromDate);
        if (!beforeAge) {
            boolean after = bizDate.after(new Date());
            if (after && !this.useClosingDate) {
                this.moveQtys(rowX, AgeRptUtil.getQtyInColSuffix(this.ageSegment[this.ageSegment.length - 1]));
            } else {
                this.moveQtys(rowX, AgeRptUtil.getQtyInColSuffix(this.calAgesegment(bizDate)));
            }
        }
        this.moveQty2InitOrBal(rowX, beforeAge, false);
    }

    private void moveQty2InitOrBal(RowX rowX, boolean beforeAge, boolean outQty) {
        BigDecimal qty = null;
        if (this.useClosingDate) {
            for (String qtyCol : this.qtyCols) {
                qty = rowX.getBigDecimal(this.idxs.get(qtyCol).intValue());
                String type = rowX.getString(this.idxs.get("datatype").intValue());
                if (outQty) {
                    qty = qty.negate();
                    rowX.set(this.idxs.get(qtyCol).intValue(), (Object)qty);
                }
                if (beforeAge) {
                    rowX.set(this.idxs.get(AgeRptUtil.getQtyInitCol(qtyCol)).intValue(), (Object)qty);
                }
                if (!"3".equals(type)) continue;
                qty = qty.negate();
                if (beforeAge) {
                    rowX.set(this.idxs.get(AgeRptUtil.getQtyInitCol(qtyCol)).intValue(), (Object)BigDecimal.ZERO);
                } else {
                    rowX.set(this.idxs.get(AgeRptUtil.getQtyInitCol(qtyCol)).intValue(), (Object)qty);
                }
                rowX.set(this.idxs.get(qtyCol).intValue(), (Object)BigDecimal.ZERO);
            }
        } else {
            for (String qtyCol : this.qtyCols) {
                qty = rowX.getBigDecimal(this.idxs.get(qtyCol).intValue());
                if (!outQty) {
                    qty = qty.negate();
                }
                rowX.set(this.idxs.get(AgeRptUtil.getQtyInitCol(qtyCol)).intValue(), (Object)qty);
                rowX.set(this.idxs.get(qtyCol).intValue(), (Object)BigDecimal.ZERO);
            }
        }
    }

    private void handleOutData(RowX rowX) {
        Date bizDate = rowX.getDate(this.idxs.get("biztime").intValue());
        boolean beforeAge = bizDate.before(this.ageFromDate);
        if (!beforeAge) {
            boolean after = bizDate.after(new Date());
            if (after && !this.useClosingDate) {
                this.moveQtys(rowX, AgeRptUtil.getQtyInColSuffix(this.ageSegment[this.ageSegment.length - 1]));
            } else {
                this.moveQtys(rowX, "_out");
            }
        }
        this.moveQty2InitOrBal(rowX, beforeAge, true);
    }

    private void handleInitBalData(RowX rowX) {
        this.moveQtys(rowX, "init");
    }

    private void moveQtys(RowX rowX, String suffix) {
        for (String qtyCol : this.qtyCols) {
            rowX.set(this.idxs.get(qtyCol + suffix).intValue(), (Object)rowX.getBigDecimal(this.idxs.get(qtyCol).intValue()));
        }
    }
}

