/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.detail;

import com.alibaba.fastjson.JSON;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.report.algox.detail.DetailRptParam;
import kd.scmc.im.report.algox.detail.OpenDetailParam;
import kd.scmc.im.report.algox.util.RptForm;
import kd.scmc.im.report.algox.util.RptUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public final class DetailRptForm
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener,
BeforeFilterF7SelectListener {
    private static final String LINK_OPENED = "linkOpened";
    private boolean isLoadOpenDetailParam;
    private OpenDetailParam openParam;
    private RptForm localRptForm;

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("billno".equals(key)) {
            this.showBill(e);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getRptForm().changeContainLowerGrp();
        if (this.getOpenDetailParam() != null) {
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.search();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    private void showBill(HyperLinkClickEvent e) {
        DynamicObject row = RptUtil.getRptRowData(e);
        IDataEntityProperty billTypeProp = (IDataEntityProperty)row.getDataEntityType().getProperties().get((Object)"billtype");
        if (billTypeProp == null) {
            String showKeyCols = (String)this.getModel().getValue("showkeycols");
            if (!showKeyCols.contains("billtype")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5355\u636e\u4fe1\u606f\u65f6\uff0c\u663e\u793a\u5b57\u6bb5\u4e2d\u5fc5\u987b\u9009\u4e2d\u201c\u5355\u636e\u7c7b\u578b\u201d\u3002", (String)"DetailRptForm_0", (String)"scmc-im-report", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5355\u636e\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u9009\u4e2d\u884c\u7684\u201c\u5355\u636e\u7c7b\u578b\u201d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DetailRptForm_1", (String)"scmc-im-report", (Object[])new Object[0]));
            }
            return;
        }
        String billType = row.getDynamicObject("billtype").getString("billformid.id");
        long id = row.getLong("billid");
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(billType);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getRptForm().register((Object)this);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    private OpenDetailParam getOpenDetailParam() {
        if (!this.isLoadOpenDetailParam) {
            FormShowParameter fsp;
            String openParamStr;
            if (this.getPageCache().get(LINK_OPENED) == null && StringUtils.isNotBlank((CharSequence)(openParamStr = (String)(fsp = this.getView().getFormShowParameter()).getCustomParam(OpenDetailParam.class.getName())))) {
                this.openParam = (OpenDetailParam)SerializationUtils.fromJsonString((String)openParamStr, OpenDetailParam.class);
            }
            this.isLoadOpenDetailParam = true;
        }
        return this.openParam;
    }

    public void afterCreateNewData(EventObject e) {
        OpenDetailParam param = this.getOpenDetailParam();
        if (param == null) {
            this.init4DirectOpen();
        } else {
            this.init4LinkOpen(param);
            this.getPageCache().put(LINK_OPENED, "true");
        }
    }

    private void init4LinkOpen(OpenDetailParam param) {
        RptForm RptForm2 = this.getRptForm();
        HashSet<String> needCols = new HashSet<String>(1);
        needCols.add("auxpty");
        RptForm2.removeFilterGridCols(this.getRemoveFilterGridCols(), needCols);
        this.handleAuxptyFs();
        RptForm2.initOrg(param.getOrgId());
        IDataModel model = this.getModel();
        model.setValue("startdate", (Object)param.getDateFrom());
        model.setValue("enddate", (Object)param.getDateTo());
        model.setValue("materialtype", (Object)param.getMaterialType());
        model.setValue("groupstandard", (Object)param.getGroupStandard());
        List<Object> tempIds = param.getGroupFrom();
        model.setValue("groupfrom", (Object)(tempIds == null ? new Object[]{} : tempIds.toArray()));
        model.setValue("groupto", param.getGroupTo());
        tempIds = param.getMaterialFrom();
        model.setValue("materialfrom", (Object)(tempIds == null ? new Object[]{} : tempIds.toArray()));
        model.setValue("materialto", param.getMaterialTo());
        model.setValue("include_submit", (Object)param.isIncludeSubmit());
        model.setValue("include_unupdate", (Object)param.isIncludeUnupdate());
        model.setValue("showqtycols", (Object)String.join((CharSequence)",", param.getShowQtys()));
        this.buildAuxptyEntry(param);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        RptUtil.rebuildCondition(param.getCondition(), model.getDataEntityType().getName());
        filterGrid.SetValue(param.getCondition());
        model.setValue("display_init_bal", (Object)param.isIncludeInitBalQty());
        model.setValue("display_in", (Object)param.isIncludeInQty());
        model.setValue("display_out", (Object)param.isIncludeOutQty());
    }

    private void handleAuxptyFs() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!"auxpty".equals(fieldName)) continue;
            List dtos = (List)info.get("compareTypes");
            CompareTypeDto isNullType = null;
            for (CompareTypeDto dto : dtos) {
                if (!CompareTypeEnum.ISNULL.getId().equals(dto.getId())) continue;
                isNullType = dto;
                break;
            }
            dtos.clear();
            dtos.add(isNullType);
            return;
        }
    }

    private void buildAuxptyEntry(OpenDetailParam param) {
        Long auxptyId = param.getAuxptyId();
        List<Map<String, Object>> auxptyInfos = param.getAuxptyInfos();
        IDataModel model = this.getModel();
        model.deleteEntryData("auxentry");
        if (auxptyId != null) {
            if (auxptyId == 0L) {
                this.buildAuxptyNullFs(param);
            } else {
                AuxptyFilterHelper.bindAuxptyEntryById((Object)auxptyId, (IDataModel)this.getModel(), (IFormView)this.getView());
            }
        } else if (auxptyInfos != null && auxptyInfos.size() > 0) {
            int[] idxs = model.batchCreateNewEntryRow("auxentry", auxptyInfos.size());
            int i = 0;
            Object[] value = null;
            for (Map<String, Object> infos : auxptyInfos) {
                int idx = idxs[i++];
                for (Map.Entry<String, Object> info : infos.entrySet()) {
                    value = info.getValue();
                    if ("auxdetailbd".equals(info.getKey()) && value != null) {
                        value = JSON.parseArray((String)((String)value), Long.class).toArray();
                    }
                    if (value instanceof List) {
                        value = ((List)((Object)info)).toArray();
                    }
                    model.setValue(info.getKey(), (Object)value, idx);
                }
            }
        }
    }

    private void buildAuxptyNullFs(OpenDetailParam param) {
        FilterCondition condition = param.getCondition();
        SimpleFilterRow filterRow = new SimpleFilterRow();
        filterRow.setFieldName("auxpty");
        filterRow.setCompareType(CompareTypeEnum.ISNULL.getId());
        condition.addFilterRow(filterRow);
    }

    private void init4DirectOpen() {
        this.getRptForm().initPage(this.getRemoveFilterGridCols());
        this.initQueryDate();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getRptForm().propertyChanged(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        this.getRptForm().beforeF7Select(f7);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent f7) {
        this.getRptForm().beforeF7Select(f7, this.getModel());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        if (RptUtil.isNull(view, "invorg") || RptUtil.isNull(view, "startdate") || RptUtil.isNull(view, "enddate") || RptUtil.isNull(view, "groupstandard")) {
            return false;
        }
        DynamicObject data = this.getModel().getDataEntity();
        Date startDate = data.getDate("startdate");
        Date enddate = data.getDate("enddate");
        if (enddate.before(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"DetailRptForm_2", (String)"scmc-im-report", (Object[])new Object[0]));
            return false;
        }
        if (!this.getRptForm().checkDataCtrl()) {
            return false;
        }
        this.buildReportParms();
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        List<Long> warehouseIds = this.getRptForm().warehouseBeforeQuery(queryParam, this.getModel(), "im_detail_rpt");
        DetailRptParam rptParam = (DetailRptParam)queryParam.getCustomParam().get(DetailRptParam.class.getName());
        rptParam.setWareHouseIds(warehouseIds);
    }

    private RptForm getRptForm() {
        if (this.localRptForm == null) {
            this.localRptForm = new RptForm(this.getView());
        }
        return this.localRptForm;
    }

    private void initQueryDate() {
        IDataModel model = this.getModel();
        Date now = new Date();
        model.setValue("enddate", (Object)now);
        model.setValue("startdate", (Object)DateUtils.addDays((Date)now, (int)-6));
    }

    private Set<String> getRemoveFilterGridCols() {
        HashSet<String> removedPros = new HashSet<String>();
        removedPros.add("perioddate");
        removedPros.add("status");
        removedPros.add("isupdatebal");
        removedPros.add("datatype");
        removedPros.add("transceivertype");
        removedPros.add("materialmasterid");
        return removedPros;
    }

    private DetailRptParam buildReportParms() {
        IDataModel model = this.getModel();
        ReportQueryParam param = this.getQueryParam();
        DetailRptParam reportParam = new DetailRptParam();
        DynamicObject data = model.getDataEntity();
        RptForm RptForm2 = this.getRptForm();
        RptForm2.buildRptParam(reportParam);
        reportParam.setShowInQty(data.getBoolean("display_in"));
        reportParam.setShowOutQty(data.getBoolean("display_out"));
        boolean displayInitBal = data.getBoolean("display_init_bal");
        reportParam.setShowInitAndBalQty(displayInitBal);
        reportParam.setIncludeSubmitStatus(data.getBoolean("include_submit"));
        reportParam.setIncludeUnUpdateBal(data.getBoolean("include_unupdate"));
        Date fromDate = RptUtil.getShortDate(data.getDate("startdate"));
        reportParam.setFromDate(fromDate);
        Date toDate = RptUtil.getShortDate(data.getDate("enddate"), 1);
        reportParam.setToDate(toDate);
        reportParam.setBillFromDate(displayInitBal ? this.getFirstDateOfMonth(fromDate) : fromDate);
        reportParam.setQtyFilters(ReportUtil.parseCombColVal((IDataModel)model, (String)"qtydisplay"));
        param.getCustomParam().put(DetailRptParam.class.getName(), reportParam);
        return reportParam;
    }

    private Date getFirstDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        this.getRptForm().loadOtherEntryFilter(scheme);
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        this.getRptForm().saveEntryFilter("auxentry");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        this.getRptForm().closedCallBack(evt);
    }

    public void click(EventObject evt) {
        this.getRptForm().click(evt, (IFormPlugin)this);
    }
}

