/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.detail.func;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.scmc.im.report.algox.detail.DetailRptParam;
import kd.scmc.im.report.algox.util.RptUtil;
import kd.scmc.im.utils.DateUtils;

public class MoveQtyMapFunc
extends MapFunction {
    private RowMeta rowMeta;
    private Map<String, Integer> idxs;
    private Date fromDate;
    private Set<String> qtyCols;
    private Date initQtyFillDate;
    private boolean showInitAndBalQty;
    private static final long serialVersionUID = 7233110696072059166L;

    public MoveQtyMapFunc(ReportDataCtx ctx, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.qtyCols = ctx.getShowQtyCols();
        DetailRptParam rptParam = (DetailRptParam)ctx.getParam(DetailRptParam.class.getName());
        this.fromDate = rptParam.getFromDate();
        this.initQtyFillDate = DateUtils.addDay((Date)this.fromDate, (int)-1);
        this.showInitAndBalQty = rptParam.isShowInitAndBalQty();
        this.buildIndexs();
    }

    private void buildIndexs() {
        int numColCount = this.qtyCols.size();
        ArrayList<String> cols = new ArrayList<String>(numColCount * 3 + 2);
        cols.add("perioddate");
        cols.add("datatype");
        ArrayList<Object> suffixs = new ArrayList<Object>(4);
        suffixs.add("");
        suffixs.add("_in");
        suffixs.add("_out");
        if (this.showInitAndBalQty) {
            suffixs.add("_bal");
        }
        RptUtil.appendSuffixs(cols, this.qtyCols, suffixs);
        this.idxs = TransformUtil.buildIndexs((RowMeta)this.rowMeta, cols);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void moveQty(RowX rowX, String colSuffix) {
        for (String qtyCol : this.qtyCols) {
            rowX.set(this.idxs.get(qtyCol + colSuffix).intValue(), (Object)rowX.getBigDecimal(this.idxs.get(qtyCol).intValue()));
        }
    }

    public RowX map(RowX rowX) {
        String dataType = rowX.getString(this.idxs.get("datatype").intValue());
        if (this.showInitAndBalQty && "2".equals(dataType)) {
            rowX.set(this.idxs.get("perioddate").intValue(), (Object)this.initQtyFillDate);
            this.moveQty(rowX, "_bal");
        } else if ("0".equals(dataType)) {
            this.moveQty(rowX, "_in");
        } else if ("1".equals(dataType)) {
            this.moveQty(rowX, "_out");
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b", (String)"MoveQtyMapFunc_0", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        return rowX;
    }
}

