/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.dull.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.scmc.im.report.algox.dull.DullRptParam;

public class CalDullInfoMapFunc
extends MapFunction {
    private static final long serialVersionUID = -7768316645054026608L;
    private RowMeta rowMeta;
    private Set<String> showQtyCols;
    private Map<String, Integer> idxs;
    private Date fromDate;
    private Date toDate;
    private boolean useClosingDate;
    private Map<String, Set<Object>> billInvScheme;
    private int billTypeIdx = -1;
    private int schemeIdx = -1;

    public CalDullInfoMapFunc(ReportDataCtx ctx, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.showQtyCols = ctx.getShowQtyCols();
        DullRptParam rptParam = (DullRptParam)ctx.getParam(DullRptParam.class.getName());
        this.fromDate = rptParam.getFromDate();
        this.toDate = rptParam.getToDate();
        this.useClosingDate = rptParam.isUseClosingDate();
        this.buildIndexs();
        this.billTypeIdx = rowMeta.getFieldIndex("block_entity", false);
        this.schemeIdx = rowMeta.getFieldIndex("invscheme", false);
        this.billInvScheme = this.billTypeIdx == -1 || this.schemeIdx == -1 ? null : rptParam.getBillInvScheme();
    }

    private void buildIndexs() {
        ArrayList<String> cols = new ArrayList<String>(this.showQtyCols);
        cols.add("biztime");
        cols.add("datatype");
        cols.add("dull_flag_in");
        cols.add("dull_flag_out");
        this.idxs = TransformUtil.buildIndexs((RowMeta)this.rowMeta, cols);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX row) {
        block3: {
            String type;
            block4: {
                type = row.getString(this.idxs.get("datatype").intValue());
                Date bizDate = row.getDate(this.idxs.get("biztime").intValue());
                if ("2".equals(type)) break block3;
                if (bizDate.before(this.toDate) && !bizDate.before(this.fromDate) && this.checkScheme(row)) {
                    row.set(this.idxs.get("0".equals(type) ? "dull_flag_in" : "dull_flag_out").intValue(), (Object)1);
                }
                if (this.useClosingDate) break block4;
                for (String qtyCol : this.showQtyCols) {
                    row.set(this.idxs.get(qtyCol).intValue(), (Object)BigDecimal.ZERO);
                }
                break block3;
            }
            if (!"1".equals(type)) break block3;
            int idx = -1;
            for (String qtyCol : this.showQtyCols) {
                idx = this.idxs.get(qtyCol);
                row.set(idx, (Object)row.getBigDecimal(idx).negate());
            }
        }
        return row;
    }

    private boolean checkScheme(RowX row) {
        if (this.billInvScheme == null) {
            return true;
        }
        String billType = row.getString(this.billTypeIdx);
        Set<Object> scheme = this.billInvScheme.get(billType);
        if (scheme == null) {
            return false;
        }
        if (scheme.isEmpty()) {
            return true;
        }
        return scheme.contains(row.getLong(this.schemeIdx));
    }
}

