/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.realbal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.im.report.algox.realbal.RealBalRptParam;
import kd.scmc.im.report.algox.realbal.trans.CalAvlQty;
import kd.scmc.im.report.algox.realbal.trans.CalReverseQty;
import kd.scmc.im.report.algox.realbal.trans.RemoveIdTransform;
import kd.scmc.im.report.algox.util.RptHandle;
import kd.scmc.im.report.algox.util.trans.AddMaterialGroup;
import kd.scmc.im.report.algox.util.trans.QtyHeadFilterTransform;
import kd.scmc.im.report.algox.util.trans.TailDiffFilterTransform;
import kd.scmc.im.report.algox.util.trans.ZeroQtyFilterTransform;

public final class RealBalRptHandle
implements IReportDataHandle {
    public static final String ID_SELECTED = "idSelected";
    private RealBalRptParam reportParam;
    private RptHandle rptHandle;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (RealBalRptParam)ctx.getParam(RealBalRptParam.class.getName());
        this.getRptHandle().addNecessaryCol(ctx);
        this.setFixedFs(ctx);
        this.setCountQtyCols(ctx);
        this.getRptHandle().setImHeadFilter(ctx, this.reportParam);
    }

    private void setFixedFs(ReportDataCtx ctx) {
        ArrayList<QFilter> fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            fixedFs = new ArrayList<QFilter>();
            ctx.setFixedFs(fixedFs);
        }
        fixedFs.addAll(this.getFixedFilter());
    }

    private RptHandle getRptHandle() {
        return this.rptHandle == null ? (this.rptHandle = new RptHandle().setRptParam(this.reportParam)) : this.rptHandle;
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        this.getRptHandle().appendCommonFs(fs);
        return fs;
    }

    private void setCountQtyCols(ReportDataCtx ctx) {
        Set qtyCols = ctx.getShowQtyCols();
        HashSet<String> allQtyCols = new HashSet<String>(qtyCols);
        for (String qtyCol : qtyCols) {
            allQtyCols.add(qtyCol + "_lock");
            allQtyCols.add(qtyCol + "_avb");
        }
        ctx.setSumQtyCols4Count(allQtyCols);
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        List srcBlockConf = ctx.getReportConf().getSrcBlockConf();
        if (srcBlockConf.size() == 1 && "im_inv_realbalance".equals(((SrcBlockConf)srcBlockConf.get(0)).getSrcEntity())) {
            Map repoColSrcColMap = ((SrcBlockConf)srcBlockConf.get(0)).getRepoColSrcColMap();
            Set showKeyCols = ctx.getShowKeyCols();
            HashSet<String> balCols = new HashSet<String>();
            for (String keyCol : showKeyCols) {
                String balCol = (String)repoColSrcColMap.get(keyCol);
                if (balCol == null) continue;
                balCols.add(balCol);
            }
            BalanceTB tb = BalanceTB.getBalanceTB((String)"im_inv_realbalance");
            if (balCols.containsAll(tb.getColsByDataType(new BizDataType[]{BizDataType.DIM}))) {
                ctx.setGroupPlans(null);
            }
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        try {
            boolean aggregate = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"getAggregate", (Object[])new Object[0]);
            Map totalAggQty = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"totalAggQty", (Object[])new Object[0]);
            List aggregateField = (List)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"getAggregateField", (Object[])new Object[0]);
            ArrayList<String> aggDimList = new ArrayList<String>(aggregateField.size());
            List<Long> wareHouseIds = this.reportParam.getWareHouseIds();
            if (aggregate && ((Boolean)totalAggQty.get("showreport")).booleanValue()) {
                Map colMap = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"colsBillMap", (Object[])new Object[0]);
                aggDimList = new ArrayList(aggregateField.size());
                for (String colString : aggregateField) {
                    String dim = (String)colMap.get(colString);
                    aggDimList.add(dim);
                }
            }
            Set showKeyCols = ctx.getShowKeyCols();
            Map<String, String> showKeyMap = this.getShowKeyMap(blockCollector);
            ArrayList<String> invDimList = new ArrayList<String>(6);
            for (String showKeyCol : showKeyCols) {
                invDimList.add(showKeyMap.get(showKeyCol));
            }
            if (!(aggregate && ((Boolean)totalAggQty.get("showreport")).booleanValue() && aggDimList.containsAll(invDimList))) {
                blockCollector.removeIf(s -> "msmod_reserve_record".equals(s.getSrcEntity()));
            }
            for (SrcBlockConf blockConf : blockCollector) {
                this.appendIdMap2Block(blockConf);
                if (!"im_inv_realbalance".equals(blockConf.getSrcEntity()) || this.reportParam.isQueryZero()) continue;
                if (blockConf.getDataFs() == null) {
                    blockConf.setDataFs(this.addInvAccNotZeroFilter());
                    continue;
                }
                blockConf.setDataFs(blockConf.getDataFs().and(this.addInvAccNotZeroFilter()));
            }
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        if (!ctx.getShowKeyCols().contains("id")) {
            ctx.getParams().put(ID_SELECTED, 0);
        }
        ctx.getShowKeyCols().add("id");
    }

    private Map<String, String> getShowKeyMap(List<SrcBlockConf> srcBlockConf) {
        HashMap<String, String> showKeyMap = new HashMap<String, String>(16);
        for (int i = 0; i < srcBlockConf.size(); ++i) {
            SrcBlockConf srcBlock = srcBlockConf.get(i);
            if (!"im_inv_realbalance".equals(srcBlock.getSrcEntity())) continue;
            return srcBlockConf.get(i).getRepoColSrcColMap();
        }
        return showKeyMap;
    }

    private void appendIdMap2Block(SrcBlockConf blockConf) {
        Map colMap = blockConf.getRepoColSrcColMap();
        colMap.put("id", "id");
        colMap = blockConf.getRepoColFullSrcColMap();
        colMap.put("id", "id");
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        Set showQtyCols = ctx.getShowQtyCols();
        for (String qtyCols : showQtyCols) {
            repoColFilter.add(qtyCols + "_lock");
            repoColFilter.add(qtyCols + "_avb");
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        if (!this.reportParam.isQueryZero()) {
            transCollector.add(new ZeroQtyFilterTransform(ctx));
        }
        AddMaterialGroup addMaterialGroup = new AddMaterialGroup(ctx, this.reportParam);
        addMaterialGroup.setRepoMaterialCol("materialgroup");
        addMaterialGroup.setRepoMaterialCol("material");
        transCollector.add(addMaterialGroup);
        if (this.reportParam.isQueryTailDiff()) {
            transCollector.add(new TailDiffFilterTransform());
        }
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        Set showQtyCols = ctx.getShowQtyCols();
        transCollector.add(new CalAvlQty(showQtyCols));
        RealBalRptParam param = (RealBalRptParam)ctx.getParam(RealBalRptParam.class.getName());
        List<QFilter> headFilters = param.getHeadFilters();
        transCollector.add(new QtyHeadFilterTransform(headFilters));
        transCollector.add(new RemoveIdTransform(ctx));
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        for (AbstractReportColumn col : columns) {
            ReportColumn reportCol = (ReportColumn)col;
            String field = reportCol.getFieldKey();
            if ("material".equals(field) || "lotnumber".equals(field) || "qty".equals(field) || "warehouse".equals(field) || "baseqty_lock".equals(field)) {
                reportCol.setHyperlink(true);
            }
            if (!"id".equals(field)) continue;
            reportCol.setHide(true);
        }
        return columns;
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new CalReverseQty(ctx));
        if (ctx.getParams().get(ID_SELECTED) != null) {
            ctx.getShowKeyCols().remove("id");
        }
    }

    private QFilter addInvAccNotZeroFilter() {
        QFilter qtyFilter = new QFilter("baseqty", "<>", (Object)0);
        qtyFilter.or("qty", "<>", (Object)0);
        qtyFilter.or("qty2nd", "<>", (Object)0);
        return qtyFilter;
    }
}

