/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.realbal.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.TransformUtil;

public class RealBalRptMapFunc
extends MapFunction {
    private static final long serialVersionUID = -7490391329919340818L;
    private RowMeta rowMeta;
    private Set<String> showQtyCols;
    private Map<String, Integer> idxs;
    private Map<Long, Map<String, BigDecimal>> spDataMap = new HashMap<Long, Map<String, BigDecimal>>(16);

    public RealBalRptMapFunc(ReportDataCtx ctx, RowMeta rowMeta, DataSet dataSet) {
        this.rowMeta = rowMeta;
        this.showQtyCols = ctx.getShowQtyCols();
        HashSet<String> qtyCols = new HashSet<String>(8);
        qtyCols.addAll(this.showQtyCols);
        qtyCols.add("id");
        for (String qtyCol : this.showQtyCols) {
            qtyCols.add(qtyCol + "_lock");
        }
        while (dataSet.hasNext()) {
            Row row1 = dataSet.next();
            HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(4);
            for (String qtyCol : this.showQtyCols) {
                qtyMap.put("sp" + qtyCol, row1.getBigDecimal("sp" + qtyCol));
            }
            this.spDataMap.put(row1.getLong("invid"), qtyMap);
        }
        this.buildIndexs(qtyCols);
    }

    private void buildIndexs(Set<String> qtyCols) {
        ArrayList<String> cols = new ArrayList<String>(qtyCols);
        this.idxs = TransformUtil.buildIndexs((RowMeta)this.rowMeta, cols);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX row) {
        Long balId = row.getLong(this.idxs.get("id").intValue());
        Map<String, BigDecimal> qtyMap = this.spDataMap.get(balId);
        if (qtyMap != null) {
            for (String qtyCol : this.showQtyCols) {
                BigDecimal qtyLock = row.getBigDecimal(this.idxs.get(qtyCol + "_lock").intValue());
                BigDecimal qtySp = qtyMap.get("sp" + qtyCol) == null ? BigDecimal.ZERO : qtyMap.get("sp" + qtyCol);
                row.set(this.idxs.get(qtyCol + "_lock").intValue(), (Object)qtyLock.add(qtySp));
            }
        }
        return row;
    }
}

