/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.sum;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.scmc.im.report.algox.sum.SumRptParam;
import kd.scmc.im.report.algox.sum.trans.AddBalCol;
import kd.scmc.im.report.algox.sum.trans.FilterQty;
import kd.scmc.im.report.algox.sum.trans.HandleCols4BigTable;
import kd.scmc.im.report.algox.sum.trans.OnlyShowRowCount;
import kd.scmc.im.report.algox.util.RptHandle;
import kd.scmc.im.report.algox.util.RptUtil;
import kd.scmc.im.report.algox.util.trans.AddMaterialGroup;
import kd.scmc.im.report.algox.util.trans.ZeroQtyFilterTransform;

public final class SumRptHandle
implements IReportDataHandle {
    private SumRptParam reportParam;
    private RptHandle rptHandle;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (SumRptParam)ctx.getParam(SumRptParam.class.getName());
        this.getRptHandle().addNecessaryCol(ctx);
        this.setFixedFs(ctx);
        this.setCountQtyCols(ctx);
        this.getRptHandle().setImHeadFilter(ctx, this.reportParam);
    }

    private void setFixedFs(ReportDataCtx ctx) {
        ArrayList<QFilter> fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            fixedFs = new ArrayList<QFilter>();
            ctx.setFixedFs(fixedFs);
        }
        fixedFs.addAll(this.getFixedFilter());
    }

    private void setCountQtyCols(ReportDataCtx ctx) {
        Set<Object> receiverIds = this.getReceiverIds();
        Set qtyCols = ctx.getShowQtyCols();
        HashSet<String> allQtyCols = new HashSet<String>();
        RptUtil.buildQtyCols(allQtyCols, qtyCols, receiverIds);
        ctx.setSumQtyCols4Count(allQtyCols);
    }

    private Set<Object> getReceiverIds() {
        HashSet<Object> receiverIds = new HashSet<Object>(this.reportParam.getReceiverType().keySet());
        receiverIds.addAll(this.reportParam.getFixdReceiverType().keySet());
        return receiverIds;
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("biztime");
        repoColFilter.add("datatype");
        int size = this.reportParam.getReceiverType().size() + this.reportParam.getFixdReceiverType().size();
        if (size > 0) {
            repoColFilter.add("transceivertype");
        }
        repoColFilter.add("noupdateinvfields");
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        String srcEntity = null;
        RptHandle handle = this.getRptHandle();
        for (SrcBlockConf blockConf : blockCollector) {
            srcEntity = blockConf.getSrcEntity();
            if ("im_inv_periodbalance".equals(srcEntity)) {
                this.handleInitQtyBlock(blockConf);
            }
            handle.handleInitBill(blockConf, this.reportParam.isIncludeUnUpdateBal());
            handle.handleMaterialFs(blockConf);
            handle.handleNoUpdateCols(blockConf);
        }
    }

    private void handleInitQtyBlock(SrcBlockConf blockConf) {
        int period = RptUtil.getPeriod(this.reportParam.getBillFromDate(), -1);
        this.getRptHandle().handlePerBalFs(blockConf, period);
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new AddBalCol(ctx.getShowQtyCols()));
        Collection<String> qtyFilters = this.reportParam.getQtyFilters();
        if (!qtyFilters.isEmpty()) {
            transCollector.add(new FilterQty(ctx));
        }
        transCollector.add(new ZeroQtyFilterTransform(ctx));
        AddMaterialGroup addMaterialGroup = new AddMaterialGroup(ctx, this.reportParam);
        addMaterialGroup.setRepoMaterialCol("materialgroup");
        addMaterialGroup.setRepoMaterialCol("material");
        transCollector.add(addMaterialGroup);
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        if (this.reportParam.isOnlyShowRowCount()) {
            transCollector.add(new OnlyShowRowCount());
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new HandleCols4BigTable(ctx));
    }

    private List<QFilter> getFixedFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        fs.add(RptUtil.buildStatusFs("status", this.reportParam.isIncludeSubmitStatus()));
        fs.add(RptUtil.buildBizTimeFs("biztime", this.reportParam.getBillFromDate(), this.reportParam.getToDate()));
        if (!this.reportParam.isIncludeUnUpdateBal()) {
            fs.add(new QFilter("isupdatebal", "=", (Object)"0").and("isvirtualbill", "=", (Object)"0"));
        }
        this.getRptHandle().appendCommonFs(fs);
        return fs;
    }

    private RptHandle getRptHandle() {
        return this.rptHandle == null ? (this.rptHandle = new RptHandle().setRptParam(this.reportParam)) : this.rptHandle;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        Set showQtyCols = ctx.getShowQtyCols();
        ArrayList<AbstractReportColumn> showCols = new ArrayList<AbstractReportColumn>(columns.size() + showQtyCols.size() * 3);
        ReportColumn reportCol = null;
        boolean showInitAndBal = this.reportParam.isShowInitAndBalQty();
        boolean showIn = this.reportParam.isShowInQty();
        boolean showOut = this.reportParam.isShowOutQty();
        HashMap<Object, String> receiverType = new HashMap<Object, String>(this.reportParam.getReceiverType());
        receiverType.putAll(this.reportParam.getFixdReceiverType());
        String field = null;
        ArrayList<DecimalReportColumn> receiverQtyCol = new ArrayList<DecimalReportColumn>(showQtyCols.size() * receiverType.size());
        String qtyColName = null;
        DecimalReportColumn tempQtyCol = null;
        boolean zeroShow = false;
        boolean scaleZero = false;
        boolean summary = false;
        for (AbstractReportColumn col : columns) {
            reportCol = (ReportColumn)col;
            field = reportCol.getFieldKey();
            zeroShow = reportCol.isZeroShow();
            scaleZero = reportCol.isNoDisplayScaleZero();
            if (showQtyCols.contains(field)) {
                if (col instanceof DecimalReportColumn) {
                    summary = ((DecimalReportColumn)col).getSummary() == 1;
                }
                qtyColName = col.getCaption().getLocaleValue();
                String unitCol = reportCol.getMeasureUnitField();
                if (showInitAndBal) {
                    tempQtyCol = ReportUtil.buildQtyCol((String)field, (LocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\uff08\u671f\u521d\uff09", (String)"SumRptHandle_0", (String)"scmc-im-report", (Object[])new Object[0]), qtyColName)), (String)unitCol, (boolean)summary);
                    tempQtyCol.setZeroShow(zeroShow);
                    tempQtyCol.setNoDisplayScaleZero(scaleZero);
                    showCols.add((AbstractReportColumn)tempQtyCol);
                }
                if (showIn) {
                    tempQtyCol = ReportUtil.buildQtyCol((String)(field + "_in"), (LocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\uff08\u6536\u5165\uff09", (String)"SumRptHandle_1", (String)"scmc-im-report", (Object[])new Object[0]), qtyColName)), (String)unitCol, (boolean)summary);
                    tempQtyCol.setZeroShow(zeroShow);
                    tempQtyCol.setNoDisplayScaleZero(scaleZero);
                    showCols.add((AbstractReportColumn)tempQtyCol);
                }
                if (showOut) {
                    tempQtyCol = ReportUtil.buildQtyCol((String)(field + "_out"), (LocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\uff08\u53d1\u51fa\uff09", (String)"SumRptHandle_2", (String)"scmc-im-report", (Object[])new Object[0]), qtyColName)), (String)unitCol, (boolean)summary);
                    tempQtyCol.setZeroShow(zeroShow);
                    tempQtyCol.setNoDisplayScaleZero(scaleZero);
                    showCols.add((AbstractReportColumn)tempQtyCol);
                }
                if (showInitAndBal) {
                    tempQtyCol = ReportUtil.buildQtyCol((String)(field + "_bal"), (LocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\uff08\u7ed3\u4f59\uff09", (String)"SumRptHandle_3", (String)"scmc-im-report", (Object[])new Object[0]), qtyColName)), (String)unitCol, (boolean)summary);
                    tempQtyCol.setZeroShow(zeroShow);
                    tempQtyCol.setNoDisplayScaleZero(scaleZero);
                    showCols.add((AbstractReportColumn)tempQtyCol);
                }
                for (Map.Entry entry : receiverType.entrySet()) {
                    tempQtyCol = ReportUtil.buildQtyCol((String)(field + entry.getKey()), (LocaleString)new LocaleString(qtyColName + "\uff08" + (String)entry.getValue() + "\uff09"), (String)unitCol, (boolean)summary);
                    tempQtyCol.setZeroShow(zeroShow);
                    tempQtyCol.setNoDisplayScaleZero(scaleZero);
                    receiverQtyCol.add(tempQtyCol);
                }
            } else {
                showCols.add(col);
            }
            if (!"material".equals(field)) continue;
            reportCol.setHyperlink(true);
        }
        showCols.addAll(receiverQtyCol);
        return showCols;
    }
}

