/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.sum.trans;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.im.report.algox.detail.DetailRptParam;
import kd.scmc.im.report.algox.sum.SumRptParam;
import kd.scmc.im.report.algox.sum.func.QtyFilterFunc;

public class FilterQty
implements IDataXTransform {
    private String[] qtyCols;
    private String[] filters;

    public FilterQty(ReportDataCtx ctx) {
        this.qtyCols = ctx.getShowQtyCols().toArray(new String[0]);
        SumRptParam reportParam = (SumRptParam)ctx.getParam(SumRptParam.class.getName());
        if ("im_detail_rpt".equals(ctx.getReportEntity())) {
            reportParam = (SumRptParam)ctx.getParam(DetailRptParam.class.getName());
        }
        this.filters = reportParam.getQtyFilters().toArray(new String[0]);
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.filters.length == 0 || this.qtyCols.length == 0) {
            return srcData;
        }
        ArrayList<int[]> idxList = new ArrayList<int[]>(this.filters.length);
        RowMeta rowMeta = srcData.getRowMeta();
        String[] stringArray = this.filters;
        int n = stringArray.length;
        block16: for (int i = 0; i < n; ++i) {
            String filter;
            switch (filter = stringArray[i]) {
                case "1": {
                    idxList.add(this.getIdx(rowMeta, "_in"));
                    continue block16;
                }
                case "2": {
                    idxList.add(this.getIdx(rowMeta, "_out"));
                    continue block16;
                }
                case "3": {
                    idxList.add(this.getIdx(rowMeta, "_in", "_out"));
                    continue block16;
                }
                case "4": {
                    idxList.add(this.getIdx(rowMeta, ""));
                    continue block16;
                }
                case "5": 
                case "6": 
                case "7": {
                    idxList.add(this.getIdx(rowMeta, "_bal"));
                    continue block16;
                }
            }
        }
        return srcData.filter((FilterFunction)new QtyFilterFunc(idxList, this.filters));
    }

    private int[] getIdx(RowMeta rowMeta, String ... qtyType) {
        int[] idx = new int[this.qtyCols.length * qtyType.length];
        int i = 0;
        for (String type : qtyType) {
            for (String qtyCol : this.qtyCols) {
                idx[i++] = rowMeta.getFieldIndex(qtyCol + type);
            }
        }
        return idx;
    }

    public String toString() {
        return "FilterQty [qtyCols=" + Arrays.toString(this.qtyCols) + ", filters=" + Arrays.toString(this.filters) + "]";
    }
}

