/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.report.IReportView;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.bplat.scmc.report.util.ReportUtil;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.datactrl.DataCtrlSchemeResultHandle;
import kd.scmc.im.business.helper.datactrl.InvBizDataCtrlHelper;
import kd.scmc.im.business.helper.datactrl.MaterielIsolateResultHandle;
import kd.scmc.im.business.helper.datactrl.WarehouseIsolateResultHandle;
import kd.scmc.im.report.algox.util.FromToCol;
import kd.scmc.im.report.algox.util.GroupCol;
import kd.scmc.im.report.algox.util.RptParam;
import kd.scmc.im.report.algox.util.RptUtil;
import kd.scmc.im.report.common.AnalyseReportConst;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public class RptForm {
    public static final String DATASEGTYPE = "datasegtype";
    private IReportView view;
    private String orgCol = "invorg";
    private String groupStandardCol = "groupstandard";
    private String groupFromCol = "groupfrom";
    private String groupToCol = "groupto";
    private String materialTypeCol = "materialtype";
    private String materialFromCol = "materialfrom";
    private String materialToCol = "materialto";
    private String repoMaterialCol = "material";
    private String repoMaterialGroupCol = "materialgroup";
    private String repoOwnerCol = "owner";
    private String repoOwnerTypeCol = "ownertype";
    private String repoKeeperCol = "keeper";
    private String repoKeeperTypeCol = "keepertype";
    private String repoOrgCol = "org";
    private String repoAuxptyCol = "auxpty";
    private String repoNoUpdateCols = "noupdateinvfields";
    private String longNumber = "longnumber";
    private String longNumberSplit = "!";
    private final Log log = LogFactory.getLog(RptForm.class);
    public static final String STARTSTATUS = "startstatus";
    public static final String WAREHOUSE_ID = "warehouse.id";
    private static final String CACHE_KEY_ORG_IDS = "hasPermissionOrg";
    public static final String _NO = ".number";
    public static final String NO = "number";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String ORG = "org";
    public static final String bd_materialgroupdetail = "bd_materialgroupdetail";
    public static final String meta_material_group = "group";
    public static final String meta_material_standard = "standard";

    public void setRepoAuxptyCol(String repoAuxptyCol) {
        this.repoAuxptyCol = repoAuxptyCol;
    }

    public void setRepoMaterialCol(String repoMaterialCol) {
        this.repoMaterialCol = repoMaterialCol;
    }

    public void setRepoMaterialGroupCol(String repoMaterialGroupCol) {
        this.repoMaterialGroupCol = repoMaterialGroupCol;
    }

    public void setRepoOwnerCol(String repoOwnerCol) {
        this.repoOwnerCol = repoOwnerCol;
    }

    public void setRepoOwnerTypeCol(String repoOwnerTypeCol) {
        this.repoOwnerTypeCol = repoOwnerTypeCol;
    }

    public void setRepoKeeperCol(String repoKeeperCol) {
        this.repoKeeperCol = repoKeeperCol;
    }

    public void setRepoKeeperTypeCol(String repoKeeperTypeCol) {
        this.repoKeeperTypeCol = repoKeeperTypeCol;
    }

    public void setRepoOrgCol(String repoOrgCol) {
        this.repoOrgCol = repoOrgCol;
    }

    public void register(Object form) {
        if (form instanceof BeforeF7SelectListener) {
            FormUtils.addF7Listener((BeforeF7SelectListener)((BeforeF7SelectListener)form), (String[])new String[]{this.orgCol, this.groupStandardCol, this.groupFromCol, this.groupToCol, this.materialFromCol, this.materialToCol, "auxproperty", "auxdetailbd"});
        }
        if (form instanceof AbstractFormPlugin) {
            ((AbstractFormPlugin)form).addClickListeners(new String[]{"auxdetailbasebd"});
        }
        if (form instanceof BeforeFilterF7SelectListener) {
            FilterGrid filterGrid = (FilterGrid)((AbstractFormPlugin)form).getView().getControl("commonfs");
            filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)form);
        }
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        AuxptyFilterHelper.loadOtherEntryFilter((DynamicObject)scheme, (IDataModel)this.view.getModel(), (IReportView)this.view);
    }

    public void saveEntryFilter(String ... entrys) {
        if (entrys == null) {
            return;
        }
        DynamicObject data = this.view.getModel().getDataEntity();
        for (String entry : entrys) {
            data.set(entry, (Object)this.view.getModel().getEntryEntity(entry));
        }
    }

    public void initPage(Set<String> rmCols) {
        this.initOrg();
        this.removeFilterGridCols(rmCols);
        this.initAuxpty();
    }

    private void initAuxpty() {
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.view.getModel(), (IFormView)this.view);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name != null) {
            ChangeData[] valueSet = e.getChangeSet();
            Object newValue = valueSet[0].getNewValue();
            int rowIndex = valueSet[0].getRowIndex();
            if (name.equals("showkeycols")) {
                this.changedShowKeyCols();
            } else if (name.equals("sumkeycols")) {
                this.changedSumKeyCols();
            } else if (name.equals(this.orgCol)) {
                this.changedInvOrg(e);
            } else if (name.equals(this.groupStandardCol)) {
                this.changedGroupStandard();
            } else if (name.equals(this.groupFromCol)) {
                this.changedGroupFrom(e);
                this.changeContainLowerGrp();
            } else if (name.equals(this.groupToCol)) {
                this.changedGroupto();
                this.changeContainLowerGrp();
            } else if (name.equals(this.materialFromCol)) {
                this.changedMaterialFrom(e);
            } else if (name.equals("auxproperty")) {
                AuxptyFilterHelper.handleAuxpropertyChangeEvent((Object)newValue, (int)rowIndex, (IFormView)this.view);
            } else if (name.equals("auxdetailbasebd")) {
                AuxptyFilterHelper.handleAuxdetailBdChagneEvent((Object)newValue, (int)rowIndex, (IDataModel)this.view.getModel());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent f7) {
        String name = f7.getProperty().getName();
        if (name != null) {
            if (name.equals(this.orgCol)) {
                this.selectInvOrg(f7);
            } else if (name.equals(this.groupStandardCol)) {
                this.selectGroupStandard(f7);
            } else if (name.equals(this.groupFromCol)) {
                this.selectGroupFrom(f7);
            } else if (name.equals(this.groupToCol)) {
                this.selectGroupTo(f7);
            } else if (name.equals(this.materialFromCol)) {
                this.selectMaterialFrom(f7);
            } else if (name.equals(this.materialToCol)) {
                this.selectMaterialTo(f7);
            } else if (name.equals("auxproperty")) {
                ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
                AuxptyFilterHelper.beforeAuxProperty((ListShowParameter)showParameter);
            } else if (name.equals("auxdetailbd")) {
                ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
                AuxptyFilterHelper.beforeAuxpropertydetail((ListShowParameter)showParameter, (IFormView)this.view);
            }
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent f7, IDataModel model) {
        String entityId = f7.getRefEntityId();
        if ("bd_warehouse".equals(entityId)) {
            DynamicObjectCollection invOrg = model.getDataEntity().getDynamicObjectCollection("invorg");
            this.selectWarehouse(f7, invOrg);
            return;
        }
        this.selectCommonFs(f7);
    }

    private void selectCommonFs(BeforeFilterF7SelectEvent f7) {
        QFilter dataSegF7Fs = this.getDataSegF7Fs(f7.getRefEntityId(), f7.getFieldName(), ID);
        f7.getQfilters().add(dataSegF7Fs);
    }

    public void setWhFilterBeforeQuery(ReportQueryParam queryParam, IDataModel model, String commFilterKey) {
        List<Long> whIds = this.warehouseBeforeQuery(queryParam, model, commFilterKey);
        if (whIds.isEmpty()) {
            return;
        }
        FilterInfo filter = queryParam.getFilter();
        QFilter commonFilter = filter.getCommFilter(commFilterKey);
        QFilter warehouseFilter = new QFilter("warehouse", "in", whIds);
        if (commonFilter == null) {
            filter.getCommFilter().put(commFilterKey, warehouseFilter);
        } else {
            commonFilter.and(warehouseFilter);
        }
    }

    public List<Long> warehouseBeforeQuery(ReportQueryParam queryParam, IDataModel model, String commFilterKey) {
        DynamicObjectCollection invOrg = model.getDataEntity().getDynamicObjectCollection("invorg");
        if (invOrg.isEmpty()) {
            return new ArrayList<Long>();
        }
        List warehouseIds = WareHouseIsolateHelper.getWarehouseIds((Object)invOrg, (String)"", (boolean)false);
        if (warehouseIds == null || warehouseIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        return warehouseIds;
    }

    public RptForm(IReportView view) {
        this.view = view;
    }

    private void selectWarehouse(BeforeFilterF7SelectEvent f7, DynamicObjectCollection invOrg) {
        if (invOrg.isEmpty()) {
            return;
        }
        QFilter dataSegF7Fs = this.getDataSegF7Fs(f7.getRefEntityId(), f7.getFieldName(), ID);
        f7.getQfilters().add(dataSegF7Fs);
        this.addEnabledInvWhFilter(f7, invOrg);
    }

    private void addEnabledInvWhFilter(BeforeFilterF7SelectEvent f7, DynamicObjectCollection invOrgCollection) {
        List<Long> orgIds = this.getOrgIds();
        if (orgIds.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter(STARTSTATUS, "=", (Object)"B");
        filter.and(ORG, "in", orgIds);
        try (DataSet enabledInvWhs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_invstart", (String)WAREHOUSE_ID, (QFilter[])filter.toArray(), null);){
            ArrayList<Object> whIds = new ArrayList<Object>(invOrgCollection.size());
            if (!enabledInvWhs.isEmpty()) {
                for (Row row : enabledInvWhs) {
                    Object whId = row.get(WAREHOUSE_ID);
                    whIds.add(whId);
                }
            }
            if (!whIds.isEmpty()) {
                f7.getQfilters().add(new QFilter(ID, "in", whIds));
            }
        }
    }

    public void setOrgCol(String orgCol) {
        this.orgCol = orgCol;
    }

    public void setGroupStandardCol(String groupStandardCol) {
        this.groupStandardCol = groupStandardCol;
    }

    public void setGroupFromCol(String groupFromCol) {
        this.groupFromCol = groupFromCol;
    }

    public void setGroupToCol(String groupToCol) {
        this.groupToCol = groupToCol;
    }

    public void setMaterialFromCol(String materialFromCol) {
        this.materialFromCol = materialFromCol;
    }

    public void setMaterialToCol(String materialToCol) {
        this.materialToCol = materialToCol;
    }

    public void setMaterialTypeCol(String materialTypeCol) {
        this.materialTypeCol = materialTypeCol;
    }

    public void initOrg(List<Long> orgIds) {
        Object[] ids = null;
        if (orgIds != null && orgIds.size() > 0) {
            ids = new Object[]{orgIds.get(0)};
        }
        IDataModel model = this.view.getModel();
        model.setValue(this.orgCol, ids);
    }

    public void initOrg() {
        List<Long> orgIds = this.getHasPermissionOrg();
        this.initOrg(orgIds);
    }

    private List<Long> getHasPermissionOrg() {
        ArrayList<Long> ids = null;
        String idStr = this.view.getPageCache().get(CACHE_KEY_ORG_IDS);
        if (StringUtils.isBlank((CharSequence)idStr)) {
            ids = new ArrayList();
            Long orgId = RequestContext.getOrCreate().getOrgId();
            List allPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)this.view.getModel().getDataEntityType().getName(), (String)"05");
            if (allPermissionOrgs != null) {
                int orgIdIdx = -1;
                Long tempId = null;
                int len = allPermissionOrgs.size();
                for (int i = 0; i < len; ++i) {
                    tempId = Long.valueOf((String)((Map)allPermissionOrgs.get(i)).get(ID));
                    ids.add(tempId);
                    if (!orgId.equals(tempId)) continue;
                    orgIdIdx = i;
                }
                if (orgIdIdx > 0) {
                    tempId = ids.set(0, orgId);
                    ids.set(orgIdIdx, tempId);
                }
            } else {
                ids.add(0L);
            }
            this.view.getPageCache().put(CACHE_KEY_ORG_IDS, SerializationUtils.toJsonString(ids));
        } else {
            ids = SerializationUtils.fromJsonStringToList((String)idStr, Long.class);
        }
        return ids;
    }

    public void selectInvOrg(BeforeF7SelectEvent f7) {
        List<Long> orgIds = this.getHasPermissionOrg();
        F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter(ID, "in", orgIds));
    }

    public void changedSumKeyCols() {
        String addkeeperType;
        IDataModel model = this.view.getModel();
        String colsStr = (String)model.getValue("sumkeycols");
        if (StringUtils.isBlank((CharSequence)colsStr)) {
            return;
        }
        String addOwnerType = this.checkCoupleItem(colsStr, this.repoOwnerCol, this.repoOwnerTypeCol);
        if (addOwnerType != null) {
            colsStr = addOwnerType;
        }
        if ((addkeeperType = this.checkCoupleItem(colsStr, this.repoKeeperCol, this.repoKeeperTypeCol)) != null) {
            colsStr = addkeeperType;
        }
        if (addOwnerType != null || addkeeperType != null) {
            model.setValue("sumkeycols", (Object)colsStr);
        }
    }

    public void changedShowKeyCols() {
        String addMaterial;
        String addkeeperType;
        IDataModel model = this.view.getModel();
        String colsStr = (String)model.getValue("showkeycols");
        if (StringUtils.isBlank((CharSequence)colsStr)) {
            return;
        }
        String addOwnerType = this.checkCoupleItem(colsStr, this.repoOwnerCol, this.repoOwnerTypeCol);
        if (addOwnerType != null) {
            colsStr = addOwnerType;
        }
        if ((addkeeperType = this.checkCoupleItem(colsStr, this.repoKeeperCol, this.repoKeeperTypeCol)) != null) {
            colsStr = addkeeperType;
        }
        if ((addMaterial = this.checkCoupleItem(colsStr, this.repoMaterialGroupCol, this.repoMaterialCol)) != null) {
            colsStr = addMaterial;
        }
        if (addOwnerType != null || addkeeperType != null || addMaterial != null) {
            model.setValue("showkeycols", (Object)colsStr);
        }
    }

    private String checkCoupleItem(String str, String hasVal, String addVal) {
        CharSequence[] items = str.split(",");
        int hasValIdx = -1;
        int addValIdx = -1;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].equals(hasVal)) {
                hasValIdx = i;
                continue;
            }
            if (!items[i].equals(addVal)) continue;
            addValIdx = i;
        }
        if (hasValIdx > -1 && addValIdx == -1) {
            items[hasValIdx] = hasVal + "," + addVal;
            return String.join((CharSequence)",", items) + ",";
        }
        return null;
    }

    public List<Long> getOrgIds() {
        return RptUtil.getBaseDataLongIds(this.view, this.orgCol);
    }

    public void selectGroupStandard(BeforeF7SelectEvent f7) {
        if (RptUtil.isNull(this.view, this.orgCol)) {
            f7.setCancel(true);
            return;
        }
        List<Long> orgIds = this.getOrgIds();
        Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", orgIds, Boolean.TRUE});
        F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter(ID, "in", (Object)ids));
    }

    public void selectGroupFrom(BeforeF7SelectEvent f7) {
        this.selectGroup(f7);
    }

    public void selectGroupTo(BeforeF7SelectEvent f7) {
        this.selectGroup(f7);
        this.appendFromNoFs(f7, this.groupFromCol);
    }

    private void selectGroup(BeforeF7SelectEvent f7) {
        DynamicObject data = this.view.getModel().getDataEntity();
        if (RptUtil.isNull(this.view, this.orgCol) || RptUtil.isNull(this.view, this.groupStandardCol)) {
            f7.setCancel(true);
            return;
        }
        List<Long> orgIds = this.getOrgIds();
        Object groupStandardId = data.getDynamicObject(this.groupStandardCol).getPkValue();
        QFilter fs = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, groupStandardId, false});
        F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)fs);
        ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
        showParameter.setCustomParam("groupStandard", groupStandardId);
    }

    public void selectMaterial(BeforeF7SelectEvent f7) {
        DynamicObject data = this.view.getModel().getDataEntity();
        List<Long> orgIds = this.getOrgIds();
        DynamicObject groupStandard = data.getDynamicObject(this.groupStandardCol);
        Object groupStandardId = groupStandard == null ? AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID : groupStandard.getPkValue();
        ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("groupStandard", groupStandardId);
        if (orgIds.isEmpty()) {
            params.put("isShowAllNoOrg", "true");
            showParameter.setCustomParams(params);
        } else {
            params.put("useOrgs", orgIds);
            showParameter.setCustomParams(params);
        }
        List treeFs = showParameter.getTreeFilterParameter().getQFilters();
        QFilter groupFs = this.getGroupFs();
        if (groupFs != null) {
            treeFs.add(groupFs);
        }
        QFilter fs = this.getMaterialFsByGroup();
        F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)fs);
    }

    private QFilter getGroupFs() {
        GroupCol info = this.getGroupCol();
        return info.buildFromToFs(ID, NO);
    }

    private void appendFromNoFs(BeforeF7SelectEvent f7, String fromCol) {
        DynamicObject data = this.view.getModel().getDataEntity();
        DynamicObjectCollection fromDatas = data.getDynamicObjectCollection(fromCol);
        if (fromDatas.size() == 1) {
            String no = ((DynamicObject)fromDatas.get(0)).getDynamicObject("fbasedataid").getString(NO);
            F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter(NO, ">=", (Object)no));
        } else if (fromDatas.size() > 1) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)new QFilter("1", "=", (Object)2));
        }
    }

    public void selectMaterialFrom(BeforeF7SelectEvent f7) {
        this.selectMaterial(f7);
        F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)this.getDataSegF7Fs("bd_material", "material", ID));
    }

    public void selectMaterialTo(BeforeF7SelectEvent f7) {
        this.selectMaterial(f7);
        this.appendFromNoFs(f7, this.materialFromCol);
        F7Utils.addF7Filter((BeforeF7SelectEvent)f7, (QFilter)this.getDataSegF7Fs("bd_material", "material", ID));
    }

    private QFilter getMaterialFsByGroup() {
        GroupCol info = this.getGroupCol();
        this.appendLowerGrpId2Info(info);
        QFilter fs = this.buildGroupFs(info, meta_material_group);
        if (fs != null && meta_material_group.equals(fs.getProperty())) {
            fs.__setProperty("group.id");
        }
        if (fs == null || info.isGroupStandardId()) {
            return fs;
        }
        int maxRowCount = 5000;
        DataSet idData = QueryServiceHelper.queryDataSet((String)"getMaterialFsByGroup", (String)bd_materialgroupdetail, (String)"material", (QFilter[])fs.toArray(), null, (int)maxRowCount);
        ArrayList<Long> ids = new ArrayList<Long>(maxRowCount);
        for (Row idInfo : idData) {
            ids.add(idInfo.getLong("material"));
        }
        if (ids.size() >= maxRowCount) {
            return null;
        }
        return new QFilter(ID, "in", ids);
    }

    public GroupCol getGroupCol() {
        FromToCol fsInfo = this.getFromToCol(this.groupFromCol, this.groupToCol);
        GroupCol info = new GroupCol();
        DynamicObject data = this.view.getModel().getDataEntity();
        DynamicObject groupStandard = data.getDynamicObject(this.groupStandardCol);
        info.setGroupStandardId(groupStandard == null ? AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID.longValue() : groupStandard.getLong(ID));
        info.setNoFrom(fsInfo.getNoFrom());
        info.setNoTo(fsInfo.getNoTo());
        info.setIds(fsInfo.getIds());
        return info;
    }

    public FromToCol getFromToCol(String fromCol, String toCol) {
        FromToCol info = new FromToCol();
        DynamicObject data = this.view.getModel().getDataEntity();
        DynamicObjectCollection fromDatas = data.getDynamicObjectCollection(fromCol);
        ArrayList<Object> ids = new ArrayList<Object>(fromDatas.size());
        DynamicObject from = null;
        DynamicObject tempDaseData = null;
        int i = 0;
        for (DynamicObject baseData : fromDatas) {
            tempDaseData = baseData.getDynamicObject("fbasedataid");
            ids.add(tempDaseData.getPkValue());
            if (i++ != 0) continue;
            from = tempDaseData;
        }
        info.setNoFrom(from != null ? from.getString(NO) : null);
        DynamicObject to = data.getDynamicObject(toCol);
        info.setNoTo(to != null ? to.getString(NO) : null);
        if (ids.size() == 1 && info.getNoTo() == null || ids.size() == 1 && to != null && !ids.get(0).equals(to.getPkValue())) {
            ids.clear();
        }
        info.setIds(ids);
        return info;
    }

    public QFilter buildGroupFs(GroupCol info, String materialGroupCol) {
        QFilter fs = null;
        if (info.isGroupStandardId()) {
            fs = info.buildFromToFs(materialGroupCol, materialGroupCol + _NO);
        } else {
            fs = new QFilter(meta_material_standard, "=", (Object)info.getGroupStandardId());
            QFilter groupFs = info.buildFromToFs(meta_material_group, "group.number");
            if (groupFs != null) {
                fs.and(groupFs);
            }
        }
        return fs;
    }

    public void changedInvOrg(PropertyChangedArgs e) {
        IDataModel model = this.view.getModel();
        ChangeData[] valueSet = e.getChangeSet();
        DynamicObjectCollection newValue = (DynamicObjectCollection)valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        if (newValue == null || newValue.size() == 0) {
            model.setValue("invorg", oldValue);
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RptForm_0", (String)"scmc-im-report", (Object[])new Object[0]));
            return;
        }
        model.setValue(this.groupStandardCol, (Object)730148448254487552L);
        model.setValue(this.groupFromCol, null);
        model.setValue(this.groupToCol, null);
        model.setValue(this.materialFromCol, null);
        model.setValue(this.materialToCol, null);
        FilterGrid filterGrid = (FilterGrid)this.view.getControl("commonfs");
        filterGrid.SetValue(new FilterCondition());
    }

    public void changedGroupStandard() {
        IDataModel model = this.view.getModel();
        model.setValue(this.groupFromCol, null);
        model.setValue(this.groupToCol, null);
        model.setValue(this.materialFromCol, null);
        model.setValue(this.materialToCol, null);
    }

    public void changedGroupFrom(PropertyChangedArgs e) {
        IDataModel model = this.view.getModel();
        this.changedFromTo(e, this.groupToCol);
        model.setValue(this.materialFromCol, null);
        model.setValue(this.materialToCol, null);
    }

    public void changedGroupto() {
        IDataModel model = this.view.getModel();
        model.setValue(this.materialFromCol, null);
        model.setValue(this.materialToCol, null);
    }

    public void changeContainLowerGrp() {
        IDataModel model = this.view.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObjectCollection groupFrom = data.getDynamicObjectCollection(this.groupFromCol);
        DynamicObject groupTo = data.getDynamicObject(this.groupToCol);
        if (groupFrom.size() > 1) {
            this.view.setEnable(Boolean.TRUE, new String[]{"containlowergrp"});
        } else if (groupFrom.size() == 1) {
            Long groupToId;
            Long groupFromId = ((DynamicObject)groupFrom.get(0)).getLong("fbasedataid_id");
            if (groupFromId.equals(groupToId = Long.valueOf(groupTo == null ? 0L : groupTo.getLong(ID)))) {
                this.view.setEnable(Boolean.TRUE, new String[]{"containlowergrp"});
            } else {
                this.view.setEnable(Boolean.FALSE, new String[]{"containlowergrp"});
                this.view.getModel().setValue("containlowergrp", (Object)Boolean.FALSE);
            }
        } else {
            this.view.setEnable(Boolean.FALSE, new String[]{"containlowergrp"});
            this.view.getModel().setValue("containlowergrp", (Object)Boolean.FALSE);
        }
    }

    public void changedMaterialFrom(PropertyChangedArgs e) {
        this.changedFromTo(e, this.materialToCol);
    }

    public void changedFromTo(PropertyChangedArgs e, String to) {
        ChangeData[] datas = e.getChangeSet();
        DynamicObjectCollection newValue = (DynamicObjectCollection)datas[0].getNewValue();
        if (newValue == null || newValue.size() == 0) {
            this.view.setEnable(Boolean.TRUE, new String[]{to});
            this.view.getModel().setValue(to, null);
        } else if (newValue.size() == 1) {
            this.view.setEnable(Boolean.TRUE, new String[]{to});
            this.view.getModel().setValue(to, ((DynamicObject)newValue.get(0)).getDynamicObject("fbasedataid").getPkValue());
        } else {
            this.view.setEnable(Boolean.FALSE, new String[]{to});
            this.view.getModel().setValue(to, null);
        }
    }

    public void buildRptParam(RptParam reportParam) {
        reportParam.setOrgs(this.getOrgIds());
        this.setMaterialGroupInfo(reportParam);
        this.setMaterialInfo(reportParam);
        this.setAuxptyInfo(reportParam);
    }

    private void setAuxptyInfo(RptParam param) {
        List auxptyIds = AuxptyFilterHelper.getAuxptyIds((IDataModel)this.view.getModel());
        param.setAuxptyIds(auxptyIds);
    }

    private void setMaterialInfo(RptParam reportParam) {
        FromToCol fsInfo = this.getFromToCol(this.materialFromCol, this.materialToCol);
        QFilter materialFs = fsInfo.buildFromToFs(this.repoMaterialCol, this.repoMaterialCol + _NO);
        if (!fsInfo.getIds().isEmpty()) {
            reportParam.setOnlyMaterialIdFs(true);
        }
        reportParam.setMaterialFs(materialFs);
        reportParam.setMaterialtypes(ReportUtil.parseCombColVal((IDataModel)this.view.getModel(), (String)this.materialTypeCol));
    }

    private void setMaterialGroupInfo(RptParam reportParam) {
        GroupCol info = this.getGroupCol();
        reportParam.setDefStander(info.isGroupStandardId());
        this.appendLowerGrpId2Info(info);
        QFilter fs = this.buildGroupFs(info, this.repoMaterialGroupCol);
        reportParam.setSelectedGroup(info.getIds().size() > 0);
        reportParam.setMaterialGroupFs(fs);
    }

    private void appendLowerGrpId2Info(GroupCol info) {
        DynamicObject data = this.view.getModel().getDataEntity();
        boolean containLowerGrp = data.getBoolean("containlowergrp");
        if (!containLowerGrp) {
            return;
        }
        DynamicObjectCollection groupFroms = data.getDynamicObjectCollection(this.groupFromCol);
        QFilter longNumFilter = null;
        for (DynamicObject group : groupFroms) {
            String longNum = group.getDynamicObject("fbasedataid").getString(this.longNumber);
            if (longNumFilter == null) {
                longNumFilter = new QFilter(this.longNumber, "like", (Object)(longNum + this.longNumberSplit + "%"));
                continue;
            }
            longNumFilter.or(this.longNumber, "like", (Object)(longNum + this.longNumberSplit + "%"));
        }
        QFilter[] qfs = new QFilter[2];
        DynamicObject groupStandard = data.getDynamicObject(this.groupStandardCol);
        Long standardId = groupStandard == null ? AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID.longValue() : groupStandard.getLong(ID);
        qfs[0] = new QFilter(meta_material_standard, "=", (Object)standardId);
        qfs[1] = longNumFilter;
        if (longNumFilter == null) {
            return;
        }
        Map lowerGrpMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (QFilter[])qfs);
        for (DynamicObject lowerGrp : lowerGrpMap.values()) {
            Long lowerGrpId = lowerGrp.getLong(ID);
            info.getIds().add(lowerGrpId);
        }
    }

    public void removeFilterGridCols(Set<String> removedPros, Set<String> needPros) {
        removedPros = removedPros == null ? new HashSet<String>(4) : removedPros;
        removedPros.add(this.repoOrgCol);
        removedPros.add(this.repoAuxptyCol);
        removedPros.add(this.repoMaterialGroupCol);
        removedPros.add(this.repoMaterialCol);
        removedPros.add(this.repoNoUpdateCols);
        if (needPros != null) {
            removedPros.removeAll(needPros);
        }
        FilterGrid filterGrid = (FilterGrid)this.view.getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (removedPros.contains(fieldName.split("\\.")[0])) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    public void removeFilterGridCols(Set<String> removedPros) {
        this.removeFilterGridCols(removedPros, null);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnDataObj = evt.getReturnData();
        switch (actionId) {
            case "auxdetailbasebd": {
                int idx = this.view.getModel().getEntryCurrentRowIndex("auxentry");
                AuxptyFilterHelper.handleClosedCallBack((Object)returnDataObj, (IDataModel)this.view.getModel(), (String)(idx + ""));
            }
        }
    }

    public void click(EventObject evt, IFormPlugin plugin) {
        TextEdit textEdit;
        String key;
        Object source = evt.getSource();
        if (source instanceof TextEdit && "auxdetailbasebd".equals(key = (textEdit = (TextEdit)source).getKey())) {
            int idx = this.view.getModel().getEntryCurrentRowIndex("auxentry");
            AuxptyFilterHelper.showAuxBaseForm((String)key, (int)idx, (IFormView)this.view, (IDataModel)this.view.getModel(), (IFormPlugin)plugin);
        }
    }

    public boolean checkDataCtrl() {
        DynamicObject repo;
        boolean singleOrg;
        DynamicObject dynamicObject = ReportDataHandle.loadConfModel((String)this.view.getModel().getDataEntityType().getName());
        DynamicObjectCollection colsentry = dynamicObject.getDynamicObjectCollection("colsentry");
        boolean anyMatch = colsentry.stream().anyMatch(item -> StringUtils.isNotEmpty((CharSequence)item.getString(DATASEGTYPE)));
        if (!anyMatch) {
            return true;
        }
        String dataSegOrg = dynamicObject.getString("datasegorg");
        if (StringUtils.isBlank((CharSequence)dataSegOrg)) {
            return true;
        }
        List<Long> orgIds = RptUtil.getBaseDataLongIds(this.view, dataSegOrg);
        if (orgIds.size() > 1 && !(singleOrg = this.checkOrg(orgIds, colsentry, (repo = dynamicObject.getDynamicObject("repo")).getString(NO)))) {
            return false;
        }
        return this.checkDataCtrlSchema(colsentry);
    }

    private boolean checkDataCtrlSchema(DynamicObjectCollection colsentry) {
        List strategyIds = colsentry.stream().filter(item -> item.getDynamicObject("datactrlstrategy") != null).map(item -> item.getDynamicObject("datactrlstrategy").getLong(ID)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(strategyIds)) {
            QFilter qFilter = new QFilter(ID, "in", strategyIds);
            Map strategyMap = BusinessDataServiceHelper.loadFromCache((String)"msbd_datactrlstrategy", (String)"id,entryentity.datactrlscheme", (QFilter[])qFilter.toArray());
            if (strategyMap == null) {
                return true;
            }
            ArrayList<Long> schemaIds = new ArrayList<Long>();
            for (DynamicObject row : strategyMap.values()) {
                DynamicObjectCollection entryentity = row.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    schemaIds.add(entry.getDynamicObject("datactrlscheme").getLong(ID));
                }
            }
            QFilter schemaFilter = new QFilter(ID, "in", schemaIds);
            Map schemaDataSet = BusinessDataServiceHelper.loadFromCache((String)"msbd_datactrlscheme", (String)"id,entryentity.inputcondition", (QFilter[])schemaFilter.toArray());
            if (schemaDataSet == null) {
                return true;
            }
            for (DynamicObject row : schemaDataSet.values()) {
                DynamicObjectCollection entryentity = row.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    String[] split;
                    String inputcondition = entry.getString("inputcondition");
                    if (StringUtils.isBlank((CharSequence)inputcondition)) continue;
                    for (String condition : split = inputcondition.split(",")) {
                        if (!StringUtils.isNotBlank((CharSequence)condition) || RptUtil.DATA_CTRL_FIELD.contains(condition)) continue;
                        String msg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u62a5\u8868\u5f15\u7528\u7684\u6570\u636e\u63a7\u5236\u65b9\u6848\u201c%s\u201d\uff0c\u53d6\u503c\u6761\u4ef6\u53ea\u80fd\u9009\u7ec4\u7ec7\u548c\u4eba\u5458/\u4e1a\u52a1\u5458/\u4e1a\u52a1\u7ec4/\u4e1a\u52a1\u90e8\u95e8\u3002", (String)"MSCOMMON-E-368872", (String)"scmc-im-report", (Object[])new Object[]{row.getString(NAME)});
                        this.view.showTipNotification(msg);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public QFilter getDataSegF7Fs(String refEntityId, String fieldName, String filterField) {
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        MainEntityType dataEntityType = this.view.getModel().getDataEntityType();
        DynamicObject dynamicObject = ReportDataHandle.loadConfModel((String)dataEntityType.getName());
        DynamicObjectCollection colsEntry = dynamicObject.getDynamicObjectCollection("colsentry");
        List dynamicObjectList = colsEntry.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getString(DATASEGTYPE))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return null;
        }
        Object datasegorg = this.view.getModel().getDataEntity().get(dynamicObject.getString("datasegorg"));
        ArrayList<Long> orgs = new ArrayList<Long>();
        if (datasegorg instanceof DynamicObject) {
            orgs.add(((DynamicObject)datasegorg).getLong("fbasedataid_id"));
        } else if (datasegorg instanceof DynamicObjectCollection) {
            orgs.add(((DynamicObject)((DynamicObjectCollection)datasegorg).get(0)).getLong("fbasedataid_id"));
        }
        for (DynamicObject dyn : dynamicObjectList) {
            String repoField = fieldName.contains(".") ? fieldName.substring(0, fieldName.indexOf(".")) : fieldName;
            if (!repoField.equals(dyn.getString("repo_col"))) continue;
            String dataSegType = dyn.getString(DATASEGTYPE);
            if ("A".equals(dataSegType)) {
                PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                this.log.info("[RptForm.getDataSegF7Fs]getDataRuleWithoutDim param:refEntityId:" + refEntityId + ",orgs:" + orgs);
                QFilter dataRuleWithoutDim = permissionService.getDataRuleWithoutDim(currUserId, dataEntityType.getAppId(), refEntityId, "47150e89000000ac", orgs);
                this.log.info("[RptForm.getDataSegF7Fs]getDataRuleWithoutDim result:" + dataRuleWithoutDim);
                return dataRuleWithoutDim;
            }
            if (!"B".equals(dataSegType)) continue;
            Long strategyId = dyn.getDynamicObject("datactrlstrategy").getLong(ID);
            this.log.info("[RptForm.getDataSegF7Fs]getDataByUser param:strategyId:" + strategyId + ",orgs:" + orgs);
            Set dataByUser = InvBizDataCtrlHelper.buildF7Helper().getDataByUser(orgs, strategyId);
            this.log.info("[RptForm.getDataSegF7Fs]getDataByUser result:" + dataByUser);
            if (!CollectionUtils.isNotEmpty((Collection)dataByUser)) continue;
            return new QFilter(filterField, "in", (Object)dataByUser);
        }
        return null;
    }

    private boolean checkOrg(List<Long> orgs, DynamicObjectCollection colsentry, String repoNumber) {
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        MainEntityType dataEntityType = this.view.getModel().getDataEntityType();
        MainEntityType repoEntityType = MetadataServiceHelper.getDataEntityType((String)repoNumber);
        for (DynamicObject dyn : colsentry) {
            String repoCol = dyn.getString("repo_col");
            String dataSegType = dyn.getString(DATASEGTYPE);
            if ("A".equals(dataSegType)) {
                String typePropName = null;
                ArrayList<String> basedataEntityNames = new ArrayList<String>();
                IDataEntityProperty property = repoEntityType.findProperty(repoCol);
                if (property instanceof ItemClassProp) {
                    typePropName = ((ItemClassProp)MetadataServiceHelper.getDataEntityType((String)repoNumber).findProperty(repoCol)).getTypePropName();
                    List baseDataTypes = ((ItemClassTypeProp)repoEntityType.findProperty(typePropName)).getBaseEntityIds();
                    basedataEntityNames.addAll(baseDataTypes);
                } else if (property instanceof BasedataProp) {
                    String basedataNumber = ((BasedataProp)MetadataServiceHelper.getDataEntityType((String)repoNumber).findProperty(repoCol)).getBaseEntityId();
                    basedataEntityNames.add(basedataNumber);
                }
                PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
                for (String entityname : basedataEntityNames) {
                    QFilter dataRuleQf = permissionService.getDataRuleWithoutDim(currUserId, dataEntityType.getAppId(), entityname, "47150e89000000ac", orgs);
                    if (dataRuleQf == null) continue;
                    String msg = ResManager.loadKDString((String)"\u62a5\u8868\u914d\u7f6e\u4e86\u201c\u6570\u636e\u9694\u79bb\u65b9\u5f0f\u201d\uff0c\u53ea\u80fd\u6309\u5355\u7ec4\u7ec7\u67e5\u8be2\uff0c\u8bf7\u68c0\u67e5\u201c\u62a5\u8868\u6570\u636e\u6e90\u914d\u7f6e\u201d\u3002", (String)"RptForm_1", (String)"scmc-im-report", (Object[])new Object[0]);
                    this.view.showTipNotification(msg);
                    return false;
                }
                continue;
            }
            if (!"B".equals(dataSegType)) continue;
            Long strategyId = dyn.getDynamicObject("datactrlstrategy").getLong(ID);
            Set dataByUser = InvBizDataCtrlHelper.buildLimitHelper((DataCtrlSchemeResultHandle[])new DataCtrlSchemeResultHandle[0]).addFilter((DataCtrlSchemeResultHandle)new WarehouseIsolateResultHandle()).addFilter((DataCtrlSchemeResultHandle)new MaterielIsolateResultHandle()).getDataByUser(orgs, strategyId);
            if (CollectionUtils.isEmpty((Collection)dataByUser)) continue;
            String msg = ResManager.loadKDString((String)"\u62a5\u8868\u914d\u7f6e\u4e86\u201c\u6570\u636e\u9694\u79bb\u65b9\u5f0f\u201d\uff0c\u53ea\u80fd\u6309\u5355\u7ec4\u7ec7\u67e5\u8be2\uff0c\u8bf7\u68c0\u67e5\u201c\u62a5\u8868\u6570\u636e\u6e90\u914d\u7f6e\u201d\u3002", (String)"RptForm_1", (String)"scmc-im-report", (Object[])new Object[0]);
            this.view.showTipNotification(msg);
            return false;
        }
        return true;
    }
}

