/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.util;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.scmc.im.report.algox.util.RptParam;
import kd.scmc.im.report.algox.util.RptUtil;
import kd.scmc.im.report.algox.util.trans.RmNoUpdateCols;
import kd.scmc.im.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class RptHandle {
    private String orgCol = "org";
    private String auxptyCol = "auxpty";
    private String materialCol = "material";
    private String mtMasteridCol = "materialmasterid";
    private RptParam rptParam;

    public RptHandle setRptParam(RptParam rptParam) {
        this.rptParam = rptParam;
        return this;
    }

    public void setOrgCol(String orgCol) {
        this.orgCol = orgCol;
    }

    public void setMaterialCol(String materialCol) {
        this.materialCol = materialCol;
    }

    public void appendCommonFs(List<QFilter> fs) {
        if (fs != null) {
            List<Object> auxptyIds;
            QFilter materialFs;
            Set<String> materialTypes;
            List<Long> orgs = this.rptParam.getOrgs();
            fs.add(orgs.size() == 1 ? new QFilter(this.orgCol, "=", (Object)orgs.get(0)) : new QFilter(this.orgCol, "in", orgs));
            QFilter materialGroupFs = this.rptParam.getMaterialGroupFs();
            if (materialGroupFs != null && this.rptParam.isDefStander()) {
                fs.add(this.rptParam.getMaterialGroupFs());
            }
            if ((materialTypes = this.rptParam.getMaterialTypes()) != null && materialTypes.size() > 0) {
                fs.add(new QFilter(this.materialCol + ".materialtype", "in", materialTypes));
            }
            if ((materialFs = this.rptParam.getMaterialFs()) != null) {
                fs.add(materialFs);
            }
            if ((auxptyIds = this.rptParam.getAuxptyIds()) != null) {
                fs.add(new QFilter(this.auxptyCol, "in", auxptyIds));
            }
        }
    }

    public void appendWarehouseFs(List<QFilter> fs) {
        List<Long> wareHouseIds = this.rptParam.getWareHouseIds();
        if (wareHouseIds != null && !wareHouseIds.isEmpty()) {
            fs.add(new QFilter("warehouse", "in", wareHouseIds));
        }
    }

    public void handleMaterialFs(SrcBlockConf blockConf) {
        Map repoColSrcColMap;
        String materialMasteridCol;
        List<QFilter> headFilters = this.rptParam.getHeadFilters();
        if (this.rptParam.getMaterialTypes().isEmpty() && (this.rptParam.isOnlyMaterialIdFs() || this.rptParam.getMaterialFs() == null) && (headFilters == null || headFilters.isEmpty()) && StringUtils.isNotBlank((CharSequence)(materialMasteridCol = (String)(repoColSrcColMap = blockConf.getRepoColFullSrcColMap()).get(this.mtMasteridCol)))) {
            repoColSrcColMap.put(this.materialCol, materialMasteridCol);
        }
    }

    public void handlePerBalFs(SrcBlockConf blockConf, int period) {
        QFilter allFs = new QFilter("period", "<=", (Object)period).and("endperiod", ">", (Object)period);
        QFilter dataFs = blockConf.getDataFs();
        if (dataFs != null) {
            allFs.and(dataFs);
        }
        blockConf.setDataFs(allFs);
        blockConf.setAllowNotMatch(true);
    }

    public void handleNoUpdateCols(SrcBlockConf blockConf) {
        blockConf.getDataTransform().add(new RmNoUpdateCols(blockConf));
    }

    public void handleInitBill(SrcBlockConf blockConf, boolean includeUnUpdateBal) {
        String srcEntity;
        if (!includeUnUpdateBal && ("im_purinbill".equals(srcEntity = blockConf.getSrcEntity()) || "im_saloutbill".equals(srcEntity))) {
            QFilter dataFs = blockConf.getDataFs();
            dataFs.and("isinitbill", "=", (Object)"0");
            blockConf.setDataFs(dataFs);
        }
    }

    public void addNecessaryCol(ReportDataCtx ctx) {
        boolean defStander = this.rptParam.isDefStander();
        if (!defStander) {
            ctx.getShowKeyCols().add(this.materialCol);
        }
    }

    public void setImHeadFilter(ReportDataCtx ctx, RptParam rptParam) {
        List<QFilter> headFilters = rptParam.getHeadFilters();
        Set qtyCols = ctx.getSumQtyCols4Count();
        if (headFilters == null || headFilters.isEmpty()) {
            return;
        }
        Map<String, String> transHeadFiltersMap = this.buildTransHeadFiltersMap(ctx);
        LinkedList<QFilter> billHeadFilters = new LinkedList<QFilter>();
        QFilter materialGroupFilter = null;
        for (QFilter headFilter : headFilters) {
            Map dataTypeMap;
            String originalProp = headFilter.getProperty();
            Object val = headFilter.getValue();
            String newProp = transHeadFiltersMap.get(originalProp);
            newProp = newProp == null ? originalProp : newProp;
            String cp = headFilter.getCP();
            if ("materialgroup".equals(originalProp) && !rptParam.isDefStander()) {
                originalProp = originalProp.replace("materialgroup", "group");
                newProp = newProp.replace("materialgroup", "group");
                headFilter.__setProperty(newProp);
                materialGroupFilter = headFilter;
            } else if (!qtyCols.contains(originalProp.split("_")[0])) {
                headFilter.__setProperty(newProp);
                billHeadFilters.add(headFilter);
            }
            if ("is null".equals(cp) || "is not null".equals(cp)) {
                String qcp = "is null".equals(cp) ? "=" : "!=";
                headFilter.clearNests();
                if (originalProp.equals(newProp) || originalProp.contains("_ref_")) {
                    headFilter.__setCP(qcp);
                    headFilter.__setValue((Object)"");
                } else {
                    headFilter.__setProperty(originalProp);
                    headFilter.__setCP(qcp);
                    headFilter.__setValue((Object)0);
                }
            }
            if (!DataType.TimestampType.equals((dataTypeMap = ctx.getReportConf().getDataTypeMap()).get(originalProp)) || !"=".equals(cp) || !(val instanceof String)) continue;
            Date date = DateUtils.parseDate((String)val.toString());
            headFilter.__setValue((Object)date);
        }
        QFilter materialGroupFs = this.rptParam.getMaterialGroupFs();
        if (materialGroupFilter != null) {
            if (materialGroupFs == null) {
                this.rptParam.setMaterialGroupFs(materialGroupFilter);
            } else {
                materialGroupFs.and(materialGroupFilter);
            }
        }
        ctx.getPageFs().addAll(billHeadFilters);
    }

    private Map<String, String> buildTransHeadFiltersMap(ReportDataCtx ctx) {
        ReportConf reportConf = ctx.getReportConf();
        List bigTableColConf = reportConf.getBigTableColConf();
        HashMap<String, String> resultMap = new HashMap<String, String>(bigTableColConf.size());
        for (BigTableColConf colConf : bigTableColConf) {
            String key;
            String val = key = colConf.getCol();
            String showProp = colConf.getShowProp();
            if (colConf.getDataType() == DataType.LongType) {
                val = String.join((CharSequence)".", key, RptUtil.getDisplayProp(showProp));
            }
            resultMap.put(key, val);
            List showRefProps = colConf.getShowRefProps();
            if (showRefProps == null || showRefProps.isEmpty()) continue;
            showRefProps.stream().forEach(c -> resultMap.put(String.join((CharSequence)"_ref_", key, c), String.join((CharSequence)".", key, c)));
        }
        return resultMap;
    }
}

