/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.util.trans;

import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.im.report.algox.sum.SumRptParam;
import kd.scmc.im.report.algox.util.func.ZeroQtyFilterFunc;

public class ZeroQtyFilterTransform
implements IDataXTransform {
    private Set<String> qtyCols;

    public ZeroQtyFilterTransform(ReportDataCtx ctx) {
        this.qtyCols = ctx.getSumQtyCols4Count();
        if ("im_age_rpt".equals(ctx.getReportEntity())) {
            this.qtyCols = ctx.getShowQtyCols();
        } else if ("im_sum_rpt".equals(ctx.getReportEntity())) {
            this.qtyCols = this.removeSumRptUnShowQtyCol(ctx);
        }
    }

    private Set<String> removeSumRptUnShowQtyCol(ReportDataCtx ctx) {
        SumRptParam rptParam = (SumRptParam)ctx.getParam(SumRptParam.class.getName());
        Set showQtyCols = ctx.getShowQtyCols();
        Set allQtyCols = ctx.getSumQtyCols4Count();
        Iterator iterator = allQtyCols.iterator();
        while (iterator.hasNext()) {
            String col = (String)iterator.next();
            if (!rptParam.isShowInQty() && col.endsWith("_in")) {
                iterator.remove();
                continue;
            }
            if (!rptParam.isShowOutQty() && col.endsWith("_out")) {
                iterator.remove();
                continue;
            }
            if (rptParam.isShowInitAndBalQty() || !col.endsWith("_bal") && !showQtyCols.contains(col)) continue;
            iterator.remove();
        }
        return allQtyCols;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.qtyCols.isEmpty()) {
            return srcData;
        }
        int[] qtyIdxs = new int[this.qtyCols.size()];
        RowMeta rowMeta = srcData.getRowMeta();
        Iterator<String> iterator = this.qtyCols.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            int fieldIdx = rowMeta.getFieldIndex(iterator.next());
            qtyIdxs[i++] = fieldIdx;
        }
        return srcData.filter((FilterFunction)new ZeroQtyFilterFunc(qtyIdxs));
    }

    public String toString() {
        return "FilterZeroQty [qtyCols=" + this.qtyCols + "]";
    }
}

