/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.analyse.base;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.report.common.AnalyseReportConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.AnalyseRptOpHelper;

public abstract class AbstractAnalyseDetailRptQuery
extends AbstractReportListDataPlugin {
    protected AbstractAnalyseDetailRptQuery() {
    }

    protected static QFilter addCommonDataQFilter(FilterInfo filterInfo) {
        QFilter tracknumberFilter;
        QFilter configuredCodeFilter;
        QFilter projectFilter;
        QFilter locationFilter;
        QFilter warehouseFilter;
        QFilter materialFilter;
        DynamicObjectCollection invstatusheads;
        DynamicObjectCollection ivntypeheads;
        DynamicObjectCollection orgSet = filterInfo.getDynamicObjectCollection("orghead");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (DynamicObject org : orgSet) {
            orgIds.add((Long)org.getPkValue());
        }
        QFilter commDataQFilter = new QFilter("org", "in", orgIds);
        String ownerTypehead = filterInfo.getString("ownertypehead");
        QFilter ownerTypeFilter = null;
        if (ownerTypehead != null && !ownerTypehead.trim().equals("")) {
            ownerTypeFilter = new QFilter("ownertype", "=", (Object)ownerTypehead);
            commDataQFilter.and(ownerTypeFilter);
        }
        if ((ivntypeheads = filterInfo.getDynamicObjectCollection("ivntypehead")) != null && ivntypeheads.size() > 0) {
            HashSet<Object> ivntypeIds = new HashSet<Object>();
            for (Iterator ivntype : ivntypeheads) {
                ivntypeIds.add(ivntype.getPkValue());
            }
            QFilter ivntypeheadFilter = new QFilter("invtype", "in", ivntypeIds);
            commDataQFilter.and(ivntypeheadFilter);
        }
        if ((invstatusheads = filterInfo.getDynamicObjectCollection("invstatushead")) != null && invstatusheads.size() > 0) {
            HashSet<Object> invstatusIds = new HashSet<Object>();
            for (DynamicObject invstatus : invstatusheads) {
                invstatusIds.add(invstatus.getPkValue());
            }
            QFilter invstatusheadFilter = new QFilter("invstatus", "in", invstatusIds);
            commDataQFilter.and(invstatusheadFilter);
        }
        if ((materialFilter = AbstractAnalyseDetailRptQuery.getMaterialNumFromToFilter(filterInfo)) != null) {
            commDataQFilter.and(materialFilter);
        }
        if ((warehouseFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "warehouse.number", "warehousefrom", "warehouseto")) != null) {
            commDataQFilter.and(warehouseFilter);
        }
        if ((locationFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "location.number", "locationfrom", "locationto")) != null) {
            commDataQFilter.and(locationFilter);
        }
        if ((projectFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "project.number", "projectfrom", "projectto")) != null) {
            commDataQFilter.and(projectFilter);
        }
        if ((configuredCodeFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "configuredcode.number", "configuredcodefrom", "configuredcodeto")) != null) {
            commDataQFilter.and(configuredCodeFilter);
        }
        if ((tracknumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "tracknumber.number", "tracknumberfrom", "tracknumberto")) != null) {
            commDataQFilter.and(tracknumberFilter);
        }
        return commDataQFilter;
    }

    protected void addLotNumberFilter(FilterInfo filterInfo, String lotnumberKey, QFilter defaultQFilter) {
        QFilter lotNumberFilter = ReportCommonFilterOrChangeOp.getTextFromToFilter(filterInfo, lotnumberKey, "lotnumberfrom", "lotnumberto");
        if (lotNumberFilter != null) {
            defaultQFilter.and(lotNumberFilter);
        }
    }

    protected static QFilter getMaterialFromToFilter(FilterInfo filterInfo, String filterColomn, String materialLogo) {
        DynamicObjectCollection materialFroms = filterInfo.getDynamicObjectCollection("materialnumberfrom");
        if (materialFroms != null && !materialFroms.isEmpty()) {
            if (materialFroms.size() > 1) {
                ArrayList<Object> materialNums = new ArrayList<Object>();
                for (DynamicObject materialFrom : materialFroms) {
                    Object materialNum = materialFrom.get(filterColomn);
                    materialNums.add(materialNum);
                }
                return new QFilter(materialLogo + "." + filterColomn, "in", materialNums);
            }
            DynamicObject materialFrom = (DynamicObject)materialFroms.get(0);
            if (materialFrom == null) {
                return null;
            }
            Object materialNumFrom = materialFrom.get(filterColomn);
            QFilter fromFilter = new QFilter(materialLogo + "." + filterColomn, ">=", materialNumFrom);
            DynamicObject materialTo = filterInfo.getDynamicObject("materialnumberto");
            if (materialTo == null) {
                return fromFilter;
            }
            Object materialNumTo = materialTo.get(filterColomn);
            QFilter toFilter = new QFilter(materialLogo + "." + filterColomn, "<=", materialNumTo);
            return fromFilter.and(toFilter);
        }
        DynamicObject materialTo = filterInfo.getDynamicObject("materialnumberto");
        if (materialTo == null) {
            return null;
        }
        Object materialNumTo = materialTo.get(filterColomn);
        QFilter toFilter = new QFilter(materialLogo + "." + filterColomn, "<=", materialNumTo);
        return toFilter;
    }

    protected static QFilter getMaterialNumFromToFilter(FilterInfo filterInfo) {
        return AbstractAnalyseDetailRptQuery.getMaterialFromToFilter(filterInfo, "number", "material");
    }

    protected DataSet getClassifiedMaterialDataSet(FilterInfo filterInfo) {
        Object pkValue = null;
        DynamicObject materialgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        pkValue = materialgroupstandard == null ? AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID : materialgroupstandard.getPkValue();
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"group,group.number as groupnumber,material,material.number as materialnumber,standard", (QFilter[])new QFilter("standard", "=", pkValue).toArray(), (String)"group desc");
        QFilter materialGroupNumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "groupnumber", "materialgroupfrom", "materialgroupto");
        if (materialGroupNumberFilter != null) {
            classifiedMaterialDataSet = classifiedMaterialDataSet.filter(materialGroupNumberFilter.toString());
        }
        return classifiedMaterialDataSet;
    }

    protected static QFilter buildBillQFilter(FilterInfo filterInfo) {
        QFilter lotNumberFilter;
        DynamicObjectCollection invstatusheads;
        DynamicObjectCollection ivntypeheads;
        QFilter billQFilter = AnalyseRptOpHelper.getIdentEqQFilter();
        DynamicObjectCollection orgSet = filterInfo.getDynamicObjectCollection("orghead");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (DynamicObject org : orgSet) {
            orgIds.add((Long)org.getPkValue());
        }
        billQFilter.and(new QFilter("org", "in", orgIds));
        String ownerTypehead = filterInfo.getString("ownertypehead");
        QFilter ownerTypeFilter = null;
        if (ownerTypehead != null && !ownerTypehead.trim().equals("")) {
            ownerTypeFilter = new QFilter("ownertype", "=", (Object)ownerTypehead);
            billQFilter.and(ownerTypeFilter);
        }
        if ((ivntypeheads = filterInfo.getDynamicObjectCollection("ivntypehead")) != null && ivntypeheads.size() > 0) {
            HashSet<Object> ivntypeIds = new HashSet<Object>();
            for (Iterator ivntype : ivntypeheads) {
                ivntypeIds.add(ivntype.getPkValue());
            }
            QFilter ivntypeheadFilter = new QFilter("invtype", "in", ivntypeIds);
            billQFilter.and(ivntypeheadFilter);
        }
        if ((invstatusheads = filterInfo.getDynamicObjectCollection("invstatushead")) != null && invstatusheads.size() > 0) {
            HashSet<Object> invstatusIds = new HashSet<Object>();
            for (DynamicObject invstatus : invstatusheads) {
                invstatusIds.add(invstatus.getPkValue());
            }
            QFilter invstatusheadFilter = new QFilter("invstatus", "in", invstatusIds);
            billQFilter.and(invstatusheadFilter);
        }
        if ((lotNumberFilter = ReportCommonFilterOrChangeOp.getTextFromToFilter(filterInfo, "lotnumber", "lotnumberfrom", "lotnumberto")) != null) {
            billQFilter.and(lotNumberFilter);
        }
        return billQFilter;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object paramObject) throws Throwable {
        return null;
    }
}

