/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.analyse.billparse;

import kd.bos.orm.query.QFilter;
import kd.scmc.im.report.analyse.billparse.IInvBillAsAccParser;
import kd.scmc.im.report.analyse.billparse.impl.AdjustBillAsAccParser;
import kd.scmc.im.report.analyse.billparse.impl.AssembBillAsAccParser;
import kd.scmc.im.report.analyse.billparse.impl.DisassBillAsAccParser;
import kd.scmc.im.report.analyse.billparse.impl.InitBillAsAccParser;
import kd.scmc.im.report.analyse.billparse.impl.InvTplBillAsAccParser;
import kd.scmc.im.report.analyse.billparse.impl.LocatTransferBillAsAccParser;
import kd.scmc.im.report.analyse.billparse.impl.TransDirBillAsAccParser;

public class InvBillAsAccParserFactory {
    public static IInvBillAsAccParser buildBillAsAccParser(String billType, QFilter timeQFilter) {
        switch (billType) {
            case "im_adjustbill": {
                return new AdjustBillAsAccParser(billType, timeQFilter);
            }
            case "im_assembbill": {
                return new AssembBillAsAccParser(billType, timeQFilter);
            }
            case "im_disassemblebill": {
                return new DisassBillAsAccParser(billType, timeQFilter);
            }
            case "im_locationtransfer": {
                return new LocatTransferBillAsAccParser(billType, timeQFilter);
            }
            case "im_transdirbill": {
                return new TransDirBillAsAccParser(billType, timeQFilter);
            }
            case "mdc_mftmanuinbill": 
            case "mdc_mftreqoutbill": {
                return null;
            }
            case "im_initbill": {
                return new InitBillAsAccParser(billType, timeQFilter);
            }
        }
        return new InvTplBillAsAccParser(billType, timeQFilter);
    }
}

