/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.analyse.shelflife;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.scmc.im.report.analyse.shelflife.ShelfLifeRptBeforeF7Select;
import kd.scmc.im.report.analyse.shelflife.ShelfLifeRptPropChanged;
import kd.scmc.im.report.common.AnalyseReportConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.common.ValidateMsgEntity;
import kd.scmc.im.report.helper.AnalyseRptOpHelper;
import kd.scmc.im.report.helper.OwnerTypeViewHelper;
import kd.scmc.im.utils.FormUtils;

public class ShelfLifeAlysRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        AnalyseRptOpHelper.handlePreOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"orghead", "accountownerfrom", "supplierownerfrom", "customerownerfrom", "ownerto", "materialgroupfrom", "materialgroupto", "materialnumberfrom", "materialnumberto", "warehousefrom", "warehouseto", "locationfrom", "locationto", "projectfrom", "projectto", "materialgroupstandard", "ivntypehead", "invstatushead", "configuredcodeto", "tracknumberto"});
        this.addClickListeners(new String[]{"lotnumberfrom"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap prop = new HashMap(1);
        HashMap<String, Integer> editor = new HashMap<String, Integer>(1);
        editor.put("maxlength", 8000);
        prop.put("item", editor);
        this.getView().updateControlMetadata("lotnumberfrom", prop);
        OwnerTypeViewHelper.setEnableUI(this.getModel(), (IFormView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ShelfLifeRptBeforeF7Select shelfLifeRptBeforeF7Select = new ShelfLifeRptBeforeF7Select((IFormView)this.getView());
        shelfLifeRptBeforeF7Select.beforeF7Select(e, "orghead");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ShelfLifeRptPropChanged shelfLifeRptPropChanged = new ShelfLifeRptPropChanged((IFormView)this.getView());
        shelfLifeRptPropChanged.propertyChanged(e);
    }

    public void afterCreateNewData(EventObject e) {
        ReportCommonFilterOrChangeOp.initMultiOrg(this.getView(), "orghead");
        this.initStandard();
        this.handleResetButtonEvent();
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "lotnumberfrom".equals(key = (textEdit = (TextEdit)source).getKey())) {
            this.showLotnumber(key);
        }
    }

    private void handleResetButtonEvent() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialgroupto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"warehouseto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"locationto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"projectto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"lotnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"configuredcodeto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"tracknumberto"});
    }

    private void showLotnumber(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("im_multitext");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        }
    }

    private void verifyDate(ValidateMsgEntity ckMsgEntity, Date prodatefrom, Date prodateto) {
        if (prodatefrom == null && prodateto == null) {
            return;
        }
        if (prodatefrom != null && prodateto != null && prodatefrom.after(prodateto)) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u201c\u751f\u4ea7\u65e5\u671f\u4ece\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u751f\u4ea7\u65e5\u671f\u81f3\u201d\u3002", (String)"ShelfLifeAlysRptPlugin_0", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    private void verifyShelfLifeDays(ValidateMsgEntity ckMsgEntity, int shelflifedaysfrom, int shelflifedaysto) {
        if (shelflifedaysfrom == 0 && shelflifedaysto == 0) {
            return;
        }
        if (shelflifedaysfrom > 0 && shelflifedaysto > 0 && shelflifedaysfrom > shelflifedaysto) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u201c\u4fdd\u8d28\u671f\u5929\u6570\u4ece\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u4fdd\u8d28\u671f\u5929\u6570\u81f3\u201d\u3002", (String)"ShelfLifeAlysRptPlugin_1", (String)"scmc-im-report", (Object[])new Object[0]));
            return;
        }
        if (shelflifedaysfrom < 0) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u201c\u4fdd\u8d28\u671f\u5929\u6570\u4ece\u201d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ShelfLifeAlysRptPlugin_2", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        if (shelflifedaysto < 0) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u201c\u4fdd\u8d28\u671f\u5929\u6570\u81f3\u201d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ShelfLifeAlysRptPlugin_3", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    private void verifyExpiryDays(ValidateMsgEntity ckMsgEntity, int expirydaysfrom, int expirydaysto) {
        if (expirydaysfrom != 0 && expirydaysto != 0 && expirydaysfrom > expirydaysto) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u201c\u5230\u671f\u5929\u6570\u4ece\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u5230\u671f\u5929\u6570\u81f3\u201d\u3002", (String)"ShelfLifeAlysRptPlugin_4", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    private boolean verifyQueryParam(FilterInfo filterInfo, ValidateMsgEntity ckMsgEntity) {
        IReportView view = this.getView();
        DynamicObjectCollection orghead = filterInfo.getDynamicObjectCollection("orghead");
        AnalyseRptOpHelper.verifyOrgMustInput(ckMsgEntity, orghead);
        DynamicObject mgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        AnalyseRptOpHelper.verifyMGroupStandardMustInput(ckMsgEntity, mgroupstandard);
        Date prodatefrom = filterInfo.getDate("prodatefrom");
        Date prodateto = filterInfo.getDate("prodateto");
        this.verifyDate(ckMsgEntity, prodatefrom, prodateto);
        int shelflifedaysfrom = filterInfo.getInt("shelflifedaysfrom");
        int shelflifedaysto = filterInfo.getInt("shelflifedaysto");
        this.verifyShelfLifeDays(ckMsgEntity, shelflifedaysfrom, shelflifedaysto);
        int expirydaysfrom = filterInfo.getInt("expirydaysfrom");
        int expirydaysto = filterInfo.getInt("expirydaysto");
        this.verifyExpiryDays(ckMsgEntity, expirydaysfrom, expirydaysto);
        boolean isCkSuccess = ckMsgEntity.isCheckSuccess();
        if (!isCkSuccess) {
            ckMsgEntity.showCkErrMsgs((IFormView)view);
        }
        return isCkSuccess;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        ValidateMsgEntity ckMsgEntity = new ValidateMsgEntity();
        return this.verifyQueryParam(filterInfo, ckMsgEntity);
    }

    private void initStandard() {
        this.getModel().setValue("materialgroupstandard", (Object)AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID);
    }

    public void afterSetModelValue(DynamicObject scheme) {
        Object o;
        DynamicObjectCollection projectFrom;
        DynamicObjectCollection locationFrom;
        DynamicObjectCollection warehouseFrom;
        DynamicObjectCollection materiaNumFrom;
        super.afterSetModelValue(scheme);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection materialGrpFrom = dataEntity.getDynamicObjectCollection("materialgroupfrom");
        if (materialGrpFrom.size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialgroupto"});
        }
        if ((materiaNumFrom = dataEntity.getDynamicObjectCollection("materialnumberfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialnumberto"});
        }
        if ((warehouseFrom = dataEntity.getDynamicObjectCollection("warehousefrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"warehouseto"});
        }
        if ((locationFrom = dataEntity.getDynamicObjectCollection("locationfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"locationto"});
        }
        if ((projectFrom = dataEntity.getDynamicObjectCollection("projectfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"projectto"});
        }
        if ((o = dataEntity.get("lotnumberfrom")) == null || "".equals(o)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"lotnumberto"});
        }
    }
}

