/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.balance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.biz.balance.engine.BalanceUpdateManager;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.consts.InvAccConst;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;

class BalanceChecker {
    public static final String DIM_COL = "dimcol";
    public static final String QTY_COL = "qtycol";
    public static final String QTY_BEGIN = "begin_";
    public static final String QTY_OUT = "out_";
    public static final String QTY_IN = "in_";
    public static final String QTY_BAL = "bal_";
    public static final String QTY_INV = "inv_";

    BalanceChecker() {
    }

    public static DataSet getErrorBalanceData(List<QFilter> fs, List<String> dimCols, List<String> qtyCols) {
        DataSet balData = BalanceChecker.getBalanceData(dimCols, qtyCols, fs);
        DataSet billData = BalanceChecker.getBillData(dimCols, qtyCols, BalanceChecker.getDefaultValues(balData.getRowMeta()), fs);
        DataSet unionData = balData.union(billData);
        GroupbyDataSet sum = unionData.groupBy(dimCols.toArray(new String[0]));
        for (String string : qtyCols) {
            sum = sum.sum(QTY_BEGIN + string).sum(QTY_OUT + string).sum(QTY_IN + string).sum(QTY_INV + string);
        }
        DataSet checkData = sum.finish();
        for (String qtyCol : qtyCols) {
            checkData = checkData.addField(QTY_BEGIN + qtyCol + "+" + QTY_IN + qtyCol + "-" + QTY_OUT + qtyCol, QTY_BAL + qtyCol);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int index = 0;
        stringBuilder.append('(');
        for (String qtyCol : qtyCols) {
            if (index++ > 0) {
                stringBuilder.append(" or ");
            }
            stringBuilder.append(QTY_BAL).append(qtyCol).append("!=").append(QTY_INV).append(qtyCol);
        }
        stringBuilder.append(')');
        checkData = checkData.filter(stringBuilder.toString());
        checkData = checkData.top(5000);
        return checkData;
    }

    private static Map<String, Object> getDefaultValues(RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        HashedMap defaultValues = new HashedMap();
        for (Field field : fields) {
            String name = field.getName();
            DataType dataType = field.getDataType();
            if (dataType instanceof StringType || dataType instanceof BooleanType) {
                defaultValues.put(name, "");
                continue;
            }
            if (dataType instanceof DateType || dataType instanceof TimestampType) {
                defaultValues.put(name, null);
                continue;
            }
            defaultValues.put(name, 0);
        }
        return defaultValues;
    }

    private static DataSet getBillData(List<String> dimCols, List<String> qtyCols, Map<String, Object> defaultValues, List<QFilter> fs) {
        List rules = BalanceUpdateManager.loadUpdateRule((String)InvAccConst.getBalTb());
        ArrayList<DataSet> billDatas = new ArrayList<DataSet>(rules.size());
        for (UpdateRule rule : rules) {
            if (!rule.isEnable()) continue;
            billDatas.add(BalanceChecker.getBillDataByRule(rule, dimCols, qtyCols, defaultValues, fs));
        }
        DataSet data = null;
        for (DataSet tempData : billDatas) {
            if (data == null) {
                data = tempData;
                continue;
            }
            data = data.union(tempData);
        }
        return data;
    }

    private static DataSet getBillDataByRule(UpdateRule rule, List<String> dimCols, List<String> qtyCols, Map<String, Object> defaultValues, List<QFilter> balFs) {
        QFilter bal2BillFs;
        QFilter fs = new QFilter("billstatus", "=", (Object)"C");
        QFilter ruleFilter = rule.getFilter();
        if (ruleFilter != null) {
            fs.and(ruleFilter);
        }
        if ((bal2BillFs = BalanceChecker.parse2BillFs(rule, balFs)) != null) {
            fs.and(bal2BillFs);
        }
        String selectCols = BalanceChecker.getBillCols4Select(rule, dimCols, qtyCols, defaultValues);
        DataSet srcData = QueryServiceHelper.queryDataSet((String)BalanceChecker.class.getName(), (String)rule.getEntityNumber(), (String)selectCols, (QFilter[])fs.toArray(), null);
        StringBuilder allCols = new StringBuilder();
        allCols.append(String.join((CharSequence)",", dimCols));
        if ("im_initbill".equals(rule.getEntityNumber())) {
            BalanceChecker.handQtyCols(allCols, QTY_BEGIN, qtyCols, "");
            BalanceChecker.appandCols(allCols, "0", QTY_IN, qtyCols);
            BalanceChecker.appandCols(allCols, "0", QTY_OUT, qtyCols);
            BalanceChecker.appandCols(allCols, "0", QTY_INV, qtyCols);
        } else {
            BalanceChecker.appandCols(allCols, "0", QTY_BEGIN, qtyCols);
            if (rule.getUpdateType() == 1) {
                BalanceChecker.handQtyCols(allCols, QTY_IN, qtyCols, "");
                BalanceChecker.appandCols(allCols, "0", QTY_OUT, qtyCols);
            } else {
                BalanceChecker.appandCols(allCols, "0", QTY_IN, qtyCols);
                BalanceChecker.handQtyCols(allCols, QTY_OUT, qtyCols, "");
            }
            BalanceChecker.appandCols(allCols, "0", QTY_INV, qtyCols);
        }
        srcData = srcData.select(allCols.toString());
        return srcData;
    }

    private static QFilter parse2BillFs(UpdateRule rule, List<QFilter> balFs) {
        Map targetSrcColMap = rule.getTargetSrcColMap();
        Map srcColFullNameMap = rule.getSrcColFullNameMap();
        QFilter fs = null;
        String property = null;
        String srcCol = null;
        for (QFilter f : balFs) {
            property = f.getProperty();
            srcCol = (String)targetSrcColMap.get(property);
            if (srcCol == null) continue;
            if (fs == null) {
                fs = new QFilter((String)srcColFullNameMap.get(srcCol), f.getCP(), f.getValue());
                continue;
            }
            fs.and((String)srcColFullNameMap.get(srcCol), f.getCP(), f.getValue());
        }
        return fs;
    }

    private static String getBillCols4Select(UpdateRule rule, List<String> dimCols, List<String> qtyCols, Map<String, Object> defaultValues) {
        StringBuilder srcSelectCols = new StringBuilder();
        Map targetSrcColMap = rule.getTargetSrcColMap();
        Map srcColFullNameMap = rule.getSrcColFullNameMap();
        int index = 0;
        String colName = null;
        ArrayList<String> cols = new ArrayList<String>(dimCols);
        cols.addAll(qtyCols);
        for (String col : cols) {
            colName = (String)targetSrcColMap.get(col);
            if (index++ > 0) {
                srcSelectCols.append(',');
            }
            if (colName != null) {
                srcSelectCols.append((String)srcColFullNameMap.get(colName)).append(" AS ").append(col);
                continue;
            }
            srcSelectCols.append(defaultValues.get(col)).append(" AS ").append(col);
        }
        return srcSelectCols.toString();
    }

    private static DataSet getBalanceData(List<String> dimCols, List<String> qtyCols, List<QFilter> fs) {
        String selectCols = String.join((CharSequence)",", dimCols);
        selectCols = selectCols + "," + String.join((CharSequence)",", qtyCols);
        DataSet balData = QueryServiceHelper.queryDataSet((String)BalanceChecker.class.getName(), (String)InvAccConst.getBalTb(), (String)selectCols, fs.isEmpty() ? null : fs.toArray(new QFilter[0]), null);
        StringBuilder allCols = new StringBuilder();
        allCols.append(String.join((CharSequence)",", dimCols));
        BalanceChecker.appandCols(allCols, "0", QTY_BEGIN, qtyCols);
        BalanceChecker.appandCols(allCols, "0", QTY_IN, qtyCols);
        BalanceChecker.appandCols(allCols, "0", QTY_OUT, qtyCols);
        BalanceChecker.handQtyCols(allCols, QTY_INV, qtyCols, "");
        balData = balData.select(allCols.toString());
        return balData;
    }

    private static void appandCols(StringBuilder selectCols, String val, String colType, List<String> qtyCols) {
        for (String qtyCol : qtyCols) {
            selectCols.append(',').append(val).append(' ').append(colType).append(qtyCol);
        }
    }

    private static void handQtyCols(StringBuilder selectCols, String colType, List<String> qtyCols, String qtyFlag) {
        for (String qtyCol : qtyCols) {
            selectCols.append(',').append(qtyCol).append(qtyFlag).append(' ').append(colType).append(qtyCol);
        }
    }

    public static List<String> parseCols(FilterInfo filter, String colName) {
        FilterItemInfo info = filter.getFilterItem(colName);
        String value = (String)info.getValue();
        ArrayList<String> cols = new ArrayList<String>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) {
            String[] colArr;
            for (String col : colArr = value.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)col)) continue;
                cols.add(col);
            }
        }
        return cols;
    }
}

