/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.report.common.AnalyseReportConst;
import kd.scmc.im.report.helper.ReportGeneralOpHelper;
import kd.scmc.im.utils.CommonUtils;

public class ReportCommonFilterOrChangeOp {
    private static String algoKey = ReportCommonFilterOrChangeOp.class.getName();
    private static final int formatDisplayFilterFieldLength = 20;

    public static void beforeMaterialgroupstandard(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        Object org = view.getModel().getValue(orgLogo);
        if (org == null && orgIsMust) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportCommonFilterOrChangeOp_3", (String)"scmc-im-report", (Object[])new Object[0]));
        }
        if (org instanceof DynamicObject) {
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", ((DynamicObject)org).getPkValue(), Boolean.TRUE});
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)ids));
        } else if (org instanceof DynamicObjectCollection) {
            if (((DynamicObjectCollection)org).size() == 0 && orgIsMust) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportCommonFilterOrChangeOp_3", (String)"scmc-im-report", (Object[])new Object[0]));
            }
            if (((DynamicObjectCollection)org).size() != 0) {
                ArrayList<Long> createOrgIds = new ArrayList<Long>();
                for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                    createOrgIds.add(dynamicObject.getLong("fbasedataid_id"));
                }
                Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)ids));
            }
        }
    }

    public static void beforeF7MaterialNumber(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        ReportCommonFilterOrChangeOp.setShowParameterByOry(showParameter, orgLogo, orgIsMust, view);
        ReportCommonFilterOrChangeOp.beforeF7MaterialNumber(showParameter, view);
    }

    @Deprecated
    public static void beforeF7MaterialNumber(ListShowParameter showParameter, IFormView view) {
        DynamicObjectCollection materialgroupfrom;
        ArrayList<Object> listFrom = new ArrayList<Object>();
        ArrayList<Object> listFromTO = new ArrayList<Object>();
        DynamicObject materialgroupto = (DynamicObject)view.getModel().getValue("materialgroupto");
        if (materialgroupto == null) {
            materialgroupfrom = (DynamicObjectCollection)view.getModel().getValue("materialgroupfrom");
            if (materialgroupfrom.isEmpty()) {
                listFrom.clear();
                listFromTO.clear();
                showParameter.getListFilterParameter().getQFilters().add(ReportCommonFilterOrChangeOp.getMaterialByStandard("masterid", view));
                return;
            }
            for (DynamicObject dynamicObject : materialgroupfrom) {
                Object number = dynamicObject.getDynamicObject(1).get("number");
                listFrom.add(number);
                listFromTO.clear();
            }
        } else {
            materialgroupfrom = (DynamicObjectCollection)view.getModel().getValue("materialgroupfrom");
            if (materialgroupfrom.size() == 0) {
                listFromTO.add(materialgroupto.get("number"));
            } else {
                Object number = ((DynamicObject)materialgroupfrom.get(0)).getDynamicObject(1).get("number");
                listFromTO.add(number);
                listFromTO.add(materialgroupto.get("number"));
            }
            listFrom.clear();
        }
        QFilter qFilter = null;
        if (listFrom.size() > 1) {
            qFilter = new QFilter("group.number", "in", listFrom);
        }
        if (listFromTO.size() != 0) {
            if (listFromTO.size() == 1) {
                qFilter = new QFilter("group.number", "<=", listFromTO.get(0));
            } else {
                qFilter = new QFilter("group.number", ">=", listFromTO.get(0));
                qFilter.and("group.number", "<=", listFromTO.get(1));
            }
        } else if (listFrom.size() == 1) {
            qFilter = new QFilter("group.number", ">=", listFrom.get(0));
        }
        QFilter materialf = ReportCommonFilterOrChangeOp.getMaterialByStandard("material", view);
        qFilter = qFilter == null ? materialf : qFilter.and(materialf);
        ArrayList<Object> materialIds = new ArrayList<Object>();
        DynamicObject[] materialgroupdetailIds = BusinessDataServiceHelper.load((String)"bd_materialgroupdetail", (String)"material,material.id", (QFilter[])qFilter.toArray());
        if (materialgroupdetailIds != null && materialgroupdetailIds.length > 0) {
            for (int i = 0; i < materialgroupdetailIds.length; ++i) {
                DynamicObject dynamicObject = materialgroupdetailIds[i].getDynamicObject("material");
                if (dynamicObject == null) continue;
                materialIds.add(dynamicObject.getPkValue());
            }
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("masterid", "in", materialIds));
    }

    public static void beforeF7Location(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        DynamicObjectCollection warehouseFromCollection;
        ArrayList<Object> listFrom = new ArrayList<Object>(1);
        ArrayList<Object> listFromTO = new ArrayList<Object>(2);
        DynamicObject warehouseTo = (DynamicObject)view.getModel().getValue("warehouseto");
        if (warehouseTo == null) {
            warehouseFromCollection = (DynamicObjectCollection)view.getModel().getValue("warehousefrom");
            if (warehouseFromCollection.isEmpty()) {
                return;
            }
            for (DynamicObject warehouseFrom : warehouseFromCollection) {
                Object number = warehouseFrom.getDynamicObject(1).get("number");
                listFrom.add(number);
                listFromTO.clear();
            }
        } else {
            warehouseFromCollection = (DynamicObjectCollection)view.getModel().getValue("warehousefrom");
            if (warehouseFromCollection.size() == 0) {
                listFromTO.add(warehouseTo.get("number"));
            } else {
                Object number = ((DynamicObject)warehouseFromCollection.get(0)).getDynamicObject(1).get("number");
                listFromTO.add(number);
                listFromTO.add(warehouseTo.get("number"));
            }
            listFrom.clear();
        }
        QFilter qFilterWarehouse = null;
        ArrayList qFilter = new ArrayList();
        if (listFrom.size() > 1) {
            qFilterWarehouse = new QFilter("number", "in", listFrom);
        }
        if (listFromTO.size() != 0) {
            if (listFromTO.size() == 1) {
                qFilterWarehouse = new QFilter("number", "<=", listFromTO.get(0));
            } else {
                qFilterWarehouse = new QFilter("number", ">=", listFromTO.get(0));
                qFilterWarehouse.and("number", "<=", listFromTO.get(1));
            }
        } else if (listFrom.size() == 1) {
            qFilterWarehouse = new QFilter("number", ">=", listFrom.get(0));
        }
        if (qFilterWarehouse == null) {
            return;
        }
        DynamicObject[] warehouses = BusinessDataServiceHelper.load((String)"bd_warehouse", (String)"id,entryentity,entryentity.location", (QFilter[])qFilterWarehouse.toArray());
        if (warehouses != null && warehouses.length > 0) {
            List<Object> listallWhs = new ArrayList();
            Object org = view.getModel().getValue(orgLogo);
            if (!orgIsMust && (org == null || org instanceof DynamicObjectCollection && ((DynamicObjectCollection)org).size() == 0)) {
                for (int i = 0; i < warehouses.length; ++i) {
                    DynamicObject warehouse = warehouses[i];
                    List ids = WarehouseHelper.getLocationIds((Object)warehouse.getPkValue());
                    qFilter.addAll(ids);
                }
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", qFilter));
                return;
            }
            if (org instanceof DynamicObject) {
                Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(((DynamicObject)org).getPkValue().toString()));
                listallWhs = Arrays.asList(allWhs);
            } else if (org instanceof DynamicObjectCollection) {
                ArrayList<Object> listOrgId = new ArrayList<Object>();
                for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                    listOrgId.add(dynamicObject.get("fbasedataid_id"));
                }
                listallWhs = WarehouseHelper.getAllWarehouse(listOrgId);
            }
            for (int i = 0; i < warehouses.length; ++i) {
                Iterator warehouse = warehouses[i];
                if (!listallWhs.contains(warehouse.getPkValue())) continue;
                List ids = WarehouseHelper.getLocationIds((Object)warehouse.getPkValue());
                qFilter.addAll(ids);
            }
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", qFilter));
    }

    public static void beforeF7SelectToValidate(ListShowParameter showParameter, String key, String orgLogo, boolean orgIsMust, IFormView view) {
        Object selectedNumberValue = null;
        if ("ownerto".equals(key)) {
            ReportCommonFilterOrChangeOp.handleOwnerToBeforeF7Select(showParameter, orgLogo, orgIsMust, view);
            return;
        }
        if ("keeperto".equals(key)) {
            ReportCommonFilterOrChangeOp.handleKeeperToBeforeF7Select(showParameter, orgLogo, orgIsMust, view);
        } else {
            if ("materialgroupto".equals(key)) {
                if (((DynamicObjectCollection)view.getModel().getValue("materialgroupfrom")).size() == 0) {
                    ReportCommonFilterOrChangeOp.beforeF7SelectMaterialGroupFrom(showParameter, orgLogo, true, view);
                    return;
                }
                selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("materialgroupfrom")).get(0)).getDynamicObject(1).get("number");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
                ReportCommonFilterOrChangeOp.beforeF7SelectMaterialGroupFrom(showParameter, orgLogo, true, view);
                return;
            }
            if ("materialnumberto".equals(key)) {
                if (((DynamicObjectCollection)view.getModel().getValue("materialnumberfrom")).size() != 0) {
                    String number = "number";
                    if ("im_shelflifealysrpt".equals(view.getEntityId())) {
                        number = "masterid.number";
                    }
                    selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("materialnumberfrom")).get(0)).getDynamicObject(1).get(number);
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter(number, ">=", selectedNumberValue));
                }
                ReportCommonFilterOrChangeOp.beforeF7MaterialNumber(showParameter, orgLogo, orgIsMust, view);
                return;
            }
            if ("warehouseto".equals(key)) {
                if (((DynamicObjectCollection)view.getModel().getValue("warehousefrom")).size() != 0) {
                    selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("warehousefrom")).get(0)).getDynamicObject(1).get("number");
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
                }
                ReportCommonFilterOrChangeOp.beforeF7WarehouseFrom(showParameter, orgLogo, orgIsMust, view);
                return;
            }
            if ("locationto".equals(key)) {
                if (((DynamicObjectCollection)view.getModel().getValue("locationfrom")).size() != 0) {
                    selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("locationfrom")).get(0)).getDynamicObject(1).get("number");
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
                }
                ReportCommonFilterOrChangeOp.beforeF7Location(showParameter, orgLogo, orgIsMust, view);
                return;
            }
            if ("projectto".equals(key)) {
                if (((DynamicObjectCollection)view.getModel().getValue("projectfrom")).size() == 0) {
                    return;
                }
                selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("projectfrom")).get(0)).getDynamicObject(1).get("number");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
                return;
            }
            if ("invschemeto".equals(key)) {
                if (((DynamicObjectCollection)view.getModel().getValue("invschemefrom")).size() == 0) {
                    return;
                }
                selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("invschemefrom")).get(0)).getDynamicObject(1).get("number");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
                return;
            }
            if ("configuredcodeto".equals(key)) {
                if (((DynamicObjectCollection)view.getModel().getValue("configuredcodefrom")).size() == 0) {
                    return;
                }
                selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("configuredcodefrom")).get(0)).getDynamicObject(1).get("number");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
                return;
            }
            if ("tracknumberto".equals(key)) {
                if (((DynamicObjectCollection)view.getModel().getValue("tracknumberfrom")).size() == 0) {
                    return;
                }
                selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("tracknumberfrom")).get(0)).getDynamicObject(1).get("number");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
                return;
            }
        }
    }

    public static void beforeF7SelectMaterialGroupFrom(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        List filters = showParameter.getListFilterParameter().getQFilters();
        filters.add(ReportCommonFilterOrChangeOp.getMaterialGroupByStandard(showParameter, orgLogo, orgIsMust, view));
    }

    @Deprecated
    public static void beforeF7SelectMaterialGroupFrom(ListShowParameter showParameter, IFormView view) {
        List filters = showParameter.getListFilterParameter().getQFilters();
        filters.add(ReportCommonFilterOrChangeOp.getMaterialGroupByStandard(showParameter, null, false, view));
    }

    public static void beforeF7SelectAccountOwnerFrom(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        DynamicObjectCollection orgList;
        ArrayList list = new ArrayList();
        Object orgLogObject = view.getModel().getValue(orgLogo);
        if (!orgIsMust && (orgLogObject == null || orgLogObject instanceof DynamicObjectCollection && ((DynamicObjectCollection)orgLogObject).size() == 0)) {
            String pkSet = (String)view.getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg");
            List createOrgIds = SerializationUtils.fromJsonStringToList((String)pkSet, Long.class);
            for (Long orgId : createOrgIds) {
                list.addAll(OwnerHelper.getOwners((Long)orgId));
                long defaultOwner = OwnerHelper.getDefaultOwner((Long)orgId);
                if (defaultOwner != 0L) {
                    list.add(defaultOwner);
                }
                list.add(OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE).get("id"));
            }
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)list));
            showParameter.setCustomParam("orgFuncId", (Object)"10");
            return;
        }
        if (orgLogObject instanceof DynamicObject) {
            long orgId = (Long)((DynamicObject)orgLogObject).getPkValue();
            list = OwnerHelper.getOwners((Long)orgId);
            long defaultOwner = OwnerHelper.getDefaultOwner((Long)orgId);
            if (defaultOwner != 0L) {
                list.add(defaultOwner);
            }
            list.add(OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE).get("id"));
            if (list.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5e93\u5b58\u7ec4\u7ec7\u6ca1\u6709\u76f8\u5173\u8054\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ReportCommonFilterOrChangeOp_1", (String)"scmc-im-report", (Object[])new Object[0]));
            }
        } else if (orgLogObject instanceof DynamicObjectCollection && (orgList = (DynamicObjectCollection)orgLogObject).size() == 1) {
            long orgId = ((DynamicObject)orgList.get(0)).getLong("fbasedataid_id");
            list.addAll(OwnerHelper.getOwners((Long)orgId));
            long defaultOwner = OwnerHelper.getDefaultOwner((Long)orgId);
            if (defaultOwner != 0L) {
                list.add(defaultOwner);
            }
            list.add(OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE).get("id"));
        }
        if (!list.isEmpty()) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)list));
        }
        showParameter.setCustomParam("orgFuncId", (Object)"10");
    }

    public static void beforeF7WarehouseFrom(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        Object org = view.getModel().getValue(orgLogo);
        if (!orgIsMust && (org == null || org instanceof DynamicObjectCollection && ((DynamicObjectCollection)org).size() == 0)) {
            return;
        }
        if (org instanceof DynamicObject) {
            Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(((DynamicObject)org).getPkValue().toString()));
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)allWhs));
            return;
        }
        if (org instanceof DynamicObjectCollection) {
            ArrayList<Object> listOrgId = new ArrayList<Object>();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                listOrgId.add(dynamicObject.get("fbasedataid_id"));
            }
            List allWhs = WarehouseHelper.getAllWarehouse(listOrgId);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)allWhs));
            return;
        }
    }

    public static void handleValueToNull(String key, IFormView view) {
        IDataModel model = view.getModel();
        switch (key) {
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": {
                model.setValue("ownerto", null);
                break;
            }
            case "accountkeeperfrom": 
            case "supplierkeeperfrom": 
            case "customerkeeperfrom": {
                model.setValue("keeperto", null);
                break;
            }
            case "materialgroupstandard": {
                model.setValue("materialgroupfrom", null);
                model.setValue("materialgroupto", null);
                model.setValue("materialnumberfrom", null);
                model.setValue("materialnumberto", null);
                break;
            }
            case "materialgroupfrom": {
                model.setValue("materialgroupto", null);
                model.setValue("materialnumberfrom", null);
                model.setValue("materialnumberto", null);
                break;
            }
            case "materialgroupto": {
                model.setValue("materialnumberfrom", null);
                model.setValue("materialnumberto", null);
                break;
            }
            case "materialnumberfrom": {
                DynamicObjectCollection materialNumberFrom = (DynamicObjectCollection)model.getValue("materialnumberfrom");
                model.setValue("materialnumberto", materialNumberFrom.size() == 1 ? ((DynamicObject)materialNumberFrom.get(0)).get("fbasedataid") : null);
                break;
            }
            case "warehousefrom": {
                model.setValue("warehouseto", null);
                model.setValue("locationfrom", null);
                model.setValue("locationto", null);
                break;
            }
            case "warehouseto": {
                model.setValue("locationfrom", null);
                model.setValue("locationto", null);
                break;
            }
            case "locationfrom": {
                model.setValue("locationto", null);
                break;
            }
            case "projectfrom": {
                model.setValue("projectto", null);
                break;
            }
            case "configuredcodefrom": {
                model.setValue("configuredcodeto", null);
                break;
            }
            case "tracknumberfrom": {
                model.setValue("tracknumberto", null);
                break;
            }
        }
    }

    public static void handleOwnerTypeHeadChangeEvent(String key, IFormView view) {
        String value = (String)view.getModel().getValue(key);
        if (StringUtils.isEmpty((String)value)) {
            view.setEnable(Boolean.FALSE, new String[]{"ownerto"});
            view.setEnable(Boolean.FALSE, new String[]{"supplierownerfrom"});
            view.setEnable(Boolean.FALSE, new String[]{"customerownerfrom"});
            view.setEnable(Boolean.FALSE, new String[]{"accountownerfrom"});
            view.setEnable(Boolean.FALSE, new String[]{"accountownerfrom"});
            view.setVisible(Boolean.TRUE, new String[]{"supplierownerfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"accountownerfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"customerownerfrom"});
            view.setVisible(Boolean.TRUE, new String[]{"ownerto"});
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"accountownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"supplierownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"customerownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"ownerto", null, (boolean)false);
            return;
        }
        view.setEnable(Boolean.TRUE, new String[]{"ownerto"});
        view.setVisible(Boolean.TRUE, new String[]{"ownerto"});
        if ("bos_org".equals(value)) {
            view.setEnable(Boolean.TRUE, new String[]{"accountownerfrom"});
            view.setVisible(Boolean.TRUE, new String[]{"accountownerfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"supplierownerfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"customerownerfrom"});
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"accountownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"supplierownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"customerownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"ownerto", null, (boolean)false);
        } else if ("bd_supplier".equals(value)) {
            view.setEnable(Boolean.TRUE, new String[]{"supplierownerfrom"});
            view.setVisible(Boolean.TRUE, new String[]{"supplierownerfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"accountownerfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"customerownerfrom"});
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"accountownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"supplierownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"customerownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"ownerto", null, (boolean)false);
        } else if ("bd_customer".equals(value)) {
            view.setEnable(Boolean.TRUE, new String[]{"customerownerfrom"});
            view.setVisible(Boolean.TRUE, new String[]{"customerownerfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"accountownerfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"supplierownerfrom"});
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"accountownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"supplierownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"customerownerfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"ownerto", null, (boolean)false);
        }
    }

    public static void handleKeeperTypeHeadChangeEvent(String key, IFormView view) {
        String value = (String)view.getModel().getValue(key);
        if (StringUtils.isEmpty((String)value)) {
            view.setEnable(Boolean.FALSE, new String[]{"keeperto"});
            view.setEnable(Boolean.FALSE, new String[]{"supplierkeeperfrom"});
            view.setEnable(Boolean.FALSE, new String[]{"customerkeeperfrom"});
            view.setEnable(Boolean.FALSE, new String[]{"accountkeeperfrom"});
            view.setEnable(Boolean.FALSE, new String[]{"accountkeeperfrom"});
            view.setVisible(Boolean.TRUE, new String[]{"supplierkeeperfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"accountkeeperfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"customerkeeperfrom"});
            view.setVisible(Boolean.TRUE, new String[]{"keeperto"});
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"accountkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"supplierkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"customerkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"keeperto", null, (boolean)false);
            return;
        }
        view.setEnable(Boolean.TRUE, new String[]{"keeperto"});
        view.setVisible(Boolean.TRUE, new String[]{"keeperto"});
        if ("bos_org".equals(value)) {
            view.setEnable(Boolean.TRUE, new String[]{"accountkeeperfrom"});
            view.setVisible(Boolean.TRUE, new String[]{"accountkeeperfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"supplierkeeperfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"customerkeeperfrom"});
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"accountkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"supplierkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"customerkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"keeperto", null, (boolean)false);
        } else if ("bd_supplier".equals(value)) {
            view.setEnable(Boolean.TRUE, new String[]{"supplierkeeperfrom"});
            view.setVisible(Boolean.TRUE, new String[]{"supplierkeeperfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"accountkeeperfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"customerkeeperfrom"});
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"accountkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"supplierkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"customerkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"keeperto", null, (boolean)false);
        } else if ("bd_customer".equals(value)) {
            view.setEnable(Boolean.TRUE, new String[]{"customerkeeperfrom"});
            view.setVisible(Boolean.TRUE, new String[]{"customerkeeperfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"accountkeeperfrom"});
            view.setVisible(Boolean.FALSE, new String[]{"supplierkeeperfrom"});
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"accountkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"supplierkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"customerkeeperfrom", null, (boolean)false);
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"keeperto", null, (boolean)false);
        }
    }

    public static void handleMulBasedataChangeEvent(String key, IFormView view) {
        String controlledControl = null;
        switch (key) {
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": {
                controlledControl = "ownerto";
                break;
            }
            case "accountkeeperfrom": 
            case "supplierkeeperfrom": 
            case "customerkeeperfrom": {
                controlledControl = "keeperto";
                break;
            }
            case "materialgroupfrom": {
                controlledControl = "materialgroupto";
                break;
            }
            case "warehousefrom": {
                controlledControl = "warehouseto";
                break;
            }
            case "locationfrom": {
                controlledControl = "locationto";
                break;
            }
            case "projectfrom": {
                controlledControl = "projectto";
                break;
            }
            case "materialnumberfrom": {
                controlledControl = "materialnumberto";
                break;
            }
            case "configuredcodefrom": {
                controlledControl = "configuredcodeto";
                break;
            }
            case "tracknumberfrom": {
                controlledControl = "tracknumberto";
                break;
            }
        }
        if (((DynamicObjectCollection)view.getModel().getValue(key)).size() > 1) {
            view.setEnable(Boolean.FALSE, new String[]{controlledControl});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{controlledControl});
        }
        ReportCommonFilterOrChangeOp.handleValueToNull(key, view);
    }

    public static void beforeF7SelectOrg(ListShowParameter showParameter, IFormView view) {
        String pkSet = (String)view.getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg");
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
        showParameter.setCustomParam("orgFuncId", (Object)"05");
    }

    public static void beforeF7ShowParameterByOrg(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        ReportCommonFilterOrChangeOp.setShowParameterByOry(showParameter, orgLogo, orgIsMust, view);
    }

    private static void setShowParameterByOry(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        List<Long> orgIds = ReportCommonFilterOrChangeOp.getOrgIds(orgLogo, view);
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        if (orgIds.size() > 0) {
            params.put("useOrgs", orgIds);
            showParameter.setCustomParams(params);
        } else {
            params.put("isShowAllNoOrg", "true");
            showParameter.setCustomParams(params);
        }
    }

    public static void beforeF7SelectByEnable(ListShowParameter showParameter) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        showParameter.getListFilterParameter().setFilter(filter);
    }

    public static QFilter getOnwerQfilter(FilterInfo filterInfo) {
        QFilter baseQfilter = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection accountOrgs = filterInfo.getDynamicObjectCollection("accountownerfrom");
        DynamicObjectCollection supplierorgs = filterInfo.getDynamicObjectCollection("supplierownerfrom");
        DynamicObjectCollection customerorgs = filterInfo.getDynamicObjectCollection("customerownerfrom");
        DynamicObject to = filterInfo.getDynamicObject("ownerto");
        if (accountOrgs != null && accountOrgs.size() > 0) {
            if (accountOrgs.size() > 1) {
                HashSet<String> numbers = new HashSet<String>();
                for (DynamicObject accountOrg : accountOrgs) {
                    numbers.add(accountOrg.getString("number"));
                }
                baseQfilter.and("orgnumber", "in", numbers);
            } else {
                baseQfilter.and("orgnumber", ">=", ((DynamicObject)accountOrgs.get(0)).get("number"));
                if (to != null) {
                    baseQfilter.and("orgnumber", "<=", to.get("number"));
                }
            }
            return baseQfilter;
        }
        if (supplierorgs != null && supplierorgs.size() > 0) {
            if (supplierorgs.size() > 1) {
                HashSet<String> numbers = new HashSet<String>();
                for (DynamicObject supplierOrg : supplierorgs) {
                    numbers.add(supplierOrg.getString("number"));
                }
                baseQfilter.and("suppliernumber", "in", numbers);
            } else {
                baseQfilter.and("suppliernumber", ">=", ((DynamicObject)supplierorgs.get(0)).get("number"));
                if (to != null) {
                    baseQfilter.and("suppliernumber", "<=", to.get("number"));
                }
            }
            return baseQfilter;
        }
        if (customerorgs != null && customerorgs.size() > 0) {
            if (customerorgs.size() > 1) {
                HashSet<String> numbers = new HashSet<String>();
                for (DynamicObject customerOrg : customerorgs) {
                    numbers.add(customerOrg.getString("number"));
                }
                baseQfilter.and("customernumber", "in", numbers);
            } else {
                baseQfilter.and("customernumber", ">=", ((DynamicObject)customerorgs.get(0)).get("number"));
                if (to != null) {
                    baseQfilter.and("customernumber", "<=", to.get("number"));
                }
            }
            return baseQfilter;
        }
        if (to != null) {
            switch (to.getDataEntityType().getName()) {
                case "bos_org": {
                    baseQfilter.and("orgnumber", "<=", to.get("number"));
                    break;
                }
                case "bd_supplier": {
                    baseQfilter.and("suppliernumber", "<=", to.get("number"));
                    break;
                }
                case "bd_customer": {
                    baseQfilter.and("customernumber", "<=", to.get("number"));
                    break;
                }
            }
            return baseQfilter;
        }
        return null;
    }

    public static QFilter getKeeperQfilter(FilterInfo filterInfo) {
        QFilter baseQfilter = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection accountOrgs = filterInfo.getDynamicObjectCollection("accountkeeperfrom");
        DynamicObjectCollection supplierorgs = filterInfo.getDynamicObjectCollection("supplierkeeperfrom");
        DynamicObjectCollection customerorgs = filterInfo.getDynamicObjectCollection("customerkeeperfrom");
        DynamicObject to = filterInfo.getDynamicObject("keeperto");
        if (accountOrgs != null && accountOrgs.size() > 0) {
            if (accountOrgs.size() > 1) {
                HashSet<String> numbers = new HashSet<String>();
                for (DynamicObject accountOrg : accountOrgs) {
                    numbers.add(accountOrg.getString("number"));
                }
                baseQfilter.and("orgnumber", "in", numbers);
            } else {
                baseQfilter.and("orgnumber", ">=", ((DynamicObject)accountOrgs.get(0)).get("number"));
                if (to != null) {
                    baseQfilter.and("orgnumber", "<=", to.get("number"));
                }
            }
            return baseQfilter;
        }
        if (supplierorgs != null && supplierorgs.size() > 0) {
            if (supplierorgs.size() > 1) {
                HashSet<String> numbers = new HashSet<String>();
                for (DynamicObject supplierOrg : supplierorgs) {
                    numbers.add(supplierOrg.getString("number"));
                }
                baseQfilter.and("suppliernumber", "in", numbers);
            } else {
                baseQfilter.and("suppliernumber", ">=", ((DynamicObject)supplierorgs.get(0)).get("number"));
                if (to != null) {
                    baseQfilter.and("suppliernumber", "<=", to.get("number"));
                }
            }
            return baseQfilter;
        }
        if (customerorgs != null && customerorgs.size() > 0) {
            if (customerorgs.size() > 1) {
                HashSet<String> numbers = new HashSet<String>();
                for (DynamicObject customerOrg : customerorgs) {
                    numbers.add(customerOrg.getString("number"));
                }
                baseQfilter.and("customernumber", "in", numbers);
            } else {
                baseQfilter.and("customernumber", ">=", ((DynamicObject)customerorgs.get(0)).get("number"));
                if (to != null) {
                    baseQfilter.and("customernumber", "<=", to.get("number"));
                }
            }
            return baseQfilter;
        }
        if (to != null) {
            switch (to.getDataEntityType().getName()) {
                case "bos_org": {
                    baseQfilter.and("orgnumber", "<=", to.get("number"));
                    break;
                }
                case "bd_supplier": {
                    baseQfilter.and("suppliernumber", "<=", to.get("number"));
                    break;
                }
                case "bd_customer": {
                    baseQfilter.and("customernumber", "<=", to.get("number"));
                    break;
                }
            }
            return baseQfilter;
        }
        return null;
    }

    public static void handleOrgChangeEvent(DynamicObject newValue, Object oldValue, IFormView view) {
        if (newValue == null) {
            view.getModel().setValue("orghead", oldValue);
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"ReportCommonFilterOrChangeOp_2", (String)"scmc-im-report", (Object[])new Object[0]));
            return;
        }
        view.getModel().beginInit();
        view.getModel().createNewData();
        view.getModel().setValue("orghead", newValue.getPkValue());
        view.getModel().endInit();
        view.updateView();
    }

    public static QFilter getDynamicObjectFromToFilter(FilterInfo filterInfo, String queryFiled, String fromKey, String toKey) {
        DynamicObject to;
        QFilter bfilter = null;
        DynamicObjectCollection froms = filterInfo.getDynamicObjectCollection(fromKey);
        if (froms != null && froms.size() != 0) {
            if (froms.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : froms) {
                    idSet.add(from.get("number"));
                }
                return new QFilter(queryFiled, "in", idSet);
            }
            DynamicObject from = (DynamicObject)froms.get(0);
            bfilter = new QFilter(queryFiled, ">=", from.get("number"));
        }
        if ((to = filterInfo.getDynamicObject(toKey)) != null) {
            QFilter toFilter = new QFilter(queryFiled, "<=", to.get("number"));
            bfilter = bfilter != null ? bfilter.and(toFilter) : toFilter;
        }
        return bfilter;
    }

    public static QFilter getMaterialFromToFilter(FilterInfo filterInfo, String materialKey, boolean isMaterialNumber) {
        Object materialfrom = filterInfo.getValue("materialnumberfrom");
        String materialNumber = "masterid.number";
        String numField = "number";
        QFilter materialFilter = null;
        if (isMaterialNumber) {
            materialNumber = "number";
        }
        if (materialfrom instanceof DynamicObject) {
            DynamicObject from = (DynamicObject)materialfrom;
            DynamicObject to = filterInfo.getDynamicObject("materialnumberto");
            materialFilter = new QFilter(numField, ">=", from.get(materialNumber));
            if (to != null) {
                QFilter tofilter = new QFilter(numField, "<=", to.get(materialNumber));
                materialFilter = materialFilter.and(tofilter);
            }
        } else if (materialfrom instanceof DynamicObjectCollection) {
            DynamicObjectCollection froms = (DynamicObjectCollection)materialfrom;
            if (froms == null || froms.size() == 0) {
                return null;
            }
            if (froms.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : froms) {
                    idSet.add(from.get(materialNumber));
                }
                materialFilter = new QFilter(numField, "in", idSet);
            } else {
                DynamicObject from = (DynamicObject)froms.get(0);
                DynamicObject to = filterInfo.getDynamicObject("materialnumberto");
                materialFilter = new QFilter(numField, ">=", from.get(materialNumber));
                if (to != null) {
                    materialFilter = materialFilter.and(numField, "<=", to.get(materialNumber));
                }
            }
        } else {
            DynamicObject to = filterInfo.getDynamicObject("materialnumberto");
            if (to != null) {
                materialFilter = new QFilter(numField, "<=", to.get(materialNumber));
            }
        }
        if (materialFilter == null) {
            return null;
        }
        Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id", (QFilter[])materialFilter.toArray());
        return new QFilter(materialKey, "in", materials.keySet());
    }

    public static QFilter getTextFromToFilter(FilterInfo filterInfo, String queryFiled, String fromKey, String toKey) {
        String from = filterInfo.getString(fromKey);
        String to = filterInfo.getString(toKey);
        if (from != null && from.replaceAll(" ", "").length() != from.length()) {
            String[] froms = from.split("\\s+");
            return new QFilter(queryFiled, "in", (Object)froms);
        }
        if (from != null && from.replaceAll(",", "").length() != from.length()) {
            String[] froms = from.split(",");
            return new QFilter(queryFiled, "in", (Object)froms);
        }
        QFilter filter = null;
        if (from != null && !from.trim().equals("")) {
            filter = new QFilter(queryFiled, ">=", (Object)from.trim());
        }
        if (to != null && !to.trim().equals("")) {
            QFilter toFilter = new QFilter(queryFiled, "<=", (Object)to.trim());
            if (filter == null) {
                filter = toFilter;
            } else {
                filter.and(toFilter);
            }
        }
        return filter;
    }

    public static void initOrg(IReportView view, String orgLogo) {
        List orgList;
        long orgId = RequestContext.get().getOrgId();
        String pkSet = (String)view.getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg");
        if (StringUtils.isNotEmpty((String)pkSet) && !CommonUtils.isNull((Object)(orgList = (List)SerializationUtils.fromJsonString((String)pkSet, ArrayList.class)))) {
            boolean isExist = false;
            for (int i = 0; i < orgList.size(); ++i) {
                if (orgId != Long.parseLong(orgList.get(i).toString())) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                view.getModel().setValue(orgLogo, orgList.get(0));
                return;
            }
        }
        view.getModel().setValue(orgLogo, (Object)orgId);
    }

    public static DataSet filterOwner(FilterInfo filterInfo, DataSet dataSet) {
        String ownerType = filterInfo.getString("ownertypehead");
        if (ownerType == null || ownerType.isEmpty()) {
            return dataSet;
        }
        dataSet = dataSet.filter("ownertype = '" + ownerType + "'");
        QFilter filter = ReportCommonFilterOrChangeOp.getOnwerQfilter(filterInfo);
        if (filter == null) {
            return dataSet;
        }
        Set<String> fs = ReportGeneralOpHelper.getDataSetField(dataSet);
        if (!fs.contains("owner") || !fs.contains("ownertype")) {
            return dataSet;
        }
        String[] sfields = fs.toArray(new String[fs.size()]);
        QFilter[] ownerCommonQfilter = new QFilter("1", "=", (Object)1).toArray();
        DataSet bosorg = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_org", (String)"id, number as orgnumber, 'bos_org' as ownertype", (QFilter[])ownerCommonQfilter, (String)"");
        DataSet supplier = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_supplier", (String)"id, number as suppliernumber, 'bd_supplier' as ownertype", (QFilter[])ownerCommonQfilter, (String)"");
        DataSet customer = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_customer", (String)"id, number as customernumber, 'bd_customer' as ownertype", (QFilter[])ownerCommonQfilter, (String)"");
        dataSet = dataSet.leftJoin(bosorg).on("ownertype", "ownertype").on("owner", "id").select(sfields, new String[]{"orgnumber"}).finish().leftJoin(supplier).on("ownertype", "ownertype").on("owner", "id").select(ReportGeneralOpHelper.addFileds(sfields, "orgnumber"), new String[]{"suppliernumber"}).finish().leftJoin(customer).on("ownertype", "ownertype").on("owner", "id").select(ReportGeneralOpHelper.addFileds(sfields, "orgnumber", "suppliernumber"), new String[]{"customernumber"}).finish();
        dataSet = dataSet.filter(filter.toString());
        dataSet = dataSet.removeFields(new String[]{"orgnumber", "suppliernumber", "customernumber"});
        return dataSet;
    }

    public static DataSet filterKeeper(FilterInfo filterInfo, DataSet dataSet) {
        String keeperType = filterInfo.getString("keepertypehead");
        if (keeperType == null || keeperType.isEmpty()) {
            return dataSet;
        }
        dataSet = dataSet.filter("keepertype = '" + keeperType + "'");
        QFilter filter = ReportCommonFilterOrChangeOp.getKeeperQfilter(filterInfo);
        if (filter == null) {
            return dataSet;
        }
        Set<String> fs = ReportGeneralOpHelper.getDataSetField(dataSet);
        if (!fs.contains("keeper") || !fs.contains("keepertype")) {
            return dataSet;
        }
        String[] sfields = fs.toArray(new String[fs.size()]);
        QFilter[] keeperCommonQfilter = new QFilter("1", "=", (Object)1).toArray();
        DataSet bosorg = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_org", (String)"id, number as orgnumber, 'bos_org' as keepertype", (QFilter[])keeperCommonQfilter, (String)"");
        DataSet supplier = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_supplier", (String)"id, number as suppliernumber, 'bd_supplier' as keepertype", (QFilter[])keeperCommonQfilter, (String)"");
        DataSet customer = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_customer", (String)"id, number as customernumber, 'bd_customer' as keepertype", (QFilter[])keeperCommonQfilter, (String)"");
        dataSet = dataSet.leftJoin(bosorg).on("keepertype", "keepertype").on("keeper", "id").select(sfields, new String[]{"orgnumber"}).finish().leftJoin(supplier).on("keepertype", "keepertype").on("keeper", "id").select(ReportGeneralOpHelper.addFileds(sfields, "orgnumber"), new String[]{"suppliernumber"}).finish().leftJoin(customer).on("keepertype", "keepertype").on("keeper", "id").select(ReportGeneralOpHelper.addFileds(sfields, "orgnumber", "suppliernumber"), new String[]{"customernumber"}).finish();
        dataSet = dataSet.filter(filter.toString());
        dataSet = dataSet.removeFields(new String[]{"orgnumber", "suppliernumber", "customernumber"});
        return dataSet;
    }

    @Deprecated
    public static void doBillPermission(ReportShowParameter showParameter, String formid) {
        List permissionOrgs = NewInvOrgHelper.getPermissionOrgsByAppId((String)formid, (String)showParameter.getAppId());
        if (permissionOrgs == null || permissionOrgs.isEmpty()) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_USE_INVORG()));
        }
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formid, (String)showParameter.getAppId());
        if (orgIdList == null || orgIdList.length == 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ENABLED_INV()));
        }
        showParameter.getCustomParams().put("HasPermissionAndStartedInvOrg", SerializationUtils.toJsonString((Object)orgIdList));
    }

    public static Map<Boolean, String> checkBillPermission(ReportShowParameter showParameter, String formid) {
        HashMap<Boolean, String> result = new HashMap<Boolean, String>(8);
        result.put(Boolean.TRUE, "");
        List permissionOrgs = NewInvOrgHelper.getPermissionOrgsByAppId((String)formid, (String)showParameter.getAppId());
        if (permissionOrgs == null || permissionOrgs.isEmpty()) {
            result.put(Boolean.FALSE, CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_USE_INVORG()));
            return result;
        }
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formid, (String)showParameter.getAppId());
        if (orgIdList == null || orgIdList.length == 0) {
            result.put(Boolean.FALSE, CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ENABLED_INV()));
            return result;
        }
        showParameter.getCustomParams().put("HasPermissionAndStartedInvOrg", SerializationUtils.toJsonString((Object)orgIdList));
        return result;
    }

    public static void initMultiOrg(IReportView view, String orgLogo) {
        List orgList;
        long orgId = RequestContext.get().getOrgId();
        String pkSet = (String)view.getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg");
        if (!CommonUtils.isNull((Object)pkSet) && !CommonUtils.isNull((Object)(orgList = (List)SerializationUtils.fromJsonString((String)pkSet, ArrayList.class)))) {
            boolean isExist = false;
            for (int i = 0; i < orgList.size(); ++i) {
                if (orgId != Long.parseLong(orgList.get(i).toString())) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                view.getModel().setValue(orgLogo, (Object)new Object[]{orgList.get(0)});
                return;
            }
        }
        view.getModel().setValue(orgLogo, (Object)new Object[]{orgId});
    }

    public static void handleBillNoChangeEvent(Object newValue, String key, IFormView view) {
        DataChangeHelper.setValue((IDataModel)view.getModel(), (String)key, (Object)((String)newValue).trim(), (boolean)false);
    }

    public static void handlelotnumbertoChangeEvent(Object newValue, Object oldValue, IFormView view) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"lotnumberto", null, (boolean)false);
        } else {
            String[] lotNumberToValueStrs = ((String)newValue).trim().replace("\uff0c", ",").split(",");
            if (lotNumberToValueStrs.length > 1) {
                DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"lotnumberto", (Object)oldValue, (boolean)false);
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u6279\u53f7\u81f3\u201d\u4e0d\u80fd\u586b\u5165\u591a\u4e2a\u4ee5\u9017\u53f7\u5206\u5f00\u7684\u503c\u3002", (String)"ReportCommonFilterOrChangeOp_4", (String)"scmc-im-report", (Object[])new Object[0]));
            } else {
                DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"lotnumberto", (Object)((String)newValue).trim(), (boolean)false);
            }
        }
    }

    public static void handlelotnumberfromChangeEvent(Object newValue, IFormView view) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"lotnumberto", null, (boolean)false);
            view.setEnable(Boolean.TRUE, new String[]{"lotnumberto"});
        } else {
            String updateNewValue = ((String)newValue).trim();
            String[] froms = (updateNewValue = updateNewValue.replaceAll("\uff0c", ",")).split(",");
            if (froms.length > 1) {
                view.setEnable(Boolean.FALSE, new String[]{"lotnumberto"});
                DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"lotnumberto", null, (boolean)false);
                StringBuilder result = new StringBuilder();
                for (int i = 0; i <= froms.length - 1; ++i) {
                    result.append(froms[i].trim());
                    result.append(',');
                }
                DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"lotnumberfrom", (Object)result.toString(), (boolean)false);
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"lotnumberto"});
                DataChangeHelper.setValue((IDataModel)view.getModel(), (String)"lotnumberfrom", (Object)updateNewValue, (boolean)false);
            }
        }
    }

    public static DataSet getClassifiedMaterialDataSet(FilterInfo filterInfo, boolean isMaterialNumber) {
        QFilter materialTypeFilter;
        Object pkValue = null;
        DynamicObject materialgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        pkValue = materialgroupstandard == null ? AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID : materialgroupstandard.getPkValue();
        QFilter materialAndGroupFilter = new QFilter("standard", "=", pkValue);
        QFilter materialGroupNumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "group.number", "materialgroupfrom", "materialgroupto");
        if (materialGroupNumberFilter != null) {
            materialAndGroupFilter = materialAndGroupFilter.and(materialGroupNumberFilter);
        } else if (AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID.equals(pkValue)) {
            QFilter materialTypeFilter2;
            materialAndGroupFilter = new QFilter("group.standard", "=", pkValue);
            QFilter materialNumberFilter = ReportCommonFilterOrChangeOp.getMaterialFromToFilter(filterInfo, "id", isMaterialNumber);
            if (materialNumberFilter != null) {
                materialAndGroupFilter = materialAndGroupFilter.and(materialNumberFilter);
            }
            if ((materialTypeFilter2 = ReportCommonFilterOrChangeOp.handleMaterialTypeQfilter(filterInfo, "materialtype")) != null) {
                materialAndGroupFilter = materialAndGroupFilter.and(materialTypeFilter2);
            }
            DataSet classifiedMaterial = QueryServiceHelper.queryDataSet((String)"bd_material", (String)"bd_material", (String)"group,group.number as groupnumber,group.name as groupname,id as material,number as materialnumber,materialtype as materialtype,name as materialname1,modelnum as modelnum1", (QFilter[])materialAndGroupFilter.toArray(), null);
            return classifiedMaterial;
        }
        QFilter materialNumberFilter = ReportCommonFilterOrChangeOp.getMaterialFromToFilter(filterInfo, "material", isMaterialNumber);
        if (materialNumberFilter != null) {
            materialAndGroupFilter = materialAndGroupFilter.and(materialNumberFilter);
        }
        if ((materialTypeFilter = ReportCommonFilterOrChangeOp.handleMaterialTypeQfilter(filterInfo, "material.materialtype")) != null) {
            materialAndGroupFilter = materialAndGroupFilter.and(materialTypeFilter);
        }
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"group,group.number as groupnumber,group.name as groupname,material,material.number as materialnumber,material.materialtype as materialtype,material.name as materialname1,material.modelnum as modelnum1", (QFilter[])materialAndGroupFilter.toArray(), null);
        return classifiedMaterialDataSet;
    }

    public static DataSet filterBaseStandardMateril(FilterInfo filterInfo, DataSet billSet) {
        QFilter materialTypeFilter;
        QFilter materialNumberFilter;
        QFilter materialAndGroupFilter = new QFilter("1", "=", (Object)"1");
        QFilter materialGroupNumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "groupNumber", "materialgroupfrom", "materialgroupto");
        if (materialGroupNumberFilter != null) {
            materialAndGroupFilter = materialAndGroupFilter.and(materialGroupNumberFilter);
        }
        if ((materialNumberFilter = ReportCommonFilterOrChangeOp.getMaterialFromToFilter(filterInfo, "material", true)) != null) {
            materialAndGroupFilter = materialAndGroupFilter.and(materialNumberFilter);
        }
        if ((materialTypeFilter = ReportCommonFilterOrChangeOp.handleMaterialTypeQfilter(filterInfo, "material.materialtype")) != null) {
            materialAndGroupFilter = materialAndGroupFilter.and(materialTypeFilter);
        }
        return billSet.filter(materialAndGroupFilter.toSerializedString());
    }

    @Deprecated
    public static void addBeforeF7ControlUnitFilter(ListShowParameter showParameter, String key, String orgLogo, boolean orgIsMust, IFormView view) {
    }

    public static void formatDisplayFilterField(FormatShowFilterEvent e) {
        String formatedFilterString = e.getFormatedFilterString();
        if (StringUtils.isEmpty((String)formatedFilterString)) {
            return;
        }
        String[] formatedSplit = formatedFilterString.split(";  ");
        StringBuilder sb = new StringBuilder();
        for (String formated : formatedSplit) {
            String groupFormatedKey = formated.split("\uff1a")[0];
            String[] groupFormatedValue = formated.split("\uff1a")[1].split(";");
            if (groupFormatedValue.length > 20) {
                String[] newGroupFormated = new String[20];
                System.arraycopy(groupFormatedValue, 0, newGroupFormated, 0, 20);
                sb.append(groupFormatedKey);
                sb.append('\uff1a');
                for (int m = 0; m < newGroupFormated.length; ++m) {
                    sb.append(newGroupFormated[m]);
                    sb.append(';');
                }
                sb.append("......");
                continue;
            }
            sb.append(formated);
            sb.append(';');
        }
        e.setFormatedFilterString(sb.toString());
    }

    private static QFilter handleMaterialTypeQfilter(FilterInfo filterInfo, String property) {
        String materialtypehead = filterInfo.getString("materialtypehead");
        if (materialtypehead == null) {
            return null;
        }
        if (!materialtypehead.contains(",")) {
            return new QFilter(property, "in", (Object)materialtypehead);
        }
        String changeMaterialType = materialtypehead.substring(materialtypehead.indexOf(44) + 1, materialtypehead.lastIndexOf(44));
        if (changeMaterialType.isEmpty()) {
            return null;
        }
        String[] materialTypeValueArray = changeMaterialType.split(",");
        return new QFilter(property, "in", (Object)materialTypeValueArray);
    }

    private static void handleOwnerToBeforeF7Select(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        Object selectedNumberValue = null;
        String ownerTypeHeadValue = (String)view.getModel().getValue("ownertypehead");
        if ("bos_org".equals(ownerTypeHeadValue)) {
            if (((DynamicObjectCollection)view.getModel().getValue("accountownerfrom")).size() != 0) {
                selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("accountownerfrom")).get(0)).getDynamicObject(1).get("number");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
            }
            ReportCommonFilterOrChangeOp.beforeF7SelectAccountOwnerFrom(showParameter, orgLogo, orgIsMust, view);
            return;
        }
        if ("bd_supplier".equals(ownerTypeHeadValue)) {
            ReportCommonFilterOrChangeOp.setShowParameterByOry(showParameter, orgLogo, orgIsMust, view);
            if (((DynamicObjectCollection)view.getModel().getValue("supplierownerfrom")).size() == 0) {
                return;
            }
            selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("supplierownerfrom")).get(0)).getDynamicObject(1).get("number");
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
            return;
        }
        if ("bd_customer".equals(ownerTypeHeadValue)) {
            ReportCommonFilterOrChangeOp.setShowParameterByOry(showParameter, orgLogo, orgIsMust, view);
            if (((DynamicObjectCollection)view.getModel().getValue("customerownerfrom")).size() == 0) {
                return;
            }
            selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("customerownerfrom")).get(0)).getDynamicObject(1).get("number");
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
            return;
        }
    }

    private static void handleKeeperToBeforeF7Select(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        Object selectedNumberValue = null;
        String keeperTypeHeadValue = (String)view.getModel().getValue("keepertypehead");
        if ("bos_org".equals(keeperTypeHeadValue)) {
            ReportCommonFilterOrChangeOp.beforeF7SelectOrg(showParameter, view);
            return;
        }
        if ("bd_supplier".equals(keeperTypeHeadValue)) {
            ReportCommonFilterOrChangeOp.setShowParameterByOry(showParameter, orgLogo, orgIsMust, view);
            if (((DynamicObjectCollection)view.getModel().getValue("supplierkeeperfrom")).size() == 0) {
                return;
            }
            selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("supplierkeeperfrom")).get(0)).getDynamicObject(1).get("number");
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
            return;
        }
        if ("bd_customer".equals(keeperTypeHeadValue)) {
            ReportCommonFilterOrChangeOp.setShowParameterByOry(showParameter, orgLogo, orgIsMust, view);
            if (((DynamicObjectCollection)view.getModel().getValue("customerkeeperfrom")).size() == 0) {
                return;
            }
            selectedNumberValue = ((DynamicObject)((DynamicObjectCollection)view.getModel().getValue("customerkeeperfrom")).get(0)).getDynamicObject(1).get("number");
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("number", ">=", selectedNumberValue));
            return;
        }
    }

    private static QFilter getMaterialByStandard(String key, IFormView view) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        DynamicObject materialgroupstandard = (DynamicObject)view.getModel().getValue("materialgroupstandard");
        if (materialgroupstandard == null || materialgroupstandard.getBoolean("ispreset") && AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID.equals(materialgroupstandard.getPkValue())) {
            return qFilter;
        }
        Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (String)"material", (QFilter[])new QFilter("standard", "=", materialgroupstandard.getPkValue()).toArray());
        HashSet<Object> sets = new HashSet<Object>(dynamicObjects.size());
        for (Map.Entry entry : dynamicObjects.entrySet()) {
            sets.add(((DynamicObject)entry.getValue()).get("material.id"));
        }
        qFilter.and(key, "in", sets);
        return qFilter;
    }

    private static QFilter getMaterialGroupByStandard(ListShowParameter showParameter, String orgLogo, boolean orgIsMust, IFormView view) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        DynamicObject materialgroupstandard = (DynamicObject)view.getModel().getValue("materialgroupstandard");
        if (materialgroupstandard == null) {
            materialgroupstandard = BusinessDataServiceHelper.loadSingle((Object)AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID, (String)"bd_materialgroupstandard", (String)"");
        }
        List<Long> orgIds = ReportCommonFilterOrChangeOp.getOrgIds(orgLogo, view);
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        if (orgIds.size() > 0) {
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, materialgroupstandard.getPkValue(), true});
            qFilter.and(serviceResponse);
            params.put("useOrgs", orgIds);
            showParameter.setCustomParams(params);
        } else {
            params.put("isShowAllNoOrg", "true");
            showParameter.setCustomParams(params);
            qFilter.and("standard", "=", materialgroupstandard.getPkValue());
            qFilter.and("enable", "=", (Object)"1");
        }
        qFilter.and("status", "=", (Object)"C");
        showParameter.setCustomParam("groupStandard", materialgroupstandard.getPkValue());
        return qFilter;
    }

    private static List<Long> getOrgIds(String orgLogo, IFormView view) {
        Object org = view.getModel().getValue(orgLogo);
        ArrayList<Long> orgIds = new ArrayList<Long>(20);
        if (org instanceof DynamicObject) {
            Long orgId = Long.valueOf(String.valueOf(((DynamicObject)org).getPkValue()));
            orgIds.add(orgId);
        } else if (org instanceof DynamicObjectCollection) {
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                Long orgId = Long.valueOf(String.valueOf(dynamicObject.getLong("fbasedataid_id")));
                orgIds.add(orgId);
            }
        }
        return orgIds;
    }
}

