/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.helper;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.common.ReportCommonFiltersConsts;
import kd.scmc.im.report.common.ValidateMsgEntity;

public class AnalyseRptOpHelper {
    public static void handlePreOpenForm(PreOpenFormEventArgs e) {
        String formid;
        ReportShowParameter showParameter = (ReportShowParameter)e.getSource();
        Map<Boolean, String> hasPermission = ReportCommonFilterOrChangeOp.checkBillPermission(showParameter, formid = showParameter.getFormId());
        if (hasPermission.containsKey(Boolean.FALSE)) {
            e.setCancel(Boolean.TRUE.booleanValue());
            e.setCancelMessage(hasPermission.get(Boolean.FALSE));
        }
    }

    public static Date getDate(Date date) {
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = dateFormate.format(date);
        Date targetDate = null;
        try {
            targetDate = dateFormate.parse(dateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
        return targetDate;
    }

    public static Set<String> getDataSetFields(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        LinkedHashSet<String> fs = new LinkedHashSet<String>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getName();
            fs.add(fieldName);
        }
        return fs;
    }

    public static String[] getDataSetFieldStrs(DataSet dataSet) {
        return AnalyseRptOpHelper.collectionToStrArr(AnalyseRptOpHelper.getDataSetFields(dataSet));
    }

    public static String[] getDataSetFieldStrs(DataSet dataSet, String ... newFields) {
        String[] dataSetFields = AnalyseRptOpHelper.getDataSetFieldStrs(dataSet);
        return AnalyseRptOpHelper.addNewValsToSrcArr(dataSetFields, newFields);
    }

    public static String[] addNewValsToSrcArr(String[] srcArr, String ... newVal) {
        int newECount = newVal.length;
        int srcArrsLen = srcArr.length;
        int newArrsLen = newECount + srcArrsLen;
        String[] newArr = new String[newArrsLen];
        System.arraycopy(srcArr, 0, newArr, 0, srcArrsLen);
        System.arraycopy(newVal, 0, newArr, srcArrsLen, newECount);
        return newArr;
    }

    public static String[] removeValsFromSrcArr(String[] srcArr, String ... removes) {
        if (removes == null || removes.length == 0) {
            return srcArr;
        }
        for (String remove : removes) {
            srcArr = AnalyseRptOpHelper.removeValsFromSrcArr(srcArr, remove);
        }
        return srcArr;
    }

    public static String[] removeValsFromSrcArr(String[] srcArr, String removeVal) {
        int index = AnalyseRptOpHelper.indexOf(srcArr, removeVal);
        if (index != -1) {
            int srcArrsLen = srcArr.length;
            int newArrsLen = srcArrsLen - 1;
            String[] newArr = new String[newArrsLen];
            System.arraycopy(srcArr, 0, newArr, 0, index);
            System.arraycopy(srcArr, index + 1, newArr, index, srcArrsLen - index - 1);
            return newArr;
        }
        return srcArr;
    }

    public static int indexOf(String[] srcArr, String input) {
        for (int i = 0; i < srcArr.length; ++i) {
            if (!srcArr[i].equals(input)) continue;
            return i;
        }
        return -1;
    }

    public static String[] collectionToStrArr(Collection<String> collection) {
        return AnalyseRptOpHelper.collectionToTypeArr(collection);
    }

    public static <T> T[] collectionToTypeArr(Collection<T> collection) {
        return collection.toArray((Object[])Array.newInstance(collection.iterator().next().getClass(), collection.size()));
    }

    public static <T> List<T> strArrToList(T[] tArr) {
        return Arrays.asList(tArr);
    }

    public static <T> String listToString(List<T> list) {
        return AnalyseRptOpHelper.collectionToStr(list);
    }

    public static <T> String collectionToStr(Collection<T> collection) {
        StringBuilder sbf = new StringBuilder();
        int size = collection.size();
        int index = 0;
        for (T t : collection) {
            sbf.append(t);
            if (index++ >= size - 1) continue;
            sbf.append(',');
        }
        return sbf.toString();
    }

    public static <T> String arrayToStr(T[] arr) {
        List<T> asList = Arrays.asList(arr);
        return AnalyseRptOpHelper.collectionToStr(asList);
    }

    public static <T> String collectionToSqlWhereInStr(Collection<T> collection) {
        StringBuilder sbf = new StringBuilder();
        int size = collection.size();
        if (size == 0) {
            sbf.append("('')");
        } else {
            int index = 0;
            sbf.append('(');
            for (T t : collection) {
                sbf.append('\'');
                sbf.append(t);
                sbf.append('\'');
                if (index++ >= size - 1) continue;
                sbf.append(',');
            }
            sbf.append(')');
        }
        return sbf.toString();
    }

    public static void verifyOrgMustInput(ValidateMsgEntity ckMsgEntity, DynamicObjectCollection orghead) {
        if (orghead == null || orghead.isEmpty()) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"AnalyseRptOpHelper_0", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    public static void verifyMGroupStandardMustInput(ValidateMsgEntity ckMsgEntity, DynamicObject mgroupstandard) {
        if (mgroupstandard == null) {
            ckMsgEntity.addErrorMsg(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u6807\u51c6\u5fc5\u987b\u8981\u6709\u503c\u3002", (String)"AnalyseRptOpHelper_1", (String)"scmc-im-report", (Object[])new Object[0]));
        }
    }

    public static List<ReportColumn> setHiddenColsForRpt(List<AbstractReportColumn> rptColumns, List<String> needHideCols) {
        LinkedList<ReportColumn> needHiddenColumn = new LinkedList<ReportColumn>();
        for (AbstractReportColumn abstractReportColumn : rptColumns) {
            ReportColumn rptColumn;
            if (abstractReportColumn instanceof ReportColumn) {
                rptColumn = (ReportColumn)abstractReportColumn;
                if (!needHideCols.contains(rptColumn.getFieldKey())) continue;
                rptColumn.setHide(true);
                needHiddenColumn.add(rptColumn);
                continue;
            }
            if (!(abstractReportColumn instanceof ReportColumnGroup)) continue;
            rptColumn = (ReportColumnGroup)abstractReportColumn;
            List groupColumns = rptColumn.getChildren();
            needHiddenColumn.addAll(AnalyseRptOpHelper.setHiddenColsForRpt((List<AbstractReportColumn>)groupColumns, needHideCols));
        }
        return needHiddenColumn;
    }

    public static void setHiddenColsForRpt(List<AbstractReportColumn> rptColumns, String ... needHideCols) {
        List<String> colArrToList = Arrays.asList(needHideCols);
        AnalyseRptOpHelper.setHiddenColsForRpt(rptColumns, colArrToList);
    }

    public static boolean isEnableshelflifemgr(DynamicObject material) {
        return material.getBoolean("enableshelflifemgr");
    }

    public static QFilter getIdentEqQFilter() {
        return AnalyseRptOpHelper.getDefaultQFilter("=");
    }

    public static QFilter getIdentNotEqQFilter() {
        return AnalyseRptOpHelper.getDefaultQFilter("!=");
    }

    public static QFilter getDefaultQFilter(String operatorKey) {
        return new QFilter("1", operatorKey, (Object)ReportCommonFiltersConsts.IDENT_EQ_VAL);
    }

    public static JoinDataSet addJoinOnCols(JoinDataSet joinDataSet, String ... onFileds) {
        for (String onFiled : onFileds) {
            joinDataSet = joinDataSet.on(onFiled, onFiled);
        }
        return joinDataSet;
    }

    public static QFilter getEnableAvaliableQFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    public static QFilter getAuditedStatusQFilter() {
        return new QFilter("status", "=", (Object)"C");
    }

    public static QFilter getAuditedDataQFilter() {
        return AnalyseRptOpHelper.getEnableAvaliableQFilter().and(AnalyseRptOpHelper.getAuditedStatusQFilter());
    }
}

