/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.NoUpdateFieldsAnalysisHelper;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;

public class ReportQueryHelper {
    private static String getAlgoKeyAndMethodName() {
        return Thread.currentThread().getStackTrace()[2].toString();
    }

    public static DataSet filterNoUpdateField(DataSet billSet, FilterInfo filterInfo) {
        QFilter tracknumberFilter;
        ArrayList<Object[]> lineData = new ArrayList<Object[]>();
        DataSet copyBillSet = billSet.copy();
        billSet.close();
        RowMeta rowMeta = copyBillSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        for (Row row : copyBillSet) {
            ArrayList<Object> tempData = new ArrayList<Object>(rowMeta.getFieldCount());
            String noUpdateInvFields = row.getString("noupdateinvfields");
            Boolean updateField = null != noUpdateInvFields && !noUpdateInvFields.isEmpty();
            Set<String> noUpdateInvNumFieldSet = ReportQueryHelper.getNoUpdateInvNumFieldSet(noUpdateInvFields);
            for (String fieldName : fieldNames) {
                Object value = row.get(fieldName);
                if (updateField.booleanValue() && noUpdateInvNumFieldSet.contains(fieldName)) {
                    value = fieldName.contains(".number") ? "" : Long.valueOf(0L);
                }
                tempData.add(value);
            }
            lineData.add(tempData.toArray());
        }
        CollectionInput inputs = new CollectionInput(rowMeta, lineData);
        DataSet filterDataSet = Algo.create((String)ReportQueryHelper.getAlgoKeyAndMethodName()).createDataSet(new Input[]{inputs});
        StringBuilder filter = new StringBuilder();
        QFilter projectFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "project.number", "projectfrom", "projectto");
        if (projectFilter != null) {
            filter.append(projectFilter.toString());
        }
        if ((tracknumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "tracknumber.number", "tracknumberfrom", "tracknumberto")) != null) {
            if (filter.length() > 0) {
                filter.append(" and ");
            }
            filter.append(tracknumberFilter.toString());
        }
        if (filter.length() > 0) {
            filterDataSet = filterDataSet.filter(filter.toString());
        }
        return filterDataSet;
    }

    private static Set<String> getNoUpdateInvNumFieldSet(String noUpdateInvFields) {
        HashSet<String> getNoUpdateInvNumFieldSet = new HashSet<String>(4);
        if (null == noUpdateInvFields || noUpdateInvFields.isEmpty()) {
            return getNoUpdateInvNumFieldSet;
        }
        List updateInvFieldsList = NoUpdateFieldsAnalysisHelper.getNoUpdateFieldsList((String)noUpdateInvFields);
        for (String noUpdateInvField : updateInvFieldsList) {
            getNoUpdateInvNumFieldSet.add(noUpdateInvField);
            getNoUpdateInvNumFieldSet.add(noUpdateInvField + ".number");
        }
        return getNoUpdateInvNumFieldSet;
    }
}

