/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invacc;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;

public class InvAccRptPropChanged {
    private IFormView view = null;

    public InvAccRptPropChanged(IFormView view) {
        this.view = view;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (key = e.getProperty().getName()) {
            case "multiorghead": 
            case "multiorgheadbyowner": {
                this.handleMultiOrgChangeEvent((DynamicObjectCollection)newValue, (DynamicObjectCollection)oldValue);
                break;
            }
            case "ownertypehead": {
                ReportCommonFilterOrChangeOp.handleOwnerTypeHeadChangeEvent(key, this.view);
                break;
            }
            case "keepertypehead": {
                ReportCommonFilterOrChangeOp.handleKeeperTypeHeadChangeEvent(key, this.view);
                break;
            }
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": 
            case "accountkeeperfrom": 
            case "supplierkeeperfrom": 
            case "customerkeeperfrom": 
            case "materialgroupfrom": 
            case "warehousefrom": 
            case "locationfrom": 
            case "projectfrom": 
            case "materialnumberfrom": 
            case "configuredcodefrom": 
            case "tracknumberfrom": {
                ReportCommonFilterOrChangeOp.handleMulBasedataChangeEvent(key, this.view);
                break;
            }
            case "materialgroupto": 
            case "warehouseto": 
            case "materialgroupstandard": {
                ReportCommonFilterOrChangeOp.handleValueToNull(key, this.view);
                break;
            }
            case "lotnumberfrom": {
                ReportCommonFilterOrChangeOp.handlelotnumberfromChangeEvent(newValue, this.view);
                break;
            }
            case "lotnumberto": {
                ReportCommonFilterOrChangeOp.handlelotnumbertoChangeEvent(newValue, oldValue, this.view);
                break;
            }
            case "radiogroupfield": {
                this.handleRadioGroupFieldChagneEvent(newValue);
                break;
            }
            case "auxproperty": {
                AuxptyFilterHelper.handleAuxpropertyChangeEvent((Object)newValue, (int)rowIndex, (IFormView)this.view);
                break;
            }
            case "auxdetailbasebd": {
                AuxptyFilterHelper.handleAuxdetailBdChagneEvent((Object)newValue, (int)rowIndex, (IDataModel)this.getModel());
                break;
            }
        }
    }

    private void handleRadioGroupFieldChagneEvent(Object newValue) {
        if ("B".equals(newValue)) {
            this.getModel().setValue("radiogroupfield", newValue);
            this.view.setVisible(Boolean.TRUE, new String[]{"multiorgheadbyowner"});
            ((ItemClassTypeEdit)this.view.getControl("ownertypehead")).setMustInput(true);
            ((ItemClassTypeEdit)this.view.getControl("keepertypehead")).setMustInput(false);
            ((MulBasedataEdit)this.view.getControl("multiorghead")).setMustInput(false);
            this.view.setVisible(Boolean.FALSE, new String[]{"multiorgheadbykeeper"});
            this.view.setVisible(Boolean.FALSE, new String[]{"multiorghead"});
            this.getModel().setValue("multiorghead", null);
        } else if ("C".equals(newValue)) {
            this.getModel().setValue("radiogroupfield", newValue);
            this.view.setVisible(Boolean.TRUE, new String[]{"multiorgheadbykeeper"});
            ((ItemClassTypeEdit)this.view.getControl("keepertypehead")).setMustInput(true);
            ((ItemClassTypeEdit)this.view.getControl("ownertypehead")).setMustInput(false);
            this.view.setVisible(Boolean.FALSE, new String[]{"multiorgheadbyowner"});
            ((MulBasedataEdit)this.view.getControl("multiorghead")).setMustInput(false);
            this.view.setVisible(Boolean.FALSE, new String[]{"multiorghead"});
            this.getModel().setValue("multiorghead", null);
        } else {
            this.getModel().createNewData();
            ((MulBasedataEdit)this.view.getControl("multiorghead")).setMustInput(true);
            this.view.setVisible(Boolean.TRUE, new String[]{"multiorghead"});
            ((ItemClassTypeEdit)this.view.getControl("keepertypehead")).setMustInput(false);
            ((ItemClassTypeEdit)this.view.getControl("ownertypehead")).setMustInput(false);
            this.view.setVisible(Boolean.FALSE, new String[]{"multiorgheadbyowner"});
            this.view.setVisible(Boolean.FALSE, new String[]{"multiorgheadbykeeper"});
        }
    }

    private void handleMultiOrgChangeEvent(DynamicObjectCollection newValue, DynamicObjectCollection oldValue) {
        if (newValue.size() == 0 && this.orgIsMust()) {
            ArrayList<Long> listOrgId = new ArrayList<Long>();
            for (DynamicObject dynamicObject : oldValue) {
                listOrgId.add(dynamicObject.getLong("fbasedataid_id"));
                this.getModel().setValue("multiorghead", (Object)listOrgId.toArray());
            }
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InvAccRptPropChanged_0", (String)"scmc-im-report", (Object[])new Object[0]));
            return;
        }
        if (this.orgIsMust()) {
            this.getModel().beginInit();
            this.getModel().createNewData();
            ArrayList<Long> listOrgId = new ArrayList<Long>();
            for (DynamicObject dynamicObject : newValue) {
                listOrgId.add(dynamicObject.getLong("fbasedataid_id"));
            }
            this.getModel().setValue("multiorghead", (Object)listOrgId.toArray());
            this.getModel().endInit();
            this.view.updateView();
            return;
        }
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    private boolean orgIsMust() {
        return "A".equals(this.view.getModel().getValue("radiogroupfield"));
    }
}

