/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillagereport;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.report.common.AnalyseReportConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.helper.OwnerTypeViewHelper;
import kd.scmc.im.report.invbillagereport.InvBillAgeRptBeforeF7Select;
import kd.scmc.im.report.invbillagereport.InvBillAgeRptPropChanged;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class InvBillAgeRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        ReportShowParameter showParameter = (ReportShowParameter)e.getSource();
        String formid = showParameter.getFormId();
        this.doBillPermission(showParameter, formid);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"orghead", "accountownerfrom", "supplierownerfrom", "customerownerfrom", "ownerto", "materialgroupfrom", "materialgroupto", "materialnumberfrom", "materialnumberto", "warehousefrom", "warehouseto", "locationfrom", "locationto", "projectfrom", "projectto", "biztypeentry", "invschemeentry", "materialgroupstandard", "billtypeentry", "ivntypehead", "configuredcodeto", "tracknumberto"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        InvBillAgeRptBeforeF7Select baseInvBillAgeRptBeforeF7Select = new InvBillAgeRptBeforeF7Select((IFormView)this.getView());
        baseInvBillAgeRptBeforeF7Select.beforeF7Select(e, "orghead");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        InvBillAgeRptPropChanged baseInvBillAgeRptPropChanged = new InvBillAgeRptPropChanged((IFormView)this.getView());
        baseInvBillAgeRptPropChanged.propertyChanged(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OwnerTypeViewHelper.setEnableUI(this.getModel(), (IFormView)this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        ReportCommonFilterOrChangeOp.initOrg(this.getView(), "orghead");
        this.initDate();
        this.initInvageGroup();
        this.initStandard();
        this.handleResetButtonEvent();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.addNoStatisticalBillParams(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        this.setNeedHiddenColumn(columns, this.dynamicSetCloumns(queryParam, columns));
        this.setNeedHiddenColumn(columns, this.hanldeSumrefColumn(filterInfo));
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("entry2".equals(e.getEntryProp().getName())) {
            int rowIndex = this.getModel().getEntryRowCount("entry2") - 1;
            String prefixString = ((String)this.getModel().getValue("invagegroup", rowIndex - 1)).toLowerCase();
            if (StringUtils.isEmpty((String)prefixString)) {
                return;
            }
            String lastValue = null;
            lastValue = prefixString.contains("days") ? prefixString.substring(prefixString.indexOf(ResManager.loadKDString((String)"to", (String)"InvBillAgeRptPlugin_11", (String)"scmc-im-report", (Object[])new Object[0])) + 1, prefixString.indexOf(ResManager.loadKDString((String)"days", (String)"InvBillAgeRptPlugin_12", (String)"scmc-im-report", (Object[])new Object[0]))).trim() : prefixString.substring(prefixString.indexOf(ResManager.loadKDString((String)"\u5230", (String)"InvBillAgeRptPlugin_0", (String)"scmc-im-report", (Object[])new Object[0])) + 1, prefixString.indexOf(ResManager.loadKDString((String)"\u5929", (String)"InvBillAgeRptPlugin_1", (String)"scmc-im-report", (Object[])new Object[0])));
            Integer prefixRowIntervaldaysValue = (Integer)this.getModel().getValue("intervaldays", rowIndex - 1);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"invagegroup"});
            int totalDay = Integer.parseInt(lastValue) + prefixRowIntervaldaysValue;
            this.getModel().setValue("invagegroup", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"InvBillAgeRptPlugin_2", (String)"scmc-im-report", (Object[])new Object[0]), totalDay), rowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if ("entry1".equals(e.getEntryProp().getName())) {
            DynamicObjectCollection entry1Entity = this.getModel().getEntryEntity("entry1");
            int reffectedRows = e.getRowIndexs().length;
            if (entry1Entity.size() == reffectedRows) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u4e3a\u4fdd\u7559\u884c,\u5982\u82e5\u8981\u5220\u9664,\u8bf7\u624b\u5de5\u5220\u9664\u8be5\u884c\u6570\u636e\u3002", (String)"InvBillAgeRptPlugin_4", (String)"scmc-im-report", (Object[])new Object[0]));
            }
        }
        if ("entry2".equals(e.getEntryProp().getName())) {
            int[] rowIndexs = e.getRowIndexs();
            if (rowIndexs.length != 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9010\u884c\u5220\u9664\uff0c\u4e0d\u8981\u4e00\u6b21\u6027\u5220\u9664\u591a\u884c\u3002", (String)"InvBillAgeRptPlugin_9", (String)"scmc-im-report", (Object[])new Object[0]));
            }
            if (rowIndexs[0] == 0 || rowIndexs[0] == 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u548c\u7b2c\u4e8c\u884c\u4e3a\u4fdd\u7559\u884c\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"InvBillAgeRptPlugin_10", (String)"scmc-im-report", (Object[])new Object[0]));
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if ("entry2".equals(e.getEntryProp().getName())) {
            String sbFirst = ResManager.loadKDString((String)"0\u5230X\u5929", (String)"InvBillAgeRptPlugin_5", (String)"scmc-im-report", (Object[])new Object[0]);
            String secondString = sbFirst.substring(1, 2);
            String fourString = sbFirst.substring(sbFirst.length() - 1);
            if (sbFirst.toLowerCase().contains("to")) {
                secondString = "to";
                StringBuffer sb = new StringBuffer(sbFirst.trim());
                sb.replace(1, 4, " to X ");
                sbFirst = sb.toString();
                fourString = sbFirst.substring(sbFirst.indexOf("X ") + 2);
            }
            String sbSuffix = "";
            DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry2");
            if (entry2Entity == null || entry2Entity.isEmpty()) {
                return;
            }
            int size = entry2Entity.size();
            for (int i = 0; i < size; ++i) {
                String lastValue;
                int invagegroup = ((DynamicObject)entry2Entity.get(i)).getInt("intervaldays");
                if (i == 0) {
                    sbFirst = sbFirst.replaceAll("X", String.valueOf(invagegroup - 1));
                    this.getModel().setValue("invagegroup", (Object)sbFirst, i);
                    sbSuffix = sbFirst;
                    continue;
                }
                if (i == size - 1) {
                    lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                    int totalDay = Integer.parseInt(lastValue) + 1;
                    DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"invagegroup", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"InvBillAgeRptPlugin_2", (String)"scmc-im-report", (Object[])new Object[0]), totalDay), (int)i, (boolean)false);
                    DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"intervaldays", null, (int)i, (boolean)false);
                    continue;
                }
                lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                String tmp = null;
                tmp = "to".equals(secondString) ? Integer.parseInt(lastValue) + 1 + " " + secondString + " " + (Integer.parseInt(lastValue) + invagegroup) + " " + fourString : Integer.parseInt(lastValue) + 1 + secondString + (Integer.parseInt(lastValue) + invagegroup) + fourString;
                DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"invagegroup", (Object)tmp, (int)i, (boolean)false);
                sbSuffix = tmp;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        return this.verifyBeforeQuery(queryParam);
    }

    public void afterSetModelValue(DynamicObject scheme) {
        DynamicObjectCollection projectFrom;
        DynamicObjectCollection locationFrom;
        DynamicObjectCollection warehouseFrom;
        DynamicObjectCollection materiaNumFrom;
        Boolean displayclasssumValue = (Boolean)this.getModel().getValue("displayclasssum");
        if (displayclasssumValue.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"displaysum"});
        }
        if ("1".equals(this.getModel().getValue("ageanalysis"))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"enddate"});
        }
        OwnerTypeViewHelper.setEnableUI(this.getModel(), (IFormView)this.getView());
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection materialGrpFrom = dataEntity.getDynamicObjectCollection("materialgroupfrom");
        if (materialGrpFrom.size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialgroupto"});
        }
        if ((materiaNumFrom = dataEntity.getDynamicObjectCollection("materialnumberfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialnumberto"});
        }
        if ((warehouseFrom = dataEntity.getDynamicObjectCollection("warehousefrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"warehouseto"});
        }
        if ((locationFrom = dataEntity.getDynamicObjectCollection("locationfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"locationto"});
        }
        if ((projectFrom = dataEntity.getDynamicObjectCollection("projectfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"projectto"});
        }
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        super.setOtherEntryFilter(filterInfo);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryOne = dataModel.getEntryEntity("entry1");
        DynamicObjectCollection entryTwo = dataModel.getEntryEntity("entry2");
        this.setF7Filter(dataModel, entryOne, "billtypeentry");
        this.setF7Filter(dataModel, entryOne, "biztypeentry");
        this.setF7Filter(dataModel, entryOne, "invschemeentry");
        this.setBasicFilter(dataModel, entryTwo, "invagegroup");
        this.setBasicFilter(dataModel, entryTwo, "intervaldays");
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryOne = scheme.getDynamicObjectCollection("entry1");
        DynamicObjectCollection entryTwo = scheme.getDynamicObjectCollection("entry2");
        if (entryOne == null || entryOne.size() == 0 || entryTwo == null || entryTwo.size() == 0) {
            return;
        }
        dataModel.deleteEntryData("entry1");
        dataModel.deleteEntryData("entry2");
        dataModel.batchCreateNewEntryRow("entry1", entryOne.size());
        dataModel.batchCreateNewEntryRow("entry2", entryTwo.size());
        this.setF7Filter(dataModel, entryOne, "billtypeentry");
        this.setF7Filter(dataModel, entryOne, "biztypeentry");
        this.setF7Filter(dataModel, entryOne, "invschemeentry");
        this.setBasicFilter(dataModel, entryTwo, "invagegroup");
        this.setBasicFilter(dataModel, entryTwo, "intervaldays");
    }

    private boolean verifyBeforeQuery(ReportQueryParam queryParam) {
        Date enddate;
        FilterInfo filter = queryParam.getFilter();
        if ("1".equals(filter.getString("ageanalysis")) && (enddate = (Date)filter.getValue("enddate")) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u3002", (String)"InvBillAgeRptPlugin_13", (String)"scmc-im-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void addNoStatisticalBillParams(ReportQueryParam queryParam) {
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry1");
        if (entry2Entity != null && !entry2Entity.isEmpty()) {
            int size = entry2Entity.size();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                DynamicObject billTypeEntry = (DynamicObject)((DynamicObject)entry2Entity.get(i)).get("billtypeentry");
                DynamicObject bizTypeEntry = (DynamicObject)((DynamicObject)entry2Entity.get(i)).get("biztypeentry");
                DynamicObject invSchemeEntry = (DynamicObject)((DynamicObject)entry2Entity.get(i)).get("invschemeentry");
                StringBuilder billInvScheme = new StringBuilder();
                if (billTypeEntry != null) {
                    String billNumber = billTypeEntry.getString("billformid.number");
                    billInvScheme.append(billNumber);
                    if (bizTypeEntry != null) {
                        Long biztypeentryId = (Long)bizTypeEntry.getPkValue();
                        billInvScheme.append(":");
                        billInvScheme.append(biztypeentryId);
                    }
                    if (invSchemeEntry != null) {
                        Long invschemeId = (Long)invSchemeEntry.getPkValue();
                        billInvScheme.append(":");
                        billInvScheme.append(invschemeId);
                    }
                }
                sb.append((CharSequence)billInvScheme);
                sb.append(",");
            }
            String string = sb.toString();
            if (string.isEmpty()) {
                return;
            }
            queryParam.getFilter().addFilterItem("nostatistical", (Object)string.substring(0, string.lastIndexOf(44)));
        }
    }

    private Set<String> dynamicSetCloumns(ReportQueryParam queryParam, List<AbstractReportColumn> columns) {
        StringBuffer sbInvageGroup = null;
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("entry2");
        if (entry2Entity != null && !entry2Entity.isEmpty()) {
            int size = entry2Entity.size();
            if (((DynamicObject)entry2Entity.get(0)).getInt("intervaldays") != 0) {
                StringBuffer sbIntervaldays = new StringBuffer();
                sbInvageGroup = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    String intervalStr = ((DynamicObject)entry2Entity.get(i)).getInt("intervaldays") + ",";
                    sbIntervaldays.append(intervalStr);
                    String ageGroup = ((DynamicObject)entry2Entity.get(i)).getString("invagegroup") + ",";
                    sbInvageGroup.append(ageGroup);
                }
                sbIntervaldays = sbIntervaldays.delete(sbIntervaldays.lastIndexOf(","), sbIntervaldays.length());
                sbInvageGroup = sbInvageGroup.delete(sbInvageGroup.lastIndexOf(","), sbInvageGroup.length());
                queryParam.getFilter().addFilterItem("intervaldays", (Object)sbIntervaldays.toString());
            }
        }
        HashSet<String> hiddenColumn = new HashSet<String>();
        FilterInfo filterInfo = queryParam.getFilter();
        Map<String, String> qtyrangrangColumns = this.getFieldKey(sbInvageGroup, "qtyrang");
        Map<String, String> baseqtyrangColumns = this.getFieldKey(sbInvageGroup, "baseqtyrang");
        this.addColums(columns, qtyrangrangColumns, filterInfo);
        this.addColums(columns, baseqtyrangColumns, filterInfo);
        if (filterInfo.getBoolean("displayinvunit")) {
            if (baseqtyrangColumns != null) {
                hiddenColumn.addAll(baseqtyrangColumns.keySet());
            }
            return hiddenColumn;
        }
        if (qtyrangrangColumns != null) {
            hiddenColumn.addAll(qtyrangrangColumns.keySet());
        }
        return hiddenColumn;
    }

    private String[] getSumField() {
        String sumRef = (String)this.getModel().getValue("sumref");
        if (sumRef != null) {
            String[] fieldArray = sumRef.split(",");
            return fieldArray;
        }
        return new String[0];
    }

    private Set<String> hanldeSumrefColumn(FilterInfo filterInfo) {
        String[] sumref;
        HashSet<String> hiddenColumn = new HashSet<String>();
        hiddenColumn.add("lotnumber");
        hiddenColumn.add("warehouse");
        hiddenColumn.add("location");
        hiddenColumn.add("project");
        hiddenColumn.add("auxpty");
        hiddenColumn.add("owner");
        hiddenColumn.add("configuredcode");
        hiddenColumn.add("tracknumber");
        for (String ref : sumref = this.getSumField()) {
            hiddenColumn.remove(ref);
        }
        if (hiddenColumn.contains("owner")) {
            hiddenColumn.add("ownertype");
        }
        if (hiddenColumn.contains("warehouse")) {
            hiddenColumn.add("warehousename");
        }
        if (hiddenColumn.contains("location")) {
            hiddenColumn.add("locationname");
        }
        if (filterInfo.getBoolean("displayinvunit")) {
            hiddenColumn.add("baseqty");
            hiddenColumn.add("baseunit");
        } else {
            hiddenColumn.add("qty");
            hiddenColumn.add("unit");
        }
        return hiddenColumn;
    }

    private void initStandard() {
        this.getModel().setValue("materialgroupstandard", (Object)AnalyseReportConst.INIT_MATERIALGROUPSTANDARD_ID);
    }

    private List<AbstractReportColumn> addColums(List<AbstractReportColumn> columns, Map<String, String> fieldKeyAndNameMap, FilterInfo filterInfo) {
        if (fieldKeyAndNameMap != null) {
            for (Map.Entry<String, String> entry : fieldKeyAndNameMap.entrySet()) {
                ReportColumn reportColumn = new ReportColumn();
                reportColumn.setFieldKey(entry.getKey());
                reportColumn.setFieldType("qty");
                reportColumn.setZeroShow(true);
                if (filterInfo.getBoolean("displayinvunit")) {
                    reportColumn.setMeasureUnitField("unit");
                } else {
                    reportColumn.setMeasureUnitField("baseunit");
                }
                reportColumn.setCaption(new LocaleString(entry.getValue()));
                columns.add((AbstractReportColumn)reportColumn);
            }
        }
        return columns;
    }

    private Map<String, String> getFieldKey(StringBuffer sbInvageGroup, String setFieldKeyPrefix) {
        if (sbInvageGroup == null) {
            return null;
        }
        String[] captions = sbInvageGroup.toString().split(",");
        if (captions.length == 0) {
            return null;
        }
        int length = captions.length;
        TreeMap<String, String> fieldKeyAndNameMap = new TreeMap<String, String>();
        for (int i = 0; i < length; ++i) {
            fieldKeyAndNameMap.put(setFieldKeyPrefix + i, captions[i]);
        }
        return fieldKeyAndNameMap;
    }

    private void setNeedHiddenColumn(List<AbstractReportColumn> columns, Set<String> hiddenColumn) {
        for (AbstractReportColumn abstractReportColumn : columns) {
            ReportColumn column;
            if (!(abstractReportColumn instanceof ReportColumn) || !hiddenColumn.contains((column = (ReportColumn)abstractReportColumn).getFieldKey())) continue;
            column.setHide(true);
        }
    }

    private void initDate() {
        this.getModel().setValue("enddate", null);
        this.getView().setEnable(Boolean.FALSE, new String[]{"enddate"});
    }

    private void doBillPermission(ReportShowParameter showParameter, String formid) {
        List permissionOrgs = NewInvOrgHelper.getPermissionOrgsByAppId((String)formid, (String)showParameter.getAppId());
        if (permissionOrgs == null || permissionOrgs.isEmpty()) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_USE_INVORG()));
        }
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formid, (String)showParameter.getAppId());
        if (CommonUtils.isNull((Object)orgIdList)) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ENABLED_INV()));
        }
        showParameter.getCustomParams().put("HasPermissionAndStartedInvOrg", SerializationUtils.toJsonString((Object)orgIdList));
    }

    private void initInvageGroup() {
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"invagegroup"});
        this.getModel().setValue("invagegroup", (Object)ResManager.loadKDString((String)"0\u52306\u5929", (String)"InvBillAgeRptPlugin_7", (String)"scmc-im-report", (Object[])new Object[0]), 0);
        this.getModel().setValue("intervaldays", (Object)7, 0);
        this.getModel().setValue("invagegroup", (Object)ResManager.loadKDString((String)"7\u5929\u53ca\u4ee5\u4e0a", (String)"InvBillAgeRptPlugin_8", (String)"scmc-im-report", (Object[])new Object[0]), 1);
        this.getModel().setValue("intervaldays", null, 1);
    }

    private void handleResetButtonEvent() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"biztypeto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"invschemeto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialgroupto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"materialnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"warehouseto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"locationto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"projectto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"lotnumberto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"configuredcodeto"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"tracknumberto"});
    }

    private void setF7Filter(IDataModel dataModel, DynamicObjectCollection entryEntity, String entryField) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            DynamicObject billTypeObj = entryObj.getDynamicObject(entryField);
            if (billTypeObj == null) continue;
            Long billType = billTypeObj.getLong("id");
            dataModel.setValue(entryField, (Object)billType, i);
        }
    }

    private void setBasicFilter(IDataModel dataModel, DynamicObjectCollection entryEntity, String entryField) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            Object entryFieldObj = entryObj.get(entryField);
            if (entryFieldObj == null) continue;
            dataModel.setValue(entryField, entryFieldObj, i);
        }
    }
}

