/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillreport;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;

public class BaseInvBillRptFilteInfo {
    public static QFilter getInvBalanceQFilter(FilterInfo filterInfo) {
        QFilter tracknumberFilter;
        QFilter configuredCodeFilter;
        QFilter projectFilter;
        QFilter lotnumberFilter;
        QFilter locationFilter;
        QFilter warehouseFilter;
        QFilter materialFilter;
        DynamicObjectCollection invstatusheads;
        DynamicObjectCollection invtypeheads;
        QFilter filter = null;
        Object org = filterInfo.getValue("multiorghead");
        if (org instanceof DynamicObjectCollection) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                orgIds.add((Long)dynamicObject.getPkValue());
            }
            filter = new QFilter("org", "in", orgIds);
        } else {
            filter = new QFilter("org", "=", filterInfo.getDynamicObject("orghead").getPkValue());
        }
        String ownerTypehead = filterInfo.getString("ownertypehead");
        if (ownerTypehead != null && !ownerTypehead.trim().equals("")) {
            QFilter ownerTypeFilter = new QFilter("ownertype", "=", (Object)ownerTypehead);
            filter.and(ownerTypeFilter);
        }
        if ((invtypeheads = filterInfo.getDynamicObjectCollection("ivntypehead")) != null && invtypeheads.size() > 0) {
            HashSet<Object> invtypeIds = new HashSet<Object>();
            for (Iterator ivntype : invtypeheads) {
                invtypeIds.add(ivntype.getPkValue());
            }
            QFilter ivntypeheadFilter = new QFilter("invtype", "in", invtypeIds);
            filter.and(ivntypeheadFilter);
        }
        if ((invstatusheads = filterInfo.getDynamicObjectCollection("invstatushead")) != null && invstatusheads.size() > 0) {
            HashSet<Object> invstatusIds = new HashSet<Object>();
            for (DynamicObject invstatus : invstatusheads) {
                invstatusIds.add(invstatus.getPkValue());
            }
            QFilter invstatusheadFilter = new QFilter("invstatus", "in", invstatusIds);
            filter.and(invstatusheadFilter);
        }
        if ((materialFilter = ReportCommonFilterOrChangeOp.getMaterialFromToFilter(filterInfo, "material", true)) != null) {
            filter.and(materialFilter);
        }
        if ((warehouseFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "warehouse.number", "warehousefrom", "warehouseto")) != null) {
            filter.and(warehouseFilter);
        }
        if ((locationFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "location.number", "locationfrom", "locationto")) != null) {
            filter.and(locationFilter);
        }
        if ((lotnumberFilter = ReportCommonFilterOrChangeOp.getTextFromToFilter(filterInfo, "lotnumber", "lotnumberfrom", "lotnumberto")) != null) {
            filter.and(lotnumberFilter);
        }
        if ((projectFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "project.number", "projectfrom", "projectto")) != null) {
            filter.and(projectFilter);
        }
        if ((configuredCodeFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "configuredcode.number", "configuredcodefrom", "configuredcodeto")) != null) {
            filter.and(configuredCodeFilter);
        }
        if ((tracknumberFilter = ReportCommonFilterOrChangeOp.getDynamicObjectFromToFilter(filterInfo, "tracknumber.number", "tracknumberfrom", "tracknumberto")) != null) {
            filter.and(tracknumberFilter);
        }
        if (filterInfo.getLong("auxpty") != 0L) {
            filter.and("auxpty", "=", (Object)filterInfo.getLong("auxpty"));
        }
        return filter;
    }

    public static QFilter handleQtyDisplayQfilter(FilterInfo filterInfo) {
        QFilter filters = null;
        String qtydisplay = filterInfo.getString("qtydisplay");
        if (qtydisplay == null) {
            return null;
        }
        if (qtydisplay.contains("1")) {
            filters = new QFilter("inqty", "!=", (Object)0);
        }
        if (qtydisplay.contains("2")) {
            if (filters != null) {
                filters.and("outqty", "!=", (Object)0);
            } else {
                filters = new QFilter("outqty", "!=", (Object)0);
            }
        }
        if (qtydisplay.contains("3")) {
            if (filters != null) {
                filters.and(new QFilter("inqty", "!=", (Object)0).or("outqty", "!=", (Object)0));
            } else {
                filters = new QFilter("inqty", "!=", (Object)0).or("outqty", "!=", (Object)0);
            }
        }
        if (qtydisplay.contains("4")) {
            QFilter bgnQtyFilter = new QFilter("bgnqty", "!=", (Object)0);
            if (filters != null) {
                filters.and(bgnQtyFilter);
            } else {
                filters = bgnQtyFilter;
            }
        }
        if (qtydisplay.contains("5")) {
            if (filters != null) {
                filters.and("balanceqty", "!=", (Object)0);
            } else {
                filters = new QFilter("balanceqty", "!=", (Object)0);
            }
        }
        if (qtydisplay.contains("6")) {
            if (filters != null) {
                filters.and("balanceqty", "=", (Object)0);
            } else {
                filters = new QFilter("balanceqty", "=", (Object)0);
            }
        }
        if (qtydisplay.contains("7")) {
            if (filters != null) {
                filters.and("balanceqty", "<", (Object)0);
            } else {
                filters = new QFilter("balanceqty", "<", (Object)0);
            }
        }
        return filters;
    }

    public static QFilter handleQtyDisplayDetailQfilter(FilterInfo filterInfo) {
        QFilter filters = null;
        String qtydisplay = filterInfo.getString("qtydisplay");
        if (qtydisplay == null) {
            return null;
        }
        if (qtydisplay.contains("1")) {
            filters = new QFilter("inqty", "!=", (Object)0);
        }
        if (qtydisplay.contains("2")) {
            if (filters != null) {
                filters.and("outqty", "!=", (Object)0);
            } else {
                filters = new QFilter("outqty", "!=", (Object)0);
            }
        }
        if (qtydisplay.contains("3")) {
            if (filters != null) {
                filters.and(new QFilter("inqty", "!=", (Object)0).or("outqty", "!=", (Object)0));
            } else {
                filters = new QFilter("inqty", "!=", (Object)0).or("outqty", "!=", (Object)0);
            }
        }
        return filters;
    }
}

