/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillreport;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;

public class BaseInvBillRptPropChanged {
    private IFormView view = null;

    public BaseInvBillRptPropChanged(IFormView view) {
        this.view = view;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (key = e.getProperty().getName()) {
            case "orghead": {
                ReportCommonFilterOrChangeOp.handleOrgChangeEvent((DynamicObject)newValue, oldValue, this.view);
                break;
            }
            case "ownertypehead": {
                ReportCommonFilterOrChangeOp.handleOwnerTypeHeadChangeEvent(key, this.view);
                break;
            }
            case "keepertypehead": {
                ReportCommonFilterOrChangeOp.handleKeeperTypeHeadChangeEvent(key, this.view);
                break;
            }
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": 
            case "accountkeeperfrom": 
            case "supplierkeeperfrom": 
            case "customerkeeperfrom": 
            case "biztypefrom": 
            case "invschemefrom": 
            case "materialgroupfrom": 
            case "warehousefrom": 
            case "locationfrom": 
            case "projectfrom": 
            case "materialnumberfrom": 
            case "configuredcodefrom": 
            case "tracknumberfrom": {
                this.handleMulBasedataChangeEvent(key);
                break;
            }
            case "materialgroupto": 
            case "warehouseto": 
            case "materialgroupstandard": {
                this.handleValueToNull(key);
                break;
            }
            case "lotnumberfrom": {
                ReportCommonFilterOrChangeOp.handlelotnumberfromChangeEvent(newValue, this.view);
                break;
            }
            case "lotnumberto": {
                ReportCommonFilterOrChangeOp.handlelotnumbertoChangeEvent(newValue, oldValue, this.view);
                break;
            }
            case "billnofrom": 
            case "billnoto": {
                ReportCommonFilterOrChangeOp.handleBillNoChangeEvent(newValue, key, this.view);
                break;
            }
            case "auxproperty": {
                AuxptyFilterHelper.handleAuxpropertyChangeEvent((Object)newValue, (int)rowIndex, (IFormView)this.view);
                break;
            }
        }
    }

    private void handleMulBasedataChangeEvent(String key) {
        String controlledControl = null;
        switch (key) {
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": {
                controlledControl = "ownerto";
                break;
            }
            case "accountkeeperfrom": 
            case "supplierkeeperfrom": 
            case "customerkeeperfrom": {
                controlledControl = "keeperto";
                break;
            }
            case "biztypefrom": {
                controlledControl = "biztypeto";
                break;
            }
            case "invschemefrom": {
                controlledControl = "invschemeto";
                break;
            }
            case "materialgroupfrom": {
                controlledControl = "materialgroupto";
                break;
            }
            case "warehousefrom": {
                controlledControl = "warehouseto";
                break;
            }
            case "locationfrom": {
                controlledControl = "locationto";
                break;
            }
            case "projectfrom": {
                controlledControl = "projectto";
                break;
            }
            case "materialnumberfrom": {
                controlledControl = "materialnumberto";
                break;
            }
            case "configuredcodefrom": {
                controlledControl = "configuredcodeto";
                break;
            }
            case "tracknumberfrom": {
                controlledControl = "tracknumberto";
                break;
            }
        }
        if (((DynamicObjectCollection)this.getModel().getValue(key)).size() > 1) {
            this.view.setEnable(Boolean.FALSE, new String[]{controlledControl});
        } else {
            this.view.setEnable(Boolean.TRUE, new String[]{controlledControl});
        }
        this.handleValueToNull(key);
    }

    private void handleValueToNull(String key) {
        IDataModel model = this.getModel();
        switch (key) {
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": {
                model.setValue("ownerto", null);
                break;
            }
            case "accountkeeperfrom": 
            case "supplierkeeperfrom": 
            case "customerkeeperfrom": {
                model.setValue("keeperto", null);
                break;
            }
            case "biztypefrom": {
                model.setValue("biztypeto", null);
                break;
            }
            case "invschemefrom": {
                model.setValue("invschemeto", null);
                break;
            }
            case "materialgroupstandard": {
                model.setValue("materialgroupfrom", null);
                model.setValue("materialgroupto", null);
                model.setValue("materialnumberfrom", null);
                model.setValue("materialnumberto", null);
                break;
            }
            case "materialgroupfrom": {
                model.setValue("materialgroupto", null);
                model.setValue("materialnumberfrom", null);
                model.setValue("materialnumberto", null);
                break;
            }
            case "materialgroupto": {
                model.setValue("materialnumberfrom", null);
                model.setValue("materialnumberto", null);
                break;
            }
            case "materialnumberfrom": {
                DynamicObjectCollection materialNumberFrom = (DynamicObjectCollection)model.getValue("materialnumberfrom");
                model.setValue("materialnumberto", materialNumberFrom.size() == 1 ? ((DynamicObject)materialNumberFrom.get(0)).get("fbasedataid") : null);
                break;
            }
            case "warehousefrom": {
                model.setValue("warehouseto", null);
                model.setValue("locationfrom", null);
                model.setValue("locationto", null);
                break;
            }
            case "warehouseto": {
                model.setValue("locationfrom", null);
                model.setValue("locationto", null);
                break;
            }
            case "locationfrom": {
                model.setValue("locationto", null);
                break;
            }
            case "projectfrom": {
                model.setValue("projectto", null);
                break;
            }
            case "configuredcodefrom": {
                model.setValue("configuredcodeto", null);
                break;
            }
            case "tracknumberfrom": {
                model.setValue("tracknumberto", null);
                break;
            }
        }
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }
}

