/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.invbillreport;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.SortAndFilterEvent;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.consts.InvBillRptConst;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;
import kd.scmc.im.report.invbillreport.BaseInvBillRptBeforeF7Select;
import kd.scmc.im.report.invbillreport.BaseInvBillRptPlugin;
import kd.scmc.im.utils.FormUtils;

public class InvBillDetailRptPlugin
extends BaseInvBillRptPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"multiorghead", "invschemefrom", "invschemeto"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        BaseInvBillRptBeforeF7Select baseInvBillRptBeforeF7Select = new BaseInvBillRptBeforeF7Select((IFormView)this.getView());
        baseInvBillRptBeforeF7Select.beforeF7Select(e, "multiorghead");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        switch (key = e.getProperty().getName()) {
            case "multiorghead": {
                this.handleMultiOrgChangeEvent((DynamicObjectCollection)newValue, (DynamicObjectCollection)oldValue);
                break;
            }
            default: {
                super.propertyChanged(e);
            }
        }
    }

    private void handleMultiOrgChangeEvent(DynamicObjectCollection newValue, DynamicObjectCollection oldValue) {
        if (newValue == null || newValue.size() == 0) {
            ArrayList<Long> listOrgId = new ArrayList<Long>();
            for (DynamicObject dynamicObject : oldValue) {
                listOrgId.add(dynamicObject.getLong("fbasedataid_id"));
                this.getModel().setValue("multiorghead", (Object)listOrgId.toArray());
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"InvBillDetailRptPlugin_0", (String)"scmc-im-report", (Object[])new Object[0]));
            return;
        }
        this.getModel().beginInit();
        this.getModel().createNewData();
        ArrayList<Long> listOrgId = new ArrayList<Long>();
        for (DynamicObject dynamicObject : newValue) {
            listOrgId.add(dynamicObject.getLong("fbasedataid_id"));
        }
        this.getModel().setValue("multiorghead", (Object)listOrgId.toArray());
        this.getModel().endInit();
        this.getView().updateView();
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ReportCommonFilterOrChangeOp.initMultiOrg(this.getView(), "multiorghead");
        if (this.getView().getFormShowParameter().getCustomParam("hyperlinkFromInvAccRpt") != null) {
            Object auxpty = this.getView().getFormShowParameter().getCustomParam("auxpty");
            AuxptyFilterHelper.bindAuxptyEntryById((Object)auxpty, (IDataModel)this.getModel(), (IFormView)this.getView());
        } else {
            String auxentryJson = (String)this.getView().getFormShowParameter().getCustomParam("auxentry");
            if (null == auxentryJson) {
                return;
            }
            List auxentryListMap = (List)SerializationUtils.fromJsonString((String)auxentryJson, List.class);
            for (int i = 0; i < auxentryListMap.size(); ++i) {
                if (i == 0) {
                    this.getModel().deleteEntryData("auxentry");
                    this.getModel().batchCreateNewEntryRow("auxentry", auxentryListMap.size());
                }
                Map map = (Map)auxentryListMap.get(i);
                this.getModel().setValue("auxproperty", map.get("auxproperty"), i);
                ArrayList auxdetailbdIdSet = (ArrayList)map.get("auxdetailbd");
                this.getModel().setValue("auxdetailbd", (Object)auxdetailbdIdSet.toArray(), i);
                this.getModel().setValue("auxdetailtxt", map.get("auxdetailtxt"), i);
                this.getModel().setValue("auxdetailbasebd", map.get("auxdetailbasebd"), i);
                this.getModel().setValue("auxdetailbasebdid", map.get("auxdetailbasebdid"), i);
            }
        }
    }

    public void afterSetModelValue(DynamicObject scheme) {
        Object o;
        DynamicObjectCollection projectFrom;
        DynamicObjectCollection locationFrom;
        DynamicObjectCollection warehouseFrom;
        DynamicObjectCollection materiaNumFrom;
        if (scheme == null) {
            return;
        }
        this.getModel().setValue("orghead", scheme.get("orghead"));
        this.getModel().setValue("multiorghead", scheme.get("multiorghead"));
        DataEntityPropertyCollection dataEntityPropertyCollection = scheme.getDataEntityType().getProperties();
        for (IDataEntityProperty property : dataEntityPropertyCollection) {
            String name = property.getName();
            if ("orghead".equals(name) || "multiorghead".equals(name) || "auxentry".equals(name)) continue;
            DataChangeHelper.setValue((IDataModel)this.getModel(), (String)name, (Object)scheme.get(name), (boolean)false);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection materialGrpFrom = dataEntity.getDynamicObjectCollection("materialgroupfrom");
        if (materialGrpFrom.size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialgroupto"});
        }
        if ((materiaNumFrom = dataEntity.getDynamicObjectCollection("materialnumberfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"materialnumberto"});
        }
        if ((warehouseFrom = dataEntity.getDynamicObjectCollection("warehousefrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"warehouseto"});
        }
        if ((locationFrom = dataEntity.getDynamicObjectCollection("locationfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"locationto"});
        }
        if ((projectFrom = dataEntity.getDynamicObjectCollection("projectfrom")).size() > 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"projectto"});
        }
        if ((o = dataEntity.get("lotnumberfrom")) == null || "".equals(o)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"lotnumberto"});
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            if (!InvBillRptConst.DETAIL_HEADFILTER_LIST.contains(event.getColumnName())) continue;
            event.setFilter(true);
        }
    }
}

