/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.measureadjust;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.report.common.ReportCommonFilterOrChangeOp;

public class MeasureDeviationAdjustPropChanged {
    private IFormView view;

    MeasureDeviationAdjustPropChanged(IFormView view) {
        this.view = view;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        switch (key = e.getProperty().getName()) {
            case "multiorghead": {
                this.handleOrgChangeEvent((DynamicObject)newValue, (DynamicObject)oldValue);
                break;
            }
            case "ownertypehead": {
                ReportCommonFilterOrChangeOp.handleOwnerTypeHeadChangeEvent(key, this.view);
                break;
            }
            case "accountownerfrom": 
            case "supplierownerfrom": 
            case "customerownerfrom": 
            case "materialgroupfrom": 
            case "warehousefrom": 
            case "locationfrom": 
            case "projectfrom": 
            case "materialnumberfrom": 
            case "configuredcodefrom": 
            case "tracknumberfrom": {
                ReportCommonFilterOrChangeOp.handleMulBasedataChangeEvent(key, this.view);
                break;
            }
            case "materialgroupto": 
            case "warehouseto": 
            case "materialgroupstandard": {
                ReportCommonFilterOrChangeOp.handleValueToNull(key, this.view);
                break;
            }
            case "lotnumberfrom": {
                ReportCommonFilterOrChangeOp.handlelotnumberfromChangeEvent(newValue, this.view);
                break;
            }
            case "lotnumberto": {
                ReportCommonFilterOrChangeOp.handlelotnumbertoChangeEvent(newValue, oldValue, this.view);
                break;
            }
        }
    }

    private void handleOrgChangeEvent(DynamicObject newValue, DynamicObject oldValue) {
        if (newValue == null) {
            this.getModel().setValue("multiorghead", oldValue.getPkValue());
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MeasureDeviationAdjustPropChanged_0", (String)"scmc-im-report", (Object[])new Object[0]));
            return;
        }
        this.getModel().beginInit();
        this.getModel().createNewData();
        this.getModel().setValue("multiorghead", newValue.getPkValue());
        this.getModel().endInit();
        this.view.updateView();
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }
}

