/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.balance;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.acct.BalanceHelper;
import kd.scmc.im.consts.InvBalanceConst;
import kd.scmc.im.mservice.api.balance.InvAccRenovatorService;
import kd.scmc.im.utils.DateUtils;

public class InvAccRenovatorServiceImpl
implements InvAccRenovatorService {
    private Map param = new HashMap(16);
    private Map<String, String> mdcBillTypeMap = InvBalanceConst.getMdcBillTypeMap();
    private static final Set<String> spBills = new HashSet<String>(Arrays.asList("im_adjustbill", "im_assembbill", "im_locationtransfer", "im_disassemblebill"));
    private static final String invBal = "1";
    private static final String calBal = "2";
    private static final String calallinvbal = "calallinvbal";

    public void invAccRenovator(Map param) throws KDBizException {
    }

    public void invBalRenovator(Map param) throws KDBizException {
        this.param = param;
        if (calallinvbal.equals(param.get(calallinvbal))) {
            DeleteServiceHelper.delete((String)"im_invbalance", null);
            this.reCalAllBalance();
            return;
        }
        Long paramID = 0L;
        this.updateInvBalData();
        this.reCalBalance();
    }

    private void reCalAllBalance() {
        String selects = InvBalanceConst.getInitSelects();
        DataSet bills = InvAccRenovatorServiceImpl.getBillDataSet("im_initbill", new QFilter[]{this.getBillStatusf()}, selects);
        DB.execute((DBRoute)new DBRoute("im"), (String)"delete from t_im_invsnapshoot", (Object[])new Object[0]);
        BalanceHelper.calInitBalanceData((DataSet)bills.copy(), (boolean)false, (boolean)true, (boolean)true);
        BalanceHelper.calInitBalanceData((DataSet)bills, (boolean)true, (boolean)true, (boolean)true);
        this.reCalAllBizBalance();
    }

    private void reCalAllBizBalance() {
        for (String formId : InvBalanceConst.getBalBillList()) {
            QFilter calBalOutFilter;
            QFilter calBalFilter;
            QFilter invBalOutFilter;
            String outSelets;
            QFilter invBalFilter;
            String selets;
            if (formId.equals("im_adjustbill")) {
                selets = InvBalanceConst.getAdjInSelects();
                invBalFilter = this.getBillStatusf();
                outSelets = InvBalanceConst.getAdjOutSelects();
                invBalOutFilter = this.getBillStatusf();
                calBalFilter = invBalFilter.copy().and(this.filterRecIsCal(formId));
                calBalOutFilter = invBalOutFilter.copy().and(this.filterSedIsCal(formId));
            } else if (formId.equals("im_assembbill")) {
                selets = InvBalanceConst.getAssInSelects();
                invBalFilter = this.getBillStatusf();
                outSelets = InvBalanceConst.getAssOutSelects();
                invBalOutFilter = this.getBillStatusf();
                calBalFilter = invBalFilter.copy().and(this.filterRecIsCal(formId));
                calBalOutFilter = invBalOutFilter.copy().and(this.filterSedIsCal(formId));
            } else if (formId.equals("im_locationtransfer")) {
                selets = InvBalanceConst.getLocInSelects();
                invBalFilter = this.getBillStatusf();
                outSelets = InvBalanceConst.getLocOutSelects();
                invBalOutFilter = this.getBillStatusf();
                calBalFilter = invBalFilter.copy().and(this.filterRecIsCal(formId));
                calBalOutFilter = invBalOutFilter.copy().and(this.filterSedIsCal(formId));
            } else if (formId.equals("im_disassemblebill")) {
                outSelets = InvBalanceConst.getAdjOutSelects();
                invBalOutFilter = this.getBillStatusf();
                selets = InvBalanceConst.getAdjInSelects();
                invBalFilter = this.getBillStatusf();
                calBalFilter = invBalFilter.copy().and(this.filterRecIsCal(formId));
                calBalOutFilter = invBalOutFilter.copy().and(this.filterSedIsCal(formId));
            } else {
                String inUpdatef = "invscheme.isinupdate";
                String outUpdatef = "invscheme.isoutupdate";
                boolean isDirBill = formId.equalsIgnoreCase("im_transdirbill");
                selets = isDirBill ? InvBalanceConst.getDirInSelects() : InvBalanceConst.getInSelects();
                invBalFilter = this.getBillStatusf();
                invBalFilter = InvAccRenovatorServiceImpl.filterIsInitBill(formId, invBalFilter);
                outSelets = isDirBill ? InvBalanceConst.getDirOutSelects() : InvBalanceConst.getOutSelects();
                invBalOutFilter = this.getBillStatusf();
                invBalOutFilter = InvAccRenovatorServiceImpl.filterIsInitBill(formId, invBalOutFilter);
                calBalFilter = invBalFilter.copy().and(this.filterRecIsCal(formId));
                calBalOutFilter = invBalOutFilter.copy().and(this.filterSedIsCal(formId));
                calBalFilter.and(new QFilter(inUpdatef, "=", (Object)true));
                calBalOutFilter.and(new QFilter(outUpdatef, "=", (Object)true));
                invBalFilter = invBalFilter.copy().and(this.getInOrOutUpdateFilter("invscheme.isinupdate", formId));
                invBalOutFilter = invBalOutFilter.copy().and(this.getInOrOutUpdateFilter("invscheme.isoutupdate", formId));
            }
            if (this.mdcBillTypeMap.containsKey(formId)) {
                invBalFilter.and(this.getBillTypef(this.mdcBillTypeMap.get(formId)));
                invBalOutFilter.and(this.getBillTypef(this.mdcBillTypeMap.get(formId)));
                calBalFilter.and(this.getBillTypef(this.mdcBillTypeMap.get(formId)));
                calBalOutFilter.and(this.getBillTypef(this.mdcBillTypeMap.get(formId)));
            }
            this.calAllBalance(formId, invBalFilter, selets, invBalOutFilter, outSelets, false);
            this.calAllBalance(formId, calBalFilter, selets, calBalOutFilter, outSelets, true);
        }
    }

    private QFilter getBillStatusf() {
        return new QFilter("billstatus", "=", (Object)BillStatus.C);
    }

    private QFilter getBillTypef(String billtype) {
        return new QFilter("billtype.number", "=", (Object)billtype);
    }

    private void calAllBalance(String formId, QFilter invBalFilter, String selets, QFilter invBalOutFilter, String outSelets, boolean recordAccountBalance) {
        DataSet billData = InvAccRenovatorServiceImpl.getBillDataSet(formId, invBalFilter.toArray(), selets);
        billData = billData.union(InvAccRenovatorServiceImpl.getBillDataSet(formId, invBalOutFilter.toArray(), outSelets));
        this.deleteSnapData(formId, this.getBillIds(billData));
        BalanceHelper.calBillBalanceData((DataSet)billData, (boolean)recordAccountBalance, (boolean)true, (boolean)true);
    }

    @Deprecated
    private void updateInvAccDataZero(Map param) {
    }

    private QFilter[] buildFilter(Map param) {
        return null;
    }

    private void updateInvBalData() {
        Object materialId;
        StringBuilder updateSql = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>(16);
        boolean includeInit = (Boolean)this.param.get("includeinit");
        updateSql.append("update t_im_invbalance set ");
        if (includeInit) {
            updateSql.append("finqty = 0, finbaseqty = 0, finqty2nd = 0, foutqty = 0, foutbaseqty = 0, foutqty2nd = 0, fbgnqty = 0, fbgnbaseqty = 0, fbgnqty2nd = 0 ");
        } else {
            updateSql.append("finqty = 0, finbaseqty = 0, finqty2nd = 0, foutqty = 0, foutbaseqty = 0, foutqty2nd = 0 ");
        }
        Object orgid = this.param.get("orgid");
        paramList.add(orgid);
        updateSql.append("where forgid = ? ");
        Object warehouseId = this.param.get("warehouseid");
        if (warehouseId != null) {
            paramList.add(warehouseId);
            updateSql.append("and fwarehouseid = ? ");
        }
        if ((materialId = this.param.get("materialid")) != null) {
            paramList.add(materialId);
            updateSql.append("and fmaterialid = ? ");
        }
        if (!includeInit) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
            Integer period = Integer.parseInt(simpleDateFormat.format(this.param.get("period")));
            paramList.add(period);
            updateSql.append("and fperiod = ? and fisinit = '0' ");
        } else {
            updateSql.append("and fperiod = 0 and fisinit = '1' ");
        }
        if (invBal.equals(this.param.get("balancetype"))) {
            updateSql.append("and fbalancetype = '1' ");
        } else if (calBal.equals(this.param.get("balancetype"))) {
            updateSql.append("and fbalancetype = '2' ");
        }
        DB.execute((DBRoute)DBRoute.of((String)"im"), (String)updateSql.toString(), (Object[])paramList.toArray(new Object[0]));
    }

    private void deleteSnapData(String formid, List<Object> ids) {
        if (ids.isEmpty()) {
            return;
        }
        Object[] param = new Object[ids.size() + 1];
        StringBuilder deleteSnapSql = new StringBuilder("delete from t_im_invsnapshoot where fformid = ? and fbillid in(");
        param[0] = formid;
        for (int i = 0; i < ids.size(); ++i) {
            deleteSnapSql.append("?,");
            param[i + 1] = ids.get(i);
        }
        deleteSnapSql.deleteCharAt(deleteSnapSql.length() - 1);
        deleteSnapSql.append(')');
        DB.execute((DBRoute)new DBRoute("im"), (String)deleteSnapSql.toString(), (Object[])param);
    }

    private QFilter getOrgWarhosuef(String orgf, String warehousefs, String materialf) {
        QFilter orgWarehosuef = new QFilter(orgf, "=", this.param.get("orgid"));
        orgWarehosuef.and(new QFilter("billstatus", "=", (Object)BillStatus.C));
        if (this.param.get("warehouseid") != null) {
            orgWarehosuef.and(new QFilter(warehousefs, "=", this.param.get("warehouseid")));
        }
        if (this.param.get("materialid") != null) {
            orgWarehosuef.and(new QFilter(materialf, "=", this.param.get("materialid")));
        }
        return orgWarehosuef;
    }

    private void reCalBalance() {
        if (((Boolean)this.param.get("includeinit")).booleanValue()) {
            String selets = InvBalanceConst.getInitSelects();
            QFilter filter = this.getOrgWarhosuef("org", "billentry.warehouse", "billentry.material.masterid");
            DataSet bills = InvAccRenovatorServiceImpl.getBillDataSet("im_initbill", filter.toArray(), selets);
            this.deleteSnapData("im_initbill", this.getBillIds(bills));
            if (invBal.equals(this.param.get("balancetype"))) {
                BalanceHelper.calInitBalanceData((DataSet)bills, (boolean)false, (boolean)true, (boolean)false);
            } else if (calBal.equals(this.param.get("balancetype"))) {
                BalanceHelper.calInitBalanceData((DataSet)bills, (boolean)true, (boolean)true, (boolean)false);
            } else {
                BalanceHelper.calInitBalanceData((DataSet)bills.copy(), (boolean)false, (boolean)true, (boolean)false);
                BalanceHelper.calInitBalanceData((DataSet)bills, (boolean)true, (boolean)true, (boolean)false);
            }
        } else {
            for (String formId : InvBalanceConst.getBalBillList()) {
                QFilter calBalOutFilter;
                QFilter calBalFilter;
                QFilter invBalOutFilter;
                String outSelets;
                QFilter invBalFilter;
                String selets;
                if (formId.equals("im_adjustbill")) {
                    selets = InvBalanceConst.getAdjInSelects();
                    invBalFilter = this.getOrgWarhosuef("org", "billentry.afterentity.warehouse1", "billentry.afterentity.material1.masterid");
                    outSelets = InvBalanceConst.getAdjOutSelects();
                    invBalOutFilter = this.getOrgWarhosuef("org", "billentry.warehouse", "billentry.material.masterid");
                    calBalFilter = invBalFilter.copy().and(this.filterRecIsCal(formId));
                    calBalOutFilter = invBalOutFilter.copy().and(this.filterSedIsCal(formId));
                } else if (formId.equals("im_assembbill")) {
                    selets = InvBalanceConst.getAssInSelects();
                    invBalFilter = this.getOrgWarhosuef("org", "billentry.warehouse", "billentry.material.masterid");
                    outSelets = InvBalanceConst.getAssOutSelects();
                    invBalOutFilter = this.getOrgWarhosuef("org", "billentry.afterentity.warehouse1", "billentry.afterentity.material1.masterid");
                    calBalFilter = invBalFilter.copy().and(this.filterRecIsCal(formId));
                    calBalOutFilter = invBalOutFilter.copy().and(this.filterSedIsCal(formId));
                } else if (formId.equals("im_disassemblebill")) {
                    outSelets = InvBalanceConst.getAdjOutSelects();
                    invBalOutFilter = this.getOrgWarhosuef("org", "billentry.warehouse", "billentry.material.masterid");
                    selets = InvBalanceConst.getAdjInSelects();
                    invBalFilter = this.getOrgWarhosuef("org", "billentry.afterentity.warehouse1", "billentry.afterentity.material1.masterid");
                    calBalFilter = invBalFilter.copy().and(this.filterRecIsCal(formId));
                    calBalOutFilter = invBalOutFilter.copy().and(this.filterSedIsCal(formId));
                } else if (formId.equals("im_locationtransfer")) {
                    selets = InvBalanceConst.getLocInSelects();
                    invBalFilter = this.getOrgWarhosuef("org", "billentry.warehouse", "billentry.material.masterid");
                    outSelets = InvBalanceConst.getLocOutSelects();
                    invBalOutFilter = this.getOrgWarhosuef("org", "billentry.warehouse", "billentry.material.masterid");
                    calBalFilter = invBalFilter.copy().and(this.filterRecIsCal(formId));
                    calBalOutFilter = invBalOutFilter.copy().and(this.filterSedIsCal(formId));
                } else {
                    String inUpdatef = "invscheme.isinupdate";
                    String outUpdatef = "invscheme.isoutupdate";
                    boolean isDirBill = formId.equalsIgnoreCase("im_transdirbill");
                    String orgf = "org";
                    String warehousef = "billentry.warehouse";
                    selets = isDirBill ? InvBalanceConst.getDirInSelects() : InvBalanceConst.getInSelects();
                    invBalFilter = this.getOrgWarhosuef(orgf, warehousef, "billentry.material.masterid");
                    invBalFilter = InvAccRenovatorServiceImpl.filterIsInitBill(formId, invBalFilter);
                    outSelets = isDirBill ? InvBalanceConst.getDirOutSelects() : InvBalanceConst.getOutSelects();
                    orgf = isDirBill ? "outorg" : orgf;
                    warehousef = isDirBill ? "billentry.outwarehouse" : warehousef;
                    invBalOutFilter = this.getOrgWarhosuef(orgf, warehousef, "billentry.material.masterid");
                    invBalOutFilter = InvAccRenovatorServiceImpl.filterIsInitBill(formId, invBalOutFilter);
                    calBalFilter = invBalFilter.copy().and(this.filterRecIsCal(formId));
                    calBalOutFilter = invBalOutFilter.copy().and(this.filterSedIsCal(formId));
                    calBalFilter.and(new QFilter(inUpdatef, "=", (Object)true));
                    calBalOutFilter.and(new QFilter(outUpdatef, "=", (Object)true));
                    invBalFilter = invBalFilter.copy().and(this.getInOrOutUpdateFilter("invscheme.isinupdate", formId));
                    invBalOutFilter = invBalOutFilter.copy().and(this.getInOrOutUpdateFilter("invscheme.isoutupdate", formId));
                }
                if (this.mdcBillTypeMap.containsKey(formId)) {
                    invBalFilter.and(this.getBillTypef(this.mdcBillTypeMap.get(formId)));
                    invBalOutFilter.and(this.getBillTypef(this.mdcBillTypeMap.get(formId)));
                    calBalFilter.and(this.getBillTypef(this.mdcBillTypeMap.get(formId)));
                    calBalOutFilter.and(this.getBillTypef(this.mdcBillTypeMap.get(formId)));
                }
                if (invBal.equals(this.param.get("balancetype"))) {
                    this.calBalance(formId, invBalFilter, selets, invBalOutFilter, outSelets, false);
                    continue;
                }
                if (calBal.equals(this.param.get("balancetype"))) {
                    this.calBalance(formId, calBalFilter, selets, calBalOutFilter, outSelets, true);
                    continue;
                }
                this.calBalance(formId, invBalFilter, selets, invBalOutFilter, outSelets, false);
                this.calBalance(formId, calBalFilter, selets, calBalOutFilter, outSelets, true);
            }
        }
    }

    private void calBalance(String formId, QFilter invBalFilter, String selets, QFilter invBalOutFilter, String outSelets, boolean recordAccountBalance) {
        Date period = DateUtils.getFirstDayOfMonthByDate((Date)((Date)this.param.get("period")));
        Date endPeriod = DateUtils.getMonthEndDayByDate((Date)period);
        invBalFilter.and("biztime", ">=", (Object)period).and("biztime", "<=", (Object)endPeriod);
        invBalOutFilter.and("biztime", ">=", (Object)period).and("biztime", "<=", (Object)endPeriod);
        DataSet billData = InvAccRenovatorServiceImpl.getBillDataSet(formId, invBalFilter.toArray(), selets);
        billData = billData.union(InvAccRenovatorServiceImpl.getBillDataSet(formId, invBalOutFilter.toArray(), outSelets));
        this.deleteSnapData(formId, this.getBillIds(billData));
        BalanceHelper.calBillBalanceData((DataSet)billData, (boolean)recordAccountBalance, (boolean)true, (boolean)false);
    }

    private QFilter filterRecIsCal(String formId) {
        String invCalf = "im_adjustbill".equals(formId) || "im_disassemblebill".equals(formId) ? "billentry.afterentity.invtype1.isforwardamount" : "billentry.invtype.isforwardamount";
        QFilter filters = new QFilter(invCalf, "=", (Object)Boolean.TRUE);
        String ownerf = "im_adjustbill".equals(formId) || "im_disassemblebill".equals(formId) ? "billentry.afterentity.ownertype1" : "billentry.ownertype";
        filters.and(new QFilter(ownerf, "=", (Object)"bos_org"));
        if (!spBills.contains(formId)) {
            filters.and(new QFilter("invscheme.isforwardamount", "=", (Object)Boolean.TRUE));
        }
        if (!spBills.contains(formId) || "im_locationtransfer".equals(formId)) {
            filters.and(new QFilter("billentry.logisticsbill", "=", (Object)Boolean.FALSE));
        }
        return filters;
    }

    private QFilter filterSedIsCal(String formId) {
        QFilter filters = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (!spBills.contains(formId)) {
            filters.and(new QFilter("invscheme.isforwardamount", "=", (Object)Boolean.TRUE));
            filters.and(new QFilter("billentry.outinvtype.isforwardamount", "=", (Object)Boolean.TRUE));
            filters.and(new QFilter("billentry.outownertype", "=", (Object)"bos_org"));
        } else {
            String invCalf = "im_assembbill".equals(formId) ? "billentry.afterentity.invtype1.isforwardamount" : "billentry.invtype.isforwardamount";
            filters.and(new QFilter(invCalf, "=", (Object)Boolean.TRUE));
            String outOwnerf = "im_assembbill".equals(formId) ? "billentry.afterentity.ownertype1" : "billentry.ownertype";
            filters.and(new QFilter(outOwnerf, "=", (Object)"bos_org"));
        }
        if (!spBills.contains(formId) || "im_locationtransfer".equals(formId)) {
            filters.and(new QFilter("billentry.logisticsbill", "=", (Object)Boolean.FALSE));
        }
        return filters;
    }

    private static DataSet getBillDataSet(String formId, QFilter[] filter, String select) {
        return QueryServiceHelper.queryDataSet((String)BalanceHelper.class.getName(), (String)formId, (String)select, (QFilter[])filter, (String)"id");
    }

    private QFilter getInOrOutUpdateFilter(String updateDc, String formId) {
        QFilter filter = new QFilter(updateDc, "=", (Object)Boolean.TRUE);
        filter.and(new QFilter("invscheme.isnotupdate", "=", (Object)Boolean.FALSE));
        DynamicProperty isVirtualBill = EntityMetadataCache.getDataEntityType((String)formId).getProperty("isvirtualbill");
        if (isVirtualBill != null && StringUtils.isNotEmpty((String)isVirtualBill.getAlias())) {
            filter.and(new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE));
        }
        return filter;
    }

    private static QFilter filterIsInitBill(String formId, QFilter balfs) {
        if (balfs != null && MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId), (String)"isinitbill")) {
            balfs.and(new QFilter("isinitbill", "=", (Object)Boolean.FALSE));
        }
        return balfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getBillIds(DataSet billData) {
        ArrayList<Object> ids = new ArrayList<Object>();
        try (DataSet idDs = billData.copy();){
            idDs = idDs.groupBy(new String[]{"billid"}).finish();
            for (Row row : idDs) {
                ids.add(row.get("billid"));
            }
        }
        return ids;
    }
}

