/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.bcmreport;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.report.invbillreport.InvBillSumRptQuery;

public class InvSumBcpRptHandler {
    private static final Log logger = LogFactory.getLog(InvSumBcpRptHandler.class);
    private String selectfield = "";
    private String qtyfield = "";
    private Date commStartDate = null;
    private Date commEndDate = null;

    public BigDecimal handle(String formulaName, List<Object> params, List<String> paramNameList, Map<String, Object> commParam) {
        ReportQueryParam reportQueryParam = new ReportQueryParam();
        FilterInfo filterInfo = new FilterInfo();
        this.resolveDate(commParam);
        this.setFilter(filterInfo, params, paramNameList);
        if (filterInfo.getFilterItems().size() == 0) {
            return BigDecimal.ZERO;
        }
        reportQueryParam.setFilter(filterInfo);
        InvBillSumRptQuery invBillSumRptQuery = new InvBillSumRptQuery();
        DataSet dataSet = null;
        try {
            logger.info("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f:\u5f00\u59cb\u67e5\u8be2\u5e93\u5b58\u7269\u6599\u6536\u53d1\u6c47\u603b\u6570\u636e\u3002");
            dataSet = invBillSumRptQuery.query(reportQueryParam, new Object());
            logger.info("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f:\u67e5\u8be2\u5e93\u5b58\u7269\u6599\u6536\u53d1\u6c47\u603b\u6570\u636e\u7ed3\u675f\u3002");
        }
        catch (Throwable throwable) {
            logger.error("InvSumBcpRptHandler\uff1a\u5e93\u5b58\u53d6\u6570\u516c\u5f0f\u67e5\u8be2\u7269\u6599\u6536\u53d1\u6c47\u603b\u5f02\u5e38\uff1a" + throwable.getMessage() + "\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a", throwable);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"InvSumBcpRptHandler\uff1a\u5e93\u5b58\u53d6\u6570\u516c\u5f0f\u67e5\u8be2\u7269\u6599\u6536\u53d1\u6c47\u603b\u5f02\u5e38,\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"InvSumBcpRptHandler_0", (String)"scmc-im-mservice", (Object[])new Object[0]), throwable.getMessage()));
        }
        if (dataSet == null) {
            logger.info("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f:\u67e5\u8be2\u5e93\u5b58\u7269\u6599\u6536\u53d1\u6c47\u603b\u6570\u636e,\u8fd4\u56de\u7ed3\u679c\u4e3anull");
            return BigDecimal.ZERO;
        }
        String select = this.selectfield + this.qtyfield;
        dataSet = dataSet.select(select).groupBy().sum(select).finish();
        BigDecimal res = BigDecimal.ZERO;
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            res = next.getBigDecimal(select);
        }
        logger.info("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f:\u67e5\u8be2\u5e93\u5b58\u7269\u6599\u6536\u53d1\u6c47\u603b\u6570\u636e\u7ed3\u675f\u3002res = ", (Object)res);
        return res;
    }

    private void resolveDate(Map<String, Object> commParam) {
        logger.info("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f:\u5f00\u59cb\u5904\u7406\u8d22\u5e74\u3001\u671f\u95f4\u65e5\u671f\u3002");
        if (commParam.get("fy") == null || commParam.get("period") == null) {
            return;
        }
        int fy = (Integer)commParam.get("fy");
        int month = (Integer)commParam.get("period");
        String startDateStr = (String)commParam.get("startDate");
        String endDateStr = (String)commParam.get("endDate");
        if (kd.bos.util.StringUtils.isNotEmpty((String)startDateStr) && kd.bos.util.StringUtils.isNotEmpty((String)endDateStr)) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            try {
                this.commStartDate = formatter.parse(startDateStr);
                Calendar calendar = Calendar.getInstance();
                Date endDate = formatter.parse(endDateStr);
                calendar.setTime(endDate);
                this.commEndDate = calendar.getTime();
            }
            catch (ParseException e) {
                logger.error("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f\u5904\u7406\u8d22\u5e74\u3001\u671f\u95f4\u65e5\u671f\u8f6c\u6362\u5f02\u5e38:" + e.getMessage() + "\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a", (Throwable)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"InvSumBcpRptHandler\uff1a\u5e93\u5b58\u53d6\u6570\u516c\u5f0f\u5904\u7406\u8d22\u5e74\u3001\u671f\u95f4\u65e5\u671f\u8f6c\u6362\u5f02\u5e38,\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"InvSumBcpRptHandler_1", (String)"scmc-im-mservice", (Object[])new Object[0]), e.getMessage()));
            }
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(fy, month - 1, 1, 0, 0, 0);
            this.commStartDate = calendar.getTime();
            calendar.add(2, 1);
            this.commEndDate = calendar.getTime();
        }
        logger.info("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f:\u5904\u7406\u8d22\u5e74\u3001\u671f\u95f4\u65e5\u671f\u7ed3\u675f");
    }

    private void setFilter(FilterInfo filterInfo, List<Object> params, List<String> paramNameList) {
        logger.info("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f:\u5f00\u59cb\u586b\u5145\u67e5\u8be2\u6761\u4ef6FilterInfo\u3002");
        String orgNums = null;
        String materialNum = null;
        String invTypeNum = null;
        String invStatusNum = null;
        String ownerNum = null;
        String warehouseNum = null;
        String materialGroupNum = null;
        Date commStartDate = null;
        Date commEndDate = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Map<String, String>> paramList = new ArrayList<Map<String, String>>(params.size());
        for (int i = 0; i < params.size(); ++i) {
            String value = params.get(i).toString();
            String number = paramNameList.get(i);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                HashMap<String, String> multiFieldParamMap = new HashMap<String, String>(4);
                if ("startdate".equals(number)) {
                    try {
                        commStartDate = formatter.parse(value);
                    }
                    catch (ParseException e) {
                        logger.error("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f\u5904\u7406\u624b\u5de5\u8f93\u5165\u7684\u5f00\u59cb\u65e5\u671f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage() + "\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a", (Throwable)e);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"InvSumBcpRptHandler\uff1a\u5e93\u5b58\u53d6\u6570\u516c\u5f0f\u5904\u7406\u624b\u5de5\u8f93\u5165\u7684\u5f00\u59cb\u65e5\u671f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38,\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"InvSumBcpRptHandler_2", (String)"scmc-im-mservice", (Object[])new Object[0]), e.getMessage()));
                    }
                } else if ("enddate".equals(number)) {
                    try {
                        commEndDate = formatter.parse(value);
                    }
                    catch (ParseException e) {
                        logger.error("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f\u5904\u7406\u624b\u5de5\u8f93\u5165\u7684\u7ed3\u675f\u65e5\u671f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage() + "\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a", (Throwable)e);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"InvSumBcpRptHandler\uff1a\u5e93\u5b58\u53d6\u6570\u516c\u5f0f\u5904\u7406\u624b\u5de5\u8f93\u5165\u7684\u7ed3\u675f\u65e5\u671f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38,\u8be6\u7ec6\u4fe1\u606f\uff1a%s\u3002", (String)"InvSumBcpRptHandler_3", (String)"scmc-im-mservice", (Object[])new Object[0]), e.getMessage()));
                    }
                } else if ("org.number".equals(number)) {
                    orgNums = value;
                    multiFieldParamMap.put("entityname", "bos_org");
                    multiFieldParamMap.put("numstr", orgNums);
                    multiFieldParamMap.put("fromfield", "multiorghead");
                    multiFieldParamMap.put("tofield", "orghead");
                } else if ("entry.material.number".equals(number)) {
                    materialNum = value;
                    multiFieldParamMap.put("entityname", "bd_material");
                    multiFieldParamMap.put("numstr", materialNum);
                    multiFieldParamMap.put("fromfield", "materialnumberfrom");
                    multiFieldParamMap.put("tofield", "materialnumberto");
                } else if ("entry.invtype.number".equals(number)) {
                    invTypeNum = value;
                } else if ("entry.invstatus.number".equals(number)) {
                    invStatusNum = value;
                } else if ("entry.owner.number".equals(number)) {
                    ownerNum = value;
                } else if ("entry.warehouse.number".equals(number)) {
                    warehouseNum = value;
                    multiFieldParamMap.put("entityname", "bd_warehouse");
                    multiFieldParamMap.put("numstr", warehouseNum);
                    multiFieldParamMap.put("fromfield", "warehousefrom");
                    multiFieldParamMap.put("tofield", "warehouseto");
                } else if ("materialgroup".equals(number)) {
                    materialGroupNum = value;
                } else if ("selectfield".equals(number)) {
                    this.selectfield = value;
                } else if ("qtyfield".equals(number)) {
                    this.qtyfield = value;
                }
                if (multiFieldParamMap.isEmpty()) continue;
                paramList.add(multiFieldParamMap);
                continue;
            }
            if ("startdate".equals(number)) {
                commStartDate = this.commStartDate;
                continue;
            }
            if (!"enddate".equals(number)) continue;
            commEndDate = this.commEndDate;
        }
        if (commStartDate == null || commEndDate == null) {
            return;
        }
        if (!paramList.isEmpty()) {
            this.handleMultiFilters(filterInfo, paramList);
        }
        DynamicObject owner = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter("number", "=", ownerNum).toArray());
        DynamicObject invType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invtype", (String)"id,number", (QFilter[])new QFilter("number", "=", invTypeNum).toArray());
        DynamicObject invStatus = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invstatus", (String)"id,number", (QFilter[])new QFilter("number", "=", invStatusNum).toArray());
        DynamicObject materialGroup = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialgroup", (String)"id,number", (QFilter[])new QFilter("number", "=", materialGroupNum).toArray());
        DynamicObjectCollection invTypeHead = new DynamicObjectCollection();
        if (invType != null) {
            invTypeHead.add((Object)invType);
        }
        DynamicObjectCollection invStatusHead = new DynamicObjectCollection();
        if (invStatus != null) {
            invStatusHead.add((Object)invStatus);
        }
        DynamicObjectCollection materialGroups = new DynamicObjectCollection();
        if (materialGroup != null) {
            materialGroups.add((Object)materialGroup);
        }
        DynamicObjectCollection accountOnwerFrom = new DynamicObjectCollection();
        if (owner != null) {
            accountOnwerFrom.add((Object)owner);
        }
        filterInfo.addFilterItem("startdate", (Object)commStartDate);
        filterInfo.addFilterItem("enddate", (Object)commEndDate);
        filterInfo.addFilterItem("ivntypehead", (Object)invTypeHead);
        filterInfo.addFilterItem("invstatushead", (Object)invStatusHead);
        filterInfo.addFilterItem("materialgroupfrom", (Object)materialGroups);
        filterInfo.addFilterItem("materialgroupto", (Object)materialGroup);
        filterInfo.addFilterItem("accountownerfrom", (Object)accountOnwerFrom);
        filterInfo.addFilterItem("ownerto", (Object)owner);
        filterInfo.addFilterItem("ownertypehead", (Object)"bos_org");
        filterInfo.addFilterItem("biztypefrom", null);
        filterInfo.addFilterItem("biztypeto", null);
        filterInfo.addFilterItem("invschemefrom", null);
        filterInfo.addFilterItem("invschemeto", null);
        filterInfo.addFilterItem("lotnum", null);
        filterInfo.addFilterItem("project", null);
        filterInfo.addFilterItem("locationfrom", null);
        filterInfo.addFilterItem("locationto", null);
        filterInfo.addFilterItem("auxpty", (Object)0L);
        logger.info("InvSumBcpRptHandler:\u5e93\u5b58\u53d6\u6570\u516c\u5f0f:\u586b\u5145\u67e5\u8be2\u6761\u4ef6FilterInfo\u7ed3\u675f\u3002filterInfo\uff1a" + filterInfo.toString());
    }

    private void handleMultiFilters(FilterInfo filterInfo, List<Map<String, String>> paramList) {
        if (paramList == null || paramList.size() == 0) {
            return;
        }
        for (Map<String, String> map : paramList) {
            String numStr = map.get("numstr");
            String entityName = map.get("entityname");
            String fromField = map.get("fromfield");
            String toField = map.get("tofield");
            if (numStr != null && numStr.split(",").length > 1) {
                Collection dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,number", (QFilter[])new QFilter("number", "in", (Object)numStr.split(",")).toArray()).values();
                DynamicObjectCollection filterHead = new DynamicObjectCollection();
                if (dynamicObjects.size() != 0) {
                    filterHead.addAll(dynamicObjects);
                }
                filterInfo.addFilterItem(fromField, (Object)filterHead);
                continue;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)"id,number,name", (QFilter[])new QFilter("number", "=", (Object)numStr).toArray());
            filterInfo.addFilterItem(fromField, (Object)dynamicObject);
            filterInfo.addFilterItem(toField, (Object)dynamicObject);
        }
    }
}

