/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.count;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillTypeApHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.InvCountSchemeAuditHelper;
import kd.scmc.im.business.helper.InvcountSchemeHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.consts.InvCountSchemeConst;
import kd.scmc.im.enums.InvCountInfoDefultValueEnum;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.im.utils.IMStringUtils;
import kd.sdk.scmc.im.extpoint.IInvCountSchemeAuditExpand;

public class InvCountSchemeAuditServiceImpl
extends BaseECService {
    private static final String algoKey = InvCountSchemeAuditServiceImpl.class.getName();
    private static Log logger = LogFactory.getLog(InvCountSchemeAuditServiceImpl.class);

    protected DtxResponse doExecute(Object param, Object lastReturn) {
        CommonParam commonParam = (CommonParam)param;
        long schemeId = commonParam.getLong((Object)"id");
        DynamicObject invCountScheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"im_invcountscheme");
        String genCountStatus = invCountScheme.getString("gencountstatus");
        String billStatus = invCountScheme.getString("billstatus");
        if ("B".equals(genCountStatus) || !EnumBillStatus.C.toString().equals(billStatus)) {
            return null;
        }
        try {
            this.handleLogic(invCountScheme);
        }
        catch (Exception ex) {
            logger.error(ResManager.loadKDString((String)"\u5ba1\u6838\u76d8\u70b9\u65b9\u6848\u62a5\u9519,\u65e0\u6cd5\u751f\u6210\u76d8\u70b9\u8868\uff0c\u8bf7\u68c0\u67e5\u5404\u4e2a\u76d8\u70b9\u65b9\u6848\u7684\u8bbe\u7f6e\u60c5\u51b5\u3002", (String)"InvCountSchemeAuditServiceImpl_0", (String)"scmc-im-mservice", (Object[])new Object[0]), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        invCountScheme.set("gencountstatus", (Object)"B");
        SaveServiceHelper.update((DynamicObject)invCountScheme);
        return null;
    }

    private void handleLogic(DynamicObject invCountScheme) {
        ArrayList<DynamicObject> finallyInvCountData = new ArrayList<DynamicObject>(16);
        finallyInvCountData.addAll(this.handleDetailLogic(invCountScheme));
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"im_invcountbill", (DynamicObject[])finallyInvCountData.toArray(new DynamicObject[0]), null);
        if (result.getMessage() != null && result.getMessage().length() != 0) {
            StringBuilder errMsg = new StringBuilder();
            List validateErrors = result.getValidateResult().getValidateErrors();
            for (ValidateResult validateError : validateErrors) {
                List allErrorInfo = validateError.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    String message = operateErrorInfo.getMessage();
                    if (errMsg.toString().contains(message)) continue;
                    errMsg.append(message);
                }
            }
            throw new KDBizException(errMsg.toString());
        }
    }

    private List<DynamicObject> handleDetailLogic(DynamicObject invCountSchemeObj) {
        invCountSchemeObj.set("billstatus", (Object)"C");
        String backupcondition = invCountSchemeObj.getString("backupcondition");
        if ("enddateinvacc".equals(backupcondition)) {
            Set<QFilter> setQFilter = this.getListQFilterFromInvCountScheme(invCountSchemeObj);
            DataSet endDateInvAcc = InvCountSchemeAuditHelper.handleEndDateInvAccToInvCountOp((DynamicObject)invCountSchemeObj, setQFilter);
            endDateInvAcc = endDateInvAcc.filter("qty <> 0");
            return this.getInvOrEndDateInvAccToInvCountData(invCountSchemeObj, endDateInvAcc, setQFilter);
        }
        if ("invacc".equals(backupcondition)) {
            Set<QFilter> listQFilter = this.getListQFilterFromInvCountScheme(invCountSchemeObj);
            DataSet invCountDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)InvAccConst.getBalTb(), (String)this.getInvAccQueryField(), (QFilter[])listQFilter.toArray(new QFilter[listQFilter.size()]), null);
            return this.getInvOrEndDateInvAccToInvCountData(invCountSchemeObj, invCountDataSet, listQFilter);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u6570\u636e\u5907\u4efd\u6761\u4ef6\u4e3a\u201c\u622a\u6b62\u4e1a\u52a1\u65e5\u671f\u5e93\u5b58\u201d\u548c\u201c\u5373\u65f6\u5e93\u5b58\u201d\u4e24\u79cd\u65b9\u5f0f\u3002", (String)"InvCountSchemeAuditServiceImpl_1", (String)"scmc-im-mservice", (Object[])new Object[0]));
    }

    private List<DynamicObject> getInvOrEndDateInvAccToInvCountData(DynamicObject invCountSchemeObj, DataSet dataSet, Set<QFilter> listQFilter) {
        Set<String> dimensions = this.getDimenFields(invCountSchemeObj);
        DataSet copyDataSet = dataSet.copy();
        Map<Long, DynamicObject> materialIDAndMaterialInvInfoIdMap = this.getMatIdAndMatInvIdMap(invCountSchemeObj, copyDataSet);
        dimensions.add("org");
        dataSet = dataSet.orderBy(dimensions.toArray(new String[dimensions.size()]));
        return this.preInsertInvCountBillByDimensions(dataSet, invCountSchemeObj, dimensions, materialIDAndMaterialInvInfoIdMap);
    }

    private Map<Long, DynamicObject> getMatIdAndMatInvIdMap(DynamicObject invCountSchemeObj, DataSet dataSet) {
        HashSet<Long> materialFids = new HashSet<Long>(16);
        for (Row row : dataSet) {
            Long materialFid = row.getLong("material") == null ? Long.valueOf(0L) : row.getLong("material");
            materialFids.add(materialFid);
        }
        HashMap<Long, DynamicObject> materialIDAndMaterialInvInfoIdMap = new HashMap<Long, DynamicObject>(16);
        DynamicObject org = (DynamicObject)invCountSchemeObj.get("org");
        QFilter materialInfoQfilter = new QFilter("ctrlstrategy", "=", (Object)"5").or(QFilter.sqlExpress((String)"id", (String)"in", (String)("select fdataid from t_bd_materialinvinfo_U where fuseorgid = " + org.getString("id"))));
        if (BaseDataCommonService.isNewModel((String)"bd_materialinventoryinfo")) {
            materialInfoQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)org.getLong("id"));
        }
        if (materialFids.isEmpty()) {
            return materialIDAndMaterialInvInfoIdMap;
        }
        materialInfoQfilter.and("masterid", "in", materialFids);
        Map matInfos = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"id,masterid", (QFilter[])materialInfoQfilter.toArray(), (String)"status");
        for (DynamicObject matInfo : matInfos.values()) {
            DynamicObject master = matInfo.getDynamicObject("masterid");
            if (master == null) continue;
            materialIDAndMaterialInvInfoIdMap.put((Long)master.getPkValue(), matInfo);
        }
        return materialIDAndMaterialInvInfoIdMap;
    }

    private Set<String> getDimenFields(DynamicObject invCountSchemeObj) {
        DynamicObjectCollection dimensionInfo = (DynamicObjectCollection)invCountSchemeObj.get("dimensionentity");
        HashSet<String> dimen = new HashSet<String>(2);
        if (dimensionInfo != null && dimensionInfo.size() > 0) {
            for (int i = 0; i < dimensionInfo.size(); ++i) {
                String dimension = (String)((DynamicObject)dimensionInfo.get(i)).get("dimension");
                if (null == dimension || dimension.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u76d8\u70b9\u65b9\u6848\u5206\u5355\u89c4\u5219\u5b58\u5728\u7a7a\u884c\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvCountSchemeAuditServiceImpl_2", (String)"scmc-im-mservice", (Object[])new Object[0]));
                }
                dimen.add(((DynamicObject)dimensionInfo.get(i)).get("dimension").toString());
            }
        }
        return dimen;
    }

    private void setHeadValueNewInvCountDys(DynamicObject invCountSchemeObj, DynamicObject invCountObj, String sbDimenStr) {
        DynamicObjectCollection mulorgs = invCountSchemeObj.getDynamicObjectCollection("mulorg");
        DynamicObject org = invCountSchemeObj.getDynamicObject("org");
        if (mulorgs.isEmpty()) {
            invCountObj.set("org", (Object)org);
        } else {
            List<String> splitDimenList = Arrays.asList(sbDimenStr.split(","));
            for (DynamicObject mulorg : mulorgs) {
                String orgIdStr = mulorg.getString("fbasedataid_id");
                if (!splitDimenList.contains(orgIdStr)) continue;
                invCountObj.set("org", mulorg.get("fbasedataid"));
            }
        }
        invCountObj.set("billstatus", (Object)"A");
        Long billtype = BillTypeApHelper.getDefaultBillTypeId((String)"im_invcountbill");
        if (billtype == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u76d8\u70b9\u8868\u7684\u5355\u636e\u7c7b\u578b\uff0c\u7a0d\u540e\u518d\u8bd5\u3002", (String)"InvCountSchemeAuditServiceImpl_3", (String)"scmc-im-mservice", (Object[])new Object[0]));
        }
        invCountObj.set("billtype", (Object)billtype);
        invCountObj.set("backupcondition", invCountSchemeObj.get("backupcondition"));
        invCountObj.set("creator", (Object)RequestContext.get().getUserId());
        this.initBizDataByOrg(invCountObj);
        invCountObj.set("createtime", (Object)new Date());
        invCountObj.set("defaultvalue", invCountSchemeObj.get("defaultvalue"));
        invCountObj.set("counttype", invCountSchemeObj.get("counttype"));
        invCountObj.set("schemenumber", invCountSchemeObj.get("billno"));
        invCountObj.set("schemename", invCountSchemeObj.get("schemename"));
        invCountObj.set("biztime", (Object)new Date());
        if ("enddateinvacc".equals(invCountSchemeObj.getString("backupcondition"))) {
            invCountObj.set("invaccdate", (Object)invCountSchemeObj.getDate("enddate"));
        } else {
            invCountObj.set("invaccdate", (Object)new Date());
        }
        invCountObj.set("schemeid", invCountSchemeObj.getPkValue());
        invCountObj.set("enablecheck", invCountSchemeObj.get("enablecheck"));
        invCountObj.set("accessnode", invCountSchemeObj.get("accessnode"));
        invCountObj.set("excludeenddate", invCountSchemeObj.get("excludeenddate"));
        invCountObj.set("nogenotherinout", invCountSchemeObj.get("nogenotherinout"));
        Map<String, String> fieldMap = this.getFieldMap();
        for (Map.Entry<String, String> map : fieldMap.entrySet()) {
            String countSchemeFiledKey = map.getKey();
            String countFieldKey = map.getValue();
            invCountObj.set(countFieldKey, invCountSchemeObj.get(countSchemeFiledKey));
        }
    }

    private Map<String, String> getFieldMap() {
        PluginProxy proxyPlugins = PluginProxy.create(IInvCountSchemeAuditExpand.class, (String)"SCMC_IM_INV_COUNTSCHEMEAUDIT");
        List plugins = proxyPlugins.getPlugins();
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        for (IInvCountSchemeAuditExpand plugin : plugins) {
            fieldMap.putAll(plugin.getFieldMap());
        }
        return fieldMap;
    }

    private void initBizDataByOrg(DynamicObject invCountObj) {
        DynamicObject org = (DynamicObject)invCountObj.get("org");
        if (org == null) {
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        Long orgId = (Long)org.getPkValue();
        this.initDept(userId, orgId, invCountObj);
    }

    private void initDept(long userId, Long orgId, DynamicObject invCountObj) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        DynamicObject orgOrg = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        if (deptIds != null && deptIds.size() > 0) {
            orgOrg.set("id", deptIds.get(0));
            invCountObj.set("dept", (Object)orgOrg);
            return;
        }
        deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptIds != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
            orgOrg.set("id", (Object)orgId);
            invCountObj.set("dept", (Object)orgOrg);
            return;
        }
    }

    private List<DynamicObject> preInsertInvCountBillByDimensions(DataSet dataSet, DynamicObject invCountSchemeObj, Set<String> dimensions, Map<Long, DynamicObject> materialIDAndMaterialInvInfoIdMap) {
        ArrayList<DynamicObject> listInvCountObj = new ArrayList<DynamicObject>(16);
        DynamicObject invCountObj = null;
        DynamicObjectCollection billentryCollection = null;
        DynamicObject entryDynamicObject = null;
        StringBuilder sbDimensions = new StringBuilder();
        HashSet<String> setDimensionsValueHash = new HashSet<String>(16);
        ArrayList<Long> materialIdIsProblem = new ArrayList<Long>(16);
        int seq = 1;
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            for (String dimension : dimensions) {
                Object valueByDimension = row.get(dimension);
                if (valueByDimension == null) continue;
                sbDimensions.append(valueByDimension.toString());
                sbDimensions.append(",");
            }
            String sbDimenStr = sbDimensions.substring(0, sbDimensions.lastIndexOf(","));
            if (setDimensionsValueHash.add(sbDimenStr)) {
                invCountObj = BusinessDataServiceHelper.newDynamicObject((String)"im_invcountbill");
                this.setHeadValueNewInvCountDys(invCountSchemeObj, invCountObj, sbDimenStr);
                billentryCollection = (DynamicObjectCollection)invCountObj.get("billentry");
                entryDynamicObject = billentryCollection.addNew();
                listInvCountObj.add(invCountObj);
                seq = 1;
            } else {
                if (invCountObj == null) {
                    invCountObj = BusinessDataServiceHelper.newDynamicObject((String)"im_invcountbill");
                }
                entryDynamicObject = billentryCollection == null ? ((DynamicObjectCollection)invCountObj.get("billentry")).addNew() : billentryCollection.addNew();
            }
            sbDimensions = new StringBuilder();
            this.setValueForInvCountByRow(entryDynamicObject, row, invCountSchemeObj, materialIDAndMaterialInvInfoIdMap, materialIdIsProblem, fieldNames);
            entryDynamicObject.set("seq", (Object)seq);
            ++seq;
        }
        if (billentryCollection == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76d8\u70b9\u65b9\u6848\u201c{0}\u201d\u5ba1\u6838\u751f\u6210\u76d8\u70b9\u8868\u65f6\u672a\u53d1\u73b0\u76f8\u5173\u8d26\u5b58\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"InvCountSchemeAuditServiceImpl_6", (String)"scmc-im-mservice", (Object[])new Object[]{invCountSchemeObj.get("billno")}));
        }
        return listInvCountObj;
    }

    private void checkMaterialBeforeSave(List<Long> materialIdIsProblem) {
        if (materialIdIsProblem.size() == 0) {
            return;
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_materialinventoryinfo", (String)"createorg,createorg.name,masterid,masterid.name", (QFilter[])new QFilter("masterid", "in", materialIdIsProblem).toArray());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String append = ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0\u201c{0}\u201d\u3001ID:\u201c{1}\u201d\u5bf9\u5e94\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u5904\u4e8e\u672a\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u5ba1\u6838\u4e4b\u540e\u518d\u8bd5\u3002", (String)"InvCountSchemeAuditServiceImpl_8", (String)"scmc-im-mservice", (Object[])new Object[]{dynamicObject.get("masterid.name"), dynamicObject.get("masterid.id")});
            sb.append(append);
        }
        if (sb.toString().isEmpty()) {
            throw new KDBizException(IMStringUtils.append((String)ResManager.loadKDString((String)"\u76d8\u70b9\u65b9\u6848\u5ba1\u6838\u65f6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u7269\u6599ID\uff1a", (String)"InvCountSchemeAuditServiceImpl_9", (String)"scmc-im-mservice", (Object[])new Object[0]), (Object[])new Object[]{materialIdIsProblem.toString()}));
        }
        throw new KDBizException(sb.toString());
    }

    private void setValueForInvCountByRow(DynamicObject entryDynamicObject, Row row, DynamicObject invCountSchemeObj, Map<Long, DynamicObject> materialIDAndMaterialInvInfoIdMap, List<Long> materialIdIsProblem, String[] fieldNames) {
        for (String fieldName : fieldNames) {
            if ("org".equals(fieldName)) continue;
            if ("material".equals(fieldName)) {
                Long materialFid;
                Long l = materialFid = row.getLong("material") == null ? Long.valueOf(0L) : row.getLong("material");
                if (materialIDAndMaterialInvInfoIdMap.get(materialFid) == null) {
                    materialIdIsProblem.add(materialFid);
                }
                entryDynamicObject.set("material", (Object)materialIDAndMaterialInvInfoIdMap.get(materialFid));
                continue;
            }
            entryDynamicObject.set(fieldName, row.get(fieldName));
        }
        entryDynamicObject.set("sourceflag", (Object)0);
        entryDynamicObject.set("srcbillentity", (Object)"im_invcountscheme");
        entryDynamicObject.set("entrycomment", (Object)" ");
        String backupcondition = invCountSchemeObj.getString("backupcondition");
        if (!"enddateinvacc".equals(backupcondition)) {
            entryDynamicObject.set("invaccid", row.get("invaccid"));
        } else {
            entryDynamicObject.set("invaccid", (Object)0);
        }
        this.setEntriesQtyRelatedValue(entryDynamicObject, row, invCountSchemeObj);
    }

    private void setEntriesQtyRelatedValue(DynamicObject entryDynamicObject, Row row, DynamicObject invCountSchemeObj) {
        BigDecimal qty = row.getBigDecimal("qty");
        boolean enablecheck = (Boolean)invCountSchemeObj.get("enablecheck");
        if (qty.compareTo(BigDecimal.ZERO) >= 0) {
            if (InvCountInfoDefultValueEnum.ZERO.getValue().equals(invCountSchemeObj.get("defaultvalue"))) {
                entryDynamicObject.set("qty", (Object)0);
                entryDynamicObject.set("checkqty", (Object)0);
                entryDynamicObject.set("lossqty", (Object)qty);
                entryDynamicObject.set("gainqty", (Object)0);
            } else {
                entryDynamicObject.set("qty", (Object)qty);
                BigDecimal chechQty = BigDecimal.ZERO;
                if (enablecheck) {
                    chechQty = qty;
                }
                entryDynamicObject.set("checkqty", (Object)chechQty);
                entryDynamicObject.set("lossqty", (Object)0);
                entryDynamicObject.set("gainqty", (Object)0);
            }
        } else {
            entryDynamicObject.set("qty", (Object)0);
            entryDynamicObject.set("checkqty", (Object)0);
            entryDynamicObject.set("lossqty", (Object)0);
            entryDynamicObject.set("gainqty", (Object)qty.abs());
        }
        entryDynamicObject.set("qtyacc", (Object)qty);
        entryDynamicObject.set("unit", (Object)row.getLong("unit"));
        BigDecimal baseqty = row.getBigDecimal("baseqty");
        if (baseqty.compareTo(BigDecimal.ZERO) >= 0) {
            if (InvCountInfoDefultValueEnum.ZERO.getValue().equals(invCountSchemeObj.get("defaultvalue"))) {
                entryDynamicObject.set("baseqty", (Object)0);
                entryDynamicObject.set("checkbaseqty", (Object)0);
                entryDynamicObject.set("baselossqty", (Object)baseqty);
                entryDynamicObject.set("basegainqty", (Object)0);
            } else {
                entryDynamicObject.set("baseqty", (Object)baseqty);
                BigDecimal baseChechQty = BigDecimal.ZERO;
                if (enablecheck) {
                    baseChechQty = baseqty;
                }
                entryDynamicObject.set("checkbaseqty", (Object)baseChechQty);
                entryDynamicObject.set("baselossqty", (Object)0);
                entryDynamicObject.set("basegainqty", (Object)0);
            }
        } else {
            entryDynamicObject.set("baseqty", (Object)0);
            entryDynamicObject.set("checkbaseqty", (Object)0);
            entryDynamicObject.set("baselossqty", (Object)0);
            entryDynamicObject.set("basegainqty", (Object)baseqty.abs());
        }
        entryDynamicObject.set("baseqtyacc", (Object)baseqty);
        entryDynamicObject.set("baseunit", (Object)row.getLong("baseunit"));
        BigDecimal qty2nd = row.getBigDecimal("qtyunit2nd");
        if (qty2nd.compareTo(BigDecimal.ZERO) >= 0) {
            if (InvCountInfoDefultValueEnum.ZERO.getValue().equals(invCountSchemeObj.get("defaultvalue"))) {
                entryDynamicObject.set("qtyunit2nd", (Object)0);
                entryDynamicObject.set("checkqtyunit2nd", (Object)0);
                entryDynamicObject.set("lossqty2nd", (Object)qty2nd);
                entryDynamicObject.set("gainqty2nd", (Object)0);
            } else {
                entryDynamicObject.set("qtyunit2nd", (Object)qty2nd);
                BigDecimal chechQty2nd = BigDecimal.ZERO;
                if (enablecheck) {
                    chechQty2nd = qty2nd;
                }
                entryDynamicObject.set("checkqtyunit2nd", (Object)chechQty2nd);
                entryDynamicObject.set("lossqty2nd", (Object)0);
                entryDynamicObject.set("gainqty2nd", (Object)0);
            }
        } else {
            entryDynamicObject.set("qtyunit2nd", (Object)0);
            entryDynamicObject.set("checkqtyunit2nd", (Object)0);
            entryDynamicObject.set("lossqty2nd", (Object)0);
            entryDynamicObject.set("gainqty2nd", (Object)qty2nd.abs());
        }
        entryDynamicObject.set("qty2ndacc", (Object)qty2nd);
        entryDynamicObject.set("unit2nd", (Object)row.getLong("unit2nd"));
    }

    private Set<QFilter> getListQFilterFromInvCountScheme(DynamicObject invCountSchemeObj) {
        String backupcondition;
        List<Long> excludeWarehouseIds;
        Set<Long> materialIds;
        List<Long> locationIDs;
        ArrayList<QFilter> listQFilter = new ArrayList<QFilter>();
        String filterString = invCountSchemeObj.getString("filterstring_tag");
        if (!"".equals(filterString)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterString, FilterCondition.class);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)InvAccConst.getBalTb());
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter filter = filterBuilder.getQFilter();
            if (filter != null) {
                this.cycleCallQFilter(filter, listQFilter);
            }
        }
        List<Long> orgIds = this.getOrgIds(invCountSchemeObj);
        listQFilter.add(new QFilter("org", "in", orgIds));
        List<Long> wareHouseIDs = this.getWareHouseIDs(invCountSchemeObj);
        if (wareHouseIDs.size() > 0) {
            listQFilter.add(new QFilter("warehouse", "in", wareHouseIDs));
        }
        if ((locationIDs = this.getLocationIds(invCountSchemeObj)).size() > 0) {
            listQFilter.add(new QFilter("location", "in", locationIDs));
        }
        if ((materialIds = this.getMasterMaterialIds(invCountSchemeObj)) != null && materialIds.size() > 0) {
            listQFilter.add(new QFilter("material", "in", materialIds));
        }
        if (!(excludeWarehouseIds = this.getExcludeWarehouseIds(invCountSchemeObj)).isEmpty()) {
            listQFilter.add(new QFilter("warehouse", "not in", excludeWarehouseIds));
        }
        if ("enddateinvacc".equals(backupcondition = invCountSchemeObj.getString("backupcondition"))) {
            return new HashSet<QFilter>(listQFilter);
        }
        if (!((Boolean)invCountSchemeObj.get("countzeroinv")).booleanValue()) {
            listQFilter.add(new QFilter("qty", "<>", (Object)0));
        }
        return new HashSet<QFilter>(listQFilter);
    }

    private List<Long> getExcludeWarehouseIds(DynamicObject invCountSchemeObj) {
        ArrayList<Long> warehouseIDs = new ArrayList<Long>(16);
        List<Long> orgIds = this.getOrgIds(invCountSchemeObj);
        QFilter qFilter = new QFilter("org.id", "in", orgIds);
        Date endDate = invCountSchemeObj.getDate("enddate");
        endDate = DateUtils.getDayStartTime((Date)endDate);
        String accessNode = invCountSchemeObj.getString("accessnode");
        String cp = ">";
        if ("start".equals(accessNode)) {
            cp = ">=";
        }
        qFilter.and("startdate", cp, (Object)endDate);
        Map whsSetupMap = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"warehouse", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject whsSetup : whsSetupMap.values()) {
            if (whsSetup.getDynamicObject("warehouse") == null) continue;
            warehouseIDs.add((Long)whsSetup.getDynamicObject("warehouse").getPkValue());
        }
        return warehouseIDs;
    }

    private void cycleCallQFilter(QFilter qFilter, List<QFilter> listQFilter) {
        List listQFilterNest = qFilter.getNests(true);
        if (listQFilterNest.isEmpty()) {
            Object value = qFilter.getValue();
            if ("EMPTY".equals(String.valueOf(value))) {
                return;
            }
            listQFilter.add(qFilter);
        } else {
            QFilter qFilterParent = new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue());
            listQFilter.add(qFilterParent);
            for (QFilter.QFilterNest qFilterNest : listQFilterNest) {
                this.cycleCallQFilter(qFilterNest.getFilter(), listQFilter);
            }
        }
    }

    private List<Long> getOrgIds(DynamicObject invCountSchemeObj) {
        DynamicObjectCollection mulorgs = invCountSchemeObj.getDynamicObjectCollection("mulorg");
        DynamicObject org = invCountSchemeObj.getDynamicObject("org");
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        if (!mulorgs.isEmpty()) {
            for (DynamicObject mulorg : mulorgs) {
                orgIds.add(mulorg.getLong("fbasedataid_id"));
            }
        } else {
            orgIds.add(org.getLong("id"));
        }
        return orgIds;
    }

    private List<Long> getWareHouseIDs(DynamicObject invCountSchemeObj) {
        List<Long> warehouseIds = new ArrayList(16);
        DynamicObjectCollection warehouses = invCountSchemeObj.getDynamicObjectCollection("warehouse");
        if (warehouses != null && warehouses.size() > 0) {
            for (DynamicObject warehouse : warehouses) {
                warehouseIds.add(warehouse.getLong("fbasedataid_id"));
            }
        } else {
            List<Long> orgIds = this.getOrgIds(invCountSchemeObj);
            warehouseIds = WarehouseHelper.getAllFinishInitWarehouseIDsByOrgIds(orgIds);
            if (warehouseIds.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u7684\u4ed3\u5e93\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"InvCountSchemeAuditServiceImpl_10", (String)"scmc-im-mservice", (Object[])new Object[0]));
            }
        }
        return warehouseIds;
    }

    private List<Long> getLocationIds(DynamicObject invCountSchemeObj) {
        ArrayList<Long> locationIds = new ArrayList<Long>(10);
        DynamicObjectCollection locations = invCountSchemeObj.getDynamicObjectCollection("location");
        if (locations != null && locations.size() > 0) {
            for (int i = 0; i < locations.size(); ++i) {
                locationIds.add(((DynamicObject)locations.get(i)).getLong("fbasedataid_id"));
            }
        }
        return locationIds;
    }

    private Set<Long> getMasterMaterialIds(DynamicObject invCountSchemeObj) {
        HashSet<Long> masterMaterialIds = null;
        DynamicObjectCollection masterMaterialSelected = invCountSchemeObj.getDynamicObjectCollection("material");
        if (masterMaterialSelected != null && masterMaterialSelected.size() > 0) {
            masterMaterialIds = new HashSet<Long>(masterMaterialSelected.size());
            for (int i = 0; i < masterMaterialSelected.size(); ++i) {
                DynamicObject masterMaterialDy = (DynamicObject)masterMaterialSelected.get(i);
                Long masterMaterialId = masterMaterialDy.getLong("fbasedataid_id");
                masterMaterialIds.add(masterMaterialId);
            }
        }
        return masterMaterialIds;
    }

    private String getInvAccQueryField() {
        HashMap<String, String> mapper = new HashMap<String, String>(8);
        mapper.put("lotnumber", "lotnum");
        mapper.put("qtyunit2nd", "qty2nd");
        Set dymaccModelDimension = InvCountSchemeConst.getDymaccModelDimension();
        String[] dimension = InvcountSchemeHelper.addFileds((String[])dymaccModelDimension.toArray(new String[0]), (String[])new String[]{"id as invaccid"});
        String[] mapperFields = InvcountSchemeHelper.mapperFileds((String[])dimension, mapper, (String[])new String[]{"biztime"});
        return InvcountSchemeHelper.arraysToString((String[])mapperFields);
    }
}

