/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.event.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class InvInvokeCalService {
    private static final Log logger = LogFactory.getLog(InvInvokeCalService.class);
    private String formId;
    private String operate;
    private List<Object> pkIds;

    public InvInvokeCalService(String formId, String operate, List<Object> pkIds) {
        this.formId = formId;
        this.operate = operate;
        this.pkIds = pkIds;
    }

    public void invoke() {
        if ("im_purreceivebill".equals(this.formId)) {
            return;
        }
        if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0001")) {
            logger.info("\u7cfb\u7edf\u8054\u7528\u53c2\u6570\u672a\u542f\u7528,\u4e0d\u8c03\u7528\u6838\u7b97\u670d\u52a1\uff1a" + this.formId + "|" + this.operate + "|" + this.pkIds);
            return;
        }
        logger.info("\u5f00\u59cb\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a" + this.formId + "|" + this.operate + "|" + this.pkIds);
        if (SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0005") && "audit".equals(this.operate)) {
            return;
        }
        DynamicObject[] billDycs = this.getSimpleBillDycs();
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{this.operate.toUpperCase(), null, billDycs});
        logger.info("\u7ed3\u675f\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a" + this.formId + "|" + this.operate + "|" + this.pkIds);
    }

    private DynamicObject[] getSimpleBillDycs() {
        QFilter qFilter = new QFilter("id", "in", this.pkIds);
        StringBuilder selector = new StringBuilder();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.formId);
        String mainOrgName = dataEntityType.getMainOrg();
        selector.append("id").append(",").append("billno").append(",").append("billstatus").append(",").append(mainOrgName).append(",").append("auditor").append(",").append("modifytime").append(",").append("auditdate").append(",").append("biztime").append(",").append("bookdate");
        DynamicObject[] billDycs = BusinessDataServiceHelper.load((String)this.formId, (String)selector.toString(), (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> simpleDys = new ArrayList<DynamicObject>(billDycs.length);
        ArrayList<Object> deletedBizBillIds = new ArrayList<Object>(this.pkIds);
        for (int i = 0; i < billDycs.length; ++i) {
            DynamicObject simpleDy = BusinessDataServiceHelper.newDynamicObject((String)this.formId);
            simpleDy.set("id", billDycs[i].get("id"));
            simpleDy.set("billno", billDycs[i].get("billno"));
            simpleDy.set("billstatus", billDycs[i].get("billstatus"));
            simpleDy.set(mainOrgName, billDycs[i].get(mainOrgName));
            simpleDy.set("auditor", billDycs[i].get("auditor"));
            simpleDy.set("modifytime", billDycs[i].get("modifytime"));
            simpleDy.set("auditdate", billDycs[i].get("auditdate"));
            simpleDy.set("biztime", billDycs[i].get("biztime"));
            simpleDy.set("bookdate", billDycs[i].get("bookdate"));
            simpleDys.add(simpleDy);
            deletedBizBillIds.remove(billDycs[i].get("id"));
        }
        this.buildDeleteBillDycs(simpleDys, deletedBizBillIds);
        return simpleDys.toArray(new DynamicObject[0]);
    }

    private void buildDeleteBillDycs(List<DynamicObject> simpleDys, List<Object> deletedBizBillIds) {
        if (deletedBizBillIds.isEmpty()) {
            return;
        }
        if ("UNSUBMIT".equalsIgnoreCase(this.operate.toUpperCase()) || "UNAUDIT".equalsIgnoreCase(this.operate.toUpperCase())) {
            QFilter costRecordFilter = new QFilter("bizbillid", "in", deletedBizBillIds);
            costRecordFilter.and("bizentityobject.number", "=", (Object)this.formId);
            try (DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-queryCostRecord4ConstructBizBill"), (String)"cal_costrecord", (String)"bizbillid,billnumber,auditor,auditor.number,storageorgunit,storageorgunit.number,bizdate,bookdate", (QFilter[])costRecordFilter.toArray(), null).groupBy(new String[]{"bizbillid", "billnumber", "auditor", "auditor.number", "storageorgunit", "storageorgunit.number", "bizdate", "bookdate"}).finish();){
                for (Row row : costRecordDataSet) {
                    DynamicObject bizbill = BusinessDataServiceHelper.newDynamicObject((String)this.formId);
                    bizbill.set("id", (Object)row.getLong("bizbillid"));
                    bizbill.set("billno", row.get("billnumber"));
                    DynamicObject auditor = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                    auditor.set("id", row.get("auditor"));
                    auditor.set("number", row.get("auditor.number"));
                    bizbill.set("auditor", (Object)auditor);
                    DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                    org.set("id", row.get("storageorgunit"));
                    org.set("number", row.get("storageorgunit.number"));
                    bizbill.set("org", (Object)org);
                    bizbill.set("biztime", row.get("bizdate"));
                    bizbill.set("bookdate", row.get("bookdate"));
                    simpleDys.add(bizbill);
                }
            }
        }
    }
}

