/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.mobile;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.mservice.api.mobile.InvPropChange4Mobile;

public class TransApplyPropChangeServiceImpl
implements InvPropChange4Mobile {
    private static final String BOS_ORG = "bos_org";
    private int precision = 2;

    public DynamicObject propChange4Mob(DynamicObject entity, List<String> headFieldKeys, Map<Long, List<String>> changeInfo) {
        String currencyName;
        DynamicObject currency;
        if (entity == null || changeInfo == null || changeInfo.isEmpty()) {
            return entity;
        }
        String formId = entity.getDataEntityType().getName();
        String transType = "";
        if ("im_transapply".equals(formId)) {
            transType = entity.getString("transtype");
        }
        if (("im_transdirbill".equals(formId) || "im_materialreqoutbill".equals(formId)) && (currency = entity.getDynamicObject(currencyName = "im_transdirbill".equals(formId) ? "settlescurrency" : "settlecurrency")) != null) {
            this.precision = currency.getInt("amtprecision");
        }
        DynamicObjectCollection billEntry = entity.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billEntry) {
            Long entryId = entry.getLong("id");
            List<String> changeFields = changeInfo.get(entryId);
            if (changeFields == null || changeFields.isEmpty()) continue;
            Iterator<String> iterator = changeFields.iterator();
            while (iterator.hasNext()) {
                String changeField;
                switch (changeField = iterator.next()) {
                    case "qty": {
                        this.changeQty(entry, formId);
                        break;
                    }
                    case "outorg": {
                        this.changeOutOrg(entry, transType, changeFields);
                        break;
                    }
                    case "inorg": {
                        this.changeInOrg(entry, transType, changeFields);
                        break;
                    }
                    case "warehouse": {
                        this.changeWarehouse(entry, "warehouse", changeFields);
                        break;
                    }
                    case "inwarehouse": {
                        this.changeWarehouse(entry, "inwarehouse", changeFields);
                        break;
                    }
                    case "outwarehouse": {
                        this.changeWarehouse(entry, "outwarehouse", changeFields);
                        break;
                    }
                }
            }
        }
        return entity;
    }

    private void changeQty(DynamicObject entry, String formId) {
        boolean isConvert;
        DynamicObject materialInfo;
        BigDecimal qty = entry.getBigDecimal("qty");
        if ("im_transapply".equals(formId)) {
            entry.set("auditqty", (Object)qty);
        }
        if ("im_transdirbill".equals(formId) || "im_materialreqoutbill".equals(formId)) {
            this.setAmount(entry);
        }
        if ((materialInfo = entry.getDynamicObject("material")) == null) {
            return;
        }
        DynamicObject material = materialInfo.getDynamicObject("masterid");
        if (material == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u7269\u6599\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"TransApplyPropChangeServiceImpl_1", (String)"scmc-im-mservice", (Object[])new Object[0]));
        }
        DynamicObject unit = entry.getDynamicObject("unit");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
        entry.set("baseqty", (Object)baseQty);
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        String unitConvertDir = material.getString("unitconvertdir");
        boolean bl = isConvert = "A".equals(unitConvertDir) || "C".equals(unitConvertDir);
        if (!isConvert) {
            return;
        }
        BigDecimal qtyUnit2nd = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxptyUnit);
        entry.set("qtyunit2nd", (Object)qtyUnit2nd);
    }

    private void changeOutOrg(DynamicObject entry, String transType, List<String> changeFields) {
        if ("A".equals(transType)) {
            this.transInChange(entry, changeFields);
        } else {
            this.transOutChange(entry, changeFields);
        }
    }

    private void transOutChange(DynamicObject entry, List<String> changeFields) {
        DynamicObject outOrg = entry.getDynamicObject("outorg");
        if (outOrg == null) {
            entry.set("warehouse", null);
            entry.set("location", null);
            entry.set("owner", null);
            entry.set("keeper", null);
            return;
        }
        if (!changeFields.contains("warehouse")) {
            entry.set("warehouse", null);
        }
        if (!changeFields.contains("location")) {
            entry.set("location", null);
        }
        String ownerType = entry.getString("ownertype");
        Long ownerId = (Long)OwnerHelper.getOwnerDefValue((Long)outOrg.getLong("id"));
        DynamicObject owner = BusinessDataServiceHelper.newDynamicObject((String)BOS_ORG);
        owner.set("id", (Object)ownerId);
        entry.set("owner", BOS_ORG.equals(ownerType) ? owner : null);
        String keeperType = entry.getString("keepertype");
        entry.set("keeper", BOS_ORG.equals(keeperType) ? outOrg : null);
    }

    private void transInChange(DynamicObject entry, List<String> changeFields) {
        DynamicObject outOrg = entry.getDynamicObject("outorg");
        if (outOrg == null) {
            entry.set("warehouse", null);
            entry.set("inwarehouse", null);
            entry.set("location", null);
            entry.set("inlocation", null);
            entry.set("owner", null);
            entry.set("inowner", null);
            entry.set("keeper", null);
            entry.set("inkeeper", null);
            return;
        }
        if (!changeFields.contains("warehouse")) {
            entry.set("warehouse", null);
        }
        if (!changeFields.contains("inwarehouse")) {
            entry.set("inwarehouse", null);
        }
        if (!changeFields.contains("location")) {
            entry.set("location", null);
        }
        if (!changeFields.contains("inlocation")) {
            entry.set("inlocation", null);
        }
        entry.set("inorg", (Object)outOrg);
        String ownerType = entry.getString("ownertype");
        Long ownerId = (Long)OwnerHelper.getOwnerDefValue((Long)outOrg.getLong("id"));
        DynamicObject owner = BusinessDataServiceHelper.newDynamicObject((String)BOS_ORG);
        owner.set("id", (Object)ownerId);
        entry.set("owner", BOS_ORG.equals(ownerType) ? owner : null);
        String inOwnerType = entry.getString("inownertype");
        entry.set("inowner", BOS_ORG.equals(inOwnerType) ? owner : null);
        String keeperType = entry.getString("keepertype");
        entry.set("keeper", BOS_ORG.equals(keeperType) ? outOrg : null);
        String inKeeperType = entry.getString("inkeepertype");
        entry.set("inkeeper", BOS_ORG.equals(inKeeperType) ? outOrg : null);
    }

    private void changeInOrg(DynamicObject entry, String transType, List<String> changeFields) {
        if ("A".equals(transType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u8c03\u62e8\u4e0d\u5141\u8bb8\u4fee\u6539\u5206\u5f55\u8c03\u5165\u7ec4\u7ec7\u3002", (String)"TransApplyPropChangeServiceImpl_2", (String)"scmc-im-mservice", (Object[])new Object[0]));
        }
        DynamicObject inOrg = entry.getDynamicObject("inorg");
        if (inOrg == null) {
            entry.set("inwarehouse", null);
            entry.set("inlocation", null);
            entry.set("inowner", null);
            entry.set("inkeeper", null);
            return;
        }
        Long inOrgId = inOrg.getLong("id");
        if (!changeFields.contains("inwarehouse")) {
            entry.set("inwarehouse", null);
        }
        if (!changeFields.contains("inlocation")) {
            entry.set("inlocation", null);
        }
        if (!changeFields.contains("inowner")) {
            String inOwnerType = entry.getString("inownertype");
            DynamicObject owner = null;
            if (BOS_ORG.equals(inOwnerType)) {
                Long ownerId = (Long)OwnerHelper.getOwnerDefValue((Long)inOrgId);
                owner = BusinessDataServiceHelper.newDynamicObject((String)BOS_ORG);
                owner.set("id", (Object)ownerId);
            }
            entry.set("inowner", owner);
        }
        if (!changeFields.contains("inkeeper")) {
            String inKeeperType = entry.getString("inkeepertype");
            entry.set("inkeeper", BOS_ORG.equals(inKeeperType) ? inOrg : null);
        }
    }

    private void changeWarehouse(DynamicObject entry, String warehouseKey, List<String> changeField) {
        String locationKey = "location";
        if ("inwarehouse".equals(warehouseKey)) {
            locationKey = "inlocation";
        } else if ("outwarehouse".equals(warehouseKey)) {
            locationKey = "outlocation";
        }
        boolean containsLocation = changeField.contains(locationKey);
        if (!containsLocation) {
            entry.set(locationKey, null);
        }
    }

    private void setAmount(DynamicObject entry) {
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal price = entry.getBigDecimal("price");
        BigDecimal amount = qty.multiply(price);
        amount = amount.setScale(this.precision, 4);
        entry.set("amount", (Object)amount);
    }
}

