/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class AdjustBillBizTypeUpgradeDeleteServiceImpl
implements IUpgradeService {
    private static String[] billFromId = new String[]{"im_adjustbill"};
    private static Set<Object> billTypeToFromIdSet = new HashSet<Object>(16);
    private static Set<String> bizNumSet = new HashSet<String>(64);
    private static String IM_INVDBPARAM_KEY = "AdjustBillTypeDelete";
    private static Log logger;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute sysRoute = new DBRoute("sys");
        if (this.checkUpgrade()) {
            result.setSuccess(true);
            result.setLog("no need to update");
            return result;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fformid,a.fbilltypeid,a.fdata,b.fnumber ", new Object[0]).append("from t_bas_billtypeparameter a left join T_BAS_BILLTYPE b on a.fbilltypeid = b.fid where ", new Object[0]).appendIn("a.fformid", (Object[])billFromId);
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u3002");
        DataSet billTypeDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sqlBuilder);
        logger.info("\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u7ed3\u675f\u3002");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(32);
        logger.info("\u5f00\u59cb\u5904\u7406\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570\u3002");
        while (billTypeDataSet.hasNext()) {
            Row next = billTypeDataSet.next();
            Object billTypeId = next.get("fbilltypeid");
            String fdata = next.getString("fdata");
            Map bizTypeMap = (Map)JSON.parse((String)fdata);
            Object number = next.get("fnumber");
            if (!billTypeToFromIdSet.contains(number)) continue;
            List entryList = (List)bizTypeMap.get("entryentity");
            ArrayList<Map> preEntryList = new ArrayList<Map>(16);
            for (Map entryEntity : entryList) {
                Map bizTypeNumberMap = (Map)entryEntity.get("biztypenumber");
                if (bizNumSet.contains(bizTypeNumberMap.get("number"))) continue;
                preEntryList.add(entryEntity);
            }
            bizTypeMap.put("entryentity", preEntryList);
            JSONObject jsonObject = new JSONObject(bizTypeMap);
            paramList.add(new Object[]{jsonObject.toString(), billTypeId});
        }
        logger.info("\u5904\u7406\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570\u7ed3\u675f\u3002");
        try (TXHandle handle = TX.requiresNew();){
            logger.info("\u5f00\u59cb\u6267\u884c\u66f4\u65b0\uff0c\u6267\u884cSQL\u8bed\u53e5\u4e3a\uff1a\u3010update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?\u3011\uff1b\u66f4\u65b0\u53c2\u6570\u662f\uff1a\u3010" + ((Object)paramList).toString() + "\u3011\u3002");
            DB.executeBatch((DBRoute)sysRoute, (String)"update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?", paramList);
            logger.info("\u6267\u884c\u66f4\u65b0\u6210\u529f\u3002");
        }
        DB.execute((DBRoute)new DBRoute("scm"), (String)"update t_im_invdbparam set fvalue = '1' where fkey = ?", (Object[])new Object[]{IM_INVDBPARAM_KEY});
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private boolean checkUpgrade() {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = ?";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)switchSql, (Object[])new Object[]{IM_INVDBPARAM_KEY});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    static {
        billTypeToFromIdSet.addAll(Collections.singleton("im_Adjustbill_STD_BT_S"));
        bizNumSet.addAll(Collections.singleton("520"));
        logger = LogFactory.getLog(AdjustBillBizTypeUpgradeDeleteServiceImpl.class);
    }
}

