/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AdjustDefaultBizTypeUpgradeServiceImpl
implements IUpgradeService {
    private static String[] billFromId = new String[]{"im_adjustbill"};
    private static final String DEFAULTBILL_TYPE = "im_Adjustbill_STD_BT_S";
    private static final String IM_INVDBPARAM_KEY = "AdjustDefBizParam";
    private static final String MATERIAL_TRANS_BIZ_NUM = "510";
    private static final String OTHER_TRANS_BIZ_NUM = "515";
    private static Log logger = LogFactory.getLog(AdjustDefaultBizTypeUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute sysRoute = new DBRoute("sys");
        if (this.checkUpgrade()) {
            result.setSuccess(true);
            result.setLog("no need to update");
            return result;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)OTHER_TRANS_BIZ_NUM).and("enable", "=", (Object)"1");
        DynamicObject otherBiz = BusinessDataServiceHelper.loadSingle((String)"bd_biztype", (String)"id", (QFilter[])qFilter.toArray());
        if (otherBiz == null) {
            result.setLog(ResManager.loadKDString((String)"\u5df2\u7981\u7528\u5176\u4ed6\u8f6c\u6362\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"AdjustDefaultBizTypeUpgradeServiceImpl_0", (String)"scmc-im-mservice", (Object[])new Object[0]));
            return result;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fformid,a.fbilltypeid,a.fdata,b.fnumber ", new Object[0]).append("from t_bas_billtypeparameter a left join T_BAS_BILLTYPE b on a.fbilltypeid = b.fid where ", new Object[0]).appendIn("a.fformid", (Object[])billFromId);
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u3002");
        DataSet billTypeDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sqlBuilder);
        logger.info("\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u7ed3\u675f\u3002");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(32);
        logger.info("\u5f00\u59cb\u5904\u7406\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570\u3002");
        boolean changeDefault = false;
        for (Row row : billTypeDataSet) {
            Object number = row.get("fnumber");
            if (!DEFAULTBILL_TYPE.equals(number)) continue;
            Object billTypeId = row.get("fbilltypeid");
            String fdata = row.getString("fdata");
            Map bizTypeMap = (Map)JSON.parse((String)fdata);
            List entryList = (List)bizTypeMap.get("entryentity");
            for (Map entryEntity : entryList) {
                Boolean isDefault = (Boolean)entryEntity.get("isdefault");
                Map biztypenumberMap = (Map)entryEntity.get("biztypenumber");
                Object bizNum = biztypenumberMap.get("number");
                if (!isDefault.booleanValue() || !MATERIAL_TRANS_BIZ_NUM.equals(bizNum)) continue;
                changeDefault = true;
                break;
            }
            if (!changeDefault) continue;
            for (Map entryEntity : entryList) {
                Map biztypenumberMap = (Map)entryEntity.get("biztypenumber");
                Object bizNum = biztypenumberMap.get("number");
                if (MATERIAL_TRANS_BIZ_NUM.equals(bizNum)) {
                    entryEntity.put("isdefault", Boolean.FALSE);
                    continue;
                }
                if (!OTHER_TRANS_BIZ_NUM.equals(bizNum)) continue;
                entryEntity.put("isdefault", Boolean.TRUE);
            }
            bizTypeMap.put("entryentity", entryList);
            JSONObject jsonObject = new JSONObject(bizTypeMap);
            paramList.add(new Object[]{jsonObject.toString(), billTypeId});
        }
        if (!changeDefault) {
            result.setLog(ResManager.loadKDString((String)"\u9ed8\u8ba4\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u662f\u7269\u6599\u8f6c\u6362\u3002", (String)"AdjustDefaultBizTypeUpgradeServiceImpl_1", (String)"scmc-im-mservice", (Object[])new Object[0]));
            return result;
        }
        logger.info("\u5904\u7406\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570\u7ed3\u675f\u3002");
        try (TXHandle handle = TX.requiresNew();){
            logger.info("\u5f00\u59cb\u6267\u884c\u66f4\u65b0\uff0c\u6267\u884cSQL\u8bed\u53e5\u4e3a\uff1a\u3010update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?\u3011\uff1b\u66f4\u65b0\u53c2\u6570\u662f\uff1a\u3010" + ((Object)paramList).toString() + "\u3011\u3002");
            DB.executeBatch((DBRoute)sysRoute, (String)"update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?", paramList);
            logger.info("\u6267\u884c\u66f4\u65b0\u6210\u529f\u3002");
        }
        DB.execute((DBRoute)new DBRoute("scm"), (String)"update t_im_invdbparam set fvalue = '1' where fkey = ?", (Object[])new Object[]{IM_INVDBPARAM_KEY});
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private boolean checkUpgrade() {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = ?";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)switchSql, (Object[])new Object[]{IM_INVDBPARAM_KEY});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

