/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BizTypeUpgradeServiceImpl
implements IUpgradeService {
    private static String[] billFromId = new String[]{"im_purreceivebill", "im_purinbill", "im_otherinbill", "im_productinbill", "im_saloutbill", "im_otheroutbill", "im_materialreqoutbill", "im_materialreqbill", "im_locationtransfer", "im_transapply", "im_transdirbill", "im_transinbill", "im_transoutbill", "im_adjustbill", "im_assembbill", "im_disassemblebill"};
    private static Set<Object> billTypeToFromIdSet = new HashSet<Object>(16);
    private static Set<String> bizNumSet = new HashSet<String>(64);
    private Map<String, String> defaultBillNumBizNumMapping = new HashMap<String, String>(32);
    private Map<Object, String> billTypeNumToJsonMapping = new HashMap<Object, String>(128);
    private static Log logger;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute sysRoute = new DBRoute("sys");
        if (this.checkUpgrade()) {
            result.setSuccess(true);
            result.setLog("no need to update");
            return result;
        }
        this.defaultBillNumBizNumMapping.put("im_purreceivebill_STD_BT_S", "110");
        this.defaultBillNumBizNumMapping.put("im_PurInBill_STD_BT_S", "110");
        this.defaultBillNumBizNumMapping.put("im_OtherInBill_STD_BT_S", "354");
        this.defaultBillNumBizNumMapping.put("im_ProductInbill_STD_BT_S", "330");
        this.defaultBillNumBizNumMapping.put("im_OtherOutBill_STD_BT_S", "355");
        this.defaultBillNumBizNumMapping.put("im_AllotApplyBill_STD_BT_S", "310");
        this.defaultBillNumBizNumMapping.put("im_AllotDirectBill_STD_BT_S", "310");
        this.defaultBillNumBizNumMapping.put("im_AllotInBill_STD_BT_S", "310");
        this.defaultBillNumBizNumMapping.put("im_AllotOutBill_STD_BT_S", "310");
        this.defaultBillNumBizNumMapping.put("im_MaterialReqBill_STD_BT_S", "320");
        this.defaultBillNumBizNumMapping.put("im_MaterialReqOutBill_STD_BT_S", "320");
        this.defaultBillNumBizNumMapping.put("im_SalOutBill_STD_BT_S", "210");
        this.defaultBillNumBizNumMapping.put("im_Adjustbill_STD_BT_S", "510");
        this.defaultBillNumBizNumMapping.put("im_Assembbill_BT_S", "516");
        this.defaultBillNumBizNumMapping.put("im_disassemblebill_BT_S", "517");
        this.defaultBillNumBizNumMapping.put("im_locationtransfer_BT_S", "518");
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("select a.fformid,a.fbilltypeid,a.fdata,b.fnumber ", new Object[0]).append("from t_bas_billtypeparameter a left join T_BAS_BILLTYPE b on a.fbilltypeid = b.fid where ", new Object[0]).appendIn("b.fnumber", billTypeToFromIdSet.toArray());
        logger.info("BizTypeUpgradeServiceImpl:\u5f00\u59cb\u67e5\u8be2\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u548c\u53c2\u6570\u3002");
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sqlBuilder1);
        logger.info("BizTypeUpgradeServiceImpl:\u67e5\u8be2\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u548c\u53c2\u6570\u7ed3\u675f\u3002");
        this.resolveDefaultBizType(dataSet);
        bizNumSet.addAll(this.defaultBillNumBizNumMapping.values());
        logger.info("\u5f00\u59cb\u67e5\u8be2\u9700\u8981\u5347\u7ea7\u5230\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u4e2d\u7684\u6240\u6709\u4e1a\u52a1\u7c7b\u578b\u3002");
        Map bizTypeEntityMap = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (QFilter[])new QFilter("number", "in", bizNumSet).toArray());
        logger.info("\u67e5\u8be2\u9700\u8981\u5347\u7ea7\u5230\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u4e2d\u7684\u6240\u6709\u4e1a\u52a1\u7c7b\u578b\u7ed3\u675f\u3002");
        HashMap<String, Set<DynamicObject>> billTypeNumToBizType = new HashMap<String, Set<DynamicObject>>(64);
        logger.info("\u5f00\u59cb\u83b7\u53d6\u3010\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u7f16\u7801 -- \u9700\u8981\u5173\u8054\u7684\u4e1a\u52a1\u7c7b\u578b\u5b9e\u4f53\u5217\u8868\u3011\u6620\u5c04");
        for (Map.Entry entry : bizTypeEntityMap.entrySet()) {
            DynamicObject bizEntity = (DynamicObject)entry.getValue();
            this.getBillTypeBizMapping(billTypeNumToBizType, bizEntity);
        }
        logger.info("\u83b7\u53d6\u3010\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u7f16\u7801 -- \u9700\u8981\u5173\u8054\u7684\u4e1a\u52a1\u7c7b\u578b\u5b9e\u4f53\u5217\u8868\u3011\u6620\u5c04\u7ed3\u675f");
        this.convertBillTypeEntityToJson(billTypeNumToBizType);
        SqlBuilder sqlBuilder2 = new SqlBuilder();
        sqlBuilder2.append("select a.fformid,a.fbilltypeid,a.fdata,b.fnumber ", new Object[0]).append("from t_bas_billtypeparameter a left join T_BAS_BILLTYPE b on a.fbilltypeid = b.fid where ", new Object[0]).appendIn("a.fformid", (Object[])billFromId);
        logger.info("BizTypeUpgradeServiceImpl:\u5f00\u59cb\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u3002");
        DataSet billTypeDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sqlBuilder2);
        logger.info("BizTypeUpgradeServiceImpl:\u67e5\u8be2\u5e93\u5b58\u5355\u636e\u7c7b\u578b\u7ed3\u675f\u3002");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(32);
        logger.info("BizTypeUpgradeServiceImpl:\u5f00\u59cb\u5904\u7406\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570\u3002");
        while (billTypeDataSet.hasNext()) {
            Row next = billTypeDataSet.next();
            Object billTypeId = next.get("fbilltypeid");
            Object number = next.get("fnumber");
            if (billTypeToFromIdSet.contains(number)) {
                paramList.add(new Object[]{this.billTypeNumToJsonMapping.get(number), billTypeId});
                continue;
            }
            String data = next.getString("fdata");
            String json = this.convertOldJson(data);
            if (json == null) continue;
            paramList.add(new Object[]{json, billTypeId});
        }
        logger.info("BizTypeUpgradeServiceImpl:\u5904\u7406\u6279\u91cf\u66f4\u65b0\u7684\u53c2\u6570\u7ed3\u675f\u3002");
        try (TXHandle handle = TX.requiresNew();){
            logger.info("BizTypeUpgradeServiceImpl:\u5f00\u59cb\u6267\u884c\u66f4\u65b0\uff0c\u6267\u884cSQL\u8bed\u53e5\u4e3a\uff1a\u3010update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?\u3011\uff1b\u66f4\u65b0\u53c2\u6570\u662f\uff1a\u3010" + ((Object)paramList).toString() + "\u3011\u3002");
            DB.executeBatch((DBRoute)sysRoute, (String)"update t_bas_billtypeparameter set fdata = ? where fbilltypeid = ?", paramList);
            logger.info("BizTypeUpgradeServiceImpl:\u6267\u884c\u66f4\u65b0\u6210\u529f\u3002");
        }
        DB.execute((DBRoute)new DBRoute("scm"), (String)"update t_im_invdbparam set fvalue = '1' where fkey = ?", (Object[])new Object[]{"BillTypeParam"});
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private boolean checkUpgrade() {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = ?";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)switchSql, (Object[])new Object[]{"BillTypeParam"});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private String convertOldJson(String data) {
        Map oldBizType = (Map)JSONObject.parseObject((String)data, Map.class);
        if (oldBizType == null) {
            return null;
        }
        if (oldBizType.get("biztype") == null) {
            return null;
        }
        Map entity = (Map)oldBizType.get("biztype");
        Object id = entity.get("masterid");
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        ArrayList entries = new ArrayList(4);
        HashMap<String, Object> bizNumMap = new HashMap<String, Object>(8);
        bizNumMap.put("_Type_", "entryentity");
        bizNumMap.put("biztypenumber", entity);
        bizNumMap.put("biztypenumber_id", id);
        bizNumMap.put("id", 0);
        bizNumMap.put("isdefault", true);
        bizNumMap.put("ispreset", false);
        entries.add(bizNumMap);
        resultMap.put("_Type_", "bd_billtypeparameter");
        resultMap.put("entryentity", entries);
        JSONObject jsonObject = new JSONObject(resultMap);
        return jsonObject.toJSONString();
    }

    private void resolveDefaultBizType(DataSet dataSet) {
        logger.info("BizTypeUpgradeServiceImpl:\u5f00\u59cb\u5904\u7406\u539f\u5148\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u5173\u8054\u7684\u9ed8\u8ba4\u4e1a\u52a1\u7c7b\u578b\u3002");
        while (dataSet.hasNext()) {
            JSONObject biztype;
            Row row = dataSet.next();
            String billTypeNumber = row.getString("fnumber");
            String data = row.getString("fdata");
            JSONObject jsonObject = JSONObject.parseObject((String)data);
            if (jsonObject == null || (biztype = jsonObject.getJSONObject("biztype")) == null) continue;
            String bizNum = biztype.getString("number");
            this.defaultBillNumBizNumMapping.put(billTypeNumber, bizNum);
        }
        logger.info("BizTypeUpgradeServiceImpl:\u5904\u7406\u539f\u5148\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u5173\u8054\u7684\u9ed8\u8ba4\u4e1a\u52a1\u7c7b\u578b\u7ed3\u675f\u3002");
    }

    private void convertBillTypeEntityToJson(Map<String, Set<DynamicObject>> billTypeNumToBizType) {
        logger.info("BizTypeUpgradeServiceImpl:\u5f00\u59cb\u5c06\u6bcf\u4e2a\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u5e94\u8be5\u5347\u7ea7\u7684\u4e1a\u52a1\u7c7b\u578b\u8f6c\u6210json\u6570\u636e\u3002");
        for (Map.Entry<String, Set<DynamicObject>> entry : billTypeNumToBizType.entrySet()) {
            Set<DynamicObject> objectList = entry.getValue();
            Object[] sortStrings = new String[objectList.size()];
            ArrayList<String> list = new ArrayList<String>(objectList.size());
            HashMap<String, DynamicObject> sortMap = new HashMap<String, DynamicObject>(objectList.size());
            for (DynamicObject dynamicObject : objectList) {
                String number = dynamicObject.getString("number");
                list.add(number);
                sortMap.put(number, dynamicObject);
            }
            for (int i = 0; i < list.size(); ++i) {
                sortStrings[i] = (String)list.get(i);
            }
            Arrays.sort(sortStrings);
            ArrayList sortedList = new ArrayList(list.size());
            for (Object object : sortStrings) {
                sortedList.add(sortMap.get(object));
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
            ArrayList entryList = new ArrayList(256);
            int seq = 1;
            for (DynamicObject bizTypeEntity : sortedList) {
                HashMap<String, Object> bizTypeSingleLineMap = new HashMap<String, Object>(16);
                Object status = bizTypeEntity.get("status");
                Object enable = bizTypeEntity.get("enable");
                Object ispreset = bizTypeEntity.get("ispreset");
                if (!"1".equals(enable) && !"C".equals(status)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                Object number = bizTypeEntity.get("number");
                Object masterid = bizTypeEntity.get("masterid");
                Object bizName = bizTypeEntity.get("name");
                Object id = bizTypeEntity.get("id");
                map.put("number", number);
                map.put("masterid", masterid);
                map.put("_Type_", "bd_biztype");
                DynamicObjectCollection multiLanguageText = bizTypeEntity.getDynamicObjectCollection("multilanguagetext");
                if (multiLanguageText.size() > 0) {
                    ArrayList textList = new ArrayList(256);
                    for (DynamicObject text : multiLanguageText) {
                        Object pkid = text.get("pkid");
                        Object localeid = text.get("localeid");
                        Object name = text.get("name");
                        Object description = text.get("description");
                        HashMap<String, Object> tmp = new HashMap<String, Object>(8);
                        tmp.put("_Type_", "locale");
                        tmp.put("pkid", pkid);
                        tmp.put("name", name);
                        tmp.put("description", description);
                        tmp.put("localeid", localeid);
                        textList.add(tmp);
                    }
                    map.put("multilanguagetext", textList);
                    map.put("ispreset", ispreset);
                    map.put("name", bizName);
                    map.put("id", id);
                }
                bizTypeSingleLineMap.put("_Type_", "entryentity");
                bizTypeSingleLineMap.put("biztypenumber", map);
                bizTypeSingleLineMap.put("biztypenumber_id", bizTypeEntity.getPkValue());
                bizTypeSingleLineMap.put("id", 0);
                if (number.equals(this.defaultBillNumBizNumMapping.get(entry.getKey()))) {
                    bizTypeSingleLineMap.put("isdefault", true);
                } else {
                    bizTypeSingleLineMap.put("isdefault", false);
                }
                bizTypeSingleLineMap.put("ispreset", true);
                bizTypeSingleLineMap.put("seq", seq);
                entryList.add(bizTypeSingleLineMap);
                ++seq;
            }
            hashMap.put("_Type_", "bd_billtypeparameter");
            hashMap.put("entryentity", entryList);
            JSONObject jSONObject = new JSONObject(hashMap);
            this.billTypeNumToJsonMapping.put(entry.getKey(), jSONObject.toJSONString());
        }
        logger.info("BizTypeUpgradeServiceImpl:\u5c06\u6bcf\u4e2a\u7cfb\u7edf\u9884\u8bbe\u5355\u636e\u7c7b\u578b\u5e94\u8be5\u5347\u7ea7\u7684\u4e1a\u52a1\u7c7b\u578b\u8f6c\u6210json\u6570\u636e\u7ed3\u675f\u3002");
    }

    private void getBillTypeBizMapping(Map<String, Set<DynamicObject>> billTypeNumToBizType, DynamicObject bizEntity) {
        String number = bizEntity.getString("number");
        if ("110".equals(number) || "1101".equals(number) || "1102".equals(number) || "1103".equals(number) || "1104".equals(number) || "111".equals(number) || "1111".equals(number) || "130".equals(number) || "1301".equals(number)) {
            Set purRecieveMap = billTypeNumToBizType.computeIfAbsent("im_purreceivebill_STD_BT_S", key -> new HashSet());
            purRecieveMap.add(bizEntity);
            Set purInMap = billTypeNumToBizType.computeIfAbsent("im_PurInBill_STD_BT_S", key -> new HashSet());
            purInMap.add(bizEntity);
        }
        if ("330".equals(number) || "3301".equals(number)) {
            Set productMap = billTypeNumToBizType.computeIfAbsent("im_ProductInbill_STD_BT_S", key -> new HashSet());
            productMap.add(bizEntity);
        }
        if ("350".equals(number) || "352".equals(number) || "354".equals(number) || "3541".equals(number)) {
            Set otherInMap = billTypeNumToBizType.computeIfAbsent("im_OtherInBill_STD_BT_S", key -> new HashSet());
            otherInMap.add(bizEntity);
        }
        if ("320".equals(number) || "322".equals(number) || "323".equals(number)) {
            Set materialReqMap = billTypeNumToBizType.computeIfAbsent("im_MaterialReqBill_STD_BT_S", key -> new HashSet());
            materialReqMap.add(bizEntity);
            Set materialReqOutMap = billTypeNumToBizType.computeIfAbsent("im_MaterialReqOutBill_STD_BT_S", key -> new HashSet());
            materialReqOutMap.add(bizEntity);
        }
        if ("3201".equals(number) || "3231".equals(number)) {
            Set materialReqOutMap = billTypeNumToBizType.computeIfAbsent("im_MaterialReqOutBill_STD_BT_S", key -> new HashSet());
            materialReqOutMap.add(bizEntity);
        }
        if ("210".equals(number) || "2101".equals(number) || "2102".equals(number) || "2103".equals(number) || "230".equals(number) || "2301".equals(number) || "231".equals(number) || "2311".equals(number)) {
            Set salOutMap = billTypeNumToBizType.computeIfAbsent("im_SalOutBill_STD_BT_S", key -> new HashSet());
            salOutMap.add(bizEntity);
        }
        if ("351".equals(number) || "353".equals(number) || "355".equals(number) || "3551".equals(number)) {
            Set otherOutMap = billTypeNumToBizType.computeIfAbsent("im_OtherOutBill_STD_BT_S", key -> new HashSet());
            otherOutMap.add(bizEntity);
        }
        if ("310".equals(number) || "3101".equals(number)) {
            Set tansApplyMap = billTypeNumToBizType.computeIfAbsent("im_AllotApplyBill_STD_BT_S", key -> new HashSet());
            tansApplyMap.add(bizEntity);
            Set tansDirMap = billTypeNumToBizType.computeIfAbsent("im_AllotDirectBill_STD_BT_S", key -> new HashSet());
            tansDirMap.add(bizEntity);
            Set tansOutMap = billTypeNumToBizType.computeIfAbsent("im_AllotOutBill_STD_BT_S", key -> new HashSet());
            tansOutMap.add(bizEntity);
            Set tansInMap = billTypeNumToBizType.computeIfAbsent("im_AllotInBill_STD_BT_S", key -> new HashSet());
            tansInMap.add(bizEntity);
        }
        if ("518".equals(number)) {
            Set locationTransMap = billTypeNumToBizType.computeIfAbsent("im_locationtransfer_BT_S", key -> new HashSet());
            locationTransMap.add(bizEntity);
        }
        if ("510".equals(number) || "511".equals(number) || "512".equals(number) || "513".equals(number) || "514".equals(number) || "515".equals(number)) {
            Set adjustMap = billTypeNumToBizType.computeIfAbsent("im_Adjustbill_STD_BT_S", key -> new HashSet());
            adjustMap.add(bizEntity);
        }
        if ("516".equals(number)) {
            Set assembMap = billTypeNumToBizType.computeIfAbsent("im_Assembbill_BT_S", key -> new HashSet());
            assembMap.add(bizEntity);
        }
        if ("517".equals(number)) {
            Set disassembleMap = billTypeNumToBizType.computeIfAbsent("im_disassemblebill_BT_S", key -> new HashSet());
            disassembleMap.add(bizEntity);
        }
        for (Map.Entry<String, String> entry : this.defaultBillNumBizNumMapping.entrySet()) {
            String num = entry.getValue();
            if (!num.equals(number)) continue;
            Set set = billTypeNumToBizType.computeIfAbsent(entry.getKey(), key -> new HashSet());
            set.add(bizEntity);
            break;
        }
    }

    static {
        billTypeToFromIdSet.addAll(Arrays.asList("im_purreceivebill_STD_BT_S", "im_PurInBill_STD_BT_S", "im_OtherInBill_STD_BT_S", "im_ProductInbill_STD_BT_S", "im_MaterialReqBill_STD_BT_S", "im_MaterialReqOutBill_STD_BT_S", "im_SalOutBill_STD_BT_S", "im_OtherOutBill_STD_BT_S", "im_AllotApplyBill_STD_BT_S", "im_AllotDirectBill_STD_BT_S", "im_AllotOutBill_STD_BT_S", "im_AllotInBill_STD_BT_S", "im_locationtransfer_BT_S", "im_Adjustbill_STD_BT_S", "im_Assembbill_BT_S", "im_disassemblebill_BT_S"));
        bizNumSet.addAll(Arrays.asList("110", "1101", "1102", "1103", "1104", "111", "1111", "130", "1301", "330", "3301", "350", "352", "354", "3541", "320", "322", "323", "3201", "3231", "210", "2101", "2102", "2103", "230", "2301", "351", "353", "355", "3551", "310", "518", "231", "2311", "3101", "510", "511", "512", "513", "514", "515", "516", "517"));
        logger = LogFactory.getLog(BizTypeUpgradeServiceImpl.class);
    }
}

