/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;

public class InvBillMaterialUpgradeServiceImpl
implements IUpgradeService {
    private static final String SQL_INVBILL = "  SET FMATERIALMASTERID = ? WHERE FMATERIALID = ?";
    private static final String SQL_MATERIALINFO = " SELECT fid,fmasterid FROM T_BD_MATERIALINVINFO  WHERE fmasterid in ";
    private static Map<String, Set<Long>> billAndMaterialIds = new HashMap<String, Set<Long>>(32);
    private static final String[] purAndSal = new String[]{"t_im_purinbillentry", "t_im_saloutbillentry"};
    private static final String[] transBill = new String[]{"t_im_transapplyentry", "t_im_transdirbillentry", "t_im_transinbillentry", "t_im_transoutbillentry"};
    private static final String[] ontherBill = new String[]{"t_im_adjustbillentry", "t_im_adjustbillsubentry", "t_im_assembbillentry", "t_im_assembbillsubentry", "t_im_disassembleentry", "t_im_disassemblesubentry", "t_im_initbillentry", "t_im_invcountbillentry", "t_im_locationtransentry", "t_im_lotadjustentry", "t_im_mdc_mftreqoutentry", "t_im_mdc_mqbentry", "t_im_mdc_ominbillentry", "t_im_mdc_prblentry", "t_im_mdcom_mqbentry", "t_im_mdcopm_mqbentry", "t_im_mreqbillentry", "t_im_mreqoutbillentry", "t_im_otherinbillentry", "t_im_otheroutbillentry", "t_im_productinbillentry", "t_im_purrecbillentry", "t_im_statusadjustentry", "t_im_surplusbillentry", "t_im_typeadjustentry"};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String[] invTables;
        UpgradeResult result = new UpgradeResult();
        final DBRoute route = new DBRoute("sys");
        DBRoute scmRoute = new DBRoute("scm");
        result.setSuccess(true);
        ArrayList<String[]> billTables = new ArrayList<String[]>(3);
        billTables.add(purAndSal);
        billTables.add(transBill);
        billTables.add(ontherBill);
        Iterator iterator = billTables.iterator();
        while (iterator.hasNext()) {
            for (String invTbale : invTables = (String[])iterator.next()) {
                DataSet tableSet = this.queryMethod(scmRoute, invTbale);
                HashSet<Long> materialInvfoSet = new HashSet<Long>(16);
                while (tableSet.hasNext()) {
                    Row next = tableSet.next();
                    materialInvfoSet.add(next.getLong("FMATERIALID"));
                }
                billAndMaterialIds.put(invTbale, materialInvfoSet);
            }
        }
        for (int i = 0; i < billTables.size(); ++i) {
            invTables = (String[])billTables.get(i);
            ThreadPools.executeOnce((String)("InvBillMaterialUpgradeServiceImpl:" + i), (Runnable)new Runnable(){

                @Override
                public void run() {
                    InvBillMaterialUpgradeServiceImpl.this.updateInvTable(route, invTables);
                }
            });
        }
        return result;
    }

    private DataSet queryMethod(DBRoute scmRoute, String invTbale) {
        DataSet tableSet = DB.queryDataSet((String)InvBillMaterialUpgradeServiceImpl.class.getName(), (DBRoute)scmRoute, (String)("select  FMATERIALID  from " + invTbale + " where FMATERIALMASTERID = 0"));
        return tableSet;
    }

    private void updateBill(List<Object[]> updateList, DBRoute scmRoute, String table) {
        StringBuilder tableSb = new StringBuilder(" UPDATE ");
        tableSb.append(table).append(SQL_INVBILL);
        DB.executeBatch((DBRoute)scmRoute, (String)tableSb.toString(), updateList);
    }

    private void updateInvTable(DBRoute route, String[] invTables) {
        HashSet materialIds = new HashSet(16);
        for (String invTbale : invTables) {
            materialIds.addAll(billAndMaterialIds.get(invTbale));
        }
        if (materialIds.isEmpty()) {
            return;
        }
        String sql = SQL_MATERIALINFO + ((Object)materialIds).toString().replace("[", "(").replace("]", ")");
        DataSet dataSet = DB.queryDataSet((String)InvBillMaterialUpgradeServiceImpl.class.getName(), (DBRoute)route, (String)sql);
        HashMap<Long, Long> materialInfoMap = new HashMap<Long, Long>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            materialInfoMap.put(row.getLong("fid"), row.getLong("fmasterid"));
        }
        DBRoute scmRoute = new DBRoute("scm");
        try (TXHandle handle = TX.requiresNew();){
            for (String invTbale : invTables) {
                ArrayList<Object[]> updateList = new ArrayList<Object[]>(1024);
                Set<Long> materialInfoIds = billAndMaterialIds.get(invTbale);
                for (Long materialInfoId : materialInfoIds) {
                    if (updateList.size() >= 1000) {
                        this.updateBill(updateList, scmRoute, invTbale);
                        updateList.clear();
                    }
                    updateList.add(new Object[]{materialInfoMap.get(materialInfoId), materialInfoId});
                }
                if (updateList.isEmpty()) continue;
                this.updateBill(updateList, scmRoute, invTbale);
            }
        }
    }
}

