/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class InvCountStatusUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        if (this.checkUpgrade()) {
            result.setSuccess(true);
            result.setLog("no need to update");
            return result;
        }
        String selectSql1 = "select fid from t_im_invcountscheme where fbillstatus = 'C'";
        List<List<Object>> sqlParams1 = this.getExecSqlParams(selectSql1);
        for (List<Object> splitSqlParam : sqlParams1) {
            this.updateInvCountStatus(splitSqlParam, "B");
        }
        String selectSql2 = "select fid from t_im_invcountscheme where fbillstatus != 'C'";
        List<List<Object>> sqlParams2 = this.getExecSqlParams(selectSql2);
        for (List<Object> splitSqlParam : sqlParams2) {
            this.updateInvCountStatus(splitSqlParam, "A");
        }
        DB.execute((DBRoute)new DBRoute("scm"), (String)"update t_im_invdbparam set fvalue = '1' where fkey = ?", (Object[])new Object[]{"InvCountStatus"});
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private List<List<Object>> getExecSqlParams(String selectSql) {
        DBRoute dbRoute = new DBRoute("scm");
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)selectSql);
        ArrayList<List<Object>> sqlParams = new ArrayList<List<Object>>(16);
        ArrayList<Long> splitSqlParams = new ArrayList<Long>(16);
        for (Row row : dataSet) {
            Long schemeId = row.getLong("fid");
            splitSqlParams.add(schemeId);
            if (splitSqlParams.size() != 1000) continue;
            sqlParams.add(splitSqlParams);
            splitSqlParams = new ArrayList(16);
        }
        if (splitSqlParams.size() != 0) {
            sqlParams.add(splitSqlParams);
        }
        return sqlParams;
    }

    private void updateInvCountStatus(List<Object> splitSqlParam, String invCountStatus) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_im_invcountscheme set fgencountstatus = ?", new Object[]{invCountStatus}).append("where", new Object[0]);
        sqlBuilder.appendIn("fid", splitSqlParam);
        DBRoute route = new DBRoute("scm");
        DB.execute((DBRoute)route, (SqlBuilder)sqlBuilder);
    }

    private boolean checkUpgrade() {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = ?";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)switchSql, (Object[])new Object[]{"InvCountStatus"});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

