/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class InvSchemeOwnKeeperUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        if (this.checkUpgrade()) {
            result.setSuccess(true);
            result.setLog("no need to update");
            return result;
        }
        DBRoute route = new DBRoute("scm");
        String selectSql = "select fid, fownertype, fkeepertype, foutownertype, foutkeepertype from t_im_invschemes where fid not in (739551937573353472,739550538571644928)";
        DataSet invSchemeData = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)route, (String)selectSql);
        ArrayList<Object[]> ownerKeeperTypeParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> outOwnerKeeperTypeParams = new ArrayList<Object[]>(16);
        for (Row row : invSchemeData) {
            Long id = row.getLong("fid");
            String ownerType = row.getString("fownertype");
            String keeperType = row.getString("fkeepertype");
            String outOwnerType = row.getString("foutownertype");
            String outKeeperType = row.getString("foutkeepertype");
            if (StringUtils.isNotEmpty((CharSequence)ownerType) && StringUtils.isNotEmpty((CharSequence)keeperType)) {
                Object[] ownerKeeperTypeParam = new Object[]{ownerType, keeperType, id};
                ownerKeeperTypeParams.add(ownerKeeperTypeParam);
            }
            if (!StringUtils.isNotEmpty((CharSequence)outOwnerType) || !StringUtils.isNotEmpty((CharSequence)outKeeperType)) continue;
            Object[] outOwnerKeeperTypeParam = new Object[]{outOwnerType, outKeeperType, id};
            outOwnerKeeperTypeParams.add(outOwnerKeeperTypeParam);
        }
        if (!ownerKeeperTypeParams.isEmpty()) {
            String updateSql1 = "update t_im_invtypeentry set fownertype1 = ? , fkeepertype1 = ? where fid = ?";
            DB.executeBatch((DBRoute)route, (String)updateSql1, ownerKeeperTypeParams);
        }
        if (!outOwnerKeeperTypeParams.isEmpty()) {
            String updateSql2 = "update t_im_outinvtypeentry set foutownertype1 = ? , foutkeepertype1 = ? where fid = ?";
            DB.executeBatch((DBRoute)route, (String)updateSql2, outOwnerKeeperTypeParams);
        }
        String updateSql3 = "update t_im_invdbparam set fvalue = '1' where fkey = 'InvSchemeParam'";
        DB.execute((DBRoute)route, (String)updateSql3);
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private boolean checkUpgrade() {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = 'InvSchemeParam'";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)switchSql);){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

