/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class OtherOutQtyUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(OtherOutQtyUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute sysRoute = new DBRoute("scm");
        if (this.checkUpgrade()) {
            result.setSuccess(true);
            result.setLog("OtherOutQtyUpgradeServiceImpl:no need to update");
            return result;
        }
        try (TXHandle handle = TX.requiresNew();){
            logger.info("OtherOutQtyUpgradeServiceImpl:\u5f00\u59cb\u6267\u884c\u66f4\u65b0\uff0c\u6267\u884cSQL\u8bed\u53e5\u4e3a\uff1a\u3010update t_im_otheroutbillentry set fremainreturnqty = fqty,fremainreturnbaseqty = fbaseqty\u3011");
            long timeBefore = System.currentTimeMillis();
            DB.execute((DBRoute)sysRoute, (String)"update t_im_otheroutbillentry set fremainreturnqty = fqty,fremainreturnbaseqty = fbaseqty");
            logger.info("OtherOutQtyUpgradeServiceImpl:\u66f4\u65b0\u8017\u8d39\u65f6\u95f4={}", (Object)(System.currentTimeMillis() - timeBefore));
            DB.execute((DBRoute)new DBRoute("scm"), (String)"update t_im_invdbparam set fvalue = '1' where fkey = ?", (Object[])new Object[]{"OtherOutQtyParam"});
            logger.info("OtherOutQtyUpgradeServiceImpl:\u6267\u884c\u66f4\u65b0\u6210\u529f\u3002");
            result.setSuccess(true);
            result.setLog("OtherOutQtyUpgradeServiceImpl:data update successfully.");
        }
        return result;
    }

    private boolean checkUpgrade() {
        String switchSql = "select fvalue as value from t_im_invdbparam where fkey = ?";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)switchSql, (Object[])new Object[]{"OtherOutQtyParam"});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

