/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class WarehouseSetupMaterialIdServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        HashMap<Long, Set<Long>> matDefMap = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Set<Long>> warHSetMatMap = new HashMap<Long, Set<Long>>(16);
        DBRoute scmRoute = new DBRoute("scm");
        String selectMatDefSql = "select fid, fmaterialid  from t_im_materdefaultwh where fmaterialid > 0 ";
        String selectwarehouseSetupSql = "select  fentryid,fmaterialid  from t_im_warehousesetup_mater where fmaterialid > 0 ";
        DBRoute sysRoute = new DBRoute("sys");
        String selectMatSql = "select fid,fmasterid from t_bd_materialinvinfo where fid in ";
        try (TXHandle tx = TX.requiresNew((String)this.getClass().getName());){
            DataSet matDefData = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)selectMatDefSql);
            HashSet<Long> updIds = new HashSet<Long>(1024);
            for (Row row : matDefData) {
                Long materialId = row.getLong("fmaterialid");
                Long id = row.getLong("fid");
                HashSet<Long> ids = (HashSet<Long>)matDefMap.get(materialId);
                if (ids == null) {
                    ids = new HashSet<Long>(16);
                    matDefMap.put(materialId, ids);
                }
                ids.add(id);
                updIds.add(id);
                if (updIds.size() < 1000) continue;
                this.upgradeMatDef(scmRoute, sysRoute, selectMatSql, matDefMap.keySet(), matDefMap, null);
                matDefMap.clear();
                ids.clear();
            }
            DataSet warehouseSetupData = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)selectwarehouseSetupSql);
            HashSet<Long> updEntryIds = new HashSet<Long>(1024);
            for (Row row : warehouseSetupData) {
                Long materialId = row.getLong("fmaterialid");
                Long entryId = row.getLong("fentryid");
                HashSet<Long> entryIds = (HashSet<Long>)warHSetMatMap.get(materialId);
                if (entryIds == null) {
                    entryIds = new HashSet<Long>(16);
                    warHSetMatMap.put(materialId, entryIds);
                }
                entryIds.add(entryId);
                updEntryIds.add(entryId);
                if (updEntryIds.size() < 1000) continue;
                this.upgradeMatDef(scmRoute, sysRoute, selectMatSql, warHSetMatMap.keySet(), null, warHSetMatMap);
                updEntryIds.clear();
                warHSetMatMap.clear();
            }
            if (!matDefMap.isEmpty()) {
                this.upgradeMatDef(scmRoute, sysRoute, selectMatSql, matDefMap.keySet(), matDefMap, null);
            }
            if (!warHSetMatMap.isEmpty()) {
                this.upgradeMatDef(scmRoute, sysRoute, selectMatSql, warHSetMatMap.keySet(), null, warHSetMatMap);
            }
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private void upgradeMatDef(DBRoute scmRoute, DBRoute sysRoute, String selectMatSql, Set<Long> matInfoIds, Map<Long, Set<Long>> matDefMap, Map<Long, Set<Long>> warHSetMatMap) {
        StringBuilder sb = new StringBuilder(selectMatSql);
        sb.append("(");
        int i = 0;
        for (Long matInfoId : matInfoIds) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(matInfoId);
            ++i;
        }
        sb.append(")");
        DataSet MatInfoData = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)sb.toString());
        ArrayList matDefParams = new ArrayList(16);
        ArrayList warHSetMatParams = new ArrayList(16);
        for (Row row : MatInfoData) {
            Set<Long> matIds;
            Long masterId = row.getLong("fmasterid");
            Long mId = row.getLong("fid");
            if (matDefMap != null && !matDefMap.isEmpty() && (matIds = matDefMap.get(mId)) != null && !matIds.isEmpty()) {
                matIds.forEach(v -> matDefParams.add(new Object[]{masterId, v}));
            }
            if (warHSetMatMap == null || warHSetMatMap.isEmpty() || (matIds = warHSetMatMap.get(mId)) == null || matIds.isEmpty()) continue;
            matIds.forEach(v -> warHSetMatParams.add(new Object[]{masterId, v}));
        }
        if (!matDefParams.isEmpty()) {
            String matDefUpdSql = "update t_im_materdefaultwh set fmaterialmasterid = ? where fid = ?";
            DB.executeBatch((DBRoute)scmRoute, (String)matDefUpdSql, matDefParams);
        }
        if (!warHSetMatParams.isEmpty()) {
            String warehouseSetupUpdSql = "update t_im_warehousesetup_mater set fmaterialmasterid = ? where fentryid = ?";
            DB.executeBatch((DBRoute)scmRoute, (String)warehouseSetupUpdSql, warHSetMatParams);
        }
    }
}

