/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.mservice.upgrade;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WarnScheduleUpdateServiceImpl
implements IUpgradeService {
    private static final String SELECTSQL = "select fdata  from t_warn_schedule where fid = '854807900726721536';";
    private static final String UPDATESQL = "update t_warn_schedule set fdata = ? where fid = '854807900726721536';";
    private static final String SELECT_MUILTLANG_SQL = "select fid,fdata from t_warn_schedule where fid in('854806641948982272','854207324435580928','854807900726721536','854807346223055872','846108395168812032')";
    private static Log logger = LogFactory.getLog(WarnScheduleUpdateServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute sysRoute = new DBRoute("sys");
        String data = null;
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)SELECTSQL, null);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                data = next.getString("fdata");
                data = data.replace("\u5728\u8ba2\u8d27\u70b9", "\u518d\u8ba2\u8d27\u70b9");
            }
        }
        if (StringUtils.isNotBlank(data)) {
            DB.execute((DBRoute)sysRoute, (String)UPDATESQL, (Object[])new String[]{data});
        }
        try {
            this.addMuiltLangData();
        }
        catch (Exception e) {
            logger.error("\u9884\u8b66\u76d1\u63a7\u591a\u8bed\u8a00\u5347\u7ea7\u5f02\u5e38", (Throwable)e);
            result.setSuccess(false);
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    public void addMuiltLangData() throws Exception {
        InputStreamReader fileReader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("scheduleMultiLang.xml"));
        StringBuilder text = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                text.append(line);
            }
        }
        Document preDocument = DocumentHelper.parseText((String)text.toString());
        Element preRoot = preDocument.getRootElement();
        DBRoute sysRoute = new DBRoute("sys");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(32);
        String data = null;
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)SELECT_MUILTLANG_SQL, null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                String fid = next.getString("fid");
                data = next.getString("fdata");
                Element mulitElement = preRoot.element("L" + fid).element("MulilangConfigs");
                Document document = DocumentHelper.parseText((String)data);
                Element root = document.getRootElement();
                Element messageConfigElement = root.element("WarnSchedule").element("WarnSchedule").element("MessageConfig").element("WarnMessageConfig");
                Element mulilangConfigs = messageConfigElement.element("MulilangConfigs");
                if (mulilangConfigs == null) {
                    messageConfigElement.add(mulitElement.detach());
                }
                data = document.asXML();
                paramList.add(new Object[]{data, fid});
            }
            DB.executeBatch((DBRoute)sysRoute, (String)"update t_warn_schedule set fdata = ? where fid = ?", paramList);
        }
    }
}

